/*
 * tgmb-canvcmd.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "tgmb-canvcmd.h"
#include "mb/mb-cmd.h"


void
CanvasCmd::ApplyEffects(ChunkFrag *frag, u_int32_t startSeqno)
{
	if (prev_link_==NULL || prev_link_->seqNo_ < startSeqno) {
		frag->hdr_.canvCmdId_ = (u_int32_t)id_;
		if (pCmd_) {
			frag->hdr_.srcId_ = pCmd_->rcvr()->getSrcId();
		} else {
			memset(&frag->hdr_.srcId_, 0,
			       sizeof(frag->hdr_.srcId_));
		}
		for (CanvasCmd *ptr=this; ptr!=NULL; ptr = ptr->next_link_) {
			if (ptr->Apply(frag)==FALSE) {
				frag->flush();
				break;
			}
		}

		if (!frag->is_valid()) {
			frag->flush();
		} else {
			static FILE *f=NULL;
			if (f==NULL)
				f = fopen("tgmb.send.dump", "w");
			fprintf(f, "sending id %ld for src %u@%s: cmd %d "
				"(len=%d)\n", id_, frag->hdr_.srcId_.ss_uid,
				intoa(frag->hdr_.srcId_.ss_addr),
				frag->hdr_.cmd_, frag->hdr_.len_);
			fflush(f);
		}
	}
}


Bool
CanvasCreateCmd::Apply(ChunkFrag *frag)
{
	// the create command MUST be the very first command associated with
	// this item
	assert(!frag->is_valid());

	frag->hdr_.cmd_ = (u_int32_t)cmdCanvasCreate;
	frag->insert(descrItemType, (u_int16_t) pCmd_->getItem()->getType());
	frag->insertCoords(descrCoords, pCmd_->getItem()->getPoints(),
			   pCmd_->getItem()->getNumPoints());

	// now insert the item properties
	return frag->insert_props(pCmd_->getItem());
}


Bool
CanvasMoveCmd::Apply(ChunkFrag *frag)
{
	void      *pCoords;
	u_int16_t len, numPoints, tmp;
	double    dx, dy;

	frag->get_any(descrCoords, pCoords, len);
	assert( (len % 4) == 0 && "len should be a multiple of 4");
	numPoints = len/4;

	((MBCmdMove*)pCmd_)->getOffsets(dx, dy);
	if (pCoords && numPoints > 0) {
		for (int i=0; i<numPoints; i++) {
			memcpy(&tmp, pCoords, 2);
			tmp = htons((u_int16_t) (ntohs(tmp) + dx));
			memcpy(pCoords, &tmp, 2);
			pCoords = ((u_char*)pCoords) + 2;

			memcpy(&tmp, pCoords, 2);
			tmp = htons((u_int16_t) (ntohs(tmp) + dy));
			memcpy(pCoords, &tmp, 2);
			pCoords = ((u_char*)pCoords) + 2;
		}
	} else {
		Point point;
		point.x = dx;
		point.y = dy;
		frag->insertCoords(descrCoords, &point, 1);
	}

	if (frag->hdr_.cmd_==cmdInvalid) {
		// this is the first command
		// so insert a description of the command
		frag->hdr_.cmd_ = (u_int32_t)cmdCanvasMove;
	}

	return TRUE;
}


Bool
CanvasDeleteCmd::Apply(ChunkFrag *frag)
{
	u_int16_t cmd = frag->hdr_.cmd_;
	frag->flush_data();  // flush everything we currently have

	if (cmd != cmdCanvasCreate) {
		// the create command for this id has already been sent to
		// the client; so we must explicitly send a delete

		frag->hdr_.cmd_ = cmdCanvasDelete;
	}

	return TRUE;
}


Bool
CanvasUndeleteCmd::Apply(ChunkFrag *frag)
{
	// find the very first command associated with this id
	CanvasCmd *pCanvCmd = this;
	while (pCanvCmd->prev_link_!=NULL) pCanvCmd = pCanvCmd->prev_link_;

	frag->flush_data();
	for ( ; pCanvCmd != this; pCanvCmd = pCanvCmd->next_link_) {
		if (pCanvCmd->pCmd_ &&
		    pCanvCmd->pCmd_->getType()==CDel) continue;

		pCanvCmd->Apply(frag);
	}

	return TRUE;
}


Bool
CanvasConfigTextCmd::Apply(ChunkFrag *frag)
{
	if (frag->hdr_.cmd_==cmdInvalid) {
		// this is the first command
		// so insert a description of the command
		frag->hdr_.cmd_ = (u_int32_t)cmdCanvasConfigText;
	}

	frag->replace_any(descrText, text_, strlen(text_)+1);
	return TRUE;
}


Bool
CanvasRaiseCmd::Apply(ChunkFrag * /* frag */)
{
	// do nothing for now!
	return TRUE;
}
