/*
 * source-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/srmv2/source-srmv2.h,v 1.10 2002/02/03 03:05:47 lim Exp $
 */


#ifndef srmv2_source_h
#define srmv2_source_h

#include "net/inet.h"
#include "srmv2/srmv2.h"
#include "srmv2/pktbuf-srmv2.h"
#include "net/net.h"
#include "net/transmitter.h"

class SRMv2_NameSpace;
class SRMv2_Session;
class SRMv2_RReq;
struct adubuf;


class SRMv2_Source {
public:
	SRMv2_Source(const char *srcid, int islocal);
	SRMv2_Source(const int *src_id, int islocal);
	~SRMv2_Source();
	void set_app_info(const unsigned char *info,  int len) {
		if (info_) delete [] info_;
		if (info && len > 0) {
			info_ = new unsigned char [len];
			memcpy(info_, info, len);
			info_len_ = len;
		} else {
			info_ = 0;
			info_len_ = 0;
		}
	}
	void get_app_info(const unsigned char **info, int *len) {
		*info = info_;
		*len = info_len_;
	}
	
	unsigned int calloc(unsigned int parent, unsigned int offset,
			    const unsigned char *container_name, int name_len);

	void recover(unsigned int cid, unsigned int sseq, unsigned int eseq);
	inline int  source_id(int idx)    { return sid_[idx]; }
	inline int* source_id() { return sid_; }
	inline unsigned int ipaddr() { return ipaddr_; }
	inline void ipaddr(unsigned int addr) { ipaddr_ = addr; }
	void session(SRMv2_Session* s);
	inline SRMv2_Session *session() { return session_; }
	int  update_appinfo(const unsigned char *dp);
	void update_namespace(naddr_plus_name* path, int plen);
	inline SRMv2_NameSpace* name_space() { return namespace_; }
	inline int islocal() { return (ch_!=0); }
	static SRMv2_Source *source(SRMv2_CtrlHandler *ch) {
		return ((SRMv2_LocalSrcCtrlHandler*)ch)->lsrc_;
	}
	void announce();
	
private:
	class SRMv2_LocalSrcCtrlHandler : public SRMv2_CtrlHandler {
	public:
		SRMv2_LocalSrcCtrlHandler(SRMv2_Source *lsrc) : lsrc_(lsrc) {}
		SRMv2_Source *lsrc_;
	};

	int* sid_;
	unsigned char *info_;
	int info_len_;
	SRMv2_NameSpace* namespace_;
	SRMv2_Session* session_;
	unsigned int ipaddr_;   /* IPv4 address */
	SRMv2_LocalSrcCtrlHandler *ch_; /* points to a CtrlHandler object
					 * for local sources */
};
#endif

