;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;




(defun %stack-group-useable-size (&optional (sg *current-stack-group*))
  (multiple-value-bind (cf cu vf vu tf tu) (%stack-group-stack-space sg)
    (- (+ cf cu vf vu tf tu) (* 2 4096) *cs-hard-overflow-size* *cs-soft-overflow-size*)))

(defvar *allow-stack-overflows* t)

; This probably needs some tuning
(defvar *minimum-stack-overflow-size* (* 384 1024))



(queue-fixup
 
 (setq *allow-stack-overflows* nil))

(defun %kernel-restart (error-type &rest args)
  (%kernel-restart-internal error-type args (%get-frame-ptr)))

(defun %kernel-restart-internal (error-type args frame-ptr)
  ;(declare (dynamic-extent args))
  (dolist (f *kernel-restarts* (%err-disp-internal error-type args frame-ptr))
    (when (eq (car f) error-type)
      (return (apply (cdr f) frame-ptr args)))))

; this is the def of %err-disp.
; Yup.  That was my first guess.
(defun %err-disp (err-num &rest errargs)
  (%err-disp-internal err-num errargs (%get-frame-ptr)))

(defun %errno-disp (errno &rest errargs)
  (%errno-disp-internal errno errargs (%get-frame-ptr)))

(defun %errno-disp-internal (errno errargs frame-ptr)
  (declare (fixnum errno))
  (let* ((err-type (max (ash errno -16) 0))
	 (errno (%word-to-int errno))
	 (format-string (format nil "~a : ~a" (%strerror errno) "~s")))
    (%err-disp-common nil err-type  format-string errargs frame-ptr)))


(defun %err-disp-internal (err-num errargs frame-ptr)
  (declare (fixnum err-num))
  ; The compiler (finally !) won't tail-apply error.  But we kind of
  ; expect it to ...
  (let* ((err-typ (max (ash err-num -16) 0))
         (err-num (%word-to-int err-num))
         (format-string (%rsc-string err-num)))
    (%err-disp-common err-num err-typ format-string errargs frame-ptr)))

(defun %err-disp-common (err-num err-typ format-string errargs frame-ptr)
  (let* ((condition-name (or (uvref *simple-error-types* err-typ)
                             (%cdr (assq err-num *kernel-simple-error-classes*)))))
    ;(dbg format-string)
    (if condition-name      
      (funcall '%error
               (case condition-name
                 (type-error (make-condition condition-name
                                             :format-control format-string
                                             :datum (car errargs)
                                             :expected-type (%type-error-type (cadr errargs))))
                 (file-error (make-condition condition-name
                                             :pathname (car errargs)
                                             :error-type format-string
                                             :format-arguments (cdr errargs)))
                 (undefined-function (make-condition condition-name
                                                     :name (car errargs)))
                 (t (make-condition condition-name 
                                    :format-control format-string
                                    :format-arguments errargs)))
               nil
               frame-ptr)
      (funcall '%error format-string errargs frame-ptr))))

(defun error (condition &rest args)
  #|
  #+ppc-target
  (with-pstrs ((pstr (if (stringp condition) condition "Error")))
    (#_DebugStr pstr))
  |#
  (%error condition args (%get-frame-ptr)))

(defun cerror (cont-string condition &rest args)
  (let* ((fp (%get-frame-ptr)))
    (restart-case (%error condition (if (condition-p condition) nil args) fp)
      (continue ()
                :report (lambda (stream) 
                            (apply #'format stream cont-string args))
                nil))))

(defun %error (condition args error-pointer)
  (setq condition (condition-arg condition args 'simple-error))
  ;(with-pstrs ((str (format nil "error: ~a" condition))) (#_DebugStr str))  
  (signal condition)
  ;(with-pstrs ((str (format nil "error: ~a" condition))) (#_DebugStr str))
  (application-error *application* condition error-pointer)
  (application-error
   *application*
   (condition-arg "~s returned. It shouldn't.~%If it returns again, I'll throw to toplevel."
                  '(application-error) 'simple-error)
   error-pointer)
  (toplevel))
