/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "lispdcmd.h"
#ifdef LINUX
#define __USE_GNU 1
#include <dlfcn.h>
#endif

#ifdef VXWORKS
#include <symLib.h>
#include <sysSymTbl.h>
#endif

Boolean
emulated_frame_p(lisp_frame *frame)
{
  return ((((int) (frame->backlink)) & 1) != 0);
}


extern Boolean lisp_frame_p(lisp_frame *);

void
print_lisp_frame(lisp_frame *frame)
{
  LispObj fun = frame->savefn, pc = frame->savelr;
  int delta = 0;

  if ((fun == 0) || (fun == fulltag_misc)) {
    Dprintf("(#x%08X) #x%08X : (subprimitive)", frame, pc);
  } else {
    if ((fulltag_of(fun) != fulltag_misc) ||
        (header_subtag(header_of(fun)) != subtag_function)) {
      Dprintf("(#x%08X) #x%08X : (not a function!)", frame, pc);
    } else {
      LispObj code_vector = deref(fun, 1);
      
      if ((pc >= (code_vector+misc_data_offset)) &&
          (pc < ((code_vector+misc_data_offset)+(header_element_count(header_of(code_vector))<<2)))) {
        delta = (pc - (code_vector+misc_data_offset));
      }
      Dprintf("(#x%08X) #x%08X : %s +%04x", frame, pc, print_lisp_object(fun), delta);
    }
  }
}


#ifdef DARWIN
void
print_foreign_frame(c_frame *frame)
{
  long pc = (long) (frame->savelr);
  /* Not sure if there's a way to lookup foreign symbols,
     ala dladdr() */
  Dprintf("(#x%08X) #x%08X : foreign code (%s)", frame, pc, "unknown");
}
#else
void
print_foreign_frame(eabi_c_frame *frame)
{
  long pc = (long) (frame->savelr);
#ifdef LINUX
  Dl_info foreign_info;

  if (dladdr((void *)pc, &foreign_info)) {
    Dprintf("(#x%08x) #x%08X : %s + %d", frame, pc, foreign_info.dli_sname,
	    pc-((int)foreign_info.dli_saddr));
  } else {
    Dprintf("(#x%08X) #x%08X : foreign code (%s)", frame, pc, "unknown");
  }
#endif
#ifdef VXWORKS
  int retval = 0;
  SYM_TYPE symtype;
  char name[512];
  
  symFindByValue(sysSymTbl, (UINT)pc, name, &retval, &symtype);
  if (retval) {
    Dprintf("(#x%08x) #x%08X : %s + %d", frame, pc, name,
	    pc-retval);
  } else {
    Dprintf("(#x%08X) #x%08X : foreign code (%s)", frame, pc, "unknown");
  }
#endif
}
#endif /* DARWIN */

/* Walk frames from "start" to "end".  Give up if an emulated frame is
   encountered.  Say whatever can be said about foreign frames and
   lisp frames.
*/

void
walk_stack_frames(lisp_frame *start, lisp_frame *end) 
{
  lisp_frame *next;
  Dprintf("\n");
  while (start < end) {
    if (emulated_frame_p(start)) {
      break;
    }

    if (lisp_frame_p(start)) {
      print_lisp_frame(start);
    } else {
#ifdef DARWIN
      print_foreign_frame((c_frame *)start);
#else
      print_foreign_frame((eabi_c_frame *)start);
#endif
    }
    
    next = start->backlink;
    if (next < start) {
      fprintf(stderr, "Bad frame! (%x < %x)\n", next, start);
      break;
    }
    start = next;
  }
}

void
walk_other_areas()
{
  area *a = ((area *) lisp_global(ALL_AREAS))->succ, *walked = (area *) (lisp_global(CURRENT_CS));
  area_code code;

  while ((code = a->code) != AREA_VOID) {
    if (code == AREA_CSTACK) {
      if (a != walked) {
        Dprintf("\n\ncstack area #x%08x", a);
        walk_stack_frames((lisp_frame *) (a->active), (lisp_frame *) (a->high));
      }
    }
    a = a->succ;
  }
}

void
plbt_sp(LispObj currentSP)
{
  area *cs_area;
  
  if (lisp_nil == (LispObj) NULL) {
    fprintf(stderr, "can't find lisp NIL; lisp process not active process ?\n");
  } else {
    cs_area = (area *) (lisp_global(CURRENT_CS));
    if ((((LispObj) (cs_area->low)) > currentSP) ||
        (((LispObj) (cs_area->high)) < currentSP)) {
      Dprintf("\nStack pointer [#x%08X] in unknown area.", currentSP);
    } else {
      walk_stack_frames((lisp_frame *) currentSP, (lisp_frame *) (cs_area->high));
      walk_other_areas();
    }
  }
}

  
void
plbt(ExceptionInformation *xp)
{
  plbt_sp(xpGPR(xp, sp));
}
    
