'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_AdabasD.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:06:45 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Create Adabas DS & Table & fill in Test
'*
'************************************************************************
'*
' #1 b_lvl1_AdabasD
' #1 tAdabasD
' #1 tCreateNewLocalAdabasDatabase
'*
'\***********************************************************************
sub b_lvl1_AdabasD

    printlog "------------------ b_lvl1_AdabasD.inc ---------------------"

    if gPlatform = "x86" then
        printlog "No Adabas available under x86."    
    else
        call tAdabasD
        'doesn't work, has to be investigate later
        'call tCreateNewLocalAdabasDatabase
    endif
    
end sub
'-------------------------------------------------------------------------
testcase tAdabasD     

    ' **************************************************
    '   databases specific settings for Adabas D 11.02
    ' **************************************************
       
    Dim sFileName as string
    sFileName = gOfficePath + "user/work/TT_Adabas.odb"
    
    Dim sDBURL as string
    sDBURL = "waikiki-3086:TTDB"
    
    Dim sTableName as string
    sTableName = "tt_test_table"    'table name lenght restriction
    
    Dim sUserName as string
    sUserName = "testtool"
    
    Dim sPWD as string
    sPWD = "testtool"
    
    dim sCatalog as string
    sCatalog = " "              ' empty for adabas
    
    dim sSchema as string
    sSchema = "TESTTOOL"        ' case sensitive !
    
    dim sRelTable1 as string    'for relation test (tRelation1&2)
    sRelTable1 = "tt_rel1"
    
    dim sRelTable2 as string    'for relation test (tRelation1&2)
    sRelTable2 = "tt_rel2"
    
    dim sRelTable3 as string    'for relation test (tRelation2)
    sRelTable3 = "tt_rel3"
    
    Dim aFieldTypeContent(17,3) as string     'database specific data matrix
        
    aFieldTypeContent(1,1)="tt_boolean"     'name of fieldtype
    aFieldTypeContent(1,2)="boolean"        'number of fieldtype (listbox entry)    
    
    aFieldTypeContent(2,1)="tt_long_byte"
    aFieldTypeContent(2,2)="long byte"
         
    aFieldTypeContent(3,1)="tt_varchar_byte"
    aFieldTypeContent(3,2)="varchar() byte"
         
    aFieldTypeContent(4,1)="tt_char_byte"
    aFieldTypeContent(4,2)="char() byte"
         
    aFieldTypeContent(5,1)="tt_long"        ' does not work #69846
    aFieldTypeContent(5,2)="long"
         
    aFieldTypeContent(6,1)="tt_char"
    aFieldTypeContent(6,2)="char"
        
    aFieldTypeContent(7,1)="tt_decimal"     ' will probably work after #108512 is fixed
    aFieldTypeContent(7,2)="decimal"
        
    aFieldTypeContent(8,1)="tt_fixed"       ' will probably work after #108512 is fixed
    aFieldTypeContent(8,2)="fixed"
        
    aFieldTypeContent(9,1)="tt_integer"
    aFieldTypeContent(9,2)="integer"
        
    aFieldTypeContent(10,1)="tt_smallint"
    aFieldTypeContent(10,2)="smallint"
        
    aFieldTypeContent(11,1)="tt_float"
    aFieldTypeContent(11,2)="float"
        
    aFieldTypeContent(12,1)="tt_real"
    aFieldTypeContent(12,2)="real"
        
    aFieldTypeContent(13,1)="tt_double_precision"
    aFieldTypeContent(13,2)="double precision"
        
    aFieldTypeContent(14,1)="tt_varchar"
    aFieldTypeContent(14,2)="varchar"
    
    aFieldTypeContent(15,1)="tt_date"
    aFieldTypeContent(15,2)="date"
        
    aFieldTypeContent(16,1)="tt_time"
    aFieldTypeContent(16,2)="time"
        
    aFieldTypeContent(17,1)="tt_timestamp"
    aFieldTypeContent(17,2)="timestamp"
        
    Dim aFieldContent(1,4) as string
    aFieldContent(1,1)="<Space>"
    aFieldContent(1,2)="1"
    aFieldContent(1,3)="1"
    aFieldContent(1,4)="1"
    
    dim dbok as boolean
    dbok = false
	dbok = fCreateAdabasDatasource( sFileName, sDBURL, sUserName, "tt_adabas")
                                    
    if dbok = true then
        call fOpenDatabase(sFileName,"testtool")
        call fDeleteTable( sTableName )
        call fCreateTable( aFieldTypeContent(), sTableName )    
        call fInsertIntoTable( aFieldContent(), sTableName )
		call fCloseDatabase
        use "base\level1\inc\b_lvl1_Relations.inc"
        	call tRelation( sFileName, sPWD, sRelTable1, sRelTable2 )
       	 	call tDoubleRelation( sFileName, sPWD, sRelTable1, sRelTable2, sRelTable3 )
          
        use "base\level1\inc\b_lvl1_Query.inc"
        	call b_lvl1_Query(sFileName,"adabas","testtool")  
        
    else
    	warnlog "Data Source could not be created - beyond testcases stopped"
    endif  
       
endcase
'-------------------------------------------------------------------------
testcase tCreateNewLocalAdabasDatabase
    '/// create new local Adabas database
    call fCreateLocalAdabasDatasource(gOfficePath + ConvertPath("user/work/tt_adabas_local.odb"),"db00","super","super"",tt_local")
    
endcase
'-------------------------------------------------------------------------
testcase tUserSettings
    '/// test the usersettings tabpage
    dim iUser    
    call hNewDocument
    ToolsDatasources    
    Kontext "DataSourceAdministration"
        DatabaseSourceList.select "TT_ada1"
        sleep(1)
        TabControl.SetPage TabAdabasUserSettings
        Kontext "TabAdabasUserSettings"
            Kontext "LoginDialog"
                if LoginDialog.Exists(3) then
                    Password.SetText "admin"
                    LoginDialog.OK
                end if
        Kontext "TabAdabasUserSettings"         
        iUser = User.getItemCount
        if iUser <> 4 then
            warnlog "There should be 4 users in the list but there are " + iUser
        endif
        sleep(1)
        AddUser.Click
        sleep(1)
        Kontext "PasswordDLG"
        if PasswordDLG.exists(3) then
            UserName.setText "testtool"
            Password.setText "testtool"
            PasswordConfirm.setText "testtool"
            PasswordDLG.OK
        else
            warnlog "No add user dialog appear"
        endif
        sleep(1)
        Kontext "TabAdabasUserSettings"
        User.select "TESTTOOL"
        sleep(1)
        ChangePassword.Click
        sleep(1)
        Kontext "ChangePassword"
        if ChangePassword.exists(3) then
            OldPassword.setText "testtool"   
            Password.setText "testtool"
            ConfirmPassword.setText "testtool"
            ChangePassword.OK
        else
            warnlog "the changepassword dialog doesn't appear."
        endif
        sleep(1)
        Kontext "TabAdabasUserSettings"        
        User.select "TESTTOOL"
        DeleteUser.Click
        Kontext "MessageBox"
        if MessageBox.exists(3) then
            if MessageBox.getRT = 304 then
                MessageBox.Yes
            endif
        endif
                   
       'AccessRights HID_TAB_PAGE_TBLGRANTS
                
    Kontext "DataSourceAdministration"
        DataSourceAdministration.OK
    call hCloseDocument
endcase
