'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_107_.inc,v $
'*
'*  $Revision: 1.13 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/22 11:18:26 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Detailed test of functions in menu data
'*
'************************************************************************
'*
' #1 C_107_ ' Initial routine
' #1 tDataDefineRange
' #1 tDataSort
' #1 tDataFilterAutoFilter
' #1 tDataFilterStandardfilter
' #1 tDataFilterSpecialfilter
' #1 tDataFilterRemoveFilter
' #1 tDataSubtotals
' #1 tDataValidity
' #1 tDataMultibleOperations
' #1 tDataConsolidate
' #1 tDataConsolidateNew
' #1 tDataOutlineGroup
' #1 tDataOutlineAutoGroup
' #1 tDataRemoveOutline
'*
'\***********************************************************************



sub C_107_
Printlog Chr(13) + "--------- C_107_ ---------"

   Call tDataDefineRange
   Call tDataSort
   Call tDataFilterAutoFilter
   Call tDataFilterStandardfilter
   Call tDataFilterSpecialfilter
   Call tDataFilterRemoveFilter
   Call tDataSubtotals
   Call tDataValidity
   Call tDataMultibleOperations
   Call tDataConsolidate
   Call tDataConsolidateNew
   Call tDataOutlineGroup
   Call tDataOutlineAutoGroup
   Call tDataRemoveOutline
end sub
'
'--------------------------------------------------------------
'
testcase tDataDefineRange
'/// In this test a data range is added into the document. Then it is checked if the range
'/// has benn added. After saving, closing and reopening this file, it is checked, if the range
'/// still exists.

   dim SFile as String
   SFile = convertpath(gOfficePath & "user/work/datarange.ods")
   Call  hNewDocument

   DataDefineRange
   Kontext "DatenbankbereichFestlegen"
   Bereichsname.SetText "Test"
   Hinzufuegen.click
   DatenbankbereichFestlegen.Ok

   DataSelectRange
   Kontext "DatenbankbereichWaehlen"
   if Bereiche.GetItemCount > 0 then
      printlog "OK, the data range has been added"
   else
      warnlog "No data range has been added"
   end if
   DatenbankBereichWaehlen.Ok
   printlog "Save the document"
   call hSpeichernUnterMitFilterKill SFile, gCalcFilter
   sleep 10

   Call hCloseDocument
   printlog "Open the document and check if the data range still exists"
   call hDateiOeffnen SFile

   DataSelectRange
   Kontext "DatenbankbereichWaehlen"
   if Bereiche.GetItemCount > 0 then
      printlog "OK, the data rangestill exists after closing and opening the saved file"
   else
      warnlog "No data range has been lost after closing and opening the saved file"
   end if
   DatenbankBereichWaehlen.Ok
   sleep 20

   Call hCloseDocument

endcase
'
'--------------------------------------------------------------
'
testcase tDataSort
'/// This testcase tests, if the inserted contents (1,3,2,1) into the appropriate
'/// cells A1-A4 are sorted correct in an ascending sequence

   call hNewDocument
   Kontext
   DocumentCalc.TypeKeys "1<Return>3<Return>2<Return>1<Return><Up><Shift Up Up>"
   DataSort
   Kontext
   Active.SetPage TabSortierkriterien
   Kontext "TabSortierkriterien"
   Aufsteigend1.Check
   TabSortierkriterien.Ok

   Kontext
   DocumentCalc.TypeKeys "<Up>"
   Call cCellCompare (1,0,0)

   Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tDataFilterAutoFilter
'/// This test checks, if the autofilter is inserted. The contents 1,2,1 are inserted
'/// into the cells A1-A3. Then the autofilter is called. If the filter is available
'/// the menuitem 'Data|Filter|AutoFilterHide' is enabled and can be called. If not,
'7// a warnlog is written.

   Call  hNewDocument

   Kontext
   DocumentCalc.Typekeys "Value<Return>2<Return>1<Return>2<Return><Up><Shift Up Up Up>"
   DataFilterAutoFilter
   try
      DataFilterHideAutoFilter
      printlog "OK, Autofilter has been inserted "
   catch
      warnlog "No Autofilter has been inserted"
   endcatch

   Call hCloseDocument

endcase
'
'--------------------------------------------------------------
'
testcase tDataFilterStandardfilter
'/// Due to a bug (96651) the standardfilter has to be tested more detailed. The test
'/// uses the appropriate bugdoc to this bug. The testprocedure is the following.
'/// At first check the standardfunctionalitiy in a short way

    Call  hNewDocument
    Kontext
    DocumentCalc.Typekeys "Wert<Return>2<Return>1<Return>2<Return><Up><Shift Up Up Up>"
    DataFilterStandardFilter
    Kontext "Standardfilter"
    FeldName1.select 2
   Bedingung1.select 1
   Wert1.SetText "1"
    Zusaetze.Click
   FilterergebnisNach.Check
   Ausgeben.SetText "B2"
    Standardfilter.Ok
   Kontext

   DocumentCalc.TypeKeys "<Down><Down>1<Return><Up><Up>"
   call cCellCompare (1,0,0)

    Call hCloseDocument
    sleep 5


    '/// Now check this functionality in a more detailed way like the following
    '/// Open the testdocument and check, if there is a database range.
    dim file as String
    dim sfile as String
    dim regular as boolean
    dim cases as integer, reg as integer, double as integer, fresult as integer, pers as integer
    dim field as integer, condition1 as integer, lnk1 as integer, field1 as integer, field2 as integer
    dim condition2 as integer, value2 as integer
    dim value1 as String
    printlog "Now check this functionality in a more detailed way"
    file = convertpath(gTesttoolPath & "calc/level1/input/c_107/tdatafilterstandardfilter.sxc")
    printlog "file: " & file
    sfile = convertpath(gOfficePath & "user/work/tdatafilterstandardfilter.ods")
    call hDateiOeffnen file
    sleep 3
    EditNavigator
    sleep 3
    try
      call Navigatorclick("rest")
      printlog "OK, the database range 'rest' has been found"
    catch
      warnlog "There hasn't been found a database range with name 'rest'"
    endcatch
    ' close the navigator
    sleep 3
    EditNavigator
    sleep 3
    '/// Then go to this range and check if the range is correct selected (A1:E10)
    DataSelectRange
    sleep 2
    Kontext "DatenbankBereichWaehlen"
    DatenbankBereichWaehlen.OK
    sleep 2
    if fWhereIsTheCellCursor() = "A1:E10" then
      printlog "OK, the range has been correct selected"
    else
      warnlog "There has been selected the area " & fWhereIsTheCellCursor() & " instead of 'A1:E10'"
    end if
    sleep 2
   regular = false
   printlog "***Check the first time without regular expressions"
   '/// Call the standardfilter and make some settings, but withtout checking
   '/// regular expressions. Save and reload the document and check the settings again.
   gosub CheckFilter
   regular = true
   printlog "***Check the second time with regular expressions"
   '/// Then call the standardfilter again, but with checking regular expressions and do
   '/// the same as before.
   gosub CheckFilter

    goto testend

CheckFilter:
    DataFilterStandardFilter
    sleep 5
    Kontext "StandardFilter"
    Feldname1.select 2
    field1 = Feldname1.getSelIndex
    Bedingung1.select 1
    condition1 = Bedingung1.getSelIndex
    Wert1.select "charles"
    value1 = Wert1.getSelText
    Zusaetze.click
    GrossKleinSchreibung.check
    cases = GrossKleinSchreibung.getState
    Ausgeben.setText "$Tabelle1.$A$20"
    Persistent.check
    pers = Persistent.getState
    if regular then
      RegulaererAusdruck.check
    else
      RegulaererAusdruck.uncheck
    end if
    reg = RegulaererAusdruck.getState
    KeineDuplikate.uncheck
    double = KeineDuplikate.getState
    Verknuepfung2.select 1
    lnk1 = Verknuepfung2.getSelIndex
    Feldname2.select 3
    field2 = Feldname2.getSelIndex
    Bedingung2.select 2
    condition2 = Bedingung2.getSelIndex
    Wert2.select 6
    value2 = Wert2.getSelIndex

    StandardFilter.OK
    sleep 5
    ' check the output range
    if fWhereIsTheCellCursor() = "A20:E21" then
      printlog "OK, the output range is correct"
    else
      warnlog "There has been selected theoutput range " & fWhereIsTheCellCursor() & " instead of 'A20:E21'"
    end if
    
   if regular = false then
     call hSpeichernUnterMitFilterKill sfile, gCalcFilter
   else
     FileSave
   end if
   sleep 5
    call hCloseDocument
    sleep 5
    Printlog "Now reload the document and check the filtersettings again"
    call hDateiOeffnen sfile
    sleep 5
    DataSelectRange
    sleep 5
    Kontext "DatenbankBereichWaehlen"
    DatenbankBereichWaehlen.OK
    sleep 5
    if fWhereIsTheCellCursor() = "A1:E10" then
      printlog "OK, the range has been correct selected"
    else
      warnlog "There has been selected the area " & fWhereIsTheCellCursor() & " instead of 'A1:E10'"
    end if
    sleep 2
    DataFilterStandardFilter
    sleep 2
    Kontext "StandardFilter"
    Zusaetze.click
    sleep 2
    'Check the made setting
    if Feldname1.getSelIndex = field1 then
      printlog "OK, the index of field1 is correct."
    else
      warnlog "The index of field1 is: " & Feldname1.getSelIndex & " instead of 2"
    end if

    if Bedingung1.getSelIndex = condition1 then
      printlog "OK, the index of condition1 is correct"
    else
      warnlog "The index of condition1 is: " & Bedingung1.getSelIndex & " instead of 1"
    end if

   if Wert1.getSelText = "charles" then
      printlog "OK, the content of value1 is correct"
   else
      warnlog "The content of value1 is: " & Wert1.getSelText & " instaed of 'charles'."
   end if

   if GrossKleinSchreibung.getState = cases then
      printlog "OK, the state of casesensitive is correct"
   else
      warnlog "The state of casesensitive is: " & GrossKleinSchreibung.getState & " instaed of 1"
   end if

   if Persistent.getState = pers then
      printlog "OK, the state of persistence is correct"
   else
      warnlog "The state of persistence is: " & Persistent.getState & " instead of 1"
   end if

   if RegulaererAusdruck.getState = reg then
      printlog "OK, the state of regularexpressions is correct"
   else
      warnlog "the state of regularexpressions is: " & RegulaererAusdruck.getState & " instead of 0"

   end if

   if KeineDuplikate.getState = double then
      printlog "OK, the state of noduplicates is correct"
   else
      warnlog "The state of noduplicates is: " & KeineDuplikate.getState & " instead of 0"
   end if

   if Verknuepfung2.getSelIndex = lnk1 then
      printlog "OK, the index of link2 is correct"
   else
      warnlog "The index of link2 is: " & Verknuepfung2.getSelIndex & " instead of 1"
   end if

   if Feldname2.getSelIndex = field2 then
      printlog "OK, the index of field2 is correct"
   else
      warnlog "The index of field2 is: " & Feldname2.getSelIndex & " instead of 3"
   end if

   if Bedingung2.getSelIndex = condition2 then
      printlog "OK, the index of condition2 is correct"
   else
      warnlog "The index of condition2 is: " & Bedingung2.getSelIndex & " instead of 2"
   end if

   if Wert2.getSelIndex = value2 then
      printlog "OK, the index of value2 is correct"
   else
      warnlog "The index of value2 is: " & Wert2.getSelIndex & " instaed of 6"
   end if

   Kontext "StandardFilter"
   StandardFilter.Cancel
   sleep 2
return
testend:

   call hCloseDocument

endcase
'
'--------------------------------------------------------------
'
testcase tDataFilterSpecialfilter
'/// This test checks, if the advanced filter works.
'/// In column A are 4 values (2,1,2,1) inserted. In column B is
'/// a 1 inserted. Now it is checked if only the 1 is shown
'/// by using as filtercriterium the cellcontent of cell 'B2'

   dim Sheetstring as String, table_name as String

   call  hNewDocument

   select case iSprache
      case 01   : Sheetstring = "$Sheet1.$B$1:$B$2"
      case 03   : Sheetstring = "=$Folha1.$B$1:$B$2"
      case 31   : Sheetstring = "=Werblad1.$B$1:$B$2"
      case 33   : Sheetstring = "$Feuille1.$B$1:$B$2"
      case 34   : Sheetstring = "$Hoja1.$B$1:$B$2"
      case 39   : Sheetstring = "$Tabella1.$B$1:$B$2"
      case 45   : Sheetstring = "$Ark1.$B$1:$B$2"
      case 49   : Sheetstring = "$Tabelle1.$B$1:$B$2"
      case 55   : Sheetstring = "$Planilha1.$B$1:$B$2"
      case 46   : Sheetstring = "$Tabell1.$B$1:$B$2"
      case 48   : Sheetstring = "$Arkusz1.$B$1:$B$2"
      case else  : table_name = getSheetName()
               Sheetstring = table_name & ".$B$1:$B$2"
   end select
   Kontext
   DocumentCalc.Typekeys "<Right>Wert<Return>1<Return><Up><Up><Left>"
   DocumentCalc.Typekeys "Wert<Return>2<Return>1<Return>2<Return>1<Return><Up><Up><Shift Up Up Up>"
   DataFilterAdvancedFilter
   Kontext "Spezialfilter"
   Befinden.setText Sheetstring
   Spezialfilter.Ok
   Kontext
   DocumentCalc.TypeKeys "<Down>"
   call cCellCompare (1,0,0)

   call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tDataFilterRemoveFilter
'/// This test checks, if it is possible to remove a set standardfilter

   call  hNewDocument

   Kontext
   DocumentCalc.Typekeys "Wert<Return><Return>2<Return><Up><Up><Up>"
   call ZellenMarkieren ( 4, 1 )
   DataFilterStandardFilter
   Kontext "Standardfilter"
   Feldname1.select 2
   Bedingung1.select 3
   Wert1.select 1
   Standardfilter.Ok
   try
      DataFilterRemoveFilter
      printlog "Ok"
   catch
      warnlog "Remove Filter doesn't work"
   endcatch

   call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tDataSubtotals
'/// This test check in a short way if it is possible to evaluate subtotals.
'/// In column A in Cells "A2:A4" there are the contents w2-w4 inserted.
'/// in column B in cells "B1:B4" there are the contents test,1,2,3 inserted.
'/// Now the Subtotals dialog is called and in listbox subtotal entry nr.2
'/// is selected. Now in the second column (named 'Test') should be the
'/// single values and the sum of the appropriate rows (w1, w2, w3)

   dim SFile as String
   SFile = convertpath(gOfficePath & "user/work/tdadasubtotals.ods")
   printlog "SFile: " & SFile

   call hNewDocument

   Kontext
   DocumentCalc.TypeKeys "<Return>w1<Return>w2<Return>w3<Return><PageUp>"
   DocumentCalc.TypeKeys "<Right>test<Return>1<Return>2<Return>3<Return><Up><Shift PageUp Left>"
   DataSubtotals
   Kontext
   Active.SetPage TabGruppe1
   Kontext "TabGruppe1"
   try
      Teilergebnisse.select 2
      Berechnungsvorschrift.select 1
      printlog "Subtotal is available"
   catch
      printlog "Subtotals are not testable"
   endcatch
   TabGruppe1.OK

   call hSpeichernUnterMitFilterKill SFile, gCalcFilter
   sleep 3
   call hCloseDocument
   sleep 3
   call hDateiOeffnen SFile
   sleep 10
   Kontext "DocumentCalc"
   if cZellwert("B3") = "1" then
      printlog "OK, the result of cell 'B3' is correct"
   else
      warnlog "The cellcontent of cell 'B3' is " & cZellwert("B3") & " instaed of '1'"
   end if
   if cZellwert("B5") = "2" then
      printlog "OK, the result of cell 'B5' is correct"
   else
      warnlog "The cellcontent of cell 'B5' is " & cZellwert("B5") & " instaed of '2'"
   end if
   if cZellwert("B7") = "3" then
      printlog "OK, the result of cell 'B7' is correct"
   else
      warnlog "The cellcontent of cell 'B7' is " & cZellwert("B7") & " instaed of '3'"
   end if
   if cZellwert("B8") = "6" then
      printlog "OK, the result of cell 'B8' is correct"
   else
      warnlog "The cellcontent of cell 'B8' is " & cZellwert("B8") & " instaed of '6'"
   end if
   sleep 10
   Kontext "DocumentCalc"
   call hCloseDocument

endcase
'
'--------------------------------------------------------------
'
testcase tDataValidity
'/// In a new document there are made some settings in cell "A1" for data validity.
'/// After saving, closing and reloading the document, the settings are checked again.

   dim SFile as String
   SFile = convertpath(gOfficePath & "user/work/tdatavalidity.ods")
   Call hNewDocument
   printlog "Set settings for data validity"
   DataValidity

   Kontext
   Active.setpage TabWerte
   Kontext "TabWerte"
   Zulassen.select 3

   Kontext
   Active.setpage TabEingabehilfe
   Kontext "TabEingabehilfe"
   EingabehilfenbeiSelektion.check

   Kontext
   Active.Setpage TabFehlermeldung
   Kontext "TabFehlermeldung"
   FehlermeldungbeiEingabe.check
   TabFehlermeldung.Ok
   printlog "Check the settings"
   sleep 5
   gosub checksettings
   sleep 5
   printlog "Save file and check again"
   call hSpeichernUnterMitFilterKill SFile, gCalcFilter
   sleep 3
   call hCloseDocument
   sleep 3
   call hDateiOeffnen SFile
   sleep 10
   ' check the settings after saving the file
   gosub checksettings
   goto endtest

checksettings:
   DataValidity
   Kontext
   Active.setpage TabWerte
   Kontext "TabWerte"
   if Zulassen.getselIndex = 3 then
      Printlog "Settings OK"
   else
      if gPlatGroup = "w95" then
         QAErrorLog "Should be BugID #111788#"
      else
         Warnlog "Unexpected validity criteria selected!"
      end if
   end if

   Kontext
   Active.setpage TabEingabehilfe
   Kontext "TabEingabehilfe"
   if EingabehilfenbeiSelektion.ischecked then
      Printlog "TabInputHelp OK"
   else
      Warnlog "Checkbox 'ShowInputHelp' is not checked"
   end if

   Kontext
   Active.Setpage TabFehlermeldung
   Kontext "TabFehlermeldung"
   if FehlermeldungbeiEingabe.ischecked then
      Printlog "Checkbox 'ShowErrorMessage' is OK"
   else
      Warnlog "Checkbox 'ShowErrorMessage' is not checked"
   end if
   TabFehlermeldung.Cancel
return

endtest:
   sleep 30
   Call hCloseDocument

endcase
'
'--------------------------------------------------------------
'
testcase tDataMultibleOperations
'/// This test checks the function from the multible operation. In cell 'b2' is inserted
'/// '13' and in cell 'A2/3' is inserted '1' and '2'. Then the cells 'A2:B3' is selected
'/// and 'DataMultipleOperations' is called. In this dialog there is as input made for the
'/// formula cell the cell 'B2' and as column input cell the cell 'A2'.
'/// In the cells 'B2' and 'B3' should be the results '13' and '26'.

   Call hNewDocument

   Kontext
   DocumentCalc.TypeKeys "<Right>=A2*13<Return><Left>1<Return>2<Return><Up><Shift Right Up>"
   DataMultipleOperations
   Kontext "Mehrfachoperationen"
   Formeln.SetText "$B$1"
   Spalte.SetText "$A$2"
   Mehrfachoperationen.Ok
   sleep 2
   Kontext
   DocumentCalc.TypeKeys "<Up>"
   call cCellCompare (2,0,13)

   call hCloseDocument

endcase
'
'--------------------------------------------------------------
'
testcase tDataConsolidate
'/// This test check the function data consolidate. The following contents are inserted:
'/// 'A1: W1', 'A2: 2', 'C1: W1', 'C2: 11'. Now the approrpiate dialog is called, cells
'/// 'A1:A2' and 'C1:C2' are added as source data areas, the function is set to sum and the
'/// output is set a few rows downwards. Now it is checked if result off the output is '13'.

dim sheetname as String

   Call  hNewDocument

   select case iSprache
      case 01   : sheetname = "$Sheet1"
      case 03   : sheetname = "$Folha1"
      case 31   : sheetname = "$Werkblad1"
      case 33   : sheetname = "$Feuille1"
      case 34   : sheetname = "$Hoja1"
      case 39   : sheetname = "$Tabella1"
      case 45   : sheetname = "$Ark1"
      case 46   : sheetname = "$Tabell1"
      case 48   : sheetname = "Arkusz1"
      case 49   : sheetname = "$Tabelle1"
      case 55   : sheetname = "$Planilha1"
      case else  : sheetname = getSheetName()
   end select
    Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "W1<Return>2<Return>"
   DocumentCalc.TypeKeys "<Right><Up>",2
   DocumentCalc.TypeKeys "W1<Return>11<Return>"
    DataConsolidate
    Kontext "Konsolidieren"
    Quelldaten.SetText sheetname & ".$A$1:$A$2"
   Hinzufuegen.Click
    Quelldaten.SetText sheetname & ".$C$1:$C$2"
   Hinzufuegen.Click
    Ausgeben.SetText sheetname & ".$A$6"
   Zusaetze.Click
   Spaltenkoepfen.Check
    Konsolidieren.Ok
    Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<Left>",2
   DocumentCalc.TypeKeys "<Down>",4
    call cCellCompare (0,1,-13)
    call hCloseDocument
endcase
'
'--------------------------------------------------------------
'
testcase tDataConsolidateNew
'/// This test checks the consolidate function by using data source areas in different
'/// sheets. The checked function is in this case "Count (numbers only)".

   dim gibsher$
   dim i As Integer
   dim Cell As String
   dim Reslt As Integer
   call hNewDocument
   select case iSprache
      case 01   : gibsher$ = "$Sheet"
      case 03   : gibsher$ = "$Folha"
      case 31   : gibsher$ = "$Werkblad"
      case 33   : gibsher$ = "$Feuille"
      case 34   : gibsher$ = "$Hoja"
      case 39   : gibsher$ = "$Tabella"
      case 45   : gibsher$ = "$Ark"
      case 46   : gibsher$ = "$Tabell"
      case 48   : gibsher$ = "$Arkusz"
      case 49   : gibsher$ = "$Tabelle"
      case 55   : gibsher$ = "$Planilha"
      case else  : gibsher$ = getSheetName(1)
   end select
   printlog "SheetName: " & gibsher
   Kontext
   DocumentCalc.TypeKeys "11<Return>12<Return>13<Return>14<Return>15<Return>16<Return>17<Return>"
   fCalcSelectSheet ( 2 )
   cgotocell("A1")
   Kontext
   DocumentCalc.TypeKeys "21<Return>22<Return>23<Return>24<Return>25<Return>26<Return>27<Return>"
   fCalcSelectSheet ( 3 )
   cgotocell("A1")
   Kontext
   DataConsolidate
   Kontext "Konsolidieren"
   Berechnungsvorschrift.Select 7
   Quelldaten.SetText gibsher$ & "1.$A$1:$A$7"
   Hinzufuegen.Click
   Quelldaten.SetText gibsher$ & "2.$A$1:$A$7"
   Hinzufuegen.Click
   Ausgeben.SetText gibsher$ & "3.$A$1"
   Konsolidieren.Ok
   Kontext

   For i = 1 to 7
   Cell = "A" & i
   if cZellwert(Cell) <> 2 then Warnlog Cell & ": Consolidate has failed: Number doesn't work!"
   next i

   Kontext
   DataConsolidate
    Kontext "Konsolidieren"
   Berechnungsvorschrift.Select 1
    Quelldaten.SetText gibsher$ & "1.$A$1:$A$7"
   Hinzufuegen.Click
    Quelldaten.SetText gibsher$ & "2.$A$1:$A$7"
   Hinzufuegen.Click
    Ausgeben.SetText gibsher$ & "3.$A$1"
    Konsolidieren.Ok
   Kontext

   Reslt = 32
   For i = 1 to 7
   Cell = "A" & i
   if cZellwert(Cell) <> Reslt then Warnlog Cell & ": Consolidate has failed: Number doesn't work!"
   Reslt = Reslt + 2
   next i

   Kontext
   call hCloseDocument
endcase
'
'--------------------------------------------------------------
'
testcase tDataOutlineGroup
'/// This test check, if the menuitems 'DataOutlineGroup', 'DataOutlineHideDetails',
'/// 'DataOutlineShowDetails' and 'DataOutlineUngroup' are available.

   call  hNewDocument
    Kontext
   DocumentCalc.Typekeys "Wert<Return>1<Return>2<Return>3<Return><Up><Shift Up Up Up>"
    try
      DataOutlineGroup
      Kontext "GruppierungAktivieren"
      GruppierungAktivieren.OK
      printlog "Group Ok"
       DataOutlineHideDetails
       sleep (1)
      printlog "Hide Ok"
       DataOutlineShowDetails
       sleep (1)
      printlog "Show Ok"
        DataOutlineUngroup
        printlog "Ungroup Ok"
   catch
      warnlog "Group has not worked (Group, Hide, Show, Ungroup)"
   endcatch
    call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tDataOutlineAutoGroup
'/// This test checks if the details are hide. In cells 'A1:A3' the values
'/// '1,2,3' are inserted. In cell 'A4' the sum of the above cells is created.
'/// Now the function 'DataOutlineAutoGroup' is called and it is checked, if
'/// the details are hide, but the result is visible.

Dim merksdir$
   select case iSprache
      case 01   : merksdir$ = "1<Return>2<Return>3<Return>=Sum(A1:A3)<Return><Up>"
      case 03   : merksdir$ = "1<Return>2<Return>3<Return>=SOMA(A1:A3)<Return><Up>"
      case 31   : merksdir$ = "1<Return>2<Return>3<Return>=SOM(A1:A3)<Return><Up>"
      case 33   : merksdir$ = "1<Return>2<Return>3<Return>=Somme(A1:A3)<Return><Up>"
      case 34   : merksdir$ = "1<Return>2<Return>3<Return>=Suma(A1:A3)<Return><Up>"
      case 39   : merksdir$ = "1<Return>2<Return>3<Return>=Somma(A1:A3)<Return><Up>"
      case 45   : merksdir$ = "1<Return>2<Return>3<Return>=Sum(A1:A3)<Return><Up>"
      case 46   : merksdir$ = "1<Return>2<Return>3<Return>=Summa(A1:A3)<Return><Up>"
      case 48   : merksdir$ = "1<Return>2<Return>3<Return>=Suma(A1:A3)<Return><Up>"
      case 49   : merksdir$ = "1<Return>2<Return>3<Return>=Summe(A1:A3)<Return><Up>"
      case 55   : merksdir$ = "1<Return>2<Return>3<Return>=Soma(A1:A3)<Return><Up>"
      case >80  : merksdir$ = "1<Return>2<Return>3<Return>=Sum(A1:A3)<Return><Up>"
      case else : QAErrorlog "Language adjustment missing for: " & iSprache : goto endsub
   end select
    call hNewDocument
   Kontext
   DocumentCalc.Typekeys merksdir$
    FormatConditionalFormatting
    Kontext "BedingteFormatierung"
   PopupList1.select 1
   Vergleich1.select 1
   TextField1.Typekeys "6"    'wird nicht eingetragen
   Zellvorlage1.Select 2
   BedingteFormatierung.Ok
   Kontext
   DocumentCalc.Typekeys "<Shift Up Up Up>"
    DataOutlineAutoOutline
   try
      DataOutlineHideDetails
                Kontext
                DocumentCalc.TypeKeys "<up><down>"
      if fWhereIsTheCellCursor = "A4" then
            printlog "OK, the details are hide"
         Else
            warnlog "By calling DataOutlineAutoGroup the result has been hide too!"
         end if
   catch
       warnlog "Group has not been created"
   endcatch
   Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tDataRemoveOutline
'/// This test checks if the group of cellcontents are removed. In cells 'A1:A4' are
'/// inserted the contents 'Wert,1,2,3'. Then the menuitem 'DataOutlineGroup' is called
'/// and confirmed with OK. No the cursor is moved RIGHT and the menuitem 'DataOutlineRemove'
'/// is called. Then it is checked if it is still possible to call the menuitem
'/// 'DataOutlineHideDetails' which should be unavailable because the group was removed.

   call hNewDocument

   Kontext
   DocumentCalc.Typekeys "Wert<Return>1<Return>2<Return>3<Return><Up><Shift Up Up Up>"
   Kontext
   DataOutlineGroup
   Kontext "GruppierungAktivieren"
   GruppierungAktivieren.OK
    Kontext
   DocumentCalc.TypeKeys "<Right>"
    DataOutlineRemove
    try
      DataOutlineHideDetails
       warnlog "Gliederung nicht entfernt"
    catch
       printlog "Ok"
    endcatch
    Call hCloseDocument
endcase
'
'--------------------------------------------------------------
'

