'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: calc_import_general.bas,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/08 07:59:21 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Simply load max. 1000 files in .../calc/loadsave/input-directory
'*
'\***********************************************************************

global gsSourceDocument(1000) as string
global giWhichSecurityLevel as integer
global gsSourcePath as string

sub main
    use "calc\loadsave\inc\calc_import_general.inc"
    
    gsSourcePath = ConvertPath(gTestToolPath + "calc\loadsave\input\")
    'Checking in .../common sub-directory if there is a file
    'to be sure to have access to the files
    if Dir(gsSourcePath) & "common\" = "" then
        warnlog "qa:qatesttool:calc:loadsave:calc_import_general.bas: Unable to find document directory! Please adapt 'gsSourcePath'"
        exit sub
    endif    

    Call sPreconditions
        Call hStatusIn ( "calc", "calc_import_general.bas" )        
            Call tLoadAllDocuments (gsSourcePath)        
        Call hStatusOut
    Call sResetSystemUnderTest
end sub
'
'-------------------------------------------------------------------------------
'
sub LoadIncludeFiles
    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    Call GetUseFiles
    gApplication = "Calc"
end sub

'
'-------------------------------------------------------------------------------
'
sub sPreconditions    
    'Init the iWhichSecurityLevel() variable with 2
    'which would be the normal state if it's impossible
    'to detect the macro security level.
    giWhichSecurityLevel = 2
    'Get the macro security level and remember it.
    'and then set the Macro security level to (0) low
    giWhichSecurityLevel = hSetMacroSecurity(0)
end sub
'
'-------------------------------------------------------------------------------
'
sub sResetSystemUnderTest
    'Set the macro security level back to the value
    'which has it before the system was under test
    call hSetMacroSecurity(giWhichSecurityLevel)
end sub
'
'-------------------------------------------------------------------------------
'
