'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: clipboardtest.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/15 13:51:03 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Clipboard Test - Testcases
'*
'************************************************************************
'*
' #1 clipboardtest     ' Initial routine
' #1 clipboard_check_message
' #1 clipboard_check_formats
' #1 clipboard_check_editmode
' #1 clipboard_check_editmode_to_sheet
' #1 clipboard_check_sheet_to_editmode
' #1 clipboard_check_drawingObjects
' #1 clipboard_check_PixelGraphics
' #1 clipboard_check_WMFGraphics
'*
'\***********************************************************************

sub clipboardtest

Printlog Chr(13) + "--------- clipboardtest ---------"

        call clipboard_check_message
        call clipboard_check_formats
        call clipboard_check_editmode
        call clipboard_check_editmode_to_sheet
        call clipboard_check_sheet_to_editmode
        call clipboard_check_drawingObjects
        call clipboard_check_PixelGraphics
        call clipboard_check_WMFGraphics

end sub

testcase clipboard_check_message
'/// This testcase checks, if the overwrite warning appears, when you paste a contentin a cell
'/// which has already a content
'/// First call a new document

   Call hNewDocument
'/// Then insert a content in cell 'A1' and 'A2'
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "Hi"
   DocumentCalc.TypeKeys "<RETURN>"
   DocumentCalc.TypeKeys "Hello"
   DocumentCalc.TypeKeys "<RETURN>"
   DocumentCalc.TypeKeys "<UP>"
'/// Now copy the content of cell 'A2' into cell 'A1' and use for copy at first
'/// the menuitems Edit|Copy and Edit|Paste
   EditCopy
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   EditPaste
'/// Check if the warning message appears and click NO
   Kontext "Active"
   if Active.exists then Active.NO
'/// Check if the cellcontent is the same as before
   if cZellwert("A1") = "Hi" then
      printlog "OK, the cellvalue is the same as before, after dissmiss the overwrite dialog"
   else
      warnlog "The cellvalue from 'A1' is: " & cZellwert("A1") & " instead of 'Hi'"
   end if
'/// Now do the same, but confirm the warning message with OK
   call cgotocell("A2")
   EditCopy
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   EditPaste
   '/// Check if the warning message appears and click YES
   Kontext "Active"
   if Active.exists then Active.YES
   '/// Check if the cellcontent is the same as before
   if cZellwert("A1") = "Hello" then
      printlog "OK, the cellvalue is similar to cellcontent from 'A2' after confirm the overwrite dialog"
   else
      warnlog "The cellvalue from 'A1' is: " & cZellwert("A1") & " instead of 'Hello'"
   end if

   call hCloseDocument

'/// Now we do exactly the same by using the keyboard shortcuts <CTRL+C> <CTRL+V>

   Call hNewDocument
   printlog "Doing the same by using the keyboard shortcuts <CTRL+C> <CTRL+V>"
'/// Then insert a content in cell 'A1' and 'A2'
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "Hi"
   DocumentCalc.TypeKeys "<RETURN>"
   DocumentCalc.TypeKeys "Hello"
   DocumentCalc.TypeKeys "<RETURN>"
   DocumentCalc.TypeKeys "<UP>"
'/// Now copy the content of cell 'A2' into cell 'A1' and use for copy at first
'/// the menuitems Edit|Copy and Edit|Paste
   DocumentCalc.TypeKeys "<MOD1 C>"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<MOD1 V>"
'/// Check if the warning message appears and click NO
   Kontext "Active"
   if Active.exists then Active.NO
'/// Check if the cellcontent is the same as before
   if cZellwert("A1") = "Hi" then
      printlog "OK, the cellvalue is the same as before, after dissmiss the overwrite dialog"
   else
      warnlog "The cellvalue from 'A1' is: " & cZellwert("A1") & " instead of 'Hi'"
   end if
'/// Now do the same, but confirm the warning message with OK
   call cgotocell("A2")
   DocumentCalc.TypeKeys "<MOD1 C>"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<MOD1 V>"
   '/// Check if the warning message appears and click YES
   Kontext "Active"
   if Active.exists then Active.YES
   '/// Check if the cellcontent is the same as before
   if cZellwert("A1") = "Hello" then
      printlog "OK, the cellvalue is similar to cellcontent from 'A2' after confirm the overwrite dialog"
   else
      warnlog "The cellvalue from 'A1' is: " & cZellwert("A1") & " instead of 'Hello'"
   end if

   call hCloseDocument

'/// Now we disable the overwrite warning in the general settings from calc
'/// and execute the same test procedure

   call hNewDocument

   printlog "Check the same, but disable the overwrite message in the options dialog"
   ToolsOptions
   hToolsOptions("SPREADSHEET", "GENERAL")
   Ueberschreibwarnung.uncheck
   Kontext "OptionenDlg"
   OptionenDlg.OK

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "Hi"
   DocumentCalc.TypeKeys "<RETURN>"
   DocumentCalc.TypeKeys "Hello"
   DocumentCalc.TypeKeys "<RETURN>"
   DocumentCalc.TypeKeys "<UP>"
'/// Now copy the content of cell 'A2' into cell 'A1' and use for copy at first
'/// the menuitems Edit|Copy and Edit|Paste
   EditCopy
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   EditPaste
'/// Check if the warning message appears and click YES, if it appears
   Kontext "Active"
   if Active.exists then
      warnlog "The overwrite warning appears, although it was disabled in the options dialog"
      Active.YES
   else
      printlog "OK, no warning message appears"
   end if

'/// Check if the cellcontent is the same as before
   if cZellwert("A1") = "Hello" then
      printlog "OK, the cellvalue from 'A1' is similar to cellcontent from 'A2'"
   else
      warnlog "The cellvalue from 'A1' is: " & cZellwert("A1") & " instead of 'Hello'"
   end if

   call hCloseDocument

'/// Now we do exactly the same by using the keyboard shortcuts <CTRL+C> <CTRL+V>

   Call hNewDocument
   printlog "Doing the same by using the keyboard shortcuts <CTRL+C> <CTRL+V>"
'/// Then insert a content in cell 'A1' and 'A2'
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "Hi"
   DocumentCalc.TypeKeys "<RETURN>"
   DocumentCalc.TypeKeys "Hello"
   DocumentCalc.TypeKeys "<RETURN>"
   DocumentCalc.TypeKeys "<UP>"
'/// Now copy the content of cell 'A2' into cell 'A1' and use for copy at first
'/// the menuitems Edit|Copy and Edit|Paste
   DocumentCalc.TypeKeys "<MOD1 C>"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<MOD1 V>"
'/// Check if the warning message appears and click YES
   Kontext "Active"
   if Active.exists then
      warnlog "The overwrite warning appears, although it was disabled in the options dialog"
      Active.YES
   else
      printlog "OK, no warning message appears"
   end if
'/// Check if the cellcontent is the same as before
   if cZellwert("A1") = "Hello" then
      printlog "OK, the cellvalue from 'A1' is similar to cellcontent from 'A2'"
   else
      warnlog "The cellvalue from 'A1' is: " & cZellwert("A1") & " instead of 'Hello'"
   end if

'/// Undo the made settings in the option dialog
   ToolsOptions
   hToolsOptions("SPREADSHEET", "GENERAL")
   Ueberschreibwarnung.check
   Kontext "OptionenDlg"
   OptionenDlg.OK

   call hCloseDocument

endcase

testcase clipboard_check_formats
'/// This test checks, if the numberformat, fontattributes, alignment, border, background and
'/// cleeprotection is copied

'/// Load the file (gTesttoolPath & "calc/special/input/clipboardtest.sxc") ...
   call hDateiOeffnen File
   sleep 3
   call fCalcSelectSheet("Numberformats")
'/// ... and check the copy function first with the menuitem Edit|Copy/Paste
   printlog "Copy the cell 'B1' and paste it into 'C1'"
   Kontext "DocumentCalc"
   call cgotocell("B1")
   EditCopy
   DocumentCalc.TypeKeys "<RIGHT>"
   EditPaste
   printlog "Check all appropriate properties and look after cellprotection (must be active)"
   call checkFormatsAndAttributes(true)
   printlog "Copy the cell 'B2' and paste it into 'C2'"
   call cgotocell("B2")
   EditCopy
   DocumentCalc.TypeKeys "<RIGHT>"
   EditPaste
   printlog "Check all appropriate properties and look after cellprotection (must be inactive)"
   call checkFormatsAndAttributes(false)

   Kontext "DocumentCalc"

   call hCloseDocument

endcase

testcase clipboard_check_editmode_to_sheet
'/// This test checks, if the clipboard works in the edit mode of a cell
'/// Contents are paste to sheet. First open a new calc, and insert something in a cell
   call hNewDocument
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "Example<RETURN>"
   DocumentCalc.TypeKeys "<UP>"
'/// Then goto the cell with the content and press <F2> to enable the edit mode
   DocumentCalc.TypeKeys "<F2>"
'/// Select all of the cell and press copy the cell first with <CTRL C>
   DocumentCalc.TypeKeys "<MOD1 SHIFT LEFT>"
   printlog "Copy the cellcontent with '<CTRL C>' and paste it with <CTRL V>'"
   DocumentCalc.TypeKeys "<MOD1 C>"
'/// deselect the cell and goto to another cell
   DocumentCalc.TypeKeys "<ESCAPE>"
   DocumentCalc.TypeKeys "<DOWN>"
   DocumentCalc.TypeKeys "<MOD1 V>"
   if cZellwert("A2") = "Example" then
      printlog "OK, the cellcontent has been correct copied"
   else
      warnlog "The cellcontent is " & cZellwert("A2") & " instead of 'Example'"
   end if
   printlog "Now we do the same with the menuitems 'Edit|Copy/Paste'"
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   EditCopy
   DocumentCalc.TypeKeys "<DOWN><DOWN>"
   EditPaste
   if cZellwert("A3") = "Example" then
      printlog "OK, the cellcontent has been correct copied"
   else
      warnlog "The cellcontent is " & cZellwert("A2") & " instead of 'Example'"
   end if

   call hCloseDocument

endcase

testcase clipboard_check_editmode
'/// This test checks, if it is possible to copy and paste contents from a cell in editmode
'/// to the same cell
'/// First open a new document, and insert in a cell any content.
   call hNewDocument
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "Example<RETURN><UP>"
'/// Then open this cell in editmode, select the content ans paste it into the same cell
'/// Attempt Copy and paste first with the approprita eshortcuts
   printlog "Attempt Copy and paste first with the approprita eshortcuts"
   DocumentCalc.TypeKeys "<F2>"
   DocumentCalc.TypeKeys "<MOD1 SHIFT LEFT>"
   DocumentCalc.TypeKeys "<MOD1 C>"
   DocumentCalc.TypeKeys "<END>"
   DocumentCalc.TypeKeys "<MOD1 V>"
   DocumentCalc.TypeKeys "<RETURN>"
   if cZellWert("A1") = "ExampleExample" then
      printlog "OK, the cellcontent has been correct copied in the editmode"
   else
      warnlog "The cellcontent from 'A1' is " & cZellWert("A1") & " instead of 'ExampleExample'"
   end if
'/// Then attempt ti with the menuitems
   printlog "Now we do the same with the appropriate menuitems"
   call cgotocell ("A2")
   DocumentCalc.TypeKeys "Second<RETURN><UP>"
   DocumentCalc.TypeKeys "<F2>"
   DocumentCalc.TypeKeys "<MOD1 SHIFT LEFT>"
   EditCopy
   DocumentCalc.TypeKeys "<END>"
   EditPaste
   DocumentCalc.TypeKeys "<RETURN>"
   if cZellWert("A2") = "SecondSecond" then
      printlog "OK, the cellcontent has been correct copied in the editmode"
   else
      warnlog "The cellcontent from 'A2' is " & cZellWert("A2") & " instead of 'SecondSecond'"
   end if

   call hCloseDocument

endcase

testcase clipboard_check_sheet_to_editmode
'/// This test checks, if the clipboard works in the edit mode of a cell
'/// Contents are paste from sheet to a cell which is accessed in the edit mode.
'/// First open a new calc, and insert something in two cells
   call hNewDocument
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "Example<RETURN>"
   DocumentCalc.TypeKeys "Here is an <RETURN>"
   DocumentCalc.TypeKeys "<UP><UP>"
'/// Then copy the content from the first cell ...
   printlog "Copy the cellcontent with <CTRL C> and paste it with <CTRL V>"
   DocumentCalc.TypeKeys "<MOD1 C>"
   DocumentCalc.TypeKeys "<DOWN>"
'/// ... enable the edit mode of the second cell ...
   DocumentCalc.TypeKeys "<F2>"
   DocumentCalc.TypeKeys "<MOD1 V>"
'/// ... and paste the content into it
   DocumentCalc.TypeKeys "<RETURN>"
'/// Check, if the new cellconent has as append the contetn from the first cell
   if cZellwert ("A2") = "Here is an Example" then
      printlog "OK, the cellcontent from cell 'A1' has been appended to the cellcontent from 'A2'"
   else
      warnlog "The cellcontent from 'A2' is " & cZellwert ("A2") & " instead of 'Here is an Example'"
   end if

   printlog "Now we do the same by using the appropriate menuitems"
   call cgotocell ("A3")
   DocumentCalc.TypeKeys "Example<RETURN>"
   DocumentCalc.TypeKeys "Here is another <RETURN>"
   DocumentCalc.TypeKeys "<UP><UP>"
   EditCopy
   DocumentCalc.TypeKeys "<DOWN>"
   DocumentCalc.TypeKeys "<F2><END>"
   EditPaste
   DocumentCalc.TypeKeys "<RETURN>"
   if cZellwert("A4") = "Here is another Example" then
      printlog "OK, the cellcontent from cell 'A3' has been appended to the cellcontent from 'A4'"
   else
      warnlog "The cellcontent from 'A4' is " & cZellwert ("A4") & " instead of 'Here is another Example'"
   end if

   call hCloseDocument

endcase

testcase clipboard_check_drawingObjects
'/// This test check, if the clipboard works with drawing objects
'/// Copy and paste is tested with the menu and the keyboard shortcuts

'/// Open a new calcdocument and draw a rectangle
   call hNewDocument
   Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
   Kontext "Drawbar"
'   Drawbar.Move 20,20
   Rechteck.click

   call gMouseMove (10,10,30,30)
   Sleep 1
   Kontext "DocumentCalc"
'/// Copy this rectangle with <CTRL C> and paste it with <CTRL V>
   printlog "Copy and paste a rectangle by using <CTRL C> and <CTRL V>"
   DocumentCalc.TypeKeys "<MOD1 C>"
   call cgotocell("A20")
   DocumentCalc.TypeKeys "<ESCAPE>"
   DocumentCalc.TypeKeys "<MOD1 V>"
   call checkInsertedObject("DrawingObject")
   call hCloseDocument
'/// Do the same by using the menu
   call hNewDocument
   Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
   Kontext "Drawbar"
   Rechteck.click
   printlog "Copy and paste a rectangle by using the appropriate menuitems"
   call gMouseMove (10,10,30,30)
   Sleep 1
   EditCopy
   call cgotocell("A20")
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE>"
   EditPaste
   call checkInsertedObject("DrawingObject")

   call hCloseDocument

endcase

testcase clipboard_check_PixelGraphics
'/// This test checks the clipboard by using pixel graphics
'/// As the tests before, it is tested by using the keyboard shortcuts and the menuitems
   dim PixelFile as String
   PixelFile = convertpath(gTesttoolPath & "calc/special/input/usa.bmp")

'/// Open a new calcdocument
   call hNewDocument
   sleep(2)
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
'/// Call the menuitem 'InsertGraphicsFromFile' and choose the bitmap
'/// '(gTesttoolPath & "global/input/graf_inp/usa.bmp")'
   InsertGraphicsFromFile
   Kontext "GrafikEinfuegenDlg"
   Dateiname.setText PixelFile
   Auswaehlen.click
   sleep(2)
'/// Copy and paste the graphics by using the keyboard shortcuts
   printlog "Copy and paste the graphics by using the keyboard shortcuts"
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 C>"
   sleep(2)
   call cgotocell ("A20")
   sleep(2)
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE>"
   DocumentCalc.TypeKeys "<MOD1 V>"
   sleep(2)
   call checkInsertedObject("PixelGraphic")
   sleep(2)
   call hCloseDocument
   sleep(2)
'/// Do the same by using the menu
   call hNewDocument
   sleep(2)
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   InsertGraphicsFromFile
   Kontext "GrafikEinfuegenDlg"
   Dateiname.setText PixelFile
   Auswaehlen.click
   sleep(2)
'/// Copy and paste the graphics by using the keyboard shortcuts
   printlog "Copy and paste the graphics by using the menu"
   EditCopy
   sleep(2)
   call cgotocell ("A20")
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE>"
   sleep(2)
   EditPaste
   sleep(2)
   call checkInsertedObject("PixelGraphic")
   sleep(2)
   call hCloseDocument

endcase
'
'-------------------------------------------------------------------------
'
testcase clipboard_check_WMFGraphics
'/// This test checks the clipboard by using WMF graphics
'/// As the tests before, it is tested by using the keyboard shortcuts and the menuitems
   dim WMFFile as String
   if gNetzInst then
      WMFFile = convertpath(gNetzOfficePath & "share/gallery/clima/sun_funny.wmf")
   else
      WMFFile = convertpath(gOfficePath & "share/gallery/clima/sun_funny.wmf")
   end if

'/// Open a new calcdocument
   call hNewDocument
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
'/// Call the menuitem 'InsertGraphicsFromFile' and choose the bitmap
'/// '(gOfficePath & "share/gallery/clima/sun_funny.wmf")'
   InsertGraphicsFromFile
   Kontext "GrafikEinfuegenDlg"
   Dateiname.setText WMFFile
   Auswaehlen.click
'/// Copy and paste the graphics by using the keyboard shortcuts
   printlog "Copy and paste the graphics by using the keyboard shortcuts"
   Kontext "NavigatorCalc"
   if NavigatorCalc.exists then NavigatorCalc.close
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 C>"
   call cgotocell ("A20")
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE>"
   DocumentCalc.TypeKeys "<MOD1 V>"
   call checkInsertedObject("WMFGraphic")
   call hCloseDocument
'/// Do the same by using the menu
   call hNewDocument
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   InsertGraphicsFromFile
   Kontext "GrafikEinfuegenDlg"
   Dateiname.setText WMFFile
   Auswaehlen.click
'/// Copy and paste the graphics by using the keyboard shortcuts
   printlog "Copy and paste the graphics by using the menu"
   Kontext "DocumentCalc"
   EditCopy
   call cgotocell ("A20")
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE>"
   EditPaste
   call checkInsertedObject("WMFGraphic")

   call hCloseDocument

endcase



