'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: keyboardaccessibility4.inc,v $
'*
'*  $Revision: 1.16 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/22 09:07:46 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Keyboard_Accessibility - 4
'*
'************************************************************************
'*
' #1 tMoveDrawObject1
' #1 tMoveDrawObject2
' #1 tEnteringControl1
' #1 tEnteringControl2
' #1 tCreateDefaultDrawObject1
' #1 tTravelObject1
' #1 tTravelObject2
' #1 tTravelObject3
' #1 tInsertSpecialCharacter1
' #1 tInsertSpecialCharacter2
' #1 tInsertSpecialCharacter3
'*
'\***********************************************************************

sub C_Keyboard_Accessibility_4

   printlog Chr(13) + "=== Keyboard_Accessibility 4 ==="

   printlog Chr(13) + "-- Test moving draw objects"
      Call tMoveDrawObject1     'Check if the selected object can be moved by the arrow keys
      Call tMoveDrawObject2     'Check if the selected object can be moved in 1 pixel steps using ALT+arrow keys

   printlog Chr(13) + "-- Test entering control"
      Call tEnteringControl1    'Check if SHIFT+CTRL+F2 enters the input line
      Call tEnteringControl2    'Check if SHIFT+CTRL+F5 enters the sheet area control

'   printlog Chr(13) + "-- Test entering control"
'      Call tCreateDefaultDrawObject1     'Check if CTRL+Return can generate a draw object which is in the middle of the view

   printlog Chr(13) + "-- Select first draw object and travel through severeal ojbects"
      Call tTravelObject1        'Check if first drawing object is selected ,Check if background objects are reachable as well
      Call tTravelObject2        'Check if TAB travels forward through the drawing objects
      Call tTravelObject3        'Check if Shift + TAB travels backward through the drawing objects

   printlog Chr(13) + "-- Select first draw object and travel through severeal ojbects"
      Call tInsertSpecialCharacter1     'Check if characters from the table can be selected with SPACE
      Call tInsertSpecialCharacter2     'Check if RETURN (OK) puts the correct string into the cell
      Call tInsertSpecialCharacter3     'Check if characters from the table can be selected with SPACE

end sub
'
'-------------------------------------------------------------------------------
'
testcase tMoveDrawObject1
    printlog "Check if the selected object can be moved by the arrow keys"
    '/// Check if the selected object can be moved by the arrow keys
    
    Dim sPositionX as string
    Dim sPositionY as string
    Dim sPositionXGet as string
    Dim sPositionYGet as string
    Dim sPositionXMove as string
    Dim sPositionYMove as string
    
    sPositionX          = "3" + gSeperator + "00" + gMeasurementUnit
    sPositionY          = "3" + gSeperator + "00" + gMeasurementUnit
    sPositionXMove      = "3" + gSeperator + "20" + gMeasurementUnit
    sPositionYMove      = "3" + gSeperator + "20" + gMeasurementUnit

    call  hNewDocument
        '/// Insert a drawing object (rectangle)
        Call fDrawObjects("RECHTECK", 30, 40, 60, 60)
        Call gMouseClick(40,50)
        
        '/// Set x position and y position in Format/Position and Size
        Call fPositionAndSize("TabPositionAndSize")
        PositionX.Settext sPositionX
        PositionY.Settext sPositionY
        TabPositionAndSize.OK
        
        '/// Move the draw object
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Right>" , 2
        DocumentCalc.TypeKeys "<Down>"  , 2
        
        '/// Check if the draw object's position is correct
        fPositionAndSize("TabPositionAndSize")
        
        sPositionXGet = PositionX.GetText
        
        if fCalculateTolerance(sPositionXGet, sPositionXMove) > 0.015 then 
            warnlog "Expected X-Position: '" & sPositionXMove & "' but is: '" & sPositionXGet & "'"
        end if
        
        sPositionYGet = PositionY.GetText
        
        if fCalculateTolerance(sPositionYGet, sPositionYMove) > 0.015 then 
            warnlog "Expected Y-Position: " & sPositionYMove & "  but is: '" & sPositionYGet & "'"
        end if
        
        TabPositionAndSize.Cancel
    Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tMoveDrawObject2

    Dim sPositionX as string
    Dim sPositionY as string
    Dim sPositionXGet as string
    Dim sPositionYGet as string  
    Dim sPositionXMove as string
    Dim sPositionYMove as string

    sPositionX          = "3" + gSeperator + "00" + gMeasurementUnit
    sPositionY          = "3" + gSeperator + "00" + gMeasurementUnit
    sPositionXMove      = "3" + gSeperator + "02" + gMeasurementUnit
    sPositionYMove      = "3" + gSeperator + "02" + gMeasurementUnit

    printlog "Check if the selected object can be moved in 1 pixel steps using ALT+arrow keys"
    '/// Check if the selected object can be moved in 1 pixel steps using ALT+arrow keys

    call  hNewDocument
        '/// Insert a drawing object (rectangle)
        Call fDrawObjects("RECHTECK", 30, 40, 60, 60)
        Call gMouseClick(40,50)
        
        '/// Set x position and y position in Format/Position and Size
        Call fPositionAndSize("TabPositionAndSize")
        PositionX.Settext sPositionX
        PositionY.Settext sPositionY
        TabPositionAndSize.OK
        
        '/// Move the draw object
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<MOD2 RIGHT>"
        sleep(1)
        DocumentCalc.TypeKeys "<MOD2 DOWN>"
        sleep(1)
        
        '/// Check if the draw object's position is correct
        fPositionAndSize("TabPositionAndSize")
        
        sPositionXGet = PositionX.GetText
        
        if fCalculateTolerance(sPositionXGet, sPositionXMove) > 0.015 then 
            warnlog "Expected X-Position: '" & sPositionXMove & "' but is '" & sPositionXGet & "'"
        end if
        
        sPositionYGet = PositionY.GetText
        
        if fCalculateTolerance(sPositionYGet, sPositionYMove) > 0.015 then 
            warnlog "Expected Y-Position: '" & sPositionYMove & "' but is '" & sPositionYGet & "'"
        end if
        TabPositionAndSize.Cancel
    Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tEnteringControl1
    printlog "Check if SHIFT+CTRL+F2 enters the input line"
    '/// Check if SHIFT+CTRL+F2 enters the input line
    call  hNewDocument
        Kontext "RechenleisteCalc"
        try
            if Uebernehmen.IsVisible then 
                warnlog "Uebernehmen Should NOT been seen"
            end if
            if Verwerfen.IsVisible then 
                warnlog "Verwerfen Should NOT been seen"
            end if
        catch            
        endcatch
        Kontext "DocumentCalc"
        '/// Press Ctrl + Shift + F2
        DocumentCalc.TypeKeys "<MOD1 SHIFT F2>"

        Kontext "RechenleisteCalc"
        '/// Check if the focus is in input line
        '/// Hints : Check if Uebernehmen(58771) and Verwerfen(58770) are Enabled
        try
            if Uebernehmen.IsEnabled = FALSE then 
                warnlog "Uebernehmen should be Enabled"
            end if
            if Verwerfen.IsEnabled = FALSE then 
                warnlog "Verwerfen should be Enabled"
            end if
        catch
            warnlog "Something wrong when trying to test entering control"
        endcatch
    Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tEnteringControl2

  printlog "Check if SHIFT+CTRL+F5 enters the sheet area control"
  '/// Check if SHIFT+CTRL+F5 enters the sheet area control
  '/// Hint : In fact, this case can't test focus . Maybe the manual test is still needed.

  Dim sAreaContrl as string

  sAreaContrl = "A1"

  call  hNewDocument

   Kontext "DocumentCalc"

   DocumentCalc.TypeKeys "<SHIFT Right>" , 2
   EditCopy
   if GetClipboardText = sAreaContrl then Warnlog "Something wrong before trying to test area control"
   DocumentCalc.TypeKeys "<Left>" , 2

  '/// Press Ctrl + Shift + F5
   DocumentCalc.TypeKeys "<MOD1 SHIFT F5>"

  '/// Check if the focus is in area control
   Kontext "RechenleisteCalc"
   RechenleisteCalc.TypeKeys "<SHIFT Right>" , 2
   Bereich.TypeKeys "<SHIFT Right>" , 2
   Bereich.TypeKeys "<MOD1 c>" , 2

   if GetClipboardText <> sAreaContrl then Warnlog "Something wrong when trying to test area control"

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tCreateDefaultDrawObject1

  printlog "Check if CTRL+Return can generated a draw object which is in the middle of the view"
  '/// Check if CTRL+Return can generated a draw object which is in the middle of the view
  '/// Hint : In fact, this case can't test if the object is in the middle of the view.
  '/// + Maybe the manual test is still needed.

  Dim aDrawObject()     as string
  Dim i , j , iStep     as Integer
  Dim bAsianLanguage    as Boolean
  Dim aFlag(14)         as Boolean

  aDrawObject = Array( _
                      "Line"              , _
                      "Rectangle"         , _
                      "Ellipse"           , _
                      "Polygon"           , _
                      "Curve"             , _
                      "Freeform Line"     , _
                      "Arc"               , _
                      "Ellipse Pie"       , _
                      "Circle Segment"    , _
                      "Text"              , _
                      "Vertical Text"     , _
                      "Text Animation"    , _
                      "Callouts"          , _
                      "Vertical Callouts" , _
                     )

  'Set 'Asian Language support' ON
   bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)

   j = UBound(aDrawObject)

   for i = 0 to j
       aFlag(i) = fActiveObjectInToolbar("Drawing" , aDrawObject(i) , TRUE)
   next i

  '/// The following draw ojbect will be tested.
  '/// 1. line
  '/// 2. rectangle
  '/// 3. ellipse
  '/// 4. textobject
  '/// 5. callouts
  '/// 6. arc
  '/// 7. circle segment
  '/// 8. ellipse pie
  '/// 9. polygon
  '/// 10.curve
  '/// 11.freeform line
  '/// 12.text animation
  '/// 13.text
  '/// 14.veritcal text

   for i = 0 to j
       Select case aDrawObject(i)
           case "Line"               : iStep = 1
           case "Rectangle"          : iStep = 2
           case "Ellipse"            : iStep = 3
           case "Polygon"            : iStep = 4
           case "Curve"              : iStep = 5
           case "Freeform Line"      : iStep = 6
           case "Arc"                : iStep = 7
           case "Ellipse Pie"        : iStep = 8
           case "Circle Segment"     : iStep = 9
           case "Text"               : iStep = 10
           case "Vertical Text"      : iStep = 11
           case "Text Animation"     : iStep = 12
           case "Callouts"           : iStep = 13
           case "Vertical Callouts"  : iStep = 14
       end select

       call  hNewDocument

        Call hToolbarSelect("DRAWING", true)

         Kontext "Drawbar"
         Drawbar.TypeKeys "<Home>"
         sleep(1)
         Drawbar.TypeKeys "<RIGHT>" , iStep , TRUE
         sleep(2)
         Drawbar.TypeKeys "<MOD1 RETURN>"   , TRUE
         sleep(4)

         if aDrawObject(i) = "Text" OR aDrawObject(i) = "Vertical Text" OR aDrawObject(i) = "Callouts" OR aDrawObject(i) = "Text Animation" OR aDrawObject(i) = "Vertical Callouts" then
           Kontext "DocumentCalc"
           DocumentCalc.TypeKeys "<ESCAPE>"
           sleep(1)
           gMouseClick (45,40)
           sleep(1)
         end if

        'Hints : if Format/Position and Size can be executed,
        'that means the object is inserted
         try
             Call fPositionAndSize("TabPositionAndSize")
             TabPositionAndSize.Cancel
         catch
             Warnlog "Something wrong in inserting " + aDrawObject(i)
         endcatch
       Call hCloseDocument
   next i

   for i = 0 to j
       if aFlag(i) = FALSE then
           fActiveObjectInToolbar("Drawing" , aDrawObject(i) , FALSE)
       end if
   next i

  'Set the 'Asian Language support' to default
   if bAsianLanguage = FALSE then
       Call ActiveDeactivateAsianSupport(FALSE)
   end if

endcase
'
'-------------------------------------------------------------------------------
'
testcase tTravelObject1

  printlog "Check if first drawing object is selected , Check if background objects are reachable as well "
  '/// Check if first drawing object is selected , Check if background objects are reachable as well

  Dim testFile      as string
  Dim sObjectName1  as string

  testFile     = "tTravelObject1.sxc"

  sObjectName1 = "Picture1"

 '/// Open test file --  tTravelObject1.sxc which include 3 objects.
 '/// + First one is a picture which is named picture1 and be backgrounded

  Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
  Call sMakeReadOnlyDocumentEditable
  sleep(1)

  Kontext "DocumentCalc"

 '/// Move the focus to the drawing bar , then choose "Arrow"
 '/// Press Ctrl+Return
   Call hToolbarSelect("DRAWING", true)
   Kontext "Drawbar"
   Drawbar.TypeKeys "<Home>"
   Sleep(2)
   Drawbar.TypeKeys "<MOD1 RETURN>"
   sleep(1)

 '/// Check if the focus is on the first object -- picture1
   Kontext "DocumentCalc"

 ' ---- try context menu 'Name Object
   try
      DocumentCalc.OpenContextMenu
      Call hMenuSelectNr(6)
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName1 then
        Warnlog "The object name is NOT right , should be " + sObjectName1 + "but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName1
   endcatch

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tTravelObject2

  printlog "Check if TAB travels forward through the drawing objects "
  '/// Check if TAB travels forward through the drawing objects

  Dim testFile                                   as string
  Dim sObjectName1 , sObjectName2 , sObjectName3 as string

  testFile     = "tTravelObject1.sxc"

  sObjectName1 = "Picture1"
  sObjectName2 = "Chart1"
  sObjectName3 = "Picture2"

 '/// Open test file --  tTravelObject1.sxc which include 3 objects.
 '/// - First one is a picture named picture1 and be backgrounded
 '/// - Second one is a chart  named chart1
 '/// - Third one is a picture named picture2 and be backgrounded

  Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
  Call sMakeReadOnlyDocumentEditable
  sleep(1)

  Kontext "DocumentCalc"

 '/// Move the focus to the drawing bar , then choose "Arrow"
 '/// Press Ctrl+Return
   Call hToolbarSelect("DRAWING", true)
   Kontext "Drawbar"
   Drawbar.TypeKeys "<Home>"
   sleep(2)
   Drawbar.TypeKeys "<MOD1 RETURN>"
   sleep(1)
   Drawbar.TypeKeys "<F6>"
   sleep(1)
   Kontext "DocumentCalc"
 '/// Press Tab to check if the focus is on the second object -- chart1
   DocumentCalc.TypeKeys "<TAB>"

   try
      DocumentCalc.OpenContextMenu
      sleep(1)
      Call hMenuSelectNr(2)
      sleep(1)
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName2 then
        Warnlog "The object name is NOT right , should be " + sObjectName2 + "but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName2
   endcatch

 '/// Press Tab again to check if the focus is on the third object -- picture2
   Kontext "DocumentCalc"

   DocumentCalc.TypeKeys "<TAB>"

   try
      DocumentCalc.OpenContextMenu
      sleep(1)
      Call hMenuSelectNr(6)
      sleep(1)
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName3 then
        Warnlog "The object name is NOT right , should be " + sObjectName3 + "but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName3
   endcatch

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tTravelObject3

  printlog "Check if Shift+TAB travels backward through the drawing objects "
  '/// Check if Shift+TAB travels backward through the drawing objects

  Dim testFile                                   as string
  Dim sObjectName1 , sObjectName2 , sObjectName3 as string

  testFile     = "tTravelObject1.sxc"

  sObjectName1 = "Picture1"
  sObjectName2 = "Chart1"
  sObjectName3 = "Picture2"

 '/// Open test file --  tTravelObject1.sxc which include 3 objects.
 '/// - First one is a picture named picture1 and be backgrounded
 '/// - Second one is a chart  named chart1
 '/// - Third one is a picture named picture2 and be backgrounded

  Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
  Call sMakeReadOnlyDocumentEditable
  sleep(1)

  Kontext "DocumentCalc"

 '/// Move the focus to the drawing bar , then choose "Arrow"
 '/// Press Ctrl+Return
   Call hToolbarSelect("DRAWING", true)
   Kontext "Drawbar"
   Drawbar.TypeKeys "<Home>"
   sleep(2)
   Drawbar.TypeKeys "<MOD1 RETURN>"
   sleep(1)
   Drawbar.TypeKeys "<F6>"
   sleep(1)

   Kontext "DocumentCalc"
 '/// Press Shift Tab to check if the focus is on the third object -- Picture2
   DocumentCalc.TypeKeys "<Shift TAB>"

   try
      DocumentCalc.OpenContextMenu
      sleep(1)
      Call hMenuSelectNr(6)
      sleep(1)
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName3 then
        Warnlog "The object name is NOT right , should be " + sObjectName3 + " but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName3
   endcatch

 '/// Press Shift Tab again to check if the focus is on the 2nd object -- Chart1
   Kontext "DocumentCalc"

   DocumentCalc.TypeKeys "<Shift TAB>"

   try
      DocumentCalc.OpenContextMenu
      sleep(1)
      Call hMenuSelectNr(2)
      sleep(1)
      Kontext
      Kontext "NameDlgGroupCalc"
      if NameField.GetText <> sObjectName2 then
        Warnlog "The object name is NOT right , should be " + sObjectName2 + " but get" + NameField.GetText
      end if
      NameDlgGroupCalc.Cancel
   catch
      Warnlog "Something wrong when traveling in first object " + sObjectName2
   endcatch

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tInsertSpecialCharacter1

 '/// Check if characters from the table can be selected with SPACE
  printlog "Check if characters from the table can be selected with SPACE"

    Dim sTestString as string
    sTestString = "!"

    Call  hNewDocument

    '/// Open insert special characters dialog with Insert/Special Characters
     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"

    '/// Move mouse Right , now the focus is "!"
     SchriftListe.typekeys "<Right>"
     sleep(1)

    '/// Press SPACE
     SchriftListe.typekeys "<SPACE>"
     sleep(1)

     Sonderzeichen.Ok

    '/// Check if character is inserted into the spreadsheet
     Kontext "RechenleisteCalc"
     try
       Uebernehmen.Click
       sleep(1)
     catch
       Warnlog "Something wrong when inserting special characters."
     endcatch

     EditCopy
     if GetClipboardText <> sTestString then Warnlog "The character is NOT inserted correctly. Should be "+sTestString+ " but get "+GetClipboardText

     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"
     Sonderzeichen.OK

    call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tInsertSpecialCharacter2

 '/// Check if RETURN (OK) puts the correct string into the cell
  printlog "Check if RETURN (OK) puts the correct string into the cell"

    Dim sTestString as string
    sTestString = "!"

    Call  hNewDocument

    '/// Open insert special characters dialog with Insert/Special Characters
     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"

    '/// Move mouse Right , now the focus is "!"
     SchriftListe.typekeys "<Right>"
     sleep(1)

    '/// Press SPACE
     SchriftListe.typekeys "<SPACE>"
     sleep(1)

     SchriftListe.typekeys "<RETURN>" ,   TRUE
     Sleep(2)

    '/// Check if character is inserted into the spreadsheet
     Kontext "RechenleisteCalc"
     try
       Uebernehmen.Click
       sleep(1)
     catch
       Warnlog "Something wrong when inserting special characters."
     endcatch

     EditCopy
     if GetClipboardText <> sTestString then Warnlog "The character is NOT inserted correctly. Should be "+sTestString+ " but get "+GetClipboardText

     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"
     Sonderzeichen.OK

    call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tInsertSpecialCharacter3

 '/// Check if ALT+D deletes the whole string you assembled
  printlog "Check if ALT+D deletes the whole string you assembled"

    Call  hNewDocument

    '/// Open insert special characters dialog with Insert/Special Characters
     InsertSpecialCharacterCalc
     Kontext "Sonderzeichen"
     SchriftListe.typekeys "<HOME>"

    '/// Move mouse Right , now the focus is "!"
     SchriftListe.typekeys "<Right>"
     sleep(1)

    '/// Press SPACE  ( "!" should be selected)
     SchriftListe.typekeys "<SPACE>"
     sleep(1)

    '/// Press Alt+D  , "!" should be deleted .
    '/// - <<Press Alt+L , German>>
    '/// - <<Press Alt+E , Italian>>
    '/// - ......
     Select case iSprache
         case 01 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case 31 : Sonderzeichen.typekeys "<MOD2 W>" , TRUE
         case 33 : Sonderzeichen.typekeys "<MOD2 S>" , TRUE
         case 34 : Sonderzeichen.typekeys "<MOD2 B>" , TRUE
         case 39 : Sonderzeichen.typekeys "<MOD2 E>" , TRUE
         case 46 : Sonderzeichen.typekeys "<MOD2 R>" , TRUE
         case 49 : Sonderzeichen.typekeys "<MOD2 L>" , TRUE
         case 55 : Sonderzeichen.typekeys "<MOD2 E>" , TRUE
         case 81 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case 82 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case 86 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case 88 : Sonderzeichen.typekeys "<MOD2 D>" , TRUE
         case else : QAErrorLog "The test does not support the language " + iSprache
                     Sonderzeichen.Cancel
                     call hCloseDocument
                     Goto endsub
     end select

     Sleep(2)

     try
       Sonderzeichen.Ok
       Warnlog "Should NOT execute OK after deleting all selected characters!"
     catch
       SchriftListe.typekeys "<HOME>"
       sleep(1)
       Sonderzeichen.OK
     endcatch

    call hCloseDocument

endcase
