'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_tool.inc,v $
'*
'*  $Revision: 1.22 $
'*
'*  last change: $Author: jsi $ $Date: 2006/08/17 13:48:16 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Routines for..
'*
'**************************************************************************************************
'*
' #1 cZellenVergleichen     'DEPRECATED
' #1 cCellCompare           'Comparing content of two cells.
' #1 cClipboardVergleichen
' #1 atGeheZuA1
' #1 cgotoCell
' #1 cgotoCell2
' #1 cgotoCell3
' #1 cBereichmarkieren
' #1 ZellenMarkieren
' #1 Groessemessen
' #1 fWhereIsTheCellCursor  'Returns the cell address
' #1 atNavigatorzuklappen
' #1 cCellContent
' #1 cDelAllInPAge
' #1 TabPageZaehler
' #1 Navigatorclick
' #1 getSheetName
' #0 atMoveit               ' DEPRECATED
' #0 cClipboardtext         ' DEPRECATED
'*
'\************************************************************************************************

sub cZellenVergleichen(Down%, Right%, Korrektur%)
    QAErrorLog "qa:qatesttool:calc:tools:c_tool.inc::cZellenVergleichen should be exchanged with ...::cCellCompare"
    cCellCompare(Down%, Right%, Korrektur%)
end Sub
'
'-------------------------------------------------------------------------------
'
sub cCellCompare (Down%, Right%, Korrektur%)
'/// Compare cell contents
    dim cell1 as String
    dim cell2 as String
    dim number as Integer
    dim value1 as Long
    dim value2 as Long
    dim Test as Long

    Down% = Down% + 1
    Right% = Right% + 1
    Kontext "DocumentCalc"

   EditCopy          'cell1 has to be selected
   sleep(2)
   cell1 = GetClipboardtext

    number = Right% - 1          'cell 2 has to be selected
    DocumentCalc.TypeKeys "<Right>", number
    number = Down% - 1
    DocumentCalc.TypeKeys "<Down>", number

    EditCopy
    sleep(2)
    cell2 = GetClipboardtext

    value1 = cell1
    value2 = cell2

    value2 = value2 - Korrektur%

    if value1 <> value2 then
      Warnlog "cell 1 not equal to cell 2 (cell1: " & value1 & " cell2: " & value2 & ")"
    else
      Printlog "PASSED. The difference of the cells is = " & Korrektur%
    end if
end Sub
'
'-------------------------------------------------------------------------------
'
'
sub cClipboardVergleichen ( TextZelle as String )
'/// Compare cellcontents with clipboard
   dim InhaltClipboard as String

   if GetClipboardText = TextZelle then
      Printlog "Ok clipboardtext and cellcontent are the same"
   else
      if Ucase(GetClipboardText) = Ucase(TextZelle) then
            Printlog "Ok clipboardtext and cellcontent are only different in case sensetive"
      else
            Warnlog "Cellcontent and clipboardtext are different. Clipboard: " + GetClipboardText + " Desired value: " + TextZelle
      end if
   end if

end sub
'
'-------------------------------------------------------------------------------
'
sub atGeheZuA1
'///  Goto cell A1
   Kontext "DocumentCalc"
   DocumentCalc.typekeys "<MOD1 HOME>" , TRUE
end sub
'
'-------------------------------------------------------------------------------
'
sub cgotoCell (sCelladdress as String)
'///  Goto cell (Cell address)
    dim bZustand as boolean
    dim wdh as Integer
    dim sSpalte_1 as string
    dim sZeile1 as string
    dim Mecker as String
    dim bFormularToolbarState as boolean
    dim sWhereTheCursorIs as string

    sCelladdress = Ucase(sCelladdress)
    
    Kontext "RechenleisteCalc"
    if RechenleisteCalc.Exists(1) then
        bFormularToolbarState = TRUE
    else
        'if the toolbar was not visible it will be vlosed at the end of this function 
        ViewToolbarsFormulaBar
        bFormularToolbarState = FALSE
    end if
    
    sWhereTheCursorIs = fWhereIsTheCellCursor()

    if Ucase(sWhereTheCursorIs) = Ucase(sCelladdress) then
        'The cursor is already at the destination address
        exit sub
    end if
    
    bZustand = FALSE
    
    for wdh = 1 to Len(sCelladdress)
        if asc(mid(sCelladdress,wdh,1)) >= 65 then
            sSpalte_1 = left(sCelladdress,wdh)
            sZeile1 = Val(right(sCelladdress,len(sCelladdress)-wdh))
            'QAErrorLog "Spalte(" & wdh & ") = " & sSpalte_1
            'QAErrorLog "Zeile(" & wdh & ") = " & sZeile1
        else
            sCelladdress = sCelladdress
        end if
    next wdh
    
    for wdh = 0 to 5
        call cgotoCell2 (sSpalte_1,sZeile1,wdh)
        if sCelladdress = fWhereIsTheCellCursor then
            bZustand = TRUE
            exit for
        end if
    next wdh
    
    if bZustand = FALSE then
        Mecker = "Destination cell address '" + sCelladdress + "' isn't reachable after 6 attempts!"
        'to DEBUG: Active cell is fWhereIsTheCellCursor

        'Try it with down and right arrow keys
        call cgotoCell3(sSpalte_1,sZeile1)
      
        if fWhereIsTheCellCursor = sCelladdress then
            printlog Mecker & Chr$(13) & "It works with DOWN and RIGHT from cell A1"
        else
            warnlog Mecker & " It doesn't work with DOWN and RIGHT, too!"
        end if
    end if
    
    if bFormularToolbarState = FALSE then
        'Closing the toolbar if it wasn't visible at the beginning
        ViewToolbarsFormulaBar
    end if
    Kontext "DocumentCalc"    
end sub
'
'-------------------------------------------------------------------------------
'
sub cgotoCell2 (Colz as String, Rowz as String, optional pause)
'///  Goto cell with the navigator
    if Ismissing(pause) then pause = 0
    Kontext "DocumentCalc"
    DocumentCalc.typekeys "<DOWN><UP>"
    Kontext "NavigatorCalc"
    if NavigatorCalc.notexists(1) then
      EditNavigator
    end if
    Kontext "NavigatorCalc"
    if pause > 0 then
      Spalte.more
      Spalte.less
    end if
    Spalte.TypeKeys "<END>"
    Spalte.TypeKeys "<SHIFT HOME>"
    Spalte.settext Colz
    if pause > 0 then
      Zeile.more
      Zeile.less
    end if
    Zeile.typekeys "<HOME>"
    Zeile.typekeys "<SHIFT END>"
    Zeile.settext Rowz
    Spalte.settext Colz 
    ' one time again for unix systems
    Spalte.typekeys "<Return>"
    Kontext "Navigator"
    Navigator.Close
    Kontext
    if NavigatorCalc.exists then
      EditNavigator
    end if
    Kontext "DocumentCalc"
end sub
'
'-------------------------------------------------------------------------------
'
sub cgotoCell3 (Colz as String, Rowz as String)
'///  Goto cell with DOWN- and RIGHT-keys
    dim Spalten, Zeilen as Integer

    Zeilen = cint(Rowz) - 1
    Spalten = Ucase$(Trim(Colz))
    if len(Colz) > 1 then
      Spalten = asc(left$(Colz,1) - 65 + asc(right$(Colz,1)) -64
    else
      Spalten = asc(Colz) - 65
    end if
    call atGeheZuA1
    Kontext "DocumentCalc"
    DocumentCalc.typekeys("<DOWN>", Zeilen, TRUE)
    DocumentCalc.typekeys("<RIGHT>", Spalten, TRUE)
end sub
'
'-------------------------------------------------------------------------------
'
function fWhereIsTheCellCursor as string
'///  Returns the cell address
    dim bViewToolbarsFormulaBarState as boolean

    Kontext "RechenleisteCalc"
    if RechenleisteCalc.Exists() then        
        bViewToolbarsFormulaBarState = TRUE
    else
        'If the toolbar is not visible it will be disabled
        'at the end of this function
        bViewToolbarsFormulaBarState = FALSE
        ViewToolbarsFormulaBar
        sleep(2)        
    end if

    Kontext "RechenleisteCalc"
    if RechenleisteCalc.Exists(1) then
        fWhereIsTheCellCursor = AktiverZellbereich.getseltext
    else
        warnlog "Toolbar did not come up!"
    end if
    
    if bViewToolbarsFormulaBarState = FALSE then
        ViewToolbarsFormulaBar
    end if
end function
'
'-------------------------------------------------------------------------------
'
function cBereichmarkieren (Zellbereich as String)
'///  Mark a cellrange ("a1:e5")
    dim wiederholen as Integer
    dim numberx as Integer
    dim numbery as Integer
    dim Spalte1
    dim Zeile1
    dim Spalte2
    dim Zeile2
    dim CellRange as String
    dim OL as String
    dim UR as String

    CellRange = Ucase(Zellbereich)
    OL = Left(CellRange,instr(Cellrange,":")-1)
    UR = Right(CellRange,len(CellRange) - instr(Cellrange,":"))
    for wiederholen =1 to Len(OL)
      if asc(mid(OL,wiederholen,1)) >= 65 then
         Spalte1 = left(OL,wiederholen)
         if len(Spalte1) = 1 then
            Spalte1 = asc(Spalte1)-64
         else
            Spalte1 = 25*(asc(left(Spalte1,1))-64) + (asc(mid(Spalte1,1,1))-64) + (asc(mid(Spalte1,2,1))-64)
         end if
         Zeile1 = Val(right(OL,len(OL)-wiederholen))
      else
         OL =OL
      end if
    next wiederholen

    for wiederholen =1 to Len(UR)
      if asc(mid(UR,wiederholen,1)) >= 65 then
         Spalte2 = left(UR,wiederholen)
         if len(Spalte2) = 1 then
            Spalte2 = asc(Spalte2)-64
      else
         Spalte2 = 25*(asc(left(Spalte2,1))-64) + (asc(mid(Spalte2,1,1))-64) + (asc(mid(Spalte2,2,1))-64)
      end if
         Zeile2 = Val(right(UR,len(UR)-wiederholen) )
      else
         UR=UR
      end if
    next wiederholen

    numberx = Spalte2 - Spalte1
    numbery = Zeile2 - Zeile1
    kontext
    call cgotocell OL
    for wiederholen = 1 to 3
      if fWhereIsTheCellCursor<>OL then
         call cgotocell OL
      else
         exit for
      end if
    next wiederholen
    Kontext "Active"
    if Active.exists then Active.YES
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Shift Right>", numberx
    DocumentCalc.TypeKeys "<Shift Down>", numbery
    if numbery > 0 then cBereichmarkieren = "multiple_row"
end function
'
'-------------------------------------------------------------------------------
'
sub ZellenMarkieren ( Down%, Right% )
'/// Mark cells
    dim number as Integer

    Kontext "DocumentCalc"
    number = Right% - 1
    DocumentCalc.TypeKeys "<Shift Right>", number
    number = Down% - 1
    DocumentCalc.TypeKeys "<Shift Down>", number
end Sub
'
'-------------------------------------------------------------------------------
'
function cZellinhalt (wo as String)
'///  Read cellcontent (Formulars)
   dim igel
    dim ClipboardText : ClipboardText = ""
    dim Tricorder     : Tricorder = ""

    call cgotocell (wo)
    Kontext
    setClipboard ("")
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<F2>"
    Kontext
    if active.exists then 'if the cell is writeprotected
      cZellinhalt = False
      exit function
    end if
    Kontext "DocumentCalc"
    EditSelectAll
    EditCopy
    DocumentCalc.TypeKeys "<Return><Up>"
    cZellinhalt = GetClipboardtext
end function
'
'-------------------------------------------------------------------------------
'
function cZellwert(wo as String, optional p as integer)
'/// Read cellvalue. If the optional paramter 'p' is set, the cellcontent is read out
'/// with the function left. (E.G. left(cellcontent, p).

    dim content : content = ""
    dim getclipbrd     : getclipbrd = ""
    dim wh% : dim whende% : dim istda1 as boolean : dim istda2 as boolean
    setclipboard = ""

    if instr(wo,":") = 0 then
      call cgotocell(wo)
      EditCopy
      goto einzeiler
    else
      if cBereichmarkieren(wo) = "multiple_row" then
         EditCopy
         goto mehrzeiler
      else
         EditCopy
         goto einzeiler
      end if
    end if
    einzeiler:
    getclipbrd = GetClipboard
    if len(getclipbrd) = 0 then
      content = ""
    elseif len(getclipbrd) = 1 then
      if asc(getclipbrd) = 10 then content = ""
      if asc(getclipbrd) = 13 then content = ""
      printlog "Im Clipboard war nur : Chr$(" & asc(getclipbrd) + 0 & ")"
    else
      if asc ( Right( getclipbrd, 1 )) + 13 = 23 then
         content = Left( getclipbrd, len(getclipbrd) - 1 )
         if asc ( Right( content, 1 )) = 13 then
            content = Left( content, len(content) - 1)
         else
            content = content
         end if
      elseif asc ( Right( getclipbrd, 1 )) = 13 then
         content = Left( getclipbrd, len(getclipbrd) - 1)
         if asc ( Right( content, 1 )) + 13 = 23 then
            content = Left( content, len(content) - 1)
         else
            content = content
         end if
      else
         content = getclipbrd
      end if
    end if
    if NOT IsMissing(p) then
      cZellwert = left(content, p)
   else
      cZellwert = content
   end if
   goto raushier
   mehrzeiler:
   istda1 = true : istda2 = true
   content = GetClipboard
   whende% = len(content)
   for wh% = 1 to whende%  ' CR LF / LF CR durch &R& ersetzen
      if instr(content,"" & chr$(13) & chr$(10)) > 0 then
         content = left$(content,instr(content,"" & Chr$(13) & chr$(10)) - 1 ) & "&R&" & mid$(content, instr(content,"" & Chr$(13) & chr$(10)) + 2)
         whende% = whende% + 1
      else
         istda1 = False
      end if
      if instr(content,"" & chr$(10) & chr$(13)) > 0 then
         content = left$(content,instr(content,"" & Chr$(10) & chr$(13)) - 1 ) & "&R&" & mid$(content, instr(content,"" & Chr$(10) & chr$(13)) + 2)
         whende% = whende% + 1
      else
         istda2 = False
      end if
      if istda1 = False and istda2 = false then exit for
    next wh
    'replace single CR with LF or &R&
    istda1 = true : istda2 = true
    whende% = len(content)
    for wh% = 1 to len(content)
      if instr(content,"" & chr$(13)) > 0 then
         content = left$(content,instr(content,"" & Chr$(13)) - 1 ) & "&R&" & mid$(content, instr(content,"" & Chr$(13)) + 1 )
         whende% = whende% + 2
      else
         istda1 = false
      end if
      if instr(content,"" & chr$(10)) > 0 then
         content = left$(content, instr(content,"" & chr$(10)) - 1 ) & "&R&" & mid$(content, instr(content,"" & chr$(10)) + 1 )
         whende% = whende% + 2
      else
         istda2 = false
      end if
    'if istda1 = False and istda2 = false then exit for
    next wh
    ' Tabulatoren durch &T& ersetzen
    whende% = len(content)
    for wh% = 1 to len(content)   ' Tabulatoren durch &T& ersetzen
      if instr(content,"" & chr$(9)) > 0 then
      'Printlog "erstes if " & instr(content,"" & chr$(13))
      content = left$(content,instr(content,"" & Chr$(9)) - 1 ) & "&T&" & mid$(content, instr(content,"" & Chr$(9)) + 1)
      whende% = whende% + 2
    else
      exit for
    end if
    next wh
    cZellwert = left(content,len(content)-1)
    raushier:

end function
'
'-------------------------------------------------------------------------------
'
function cDokumentname
'///  Return the filename from the documentproperty
  FileProperties
  Kontext
  active.setpage TabDokument
  Kontext "TabDokument"
  cDokumentname = Dokumentname.gettext
  TabDokument.cancel

end function
'
'-------------------------------------------------------------------------------
'
function cClipboardtext
    QAErrorLog "qa:qatesttool:calc:tools:c_tool.inc::cClipboardtext should be exchanged with GetClipboardText"
    call GetClipboardText
end function
'
'-------------------------------------------------------------------------------
'
sub cZelleschreiben (zelle$,inhalt$)
'///  Write the clipboardcontent ina cell
    call cgotocell (Zelle$)
    Kontext
    DocumentCalc.Typekeys (Inhalt$)
    DocumentCalc.Typekeys ("<Return UP>")
end sub
'
'-------------------------------------------------------------------------------
'
function atMausMarkieren(ZellBereich as String)
'///  mark a range with the mouse and return the coordinates
    dim x1, x2, y1, y2, Spalte1, Spalte2, Zeile1, Zeile2, wh as Integer
    dim Startzelle, Endzelle, OL, UR, UR2, Markierung, MStartzelle, MEndzelle, lager as String
    dim xFaktor, yFaktor, MSpalte1, MSpalte2, MZeile1, MZeile2 as Integer
    dim Korrektur1, Korrektur2, Korrektur3, Korrektur4 as Integer
    dim message
    Korrektur1 = 0 : Korrektur2 = 0 : Korrektur3 = 0 : Korrektur4 = 0


    ZellBereich = Ucase(Zellbereich)

    xFaktor = groessemessen("X")
    yFaktor = groessemessen("Y")

    if Instr(ZellBereich,":") < 1 then
      Startzelle = ZellBereich
      Endzelle = ZellBereich
    else
      Startzelle = left(ZellBereich,Instr(ZellBereich,":")-1)
      Endzelle = right(ZellBereich,len(ZellBereich) - instr(ZellBereich,":"))
    end if
    Spalte1 = Val(left(Zellteilung(Startzelle),instr(Zellteilung(Startzelle),";")-1))
    spalte2 = Val(left(Zellteilung(Endzelle),instr(Zellteilung(Endzelle),";")-1))
    Zeile1 = val(right(Zellteilung(Startzelle),len(Zellteilung(Startzelle)) - instr(Zellteilung(Startzelle),";")))
    zeile2 = val(right(Zellteilung(Endzelle),len(Zellteilung(Endzelle)) - instr(Zellteilung(Endzelle),";")))
    For wh = 1 to 6
      message = FALSE
      x1 = (Spalte1 - 0.5 + Korrektur1) * xFaktor
        y1 = (Zeile1 - 0.5 + Korrektur2) * yFaktor
        x2 = (Spalte2 - 0.5 + Korrektur3) * xFaktor
        y2 = (Zeile2 - 0.5 + Korrektur4) * yFaktor
        if x1 <= 0 or x1 >= 100 then message = TRUE
        if x2 <= 0 or x2 >= 100 then message = TRUE
        if y1 <= 0 or y1 >= 100 then message = TRUE
        if y2 <= 0 or y2 >= 100 then message = TRUE
        if message = TRUE then
            Warnlog "Maus ausserhalb des Dokumentes beim markieren von: " & Zellbereich
            atMausMarkieren = FALSE
            exit for
        end if
        Kontext "DocumentCalc"
        DocumentCalc.MouseDown cint(x1),cint(y1)
        DocumentCalc.MouseUp cint(x1),cint(y1)
        DocumentCalc.MouseDown cint(x1),cint(y1)
        DocumentCalc.MouseMove cint(x2),cint(y2)
        DocumentCalc.MouseUp cint(x2),cint(y2)
        Markierung = fWhereIsTheCellCursor
        if Markierung = ZellBereich then
         atMausMarkieren = TRUE
         exit for
        else
         if Instr(Markierung,":") > 0 then
            MStartzelle = left(Markierung,Instr(Markierung,":")-1)
            MEndzelle = right(Markierung,len(Markierung) - instr(Markierung,":"))
         else
            MStartzelle = Markierung
            MEndzelle = Markierung
         end if
            MSpalte1 = Val(left(Zellteilung(MStartzelle),instr(Zellteilung(MStartzelle),";")-1))
            Mspalte2 = Val(left(Zellteilung(MEndzelle),instr(Zellteilung(MEndzelle),";")-1))
            MZeile1 = val(right(Zellteilung(MStartzelle),len(Zellteilung(MStartzelle)) - instr(Zellteilung(MStartzelle),";")))
            Mzeile2 = val(right(Zellteilung(MEndzelle),len(Zellteilung(MEndzelle)) - instr(Zellteilung(MEndzelle),";")))
            if MSpalte1 > Spalte1 then Korrektur1 = Korrektur1 - 0.5
            if MSpalte1 = Spalte1 then Korrektur1 = Korrektur1
            if MSpalte1 < Spalte1 then Korrektur1 = Korrektur1 + 0.5
            if MSpalte2 > Spalte2 then Korrektur3 = Korrektur3 - 0.5
            if MSpalte2 = Spalte2 then Korrektur3 = Korrektur3
            if MSpalte2 < Spalte2 then Korrektur3 = Korrektur3 + 0.5
            if MZeile1  > Zeile1  then Korrektur2 = Korrektur2 - 0.5
            if MZeile1  = Zeile1  then Korrektur2 = Korrektur2
            if MZeile1  < Zeile1  then Korrektur2 = Korrektur2 + 0.5
            if MZeile2  > Zeile2  then Korrektur4 = Korrektur4 - 0.5
            if MZeile2  = Zeile2  then Korrektur4 = Korrektur4
            if MZeile2  < Zeile2  then Korrektur4 = Korrektur4 + 0.5
            atMausMarkieren = FALSE
        end if
    next wh
    if atMausMarkieren = FALSE then
    Warnlog "Mrak the range with the mouse doesn't work (desired: " & Zellbereich & " current: " & fWhereIsTheCellCursor & ")"
    atMausmarkieren = "" & 1 & ";" & 1 & ";" & 2 & ";" & 2
    else
    atMausmarkieren = "" & cint(x1) & ";" & cint(y1) & ";" & cint(x2) & ";" & cint(y2)
    end if
end function
'
'-------------------------------------------------------------------------------
'
function Groessemessen(was as String)
'/// calculate columnfactor
    dim x1, x2, y1, y2, Spalte1, Spalte2, Zeile1, Zeile2, wh as Integer
    dim OL, UR, UR2 as String
    dim xFaktor, yFaktor as Integer

    Kontext "DocumentCalc"
    DocumentCalc.Mousedown 1,1
    DocumentCalc.MouseUp 1,1
    OL = fWhereIsTheCellCursor
    Spalte1 = Val(left(Zellteilung(OL),instr(Zellteilung(OL),";")-1)) 'determines the column number of the cell address
    printlog "Spalte1:" & Spalte1
    Zeile1 = val(right(Zellteilung(OL),len(Zellteilung(OL)) - instr(Zellteilung(OL),";"))) 'determines the row number of the cell address
    if Ucase(Trim(was)) = "X" then
      Kontext "DocumentCalc"
      DocumentCalc.Mousedown 70,70
      DocumentCalc.MouseUp 70,70
      UR2 = fWhereIsTheCellCursor
      printlog "UR2=" & UR2
        for wh = 70 to 90
            Kontext "DocumentCalc"
            UR = UR2
            DocumentCalc.Mousedown wh,70
            DocumentCalc.MouseUp wh,70
            UR2 = fWhereIsTheCellCursor
            if UR2 <> UR then
               x2 = wh - 1
               exit for
          end if
      next wh
      y2 = 70
    else
      Kontext "DocumentCalc"
      DocumentCalc.Mousedown 70,70
      DocumentCalc.MouseUp 70,70
      UR2 = fWhereIsTheCellCursor
      for wh = 70 to 90
         UR = UR2
         Kontext "DocumentCalc"
         DocumentCalc.Mousedown 70,wh
         DocumentCalc.MouseUp 70,wh
         UR2 = fWhereIsTheCellCursor
         if UR2 <> UR then
            y2 = wh - 1
            exit for
         end if
      next wh
      x2 = 70
    end if
    Kontext "DocumentCalc"
    DocumentCalc.Mousedown x2,y2
    DocumentCalc.MouseUp x2,y2
    UR = fWhereIsTheCellCursor
    printlog "UR= " & UR
    Spalte2 = Val(left(Zellteilung(UR),instr(Zellteilung(UR),";")-1))
    printlog "Spalte2= " & Spalte2
    Zeile2 = val(right(Zellteilung(UR),len(Zellteilung(UR)) - instr(Zellteilung(UR),";")))
    printlog "Zeile1= " & Zeile1
    if Ucase(Trim(was)) = "X" then
        Groessemessen = x2 / ( Spalte2 - Spalte1 + 1)
        printlog "x2= " & x2
    else
        Groessemessen = y2 / (Zeile2 - Zeile1 + 1)
        printlog "Zeile2= " & Zeile2
        printlog "y2= " & y2
    end if

end function
'
'-------------------------------------------------------------------------------
'
sub atMoveit(x1%,y1%,x2%,y2%)
    QAErrorLog "qa:qatesttool:calc:tools:c_tool.inc::atMoveit should be exchanged with gMouseMove"
    call gMouseMove(x1%,y1%,x2%,y2%)    
end sub
'
'-------------------------------------------------------------------------------
'
function Zellteilung (Celladdress as string) as string
'///  Return column and row number as string spltted with a semicolon
    dim wdh as Integer
    dim Spalte1
    dim Zeile1

    Celladdress = Ucase(Celladdress)
    for wdh = 1 to Len(Celladdress)
      if asc(mid(Celladdress,wdh,1)) >= 65 then
         Spalte1 = left(Celladdress,wdh)
         if len(Spalte1) = 1 then
            Spalte1 = asc(Spalte1)-64
         else
            Spalte1 = 25*(asc(left(Spalte1,1))-64) + (asc(mid(Spalte1,1,1))-64) + (asc(mid(Spalte1,2,1))-64)
      end if
         Zeile1 = Val(right(Celladdress,len(Celladdress)-wdh))
      else
         Celladdress = Celladdress
      end if
    next wdh
    Zellteilung = Cstr(Spalte1) & ";" & Cstr(Zeile1)
end function
'
'-------------------------------------------------------------------------------
'
function cFreeFile(Filename$)
'///  Try to open a writeprotected file
    dim ci%
    ci% = GetAttr(Filename$)
    try
      SetAttr( Filename$ , ci% AND NOT 1 )
      cFreeFile = True
      Printlog "File was write protected and was reset"
    catch
      cFreeFile = False
      Warnlog "File attributes from document (" & Filename$ & ") are not editable, perhaps the file was opened from an application"
    endcatch

end function
'
'-------------------------------------------------------------------------------
'
function cFileKill(Filename$)
'/// Delet file if it exists
    dim ci%

    filename$ = convertpath(Filename$)
    if Dir(Filename$) <> "" then
      ci% = GetAttr(Filename$)
      try
         SetAttr( Filename$ , ci% AND NOT 1 )
         kill(Filename$)
      catch
         cFileKill = False
         Warnlog "(" & Filename$ & ") could be in use"
      endcatch
    end if

end function
'
'-------------------------------------------------------------------------------
'
function hDateiOeffnenmitverknuepfung ( sDocName as string, bRefresh as boolean )
'///  Open files which have links to other files.
'///+ If a 0 (zero) is given as second parameter the links won't be refreshed.
    Dim sDatei as string

    sDatei = ConvertPath(sDocName)

    'Checking if the file which should be loaded exists.
    if Dir(sDatei) = "" AND gSamePC = TRUE then
        warnlog "The file " & sDatei & " does not exist!"      
    else        
        FileOpen
        Kontext "OeffnenDlg"
        Dateiname.SetText sDatei
        Oeffnen.Click
        Kontext "Active"
        'If second parameter is FALSE or o (zero) press 'no' on upcoming message box
        if Active.Exists(2) then
            if bRefresh = 0 or bRefresh = FALSE then
                Active.No
            else
                Active.Yes
            end if
        else
            warnlog "There was no hint to update the file"
        end if
    end if
end function
'
'-------------------------------------------------------------------------------
'
sub atNavigatorzuklappen
'///  Close the navigatorlist if it is open
    dim Lager : dim wh

    Kontext "NavigatorCalc"
    lager = Liste.getitemcount
    Liste.select 1
    For wh = 1 to Lager
      Liste.typekeys "-<DOWN>"
    next wh
    select case iSprache
        case 01   : Lager = "Notes"
        case 03   : Lager = "Notizen" : Warnlog " the language adjustment is missing"
        case 31   : Lager = "Notizen" : Warnlog " the language adjustment is missing"
        case 33   : Lager = "Notizen" : Warnlog " the language adjustment is missing"
        case 34   : Lager = "Notizen" : Warnlog " the language adjustment is missing"
        case 39   : Lager = "Notizen" : Warnlog " the language adjustment is missing"
        case 46   : Lager = "Notizen" : Warnlog " the language adjustment is missing"
        case else : Lager = "Notizen"
    end select
    if Liste.getseltext = lager then
      Liste.select 1
    else
      Umschalten.click
      lager = Liste.getitemcount
      Liste.select 1
      for wh = 1 to Lager
         Liste.typekeys "-<DOWN>"
      next wh
    end if
end sub
'
'-------------------------------------------------------------------------------
'
function atNavigatordetail (wasdenn as String)
'/// Select the desired entry in the navigatorlist and switch to the detailed view
    dim Lager : dim wh

    Kontext "NavigatorCalc"
    lager = Liste.getitemcount
    Liste.select 1
    for wh = 1 to Lager
      Liste.typekeys "<DOWN>"
        if Liste.getseltext = wasdenn then
         Umschalten.click
         atNavigatordetail = TRUE
         exit for
        else
         Warnlog "" & wasdenn & " not found in the navigator"
         atNavigatordetail = FALSE
        end if
    next wh
end function
'
'-------------------------------------------------------------------------------
'
sub TabPageZaehler (Sollnumber as Integer, Optional optBereich)
'/// count the tabpages and compare the result with the given parameter
    dim Istnumber, numberEintraegeZu,numberEintraege, i, startpos as integer

    if ismissing(optBereich) then
      Kontext
      if Sollnumber = 1 then
         try
            Istnumber = Active.GetPageCount
         catch
            Istnumber = 1
         endcatch
      else
         Istnumber = Active.GetPageCount
      end if
      if Istnumber <> Sollnumber then
         WarnLog "number of the tabpages old :  " + Sollnumber + "   new :  " + Istnumber
      else
         Printlog "  " & Sollnumber & " Tabpages"
      end if
    else
        Kontext "ExtrasOptionenDlg"
        if ExtrasOptionenDlg.Exists then
         Optionsliste.TypeKeys "<HOME>"
         for i = 1 to Optionsliste.GetItemCount + 1
            Optionsliste.TypeKeys "-<DOWN>"
         next i
         numberEintraegezu = Optionsliste.GetItemCount
         select case Ucase$(optBereich)
                case "ALLGEMEIN"          : startpos = 1
                case "INTERNET"           : startpos = 2
                case "BROWSER"            : startpos = 3
                case "TEXTDOKUMENT"       : startpos = 4
                case "HTMLDOKUMENT"       : startpos = 5
                case "TABELLENDOKUMENT"   : startpos = 6
                case "PRAESENTATION"      : startpos = 7
                case "ZEICHNUNG"          : startpos = 8
                case "BILD"               : startpos = 9
                case "FORMEL"             : startpos = 10
                case else                 : Warnlog "the given parameter " & Applicationname & " is unknown"
         end select
         Optionsliste.select Startpos
         Optionsliste.typekeys "+"
         numberEintraege = Optionsliste.GetItemCount
         Istnumber = numberEintraege - numberEintraegezu
         if Istnumber <> Sollnumber then
            WarnLog "number der Optionsentries in section " & optBereich & " old :  " + Sollnumber + "   new :  " + Istnumber
         else
            Printlog "  " & Sollnumber & " Optionsentries in section " & optBereich
         end if
        end if
    end if

end sub
'
'-------------------------------------------------------------------------------
'
function checkcellwert(celladdress as string, resultstr as String, optional p as integer)
'/// This function checks the value of a cell with a given result
'///+ with the optional paramter 'p' the refernence string is compare with the content of
'///+ the cell using the function 'left(content, p). This paramter is handle through
'///+ the function 'cZellwert'.
   if NOT IsMissing(p) then
       if cZellwert(celladdress, p) <> resultstr then
         warnlog "Cellcontain from cell " & celladdress & " isn't correct"
         warnlog "it is " & cZellwert(celladdress, p) & " instead of " & resultstr
       else
         printlog "OK, cellcontain from cell " & celladdress & " is right"
       end if
       printlog "result of cZellWert is: " & cZellWert(celladdress, p)
   else
       if cZellwert(celladdress) <> resultstr then
         warnlog "Cellcontain from cell " & celladdress & " isn't correct"
       else
         printlog "OK, cellcontain from cell " & celladdress & " is right"
       end if
       printlog "result of cZellWert is: " & cZellWert(celladdress)
   end if
   printlog "result of " & celladdress & ": " & resultstr

end function
'
'-------------------------------------------------------------------------------
'
sub cDelAllInPAge()
'///  This function delete all contents in a Page.
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<escape><escape>"
   BearbeitenAllesAuswaehlen
   DocumentCalc.TypeKeys "<delete>"
   Kontext "InhalteLoeschen"
   Alles.Check
   InhalteLoeschen.OK
   Kontext "DocumentCalc"
   gMouseClick (1,1)
   DocumentCalc.TypeKeys "<delete>"
   Kontext "InhalteLoeschen"
   Alles.Uncheck
   InhalteLoeschen.OK
   Kontext "DocumentCalc"
end sub
'
'-------------------------------------------------------------------------------
'
function cCellContent (inputstream as string) as string
'///  Another method to find out the cellcontent. It is an unusual method, but
'///+ this method is not in depend from the clipboard. For this function
'///+ it is important that are on the cell which should be inspected.

   Kontext "DocumentCalc"
   try
      ToolsLanguageThesaurusCalc
      Kontext "Thesaurus"
      cCellContent = Wort.GetSelText
      Thesaurus.Cancel
   catch
      if iSprache > 80 then
         printlog "There is no thesaurus for asian languages available"
      else
         warnlog "It seems that although this method couldn't be used because the thesaurus doesn't work"
      end if
   endcatch

   Kontext "DocumentCalc"

end function
'
'-------------------------------------------------------------------------------
'
function getSheetName (optional i as integer) as String
'/// This function evaluate the sheetname of the sheet in calc. The optional
'/// paramter is necessary, if the sheetname should be partly solved.
'/// E.g. if you set the paramter to '1' the sheetname is read out without sheet number.
   dim resultStr as String
   dim scheisse as String
   FormatSheetRename
   Kontext "TabelleUmbenennen"
   resultStr = TabellenName.getText
   if NOT IsMissing(i) then
      dim strlen as integer
      strlen = len(resultStr) - i
      scheisse = str(left(resultStr, strlen))
   else
      scheisse = resultStr
   end if
   TabelleUmbenennen.close
   getSheetName = scheisse

end function
'
'-------------------------------------------------------------------------------
'
sub Navigatorclick (element as String, optional all as boolean, optional moveto as boolean)
'/// This function go to a specified element of the document by using the navigator

   dim wh : dim wh2
   dim showtree as boolean
   dim tomove as boolean
    if ismissing(all) then
      showtree = false
    else
      showtree = all
    end if
    if ismissing(moveto) then
      tomove = true
    else
      tomove = moveto
    end if
   Kontext "NavigatorCalc"
   Liste.Typekeys "+"
   if showtree = false then
      Umschalten.click
   end if
   Liste.Typekeys "+"
   if Liste.getitemcount > 1 then
      for wh = 1 to 99 step 2
            for wh2 = 60 to 10 step -10
            Liste.Mousedown wh2,wh
            Liste.MouseUp wh2,wh
            if Liste.getseltext = element then
               if tomove = true then
                     Liste.MouseDoubleClick wh2,wh
                     wh = 100 : wh2 = 0
                  else
                     Liste.MouseDown wh2,wh
                     'This variables are set in the ../calc/tools/gvar.inc
                     gcMousePosX = wh2
                     gcMousePosY = wh
                     wh = 100 : wh2 = 0
                  end if
            end if
            next wh2
      next wh
   end if
   if tomove = true then
      Liste.select 1
      Kontext "NavigatorCalc"
      Liste.typekeys "-"
   end if

   if showtree = false then
      Umschalten.click
   end if

end sub
'
'-------------------------------------------------------------------------
'
sub selectFirstOLE
'/// Select first OLE object.
    dim bNavigatorWasVisible as boolean
    dim i%
    bNavigatorWasVisible = FALSE

    Kontext "NavigatorCalc"
    if NavigatorCalc.exists (10) then
       bNavigatorWasVisible = TRUE
    else
       EditNavigator
    end if
    Kontext "NavigatorCalc"
    liste.TypeKeys "<HOME>"
    for i% = 1 to 8
        liste.TypeKeys "-<DOWN>"
    next i%
    liste.select(6)
    liste.TypeKeys "+<DOWN><RETURN>"
    if bNavigatorWasVisible = TRUE then
       printlog "Leaving navigator open as initially found"
    else
       EditNavigator
       printlog "Closing navigator as initially found"
    end if
end sub

