'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_ide.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2006/05/17 06:32:45 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : Macro Dialogs opened from Basic-IDE
'*
'*******************************************************************************
' **
' #1 tBasic_IDE_Toolbar_Module   ' Work with Toolbar on Basic-IDE part 1
' #1 tBasic_IDE_Toolbar_Dialogs  ' Work with Toolbar on Basic-IDE part 2
' **
'\******************************************************************************

testcase tBasic_IDE_Toolbar_Module

    dim brc as boolean
    dim cSourceFile as string
        cSourceFile = gTesttoolpath & "framework\basic\input\resetregistration.bas"
        cSourceFile = convertpath( cSourceFile )

    '///<h1>Work with Toolbar on Basic-IDE part 1</h1>

    '///<ul>

    '///+<li>Open a new writer-doc</li>
    printlog "open a new writer-doc"
    gApplication = "Writer"
    hCreateDocument()

    '///+<li>Create a new module for the new document (named TTModule)</li>
    brc = hOpenBasicOrganizerFromDoc()
    brc = hCreateModuleForDoc()

    '///+<li>Click &quot;Compile&quot; on Toolbar</li>

    kontext "macrobar"
    printlog "- compile"
    Compile.Click
    sleep( 1 )

    '///+<li>Click &quot;Run Basic&quot; on Toolbar</li>
    printlog "- Run Basic"
    BasicRun.Click
    sleep( 1 )

    '///+<li>Click &quot;Step Procedure&quot; on Toolbar</li>
    printlog "- Step Procedure"
    ProcedureStep.Click
    sleep( 1 )

    '///+<li>Click &quot;Stop Basic&quot; on Toolbar</li>
    printlog "- Stop Basic"
    BasicStop.Click
    sleep( 1 )

    '///+<li>Click &quot;Single Step&quot; on Toolbar</li>
    printlog "- Single Step"
    SingleStep.Click
    sleep( 1 )

    '///+<li>Click &quot;Step Back&quot; on Toolbar</li>
    printlog "- Step Back"
    StepBack.Click
    sleep( 1 )

    '///+<li>Click &quot;Breakpoint&quot; on Toolbar</li>
    printlog "- Breakpoint => activate"
    Breakpoint.Click
    sleep( 1 )

    '///+<li>Deactivate &quot;Breakpoint&quot; on Toolbar</li>
    printlog "- Breakpoint => deactivate"
    Breakpoint.Click
    sleep( 1 )

    '///+<li>Click &quot;Add Watch&quot; on Toolbar</li>
    printlog "- Add Watch => deactivate"
    AddWatch.Click
    sleep( 1 )

    '///+<li>Click &quot;Object Catalog&quot; on Toolbar => close 'Object'-Dialog</li>
    printlog "- Object Catalog => deactivate"
    ObjectCatalog.Click
    sleep( 1 )

    kontext "objekte"
    Call DialogTest (Objekte)
    Objekte.Close

    '///+<li>Click &quot;Macros&quot; on Toolbar => close 'Macro'-Dialog</li>
    printlog "- Macros"

    kontext "macrobar"
    Macros.Click
    sleep( 1 )

    kontext "makro"
    Makro.Close

    '///+<li>Click &quot;Modules&quot; on Toolbar => close 'Modules'-TabDialog</li>
    kontext "macrobar"
    printlog "- Modules"
    Modules.Click
    sleep( 1 )

    hSelectBasicObjectOrganizerTab( 3 )

    kontext "tabbibliotheken"
    TabBibliotheken.Close

    '///+<li>Click &quot;Find Paranthese&quot; on Toolbar</li>
    printlog "- Find Paranthese"

    kontext "macrobar"
    FindParanthese.Click()
    sleep( 1 )

    '///+<li>Button &quot;Controls&quot; should be disabled when a module is open</li>
    printlog "- 'controls'-button must be disabled for modules"
    try
        Controls.TearOff()
        warnlog "Controls are active in a module window => bug!"
    catch
        printlog( "Controls are not active->OK" )
    endcatch
    sleep( 1 )
    printlog( "- Insert Source Text (" & cSourceFile & ")" )

    '///+<li>Click &quot;Insert Source Text&quot; on Toolbar<br>
    '///+Insert external file &quot;ResetRegistration.bas&quot;</li>

    InsertSourceText.Click()
    sleep( 1 )

    kontext "oeffnendlg"
    Dateiname.SetText( cSourceFile )
    Oeffnen.click()
    sleep( 1 )
    
    ' possible 'could not read from file' error-message -> this is a bug
    kontext "Active"
    if ( Active.exists() ) then
        warnlog( "Unexpected active: " & active.gettext() )
        active.ok()
    endif

    kontext "macrobar"
    printlog "- Save Source Test "

    '///+<li>Click &quot;Save Source Test&quot; on Toolbar, save the file</li>
    SaveSourceTest.Click
    sleep( 1 )

    kontext "speicherndlg"
    Dateiname.SetText ConvertPath (gOfficepath + "user\work\global_test.bas")
    Speichern.click()
    sleep( 1 )

    kontext "active"
    if ( Active.Exists() ) then
        Active.Yes()
    endif
    sleep( 1 )

    '///+<li>File/Close for Basic-IDE and Document</li></ul>
    hDestroyDocument()   ' for Basic-IDE
    hDestroyDocument()   ' the new writer-doc

endcase

'*******************************************************************************

testcase tBasic_IDE_Toolbar_Dialogs

    dim bIsOpen as boolean
    dim brc as boolean
    
    dim sBasfile1 as string
        sBasFile1 = gTesttoolpath & "framework\basic\input\resetregistration.bas"
        sBasFile1 = convertpath( sBasFile1 )
        
    dim sBasFile2 as string
        sBasFile2 = convertpath( gOfficepath & "user\work\global_test.bas" )

    '///<h1>Work with Toolbar on Basic-IDE part 2</h1>
    '///<ul>

    '///+<li>Open a new writer-doc</li>
    printlog "open a new writer-doc"
    gApplication = "WRITER"
    hCreateDocument()

    '///+<li>Create a new module for the new document (named TTModule)</li>
    printlog "create a new module "
    brc = hOpenBasicOrganizerFromDoc()
    brc = hCreateModuleForDoc()

    '///+<li>Create a new dialog in BasicIDE</li>
    kontext "basicide"
    Tabbar.OpenContextMenu
    hMenuSelectNr (1)
    sleep( 1 )
    hMenuSelectNr ( 2 )
    sleep( 2 )
    if ( not DialogWindow.Exists ( 2 ) ) then
        warnlog "No dialog window is shown!"
    end if

    '///+<li>Try to click &quot;Compile&quot; (should be disabled)</li>
    kontext "macrobar"
    printlog "- compile (disabled)"
    try
        Compile.Click()
        warnlog "Compile : is not disabled"
    catch
    endcatch
    sleep( 1 )

    '///+<li>Click &quot;Run Basic&quot; (disabled)</li>
    printlog "- Run Basic (disabled)"
    try
        BasicRun.Click()
        warnlog "Run : is not disabled"
    catch
    endcatch
    sleep( 1 )

    '///+<li>Click &quot;Step Procedure&quot; (disabled)</li>
    printlog "- Step Procedure (disabled)"
    try
        ProcedureStep.Click()
        warnlog "Step Procedure : is not disabled"
    catch
    endcatch
    sleep( 1 )

    '///+<li>Click &quot;Stop Basic&quot; (disabled)</li>
    printlog "- Stop Basic (disabled)"
    try
        BasicStop.Click()
        warnlog "Stop Basic : is not disabled"
    catch
    endcatch
    sleep( 1 )

    '///+<li>Click &quot;Single Step&quot; (disabled)</li>
    printlog "- Single Step (disabled)"
    try
        SingleStep.Click()
        warnlog "Single Step : is not disabled"
    catch
    endcatch
    sleep( 1 )

    '///+<li>Click &quot;Step Back&quot; (disabled)</li>
    printlog "- Step Back (disabled)"
    try
        StepBack.Click()
        warnlog "Single Step : is not disabled"
    catch
    endcatch
    sleep( 1 )

    '///+<li>Click &quot;Breakpoint&quot; (disabled)</li>
    printlog "- Breakpoint  (disabled)"
    try
        Breakpoint.Click()
        warnlog "Breakpoint : is not disabled"
    catch
    endcatch
    sleep( 1 )

    '///+<li>Click &quot;Add Watch&quot; (disabled)</li>
    printlog "- Add Watch  (disabled)"
    try
        AddWatch.Click()
        warnlog "Add Watch : is not disabled"
    catch
    endcatch
    sleep( 1 )

    '///+<li>Activate &quot;Object Catalog&quot; on Toolbar => close 'Object'-Dialog</li>
    printlog "- Object Catalog => deactivate"
    ObjectCatalog.Click()
    sleep( 1 )

    kontext "objekte"
    Call DialogTest (Objekte)
    Objekte.Close()

    '///+<li>Activate &quot;Macros&quot; on Toolbar => close 'Macro'-Dialog</li>
    printlog "- Macros"

    kontext "macrobar"
    Macros.Click()
    sleep( 1 )

    kontext "makro"
    Makro.Close()

    '///+<li>Activate &quot;Modules&quot; on Toolbar => close 'Modules'-TabDialog</li>
    printlog "- Modules"

    kontext "macrobar"
    Modules.Click()
    sleep( 1 )

    '///+<li>Switch to the Libraries Tab</li>
    hSelectBasicObjectOrganizerTab( 3 )

    kontext "tabbibliotheken"
    TabBibliotheken.Close()

    kontext "macrobar"
    printlog "- Find Paranthese (disabled)"

    '///+<li>Click &quot;Find Paranthese&quot; (disabled)</li>
    try
        FindParanthese.Click()
        warnlog "Find Paranthese : is not disabled"
    catch
    endcatch
    sleep( 1 )

    '///+<li>Tear off controls</li>
    bIsOpen = hShowMacroControls()
    if ( bIsOpen ) then
        ToolsCollectionBar.Close()
    end if
    sleep( 1 )

    kontext "macrobar"
    printlog "- Insert Source Text  (disabled))"

    '///+<li>Click &quot;Insert Source Text&quot; (disabled)</li>
    try
        InsertSourceText.Click()
        warnlog "Insert Source Text : is not disabled"
        sleep( 1 )

        kontext "oeffnendlg"
        Dateiname.SetText( sBasFile1 ) 
        
        Oeffnen.Click()
    catch
    endcatch
    sleep( 1 )

    kontext "macrobar"
    printlog "- Save Source Test  (disabled)"

    '///+<li>Click &quot;Save Source Text&quot; (disabled)<br>
    '///+Save it as bas-file</li>
    try
        SaveSourceTest.Click()
        warnlog "Save Source Text : is not disabled"
        sleep( 1 )

        kontext "speicherndlg"
        Dateiname.SetText( sBasFile2 )
        Speichern.Click()
        sleep( 1 )

        kontext "active"
        if ( Active.Exists() ) then
            Active.Yes()
        endif
        sleep( 1 )
    catch
    endcatch

    '///+<li>File/Close on Basic-IDE and Document</li></ul>
    Call hDestroyDocument()   ' for Basic-IDE
    Call hDestroyDocument()   ' the new writer-doc
    '///</ul>

endcase


