/* gwConst.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * Consolidates literal constants and applet-specific data items into
 * a single interface component.
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/




import mappingData;

public interface gwConst
{
	public static final String LATITUDE		=	"N.Latitude:";
	public static final String LONGITUDE	=	"W.Longitude:";
	public static final String FONTSTRING	=	"Helvetica";
	public static final int	   FONTHEIGHT	=	12;
	public static final String OK			=	"OK";
	public static final String CANCEL		=	"Cancel";
	public static final int EVENT_MAP_PICK	=	0;
	public static final String BUTTON       =   "How far away is...";
    public static final String COPYRIGHT    =   "(C) 1996 by W.Giel";
    public static final String LOGO         =   "geodetic2.gif";
    public static final String REDPIN       =   "redpin.gif";
    public static final String WORLD_MAP    =   "mercator.gif";
    public static final String USA_MAP      =   "us.gif";
    public static final String HELP_FILE    =   "geodist.hlp";
    public static final String LABEL        =   "GEODETIC II - World Distance Calculator";
    public static final String LABEL_0      =   "From               ";
    public static final String LABEL_1      =   "To                   ";
    public static final String LABEL_2      =   "N. Lat:";
    public static final String LABEL_3      =   "W. Long:";
    public static final String LABEL_4      =   "NAD 27";
    public static final String LABEL_5      =   "NAD 83";
    public static final String LABEL_6      =   "World>";
    public static final String LABEL_7      =   "U.S.A.>";
    public static final String LABEL_8      =   "Compute";
    public static final String LABEL_9      =   "Reset";
    public static final String LABEL_10     =   "Help";
    public static final String COPYRIGHT_2  =   "GEODETIC II v1.0 (C)1996 by W.Giel";
    public static final String COMPUTING    =   "Computing...";
    public static final String FROM         =   "\r\nFrom: ";
    public static final String RECKONED     =   " (reckoned from North.)";
    public static final String TO           =   "\r\nTo:   ";
    public static final String SHORT_FROM   =   "From";
    public static final String SHORT_TO           =   "To  ";
    public static final String IMG_ERROR    =   "Error loading images.";
    public static final String IMG_WAIT     =   "Waiting for images...";
    public static final String NOT_READY    =   "Still loading resource...";
    public static final String READY        =   "Ready.";
    public static final String PREPARING    =   "Preparing pop-up windows...";
    public static final String HELP_TITLE   =   "Distance Calculator Help";
    public static final String PREP_WORLD   =   "Preparing world map dialog...";
    public static final String PREP_US      =   "Preparing U.S. Map dialog...";
    public static final String DISTANCE     =   "\r\nGeodetic Distance: ";
    public static final String AZIMUTH      =   "\r\nGeodetic Azimuth: ";

	public static final mappingData MERC_83      =
	        new mappingData(80800.0, 173, 251, 6378137,  0.081819191, 0.0);
	public static final mappingData MERC_27      =
	        new mappingData(80800.0, 173, 251, 6378206.4,0.082271854, 0.0);	    
	public static final mappingData SINU_83    =
	        new mappingData(12750.0, 427, 208, 6378137,  0.081819191, 95.0);
	public static final mappingData SINU_27    =
	        new mappingData(12750.0, 427, 208, 6378206.4,0.082271854, 95.0);
    
    
}
