'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: first.inc,v $
'*
'*  $Revision: 1.22 $
'*
'*  last change: $Author: jsi $ $Date: 2006/03/20 07:48:44 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : First test of basic functionality
'*
'*******************************************************************************
'**
' #1 tAllNew           ' Opens all document types and checks the default filter names 
' #1 tJava             ' Opens a HTML-page with a Java applet
' #0 fDocumentCheck     ' Checks name of the file type in the Save dialog
' #1 tDatabaseCheck     ' Checks if the database works
'**
'\******************************************************************************

testcase tAllNew
    '/// Open all document types and check the default filter name.
    Dim lsList (20) as string
    
    if (gUseSysDlg = TRUE) then    
        warnlog("Only check, if the documents will be opened; no " & _
                 "check for the defaultfilter (system file-dialog)!")        
    end if

    '///+<ul><li>Create a new text document (Writer)</li>
    '///+<li>Type some text</li>
    '///+<li>Check the default filter name (fDocumentCheck)</li>
    '///+<li>Close the document window without saving it</li></ul>
    printlog ""
    try    
        gApplication = "Writer"
        printlog "  - " +  gApplication
        
        Call hNewDocument (TRUE)
        
        Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "This is a Writer-document!"        
        if gUseSysDlg = FALSE then
            if fDocumentCheck (gWriterFilter) = FALSE then 
                warnlog("The filter name (saving) is not correct! " & _
                         "Please check if a Writer document will be opened!")
            end if
        end if        
        Call hCloseDocument (TRUE)        
    catch   
        Exceptlog
        ResetApplication        
    endcatch

    '///+<ul><li>Create a new spreadsheet document</li>
    '///+<li>Type some text in a cell</li>
    '///+<li>Check the default filter name (fDocumentCheck)</li>
    '///+<li>Close the document window without saving it</li></ul>
    try    
        gApplication = "Calc"
        printlog "  - " +  gApplication
        
        Call hNewDocument (TRUE)        
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "This is a Calc-document!"
        
        if gUseSysDlg = FALSE then
            if fDocumentCheck (gCalcFilter) = FALSE then 
                warnlog("The filter name (saving) is not correct! " & _
                         "Please check if a Calc document will be opened!")
            end if
        end if        
        Call hCloseDocument (TRUE)        
    catch    
        Exceptlog
        ResetApplication        
    endcatch

    '///+<ul><li>Create a new (empty) presentation</li> 
    '///+<li>Insert a new slide with <i>Insert</i> / <i>Duplicate slide</i></li> 
    '///+<li>Check the default filter name (fDocumentCheck)</li>
    '///+<li>Close the document window without saving it</li></ul>
    try
        gApplication = "Impress"
        printlog "  - " +  gApplication
        
        Call hNewDocument (TRUE)
        sleep(3)        
        InsertDuplicateSlide
        sleep(2)        
        if gUseSysDlg = FALSE then
            if fDocumentCheck (gImpressFilter) = FALSE then 
                warnlog("The filter name (saving) is not correct! " & _
                         "Please check if an Impress document will be opened!")
            end if
        end if        
        Call hCloseDocument (TRUE)        
    catch    
        Exceptlog
        ResetApplication        
    endcatch

    '///+<ul><li>Create a new drawing document</li>
    '///+<li><i>Insert</i> / <i>slide</i></li>
    '///+<li>Check the default filter name (fDocumentCheck)</li>
    '///+<li>Close the document window without saving it</li></ul>
    try    
        gApplication = "Draw"
        printlog "  - " +  gApplication        
        Call hNewDocument (TRUE)        
        InsertSlide        
        if gUseSysDlg = FALSE then
            if fDocumentCheck (gDrawFilter) = FALSE then 
                warnlog("The filter name (saving) is not correct! Please check if a Draw document will be opened!")
            end if
        end if        
        Call hCloseDocument (TRUE)        
    catch    
        Exceptlog
        ResetApplication        
    endcatch
   try   
      gApplication = "HTML"
      printlog "  - " +  gApplication
      '///+<ul><li>Create a new HTML document</li>      
      Call hNewDocument (TRUE)      
      Kontext "DocumentWriter"
      '///+<li>Type some text</li>
      DocumentWriter.TypeKeys "This is a HTML-Document!"
      '///+<li>Check the default filter name (fDocumentCheck)</li>
      if gUseSysDlg = FALSE then
         if (fDocumentCheck (gHTMLFilter) = FALSE) then            
            warnlog("The filter name (saving) is not correct! Please check if a HTML document will be opened! -> #i30867")
         end if
      end if
      '///+<li>Close the document window without saving it</li></ul>      
      Call hCloseDocument (TRUE)      
   catch   
      Exceptlog
      ResetApplication      
   endcatch

    '///+<ul><li>Create a new Math document</li>
    '///+<li>Type formula: <i>a over b</i></li>
    '///+<li>Check the default filter name (fDocumentCheck)</li>
    '///+<li>Close the document window without saving it</li></ul>
    try    
        gApplication = "Math"
        printlog "  - " +  gApplication        
        Call hNewDocument (TRUE)        
        Call SchreibenInMathDok("a over b")        
        if gUseSysDlg = FALSE then
            if fDocumentCheck (gMathFilter) = FALSE then
                warnlog("The filter name (saving) is not correct! Please check if a Math document will be opened!")
            end if
        end if        
        Call hCloseDocument (TRUE)        
    catch    
        Exceptlog
        ResetApplication        
    endcatch

    '///+<ul><li>Crate a new Master document</li>
    '///+<li>Type some text</li>
    '///+<li>Check the default filter name (fDocumentCheck)</li>
    '///+<li>Close the document window without saving it</li></ul>
   
    try    
        gApplication = "GlobalDokument"
        printlog "  - " +  gApplication        
        Call hNewDocument (TRUE)        
        Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "This is a master document!"
        if gUseSysDlg = FALSE then
            if fDocumentCheck (gMasterDocFilter) = FALSE then 
                warnlog("The filter name (saving) is not correct! Please check if a Master document will be opened!")
            end if
        end if        
        Kontext "Navigator"
        if Navigator.Exists(5) then 
            Navigator.Close
        end if        
        Call hCloseDocument (TRUE)        
    catch    
        Exceptlog
        ResetApplication        
    endcatch
endcase

'-------------------------------------------------------------------------

testcase tJava 
   '/// Check a HTML-page with Java crashes.
   '///+<ul><li>Enable the internal file dialog: 
   '///+<ul><li><i>Tools</i></li>
   '///+<li><i>Options</i></li>
   '///+<li><i>OpenOffice.org</i></li>
   '///+<li><i>General</i></li>
   '///+<li>Check <i>Use OpenOffice.org dialogs</i></li></ul></li>
   '///+<li>Insert <b><i>TesttoolPath</i>/global/input/java/java.htm</b></li>
   '///+<li>Wait 5 seconds</li>
   '///+<li>Close the document</li></ul>
   
   Dim iTryLoadingJava as integer
   Dim cPath as string
   
   ' This test will not work if the system filedialog is used.
   if (gUseSysDlg) then    
      warnlog("No test with system file-dialog!")        
   else    
      FileOpen        
      Kontext "OeffnenDlg"
      Dateiname.settext(ConvertPath(gTestToolPath & "global\input\java\java.htm")        
      Oeffnen.Click()
      sleep(5)        
      for iTryLoadingJava = 1 to 10   
           
         'Sometimes it needs time to bring up the Java Runtime on the system.
         'Just trying it 10 times (paused with a sleep(1)
         
         ' if no java is installed or it is disabled a messagebox will be displayed
         ' for each class file triggered by this test, so there will be two errormessages
         ' asking to enable java. The first msgbox will be handled within the loop while
         ' waiting for the document to get loaded, the second msgbox will be handled 
         ' outside the loop, it comes up right after the first one.
         try   
             Kontext "Messagebox"
             if ( MessageBox.exists()) then            
                if (gPlatGroup = "unx") then sleep(2)                
                warnlog(Messagebox.GetText())                
                try
                   Messagebox.Cancel()
                   sleep( 2 )
                catch
                   Messagebox.OK() ' if "OK" works, we are in an undefined state
                   warnlog( "The dialog has been closed by OK -> BUG" )
                endcatch                
                exit for                
             end if             
         catch
             sleep(1)
             printlog "... wait another second ..."            
         endcatch
      next iTryLoadingJava        
      
      ' the second errormessage is a bug (even if it is logical it is not ok
      ' from a user's point of view. The task will not be fixed for OOo 2.0
      kontext "Messagebox"
      if ( messagebox.exists() ) then
         try
             qaerrorlog( "#i37020# Second messagebox displayed" )
             Messagebox.cancel()
         catch
             Messagebox.OK()
             warnlog( "The dialog has been closed by OK -> BUG" )
         endcatch
      endif
      
      sleep(5)      
      Call hCloseDocument()      
   end if   
endcase

'-------------------------------------------------------------------------

testcase tDatabaseCheck
    '/// Open bibliography database.    
    printlog ""
    try   
      gApplication = "Writer"        
      FileOpen        
      Kontext "OeffnenDlg"
      Dateiname.settext(ConvertPath(gOfficePath & "user\database\biblio.odb")        
      Oeffnen.Click()
      sleep(5)
      '/// Check if database is open
      printlog "check if database is open"
      Kontext "Insight"
         if (Insight.exists()) then
            printlog "Database open"
            '/// Click on the table icon and check if tables are displayed
            printlog "click on the table icon and check if tables are displayed"
            ViewTables
            sleep(1)
            Kontext "ContainerView"            
                if TableTree.exists() then
                    printlog "table tree visible"
                else
                    warnlog "table tree not visible"
                end if
         else
            warnlog "Database not open"
         end if         
      Call hCloseDocument      
    catch         
    	warnlog "error while open database."
    endcatch	
endcase

'-------------------------------------------------------------------------

function fDocumentCheck (SollFilter as String) as boolean
   ' Check the name of the file type in the Save dialog and validate 
   ' it against a given string.   
   Dim sFiltername as String

   FileSaveAs   
   Kontext "SpeichernDlg"
   sFiltername = DateiTyp.GetItemText (1)   
   if (Instr(lcase(sFiltername), lcase (SollFilter)) <> 0) then   
      fDocumentCheck() = TRUE      
   else   
      printlog("Filter names do not match:")
      printlog("Found:    [" & sFilterName & "]")
      printlog("Expected: [" & SollFilter  & "]") 
      SollFilter = sFiltername
      fDocumentCheck() = FALSE      
   end if   
   SpeichernDlg.Cancel()   
end function

'-------------------------------------------------------------------------

