'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: install_file_tools.inc,v $
'*
'*  $Revision: 1.15 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:06:38 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : misc routines to handle files / filecontent
'*
'*******************************************************************************
' **
' #0 hGetFileSizesAsLong       ' gets the filesize for a list of files
' #0 hGetFileSizeAsLong        ' gets the filesize for a given file
' #0 hGetRelPaths              ' converts a list of abs. paths to rel. paths
' #0 hGetRelPath               ' converts a given path from abs. to rel.
' #0 hGetAbsPaths              ' converts a list of rel. paths to abs. paths
' #0 hGetAbsPath               ' converts a given path from rel. to abs.
' #0 hGetRefFilePath           ' creates the path to the reference files
' #0 hCreateFileLists          ' creates the language dependent file-lists
' #0 hWriteRefLists            ' writes one reference list
' #0 hReadRefLists             ' reads one reference list
' #0 hCheckWorkDirectories     ' checks / creates missing directories
' #0 hCheckWorkDirectory       ' checks / creates a missing directory
' **
'\******************************************************************************

function hGetFileSizesAsLong( clNames() as string , clSizes() as long ) as long

   ' This function takes a list of files and gets the sizes
   ' for all those files. The returnvalue is the cumulative size of all files
   ' in byte

   dim i as integer
   dim iCurrentSize as long
   dim iSummarizedSize as long

   for i = 1 to listcount( clNames() )

       ' get the size of the current file
       iCurrentSize = hGetFileSizeAsLong( clNames( i ) )

       ' assign the value to the array
       clSizes( i ) = iCurrentSize

       ' exclude directories
       if ( iCurrentSize <> -1 ) then
          iSummarizedSize = iSummarizedSize + iCurrentSize
       endif

   next i

   clSizes( 0 ) = clNames( 0 )
   hGetFileSizesAsLong() = iSummarizedSize

end function

'*******************************************************************************

function hGetFileSizeAsLong( cFileName as string ) as long

   ' This function returns the size of a specified file. If it is a directory,
   ' the size will default to -1 (A filesize can never be <0 - hopefully)

   dim iAttrib as integer

   ' test if the file exists, if not, skip it.
   if ( app.dir( cFileName ) <> "" ) then

      try
          iAttrib = getattr( cFileName )
      
          ' distinguish between files and directories. Directories return -1 as size
          if ( iAttrib <> 16 and iAttrib <> 17 ) then
             hGetFileSizeAsLong() = filelen( cFileName )
          else
             hGetFileSizeAsLong() = -1
          endif
      catch
          qaerrorlog( "Following file was not handled correctly: " & cFileName )
          hGetFileSizeAsLong() = 0
      endcatch

   else

      ' if a file does not exist: set its size to 0 and warn. This should never
      ' happen -> programming error
      hGetFileSizeAsLong() = 0
      warnlog( "hGetFileSizeAsLong executed on non-existing file: " & _
                cFileName )

   endif

end function

'*******************************************************************************

function hGetRelPaths( cStartDir, clFilePaths() as string ) as integer

   ' This function takes a list of files with absolute paths and cuts away the
   ' first part to make the paths relative.

   dim i as integer

   for i = 1 to listcount( clFilePaths() )
       clFilePaths( i ) = hGetRelPath( cStartDir, clFilePaths( i ) )
   next i

   hGetRelPaths() = i

end function

'*******************************************************************************

function hGetRelPath( cStartDir, cFileName as String ) as string

   ' This function returns the relative filepath (that's everything to the
   ' right of cStartDir )

   hGetRelPath() = mid( cFileName , len( cStartDir + 1 ) )

end function

'*******************************************************************************

function hGetAbsPaths( cStartDir , cList() as string ) as string

   ' This function concatenates the StartDir and the (rel) filename to an
   ' absolute path to a filename. Processes a list

   dim i as integer

   for i = 1 to listcount( cList() )
      cList( i ) = hGetAbsPath( cStartDir , cList( i ))
   next i

end Function

'*******************************************************************************

function hGetAbsPath( cStartDir , cFileName as string ) as string

   ' This function concatenates the StartDir and the (rel) filename to an
   ' absolute path to a filename.

   hGetAbsPath() = cStartDir & cFileName

end Function

'*******************************************************************************

function hGetRefFilePath( sPath, sLang as string ) as string

   ' This function returns the path to the reference-files depending on
   ' the underlying OS, the project and the language.

   dim sBasePath as string

   ' all files are located below this path
   sBasePath = TESTHOME & INSTTYPE & hGetOSString() & "\"

   ' add the subdirectory to the path, append the filename
   hGetRefFilePath() = convertpath( sBasePath & sPath & "\" & sLang & ".ref" )

end function

'*******************************************************************************

function hCreateFileList(  sFileList() as string, _
                           sFileName as string ) as integer

   ' This function gets the size for each file,  makes the filepaths relative
   ' and writes the list to sFileName

   dim iThisFile as integer
   dim iListCount as integer
       iListCount = listcount( sFileList() )

   if ( listcount( sFileList() ) > 0 ) then

      ' get the filesize for each file (-1 for directories) and 0 for files that
      ' cannot be found (should never happen!)
      for iThisFile = 1 to iListCount
          sFileList( iThisFile ) = hGetDataPairAsString( _
                                   sFileList( iThisFile ) , _
                                   hGetFileSizeAsLong( sFileList( iThisFile ))
      next iThisFile

      ' make paths relative
      hGetRelPaths( OFFICEHOME , sFileList() )

      ' Write the files to the reference file.
      call listwrite( sFileList() , sFileName , "UTF8" )

      ' return the number of processed files
      hCreateFileList() = iListCount

   else

      printlog(  "       * No data for : " & sFileName )

   endif

end function

'*******************************************************************************

function hWriteRefLists( cCurFileList() as string , _
                         cLanguageList() as string , _
                         cCategoryList() as string ) as integer

   ' This function checks if all reference files exist. If this is not the
   ' case the list(s) are created.
   ' NOTE: hGetSublistByPattern must be called in ANY case because the common-
   '       list would else contain the languagedependent files as well when it
   '       is recreated.

   dim cTmpFileList( FILECOUNTLIMIT ) as string
   dim cCategoryFileList( 1000 ) as string

   dim iCurrentLanguage as integer
   dim iCurrentCategory as integer
   dim cCurrentFile as string
   dim iErrors as integer
   dim iFileCount as integer

   dim cSearchPattern as string

   dim i as integer

   iErrors = 0 ' assume all lists exist

   call listcopy( cCurFileList() , cTmpFileList() )
   printlog( "" )
   printlog( " * Checking status of reference files..." )
   printlog( "" )

   ' cycle through all categories for each language.
   for iCurrentLanguage = 1 to listcount( cLanguageList() )

      printlog("    * " & hGeti18nData( cLanguageList(iCurrentLanguage ),_
                         "longname" ))
      for iCurrentCategory = 1 to listcount( cCategoryList() )

         listalldelete( cCategoryFileList() )

         ' fetch the path to the reference file
         cCurrentFile = hGetRefFilePath( cCategoryList( iCurrentCategory ), _
                                         cLanguageList( iCurrentLanguage ) )

         ' isolate language-/category-dependend files from the list
         cSearchPattern = hGetSublistByPattern( cTmpFileList() , _
                          cCategoryFileList(), _
                          cCategoryList( iCurrentCategory ), _
                          cLanguageList( iCurrentLanguage ) )
           
         ' check if the required file exists. If not, create it.
         if ( dir( cCurrentFile ) = "" ) then

            iFileCount = listcount( cCategoryFileList() )

            ' if the list is non-empty, write it. else: notify (no error)
            if ( iFileCount > 0 ) then
               hCreateFileList( cCategoryFileList() , cCurrentFile )
               iErrors = iErrors + 1
               printlog( "       * Scan for: " & cSearchPattern & " (" & _
               iFileCount  & " Hits. * File created at: " & cCurrentFile & ") " )
            else
               printlog( "       * No data for: " & cSearchpattern )
            endif

         end if

      next iCurrentCategory
   next iCurrentLanguage

   ' for now asian and western files are handled separately
   cCurrentFile = TESTHOME & INSTTYPE & hGetOSString()
   cCurrentFile = convertpath( cCurrentFile & "\common.ref" )

   ' check if the common-file exists. If not: Create it.
   if ( app.dir( cCurrentFile )  = "" ) then
      hCreateFileList( cTmpFileList() , cCurrentFile )
      iErrors = iErrors + 1
      printlog( "    * common files. * File created at: " & cCurrentFile & ") " )
   else
      printlog( "    * common files" )
   end if

   hWriteRefLists() = iErrors

   printlog( "" )

end function

'*******************************************************************************

function hReadRefLists( cRefFileList()  as string , _
                        cLanguageList() as string , _
                        cCategoryList() as string ) as integer

   ' This function reads all required reference files into one big list.
   ' Which reference files are loaded depends on the installed languages and
   ' the categories that are defined in the categories file.

   dim iCurrentLanguage as integer
   dim iCurrentCategory as integer
   dim cCurrentFile as string
   dim iFileCount as integer

   ' delete the entire list (as a precaution)
   listalldelete( cRefFileList() )

   printlog( "" )
   printlog( " * (Re)reading the reference lists" )
   printlog( "" )

   for iCurrentLanguage = 1 to listcount( cLanguageList() )
      for iCurrentCategory = 1 to listcount( cCategoryList() )

         ' get the path to the current reference file
         cCurrentFile = hGetRefFilePath( cCategoryList( iCurrentCategory ), _
                                         cLanguageList( iCurrentLanguage ) )

         ' check if the ref-file exists and read it. If it is missing just
         ' write a log. This usually happens when files are platformdependent.
         if ( dir( cCurrentFile ) <> "" ) then
            listreadappend( cRefFileList() , cCurrentFile , "utf8" )
         else
            printlog( "     * No data for: " & cCurrentFile )
         endif

      next iCurrentCategory
   next iCurrentLanguage

   ' still maintaining lists for western and asian versions.
   ' TODO: Merge.
   cCurrentFile = TESTHOME & INSTTYPE & hGetOSString()
   cCurrentFile = convertpath( cCurrentFile & "\common.ref" )

   ' append the common files to the internal file-list
   listreadappend( cRefFileList() , cCurrentFile , "utf8" )

   ' remove any blank lines in the list (happens when appending empty lists)
   listclearblank( cRefFileList )

   ' get the absolute paths to the files
   hGetAbsPaths( OFFICEHOME , cRefFileList() )

   ' get the number of files, return them to the calling module and print a log
   iFileCount = listcount( cRefFileList() )
   hReadRefLists() = iFileCount
   printlog( "    * Collection complete. " & iFileCount & " Files read." )
   printlog( "" )


end function

'*******************************************************************************

function hCheckWorkDirectories( cDirList() as string ) as integer

   ' check if all required directories exist, else create them
   ' the categories-list is used to determine the names.
   ' this is a wrapper for hCheckWorkDirectory( ... ).

   dim cDir as string         ' the name of the directory being worked on
   dim iThisDir as integer    ' counter for the directory-list
   dim iErr as integer        ' errorcounter (+1 for each newly created dir )
   dim cPath as string        ' the path to the currently tested directory

   iErr = 0

   ' check if the sourcedirectory exists, if not: create it
   cDir = TESTHOME
   if ( hCheckWorkDirectory( cDir ) = false ) then iErr = iErr + 1

   ' check if the INSTTYPE-directory exists, if not: create it
   cDir = TESTHOME & INSTTYPE 
   if ( hCheckWorkDirectory( cDir ) = false ) then iErr = iErr + 1
   
   ' check if the platform-directory exists, if not: create it
   cDir = TESTHOME & INSTTYPE & hGetOSString()
   if ( hCheckWorkDirectory( cDir ) = false ) then iErr = iErr + 1   

   ' run through the list containing the required paths for the ref-files.
   for iThisDir = 1 to listcount( cDirList() )

      ' check if all languagedependend directories exist, if not: create them   
      cPath = cDir & "/" &  cDirList( iThisDir )
      if ( hCheckWorkDirectory( cPath ) = false ) then iErr = iErr + 1 

   next iThisDir

   ' return the errorcount
   hCheckWorkDirectories() = iErr

end function

'*******************************************************************************

function hCheckWorkDirectory( cNewDir as string ) as boolean

   ' create missing directories
   ' Note that this will fail if you have insufficient rights to write
   ' to the target directory. 
   ' You'll get something like "No errortext available"
   
   cNewDir = convertpath( cNewDir )
   
   if ( app.dir( cNewDir ) = "" ) then
      printlog( "    * Creating directory: " & cNewDir )
      try
         mkdir( cNewDir )
      catch
         warnlog( "Unable to create requested directory. Permission problem?" )
      endcatch
      hCheckWorkDirectory = false
   else
      hCheckWorkDirectory = true
   end if

end function

