'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_trusted_path.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsk $ $Date: 2006/07/24 07:34:17 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Execute macros from trusted path
'*
'*******************************************************************************
'**
' #1 tSecTrustedPath ' Execute macros from trusted path
'**
'\******************************************************************************

testcase tSecTrustedPath( cWorkFile as string )

    '///<h1>Execute macros from a trusted path</h1>
    '///<i>This testcase takes parameters and requires a number of settings
    '///+ to run. See the calling .bas-file for details. <br>
    '///+ Furthermore a number of
    '///+ workfiles are used that have a documentbound macro as payload which is 
    '///+ executed at the &quot;On document load&quot; event.<br>
    '///+ The security level needs to be &quot;medium&quot;.</i><br><br>
    '///<ul>

    dim brc as boolean
    dim cMsg as string

    printlog( "Using file: " & cWorkFile )

    '///+<li>Click &quot;FileOpen&quot; or go to the dialog via menu</li>
    printlog( "FileOpen" )
    FileOpen

    '///+<li>Enter the path to a file with macros within the trusted path</li>
    printlog( "Enter file to load" )
    Kontext "OeffnenDlg"
    DateiName.setText( cWorkFile ) 

    '///+<li>Open the file</li>
    printlog( "Open the file" )
    Oeffnen.click()

    '///+<li>Test for security-warning, warn if it pops up</li>
    printlog( "Look for Macro Security Warning" )
    brc = hAllowMacroExecution()
    if ( brc ) then
        warnlog( "Macro Security Warning was not expected at this point" )
    endif

    '///+<li>Verify that the macro is executed</li>
    printlog( "Verify that the macro is executed" )
    kontext "Active"
    if ( active.exists() ) then
        cMsg = active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        if ( cMsg = "TTMacro3" ) then
            printlog( "Macro was executed" )
        else
            warnlog( "Invalid messagebox is open, please check" )
        endif

        '///+<li>Close the macro</li>
        active.ok()

    endif

    '///+<li>Close the document</li>
    hDestroyDocument()

    '///</ul>


endcase

