'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: security_tools.inc,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: jsk $ $Date: 2006/06/27 13:22:20 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools to ease testing of security related funtionality
'*
'*******************************************************************************
'**
' #1 hSetPasswordRecommendation ' Recommend password protection on save on/off
' #1 hOpenDigitalSignaturesDialog ' open the digital signatures dialog via menu
' #1 hAllowMacroExecution ' Click RUN to allow macro execution
' #1 hDenyMacroExecution ' Click CANCEl to deny macro execution
' #1 hSwitchMacroSecurityTab ' switch between the two pages in macro security
' #1 hAddTrustedPath ' Add a trusted path to the list
' #1 hRemoveTrustedPath ' Remove a trusted path from the list
'**
'\******************************************************************************

function hSetPasswordRecommendation( bEnable as boolean ) as boolean

    '///<h3>Toggle Tools/Options/OOo/Security: Password recommendation</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Mode (boolean)</li>
    '///<ul>
    '///+<li>TRUE: Switch password recommendation on</li>
    '///+<li>FALSE: Switch password recommendation off</li>
    '///</ul>
    '///</ol>

    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Prior state (boolean)</li>
    '///<ul>
    '///+<li>TRUE: Password recommendation was on</li>
    '///+<li>FALSE: Password recommendation was off</li>
    '///</ul>
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>

    const CFN = "hSetPasswordRecommendation::"

    '///+<li>Open Tools/Options</li>
    ToolsOptions

    '///+<li>Go to the security page</li>
    hToolsOptions( "STAROFFICE" , "SECURITY" )

    '///+<li>Retrieve the current setting for passwor recommendation</li> 
    kontext "TabSecurity"
    if ( RecommendPasswordProtectionOnSaving.isChecked() ) then
        hSetPasswordRecommendation() = true
    else
        hSetPasswordRecommendation() = false
    endif
                                            
    '///+<li>Set the requested state</li>                                                                                   
    if ( bEnable ) then
        printlog( CFN & "Enabled password recommendation" )
        RecommendPasswordProtectionOnSaving.check()
    else
        printlog( CFN & "Disabled password recommendation" )
        RecommendPasswordProtectionOnSaving.uncheck()
    endif

    '///+<li>Close Tools/Options</li>
    Kontext "ToolsOptionsDlg"
    ToolsOptionsDlg.ok()
    '///</ul>

end function

'******************************************************************************

function hOpenDigitalSignaturesDialog() as boolean

    '///<h3>Open the Digital Signatures Dialog via File-Menu</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE: The Digital Signatures Dialog is open</li>
    '///+<li>FALSE: The Digital Signatures Dialog is not open</li>
    '///</ul>
    '///</ol>

    '///<u>Description</u>:
    '///<ul>

    dim brc as boolean
    const CFN = "hOpenDigitalSignaturesDialog::"

    '///+<li>Open the file-menu</li>
    call hUseMenu()
    call hMenuSelectNr( 1 )
                                                                                
    '///+<li>Select &quot;Digital signatures...&quot;</li>
    try
        if ( ucase( gApplication ) = "MATH" ) then
            call hMenuSelectNr( 14 )
        else
            call hMenuSelectNr( 15 )
        endif
    catch
        warnlog( CFN & "Failed to execute menuitem <Digital Signature...>" )
    endcatch

    ' At this stage either the digital signatures dialog or the messagebox
    ' <The document needs to be saved> is open. In the latter case the function
    ' returns false. The possibility that neither of both dialogs are open
    ' must be handled in the parent function. This means there is no warning
    ' here either

    '///+<li>Verify that the Digital Signatures dialog is open</li>
    kontext "DigitalSignature"
    if ( DigitalSignature.exists() ) then
        printlog( CFN & "Digital signatures is open" )
        brc = true
    else
        brc = false
    endif

    '///</ul>
    hOpenDigitalSignaturesDialog() = brc

end function

'*******************************************************************************

function hAllowMacroExecution() as boolean

    '///<h3>Allow macro execution on Macro Security Warning dialog</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE: Macro dialog is open, successfully clicked &quot;Run&quot;</li>
    '///+<li>FALSE: Dialog was not opened</li>
    '///</ul>
    '///</ol>

    '///<u>Description</u>:
    '///<ul>

    const CFN = "hAllowMacroExecution::"

    '///+<li>Verify that the Macro security Warning is displayed</li>
    kontext "SecurityWarning"
    if ( SecurityWarning.exists() ) then

        '///+<li>Click &quot;Run&quot; to allow macro execution</li>
        SecurityWarning.ok()
        hAllowMacroExecution() = true
        printlog( CFN & "Allowed macro execution" )
    else
        hAllowMacroExecution() = false
        printlog( CFN & "Macro dialog not displayed" )
    endif
    '///</ul>

end function

'*******************************************************************************

function hDenyMacroExecution() as boolean

    '///<h3>Deny macro execution on Macro Security Warning dialog</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE: Macro dialog is open, successfully clicked &quot;Deny&quot;</li>
    '///+<li>FALSE: Dialog was not opened</li>
    '///</ul>
    '///</ol>

    '///<u>Description</u>:
    '///<ul>

    const CFN = "hDenyMacroExecution::"

    '///+<li>Verify that the Macro security Warning is displayed</li>
    kontext "SecurityWarning"
    if ( SecurityWarning.exists() ) then

        '///+<li>Click &quot;Cancel&quot; to deny execution</li>
        SecurityWarning.cancel()
        hDenyMacroExecution() = true
        printlog( CFN & "Denied macro execution" )
    else
        hDenyMacroExecution() = false
        printlog( CFN & "Macro dialog not displayed" )
    endif
    '///</ul>

end function

'*******************************************************************************

function hSwitchMacroSecurityTab( cTab as string )

    '///<h3>Switch between Security Level and Trusted Paths</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>The Tabpage to be activated (string). Valid options are:</li>
    '///<ul>
    '///+<li>&quot;SecurityLevel&quot;</li>
    '///+<li>&quot;TrustedPaths&quot;</li>
    '///</ul>
    '///</ol>

    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Description</u>:
    '///<ul>

    kontext
   
    '///+<li>Switch to the given Tabpage</li>
    select case ( lcase( cTab ) )
    case "securitylevel"   : active.setPage TabSecurityLevel
    case "trustedpaths"    : active.setPage TabTrustedSources
    end select 

    '///</ul>

end function

'*******************************************************************************

function hAddTrustedPath( cPath as string ) as boolean

    '///<h3>Add a directory to the list of trusted paths</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Fully qualified path to the directory (string)</li>
    '///</ol>

    '///<u>Return</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE = Path was successfully added</li>
    '///+<li>FALSE = Failed to add the path</li>
    '///</ul>
    '///</ol>

    const CFN = "hAddTrustedPath::"

    dim iPathCount as integer
    dim brc as boolean

    '///<u>Description</u>:
    '///<ul>

    '///+<li>Open Tools/Options</li>
    ToolsOptions

    '///+<li>Switch to the Security page</li>
    hToolsOptions( "StarOffice" , "Security" )

    '///+<li>Click Macro Security</li>
    MacroSecurity.click()

    '///+<li>Switch to the Trusted Paths tab</li>
    hSwitchMacroSecurityTab( "trustedpaths" )
    kontext "TabTrustedSources"

    '///+<li>Get the number of currently listed items from the list</li>
    iPathCount = LocationsListBox.getItemCount()

    '///+<li>Click the &quot;Add&quot; button</li>
    LocationsAdd.click()

    '///+<li>Enter a path to some files containing macros</li>
    kontext "OeffnenDlg"
    DateiName.setText( cPath )

    '///+<li>Click &quot;Select&quot;</li>
    Oeffnen.click()

    '///+<li>Verify that the item has been added to the list</li>
    kontext "TabTrustedSources"
    if ( LocationsListBox.getItemCount() <> ( iPathCount + 1 ) ) then
        warnlog( CFN & "Incorrect number of items in locations listbox" )
        brc = false
    else
        printlog( CFN & "Added: " & cPath )
        brc = true
    endif

    '///+<li>Close the dialog</li>
    TabTrustedSources.ok()

    '///+<li>Close Tools/Options</li>
    Kontext "OptionenDlg"
    OptionenDlg.ok()

    hAddTrustedPath() = brc

    '///</ul>

end function

'*******************************************************************************

function hRemoveTrustedPath( cPath as string ) as boolean

    '///<h3>Remove a directory from the list of trusted paths</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Fully qualified path to the directory (string)</li>
    '///</ol>

    '///<u>Return</u>:
    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE = Path was successfully added</li>
    '///+<li>FALSE = Failed to add the path</li>
    '///</ul>
    '///</ol>

    const CFN = "hRemoveTrustedPath()"

    dim iPathCount as integer
    dim iCurrentPathItem as integer

    dim brc as boolean
        brc = false

    '///<u>Description</u>:
    '///<ul>

    '///+<li>Open Tools/Options</li>
    ToolsOptions

    '///+<li>Switch to the Security page</li>
    hToolsOptions( "StarOffice" , "Security" )

    '///+<li>Click Macro Security</li>
    MacroSecurity.click()

    '///+<li>Switch to the Trusted Paths tab</li>
    hSwitchMacroSecurityTab( "trustedpaths" )
    kontext "TabTrustedSources"

    '///+<li>Get the number of currently listed items from the list</li>
    iPathCount = LocationsListBox.getItemCount()

    '///+<li>Find the entry in the list</li>
    for iCurrentPathItem = 1 to iPathCount

        '///+<li>If it is there, delete it</li>
        LocationsListBox.select( iCurrentPathItem )
        if ( LocationsListBox.getSelText() = cPath ) then
            LocationsRemove.click()
            printlog( CFN & "Removed item at pos. " & iCurrentPathItem )
            brc = true
            exit for
        endif

    next iCurrentPathItem
         
    '///+<li>Close the dialog</li>
    TabTrustedSources.ok()

    '///+<li>Close Tools/Options</li>
    Kontext "OptionenDlg"
    OptionenDlg.ok()

    if ( not brc ) then
        printlog( CFN & "The trusted path was not found in the list" )
    endif

    hRemoveTrustedPath() = brc

    '///</ul>

end function
