'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: signature_tools.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsk $ $Date: 2006/07/25 06:46:26 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools to ease working with digital signatures
'*
'*******************************************************************************
'**
' #1 hSelectXMLSecTab ' Switch between tabpages on the Ceritficates/XML-Security Tabpage
'**
'\******************************************************************************

function hSelectXMLSecTab( cTab as string ) as boolean


    '///<h3>Switch between tabpages on the Ceritficates/XML-Security Tabpage</h3>

    '///<u>Input value(s):</u><br>
    '///<ol>
    '///+<li>Identifier for the requested tabpage (string). Valid options are:</li>
    '///<ul>
    '///+<li>&quot;GENERAL&quot; for the general (first page)</li>
    '///+<li>&quot;DETAILS&quot; for the details (second page)</li>
    '///+<li>&quot;PATH&quot; for the certification path (third page)</li>
    '///</ul>
    '///</ol>


    '///<u>Return Value:</u><br>
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>


    '///<u>Description:</u>
    '///<ul>

    dim brc as boolean
        brc = false
    const CFN = "hSelectXMLSecTab::"

    '///+<li>Switch page</li>
    kontext 

    select case ( ucase( cTab ) )
    case "GENERAL"     : active.setpage TabXMLSecGeneral
                         if ( TabXMLSecGeneral.exists() ) then
                             brc = true
                             printlog( CFN & "Switched to General page" )
                         endif

    case "DETAILS"     : active.setpage TabXMLSecDetails
                         if ( TabXMLSecDetails.exists() ) then
                             brc = true
                             printlog( CFN & "Switched to Details page" )
                         endif

    case "PATH"        : active.setpage TabXMLSecCertPath
                         if ( TabXMLSecCertPath.exists() ) then
                             brc = true
                             printlog( CFN & "Switched to Certification Path page" )
                         endif
    end select

    '///+<li>Set returnvalue</li>
    hSelectXMLSecTab() = brc
    '///</ul>

end function
