'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: window_tools.inc,v $
'*
'*  $Revision: 1.1 $
'*
'*  last change: $Author: jsk $ $Date: 2006/04/25 12:58:50 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools to handle windows/frames
'*
'*******************************************************************************
'**
' #1 hMaximizeDocument ' Maximize a document window
'**
'\******************************************************************************

function hMaximizeDocument() as boolean


    '///<h3>Maximize a document window</h3>
    '///<i>Note</i>: The function runs silent (no logs written)<br><br>
    '///<u>Return Value:</u><br>

    '///<ol>
    '///+<li>Errorcondition (boolean)</li>
    '///<ul>
    '///+<li>TRUE if the window claims to have been maximized</li>
    '///+<li>FALSE on invalid gApplication (with warning)</li>
    '///+<li>FALSE if the window thinks it has not been maximized</li>
    '///</ul>
    '///</ol>

    const CFN = "hMaximizeDocument::"
    dim brc as boolean 'a multi purpose boolean returnvalue

    '///<u>Description:</u>
    '///<ul>
    '///+<li>Maximize the documentwindow depending on gApplication</li>
    select case ( ucase( gApplication ) )
    case "WRITER"    : Kontext "DocumentWriter"
                       DocumentWriter.maximize()
                       brc = DocumentWriter.isMaximized()
    case "CALC"      : Kontext "DocumentCalc"
                       DocumentCalc.maximize()
                       brc = DocumentCalc.isMaximized()
    case "IMPRESS"   : Kontext "DocumentImpress"
                       DocumentImpress.maximize()
                       brc = DocumentImpress.isMaximized()
    case "DRAW"      : Kontext "DocumentDraw"
                       DocumentDraw.maximize()
                       brc = DocumentDraw.isMaximized()
    case "MATH"      : Kontext "DocumentMath"
                       DocumentMath.maximize()
                       brc = DocumentMath.isMaximized()
    case "MASTERDOC" : Kontext "DocumentWriter"
                       DocumentWriter.maximize()
                       brc = DocumentWriter.isMaximized()
    case "HTML"      : Kontext "DocumentWriter"
                       DocumentWriter.maximize()
                       brc = DocumentWriter.isMaximized()
    case else        : qaerrorlog( CFN & "Invalid documenttype" )
                       brc = false
    end select

    '///</ul>

    hMaximizeDocument() = brc

end function
