'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_211_.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:26:58 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_211_

    Call WriterToCalcText
    Call WriterToCalcField
    Call WriterToCalcTable
    Call WriterToCalcFrame
    Call WriterToCalcDrawingObject
    Call WriterToCalcGraphicLinked  'wrn:1
    Call WriterToCalcGraphicEmbedded
    Call WriterToCalcOLEObject
    Call WriterToCalcControl

end sub

' ---------------------------------------------------------------------------------

testcase WriterToCalcText
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select first paragraph ///
  '///+ Copy selected text ///
  if wSetClipboardtestDefaults("text") = True then
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Text' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_calc_text.sxc")
     '///+ Save document as "..\user\work\writer_to_calc_text.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_calc_text.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Calc -> 'Text' failed !"
  endif
  Call hCloseDocument
  '/// Close active document ///

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToCalcField
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select paragraph with 'Date Field' ///
  '///+ Copy selected text ///
  if wSetClipboardtestDefaults("field") = True then
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Field' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"field")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_calc_field.sxc")
     '///+ Save document as "..\user\work\writer_to_calc_field.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_calc_field.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Calc -> 'Field' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToCalcTable
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Table' ///
  '///+ Copy selected table ///
  if wSetClipboardtestDefaults("table") = True then
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"table")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_calc_table.sxc")
     '///+ Save document as "..\user\work\writer_to_calc_table.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_calc_table.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Calc -> 'Table' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToCalcFrame
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Frame' ///
  '///+ Copy selected frame ///
  if wSetClipboardtestDefaults("frame") = True then
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"frame")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_calc_frame.sxc")
     '///+ Save document as "..\user\work\writer_to_calc_frame.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_calc_frame.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Calc -> 'Frame' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToCalcDrawingObject
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Drawing Object' ///
  '///+ Copy selected Drawing Object ///
  if wSetClipboardtestDefaults("draw") = True then
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_calc_draw.sxc")
     '///+ Save document as "..\user\work\writer_to_calc_draw.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_calc_draw.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Calc -> 'Drawing Object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToCalcGraphicLinked
   EnableQaErrors = true
   gApplication = "WRITER"
   '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
   '///+ Jump to beginning of document ///
   '///+ Select 'Linked Graphic' ///
   '///+ Copy selected Linked Graphic ///
   if wSetClipboardtestDefaults("graphicL") = True then
      gApplication = "CALC"
      '///+ Open new document ///
      Call hNewDocument
      '///+ Edit / Paste Special ///
      Sleep 2
      try
         EditPasteSpecialCalc
      catch
         QAErrorLog "Check why linked graphic fails !"
         Call hCloseDocument
         wait 500
         Call hCloseDocument
         goto endsub
      endcatch
      Wait 500
      '/// Paste 'Linked Graphic' in all available clipboard formats ///
      Kontext "InhaltEinfuegen"
      if InhaltEinfuegen.Exists then
         Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicL")
         '///+ Write Clipboard format under pasted content ///
         Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_calc_graphic1.sxc")
         '///+ Save document as "..\user\work\writer_to_calc_graphic1.sxc" ///
         Wait 500
         Call hCloseDocument
         '///+ Close saved document ///
         wait 500
         Call hDateiOeffnen (gOfficepath + "user\work\writer_to_calc_graphic1.sxc",true)
         '///+ Reopen saved document ///
         Wait 500
         Call hCloseDocument
         '///+ Close saved document ///
      else
         Warnlog "Dialog 'Paste Special' is not up!"
         Call hCloseDocument
         goto endsub
      endif
   else
      Warnlog "Writer To Calc -> 'Linked Graphic' failed !"
   endif
  '/// Close active document ///
  Call hCloseDocument
  EnableQaErrors = false
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToCalcGraphicEmbedded
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Embedded Graphic' ///
  '///+ Copy selected Embedded Graphic ///
  if wSetClipboardtestDefaults("graphicE") = True then
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Embedded Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicE")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_calc_graphic2.sxc")
     '///+ Save document as "..\user\work\writer_to_calc_graphic2.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_calc_graphic2.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Calc -> 'Embedded Graphic' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToCalcOLEObject
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'OLE Object' ///
  '///+ Copy selected OLE Object ///
  if wSetClipboardtestDefaults("ole") = True then
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'OLE object' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ole")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_calc_ole.sxc")
     '///+ Save document as "..\user\work\writer_to_calc_ole.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_calc_ole.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Calc -> 'OLE object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToCalcControl
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Control' ///
  '///+ Copy selected Control ///
  if wSetClipboardtestDefaults("control") = True then
    gApplication = "CALC"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
        EditPasteSpecialCalc
    catch
        Warnlog "Unable to execute 'Edit / Paste / Special' -> Disabled !"
        Call hCloseDocument
        wait 500
        Call hCloseDocument
        goto endsub
    endcatch
    Wait 500
    '/// Paste 'Control' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_calc_control.sxc")
     '///+ Save document as "..\user\work\writer_to_calc_control.sxc" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_calc_control.sxc",true)
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Calc -> 'Control' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase
