'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_104a_.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:27:08 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_104a_
   printLog Chr(13) + "---------   Level 1  - Menu / Insert Part 2 -   ----------"

   Call tInsertCrossReference
   Call tInsertNote
'  Call tInsertScript

   Call tInsertFrame_1
   Call tInsertFrame_2
   Call tInsertHorizontalLine
   Call tInsertTable
   Call tInsertTable_2
'  Call tInsertGraphicsFromFile_1


end sub



' ***********************************************************************

testcase tInsertCrossReference
  PrintLog "- Insert / Cross Reference"
   '/// Insert / Cross Reference ///

  printlog "  - insert"
   Call hNewDocument
   '/// Open a new document ///
   InsertBookmark
   Kontext "TextmarkeEinfuegen"
   '/// Insert / Bookmark and enter a name for the bookmark ///
   Textmarken.SetText "Du bist aber eine Marke"
   TextmarkeEinfuegen.OK
  printlog "  - delete"
   '/// Reopen dialog and check name ///
   InsertBookmark
   Kontext "TextmarkeEinfuegen"
   Textmarken.SetText "Du bist aber eine Marke"
   '/// Select 'Delete' and close dialog ///
   Loeschen.Click
   TextmarkeEinfuegen.OK
  printlog "  - Check"
   '/// Reopen dialog and check if bookmark has been deleted ///
   InsertBookmark
   Kontext "TextmarkeEinfuegen"
   Textmarken.SetText "Du bist aber eine Marke"
   try
      Loeschen.Click
      Warnlog "Cross Reference has not been deleted"
   catch
   endcatch
   TextmarkeEinfuegen.Cancel
   '/// Close document ///
   Call hCloseDocument
endcase

' ***********************************************************************

testcase tInsertNote
  PrintLog "- Insert / Note"

   Call hNewDocument
   '/// New document and select Insert / Note ///
   InsertNoteWriter
   Kontext "NotizEinfuegen"
   TextEingabe.SetText "Hallo"
   '/// Enter a note and check if note has been inserted correctly ///
   NotizEinfuegen.OK

   Call wDokSchreiben "<Shift Home>"
   InsertNoteWriter
   Kontext "NotizEinfuegen"
   if TextEingabe.GetText <> "Hallo" then Warnlog "The note has not been inserted correctly"
   Autor.Click
   NotizEinfuegen.OK
   '/// Close document ///
   Call hCloseDocument
endcase

' ***********************************************************************

testcase tInsertScript
   '/// Not in StarOffice 6.0 ///

   PrintLog "- Insert / Script"
   Dim Scriptel as string
   Scriptel = Chr$(34) + "Hallo ich bin ein Script" + chr$(34)

   Call hNewDocument
   InsertScript
   Kontext "ScriptEinfuegen"
   ScriptText.Check
   HierDerText.Settext "{document.write(" + Scriptel + ");}"
   ScriptEinfuegen.Ok
   Call wDokSchreiben "<Return>"

   InsertScript
   Kontext "ScriptEinfuegen"
   ScriptURL.Check
   ScriptURLWaehlen.Click
   Sleep 2
   Kontext "OeffnenDlg"
   Dateiname.Settext ConvertPath(gTesttoolpath + "writer\level1\input\script.txt")
   Sleep 2
   Oeffnen.Click
   Sleep 2
   Kontext "Filterauswahl"
   Sleep 1
   if Filterauswahl.Exists then Filterauswahl.Ok

   Sleep 2
   Kontext "ScriptEinfuegen"
   ScriptEinfuegen.Ok

   FileSendCreateHTMLDocument
   Sleep 2
   Kontext "SendHTMLDocument"
   if SendHTMLDocument.Exists then
    Dateiname.Settext Convertpath(gOfficepath + "user\work\script.html")
    Sleep 1
    Speichern.Click
    Sleep 2
    Kontext "Active"
    if Active.Exists then Active.yes
    Sleep 7
    FileClose
    Sleep 2
    hDateiOeffnen(gOfficepath + "user\work\script.html")
    Sleep 3

    gApplication = "HTMLDOKUMENT"
    Call wDocSetContext
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Shift End>"
    EditCopy
    if GetClipBoardtext <> "Hallo ich bin ein Script " then Warnlog "1. Script is wrong or JAVA not activated!"
    Call wDokSchreiben "<Home><Down><Down>"
    Sleep 2
    Call wDokSchreiben "<Shift End>"
    EditCopy
    if GetClipBoardtext <> "Hallo hier bin ich nochmal" then Warnlog "2. Script is wrong or JAVA not activated!"
   else
    warnlog "- Save-Dialog is not up"
   endif

   gApplication = "WRITER"
   Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertFrame_1
 printlog "- Insert / Frame"
   '/// New writerdocument ///
  Call hNewDocument
   '/// Call Insert / Frame (with Menu) ///
  InsertFrame
  Kontext
  try
   Active.Setpage TabType
   Kontext "TabType"
   TabType.Ok
   Wait 500
  catch
   Warnlog "Unable to insert a frame (Dialog is not up)!"
  endcatch

  Call wDocSetContext
  Call gMouseClick (20, 50)

  '/// Insert a frame over Toolbox / Insert / Frame ///
  Kontext "WL_SW"
  Einfuegen.TearOff
  Wait 500
  Kontext "TB_SW_Einfuegen"
  Rahmen.Click
  wait 500

  Call gMouseDown ( 20,50 )
  Call gMouseMove ( 20,50,30,60 )
  Call gMouseUp( 30,60 )
  Call gMouseClick ( 40,70 )

  '/// Create Multi-Column frames over toolbox is not possible with testtool ///

  '/// Paste a frame from another writerdocument ///
  Call hNewDocument
   '/// Call Insert / Frame (with Menu) ///
  Call wInsertFrame
   '/// Copy frame in new document ///
   try
    EditCopy
   catch
    Warnlog "Unable to access 'Edit / Copy'. Maybe disabled !"
    Call hCloseDocument
    goto endsub
   endcatch
  '/// Close document ///
  Call hCloseDocument
  Kontext
   '/// Paste Frame into document and check ///
  BearbeitenEinfuegen
  wait 500
  FormatFrame
  Kontext
  try
   Active.Setpage TabType
   Kontext "TabType"
   TabType.Ok
   Wait 500
  catch
   Warnlog "Frame has not been pasted via clipboard !"
  endcatch
  Call gMouseClick ( 40,70 )
  '/// Insert a frame via 'Insert / File "..\writer\level1\input\frame.sxw" ///
  wait 500
  InsertFileWriter
  Kontext "OeffnenDlg"
  if gApplication = "WRITER" then
     Dateiname.Settext Convertpath (gTesttoolpath + "writer\level1\input\frame.sxw")
  else
     Dateiname.Settext Convertpath (gTesttoolpath + "writer\level1\input\masterdoc\frame.sxg")
  endif
  Oeffnen.Click
  Wait 500

  Call hCloseDocument
  '/// Close active document ///

endcase

' ***********************************************************************

testcase tInsertFrame_2
 Dim sB as String, sH as String
  PrintLog "- Insert / Frame"
   '/// Insert / Frame ///

   Call hNewDocument
   '/// New document and select Insert / Frame ///
   InsertFrame
   Kontext
   active.SetPage TabType
   Kontext "TabType"
   '/// change properties of frame and close dialog ///
   if iSprache <> 01 then
      Width.SetText "10"
      Height.SetText "3,5"
   else
      Width.SetText "3"
      Height.SetText "1.2"
   end if
   sB = Width.GetText
   sH = Height.GetText
   Kontext
   active.SetPage TabZusaetze
   Kontext "TabZusaetze"
   Objektname.SetText "Name of the frame"
   TabZusaetze.OK
   Sleep 2

   '/// Reopen dialog and check properties ///
   InsertFrame
   Kontext
   active.SetPage TabType
   Kontext "TabType"
   if Width.GetText <> sB then Warnlog "Wrong Width-Value, should -> " + sB + "   is -> "+ Width.GetText
   if Height.GetText <> sH then Warnlog "Wrong Height-Value, should -> " + sH + " is -> "+ Height.GetText
   Kontext
   active.SetPage TabZusaetze
   Kontext "TabZusaetze"
   if Objektname.GetText <> "Name of the frame" then Warnlog "Wrong Frame name"
   TabZusaetze.Cancel
   '/// Close document ///
   Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertTable
  Dim sSpalte1 : Dim sSpalte2
  Dim sSpalte3 : Dim sSpalte4
  PrintLog "- Insert Table of 4 Rows and 4 Columns"

   Call hNewDocument
   '/// New document and insert a table with modified properties ///
   Call wDokSchreiben "Tabelle<Home>"
   InsertTableWriter
   Sleep 1
   Kontext "TabelleEinfuegenWriter"
   try
      TabellenName.SetText "Huhu Eine Tabelle"
      Warnlog "Able to enter a name with a space character!"
   catch
      TabellenName.SetText "HuhuEineTabelle"
   endcatch
   Spalten.SetText "4"
   Zeilen.SetText "4"
   TabelleEinfuegenWriter.OK
   '/// Check properties of table in document ///
   Call wDokSchreiben "<Down>", 4
   Call wDokSchreiben "<Home><Shift End>"
   EditCopy
   if GetClipboardText <> "Tabelle" then Warnlog "Not 4 Columns inserted"
   Call wDokSchreiben "<Up>" ,4 : Wait 500
   Call wDokSchreiben "<Right>", 16
   Call wDokSchreiben "<Home><Shift End>"  : Wait 500
   EditCopy
   if GetClipboardText <> "Tabelle" then Warnlog "Not 4 Rows inserted"

  printlog "  - Changing properties"
   '/// change properties of table ///
   Call wDokSchreiben "<Up>",4
   Sleep 1
   InsertTableWriter
   Sleep 1
   Kontext
   Active.SetPage TabTabelle
   Kontext "TabTabelle"
   if TabellenName.GetText <> "HuhuEineTabelle" then Warnlog "Maybe the table name is wrong or contain space characters"
   TabellenName.SetText "EinAndererName"
   Sleep 2
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   UeberschriftWiederholen.Uncheck
   Kontext
   Active.SetPage TabSpaltenTabelle
   Kontext "TabSpaltenTabelle"
   if Spalte5.IsEnabled then Warnlog "Field to the 5th Row is active ( TabRows )"
   Spalte1.More 4
   sSpalte1 = Spalte1.GetText
   sSpalte2 = Spalte2.GetText
   Spalte3.Less 2
   sSpalte3 = Spalte3.GetText
   sSpalte4 = Spalte4.GetText
   TabSpaltenTabelle.OK

  printlog "  - checking properties"
   '/// check properties of table after closing an dreopening properties dialog ///
   Sleep 1
   InsertTableWriter
   Sleep 1
   Kontext
   Active.SetPage TabTabelle
   Kontext "TabTabelle"
   if TabellenName.GetText <> "EinAndererName" then Warnlog "Table Name is wrong"
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if UeberschriftWiederholen.Ischecked then Warnlog "Repeat header is active"
   Kontext
   Active.SetPage TabSpaltenTabelle
   Kontext "TabSpaltenTabelle"
   if Spalte1.GetText <> sSpalte1 then Warnlog "Row-Width (1) has not been changed  : Shall " + sSpalte1 + "   Is " + Spalte1.GetText
   if Spalte2.GetText <> sSpalte2 then Warnlog "Row-Width (2) has not been changed  : Shall " + sSpalte2 + "   Is " + Spalte2.GetText
   if Spalte3.GetText <> sSpalte3 then Warnlog "Row-Width (3) has not been changed  : Shall " + sSpalte3 + "   Is " + Spalte3.GetText
   if Spalte4.GetText <> sSpalte4 then Warnlog "Row-Width (4) has not been changed  : Shall " + sSpalte4 + "   Is " + Spalte4.GetText
   TabSpaltenTabelle.Cancel
   '/// Close document ///
   Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertTable_2
  Dim sTab as String
  PrintLog "- Insert / Table (check properties)"
   '/// New writerdocument and create a table with all properties unchecked ///

   Call hNewDocument
  printlog "   - crete table with all properties unchecked"
   InsertTableWriter
   Sleep 1
   Kontext "TabelleEinfuegenWriter"
   select case iSprache
      case 01   : sTab = "Table"
      case 03   : sTab = "Tabela"
      case 31   : sTab = "Tabel"
      case 33   : sTab = "Tableau"
      case 34   : sTab = "Tabla"
      case 39   : sTab = "Tabella"
      case 45   : sTab = "Tabel"
      case 46   : sTab = "Tabell"
      case 48   : sTab = "Tabela"
      case 49   : sTab = "Tabelle"
      case else : if bAsianLan = False then sTab = "Tabelle"
   end select
   if sTab > "" then
    if TabellenName.GetText <> sTab & "1" then Warnlog "1. Tablenname is not '" + sTab + "1' but '" + TabellenName.GetText + "'"
   endif
   Spalten.SetText "3"
   Zeilen.SetText "20"
   UeberschriftWiederholen.Uncheck
   TabelleNichtTrennen.Uncheck
   Umrandung.Uncheck
   TabelleEinfuegenWriter.OK

  printlog "     - checking properties in Table Formats"
   '/// Close dialog, reopen and check properties made ///
   InsertTableWriter
   Sleep 1
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if UeberschriftWiederholen.IsChecked then Warnlog "'Repeat heading' is checked!"
   if TabelleNichtTrennen.IsChecked then Warnlog "'Do not split table' is checked!"
   TabTextflussTabelle.OK

   Call wDokSchreiben "<Down>", 25
   Call wDokSchreiben "<Return>"
   Sleep 2
  printlog "   - create table with checking all properties"
   InsertTableWriter
   Sleep 1
   Kontext "TabelleEinfuegenWriter"
   select case iSprache
      case 01   : sTab = "Table"
      case 03   : sTab = "Tabela"
      case 31   : sTab = "Tabel"
      case 33   : sTab = "Tableau"
      case 34   : sTab = "Tabla"
      case 39   : sTab = "Tabella"
      case 45   : sTab = "Tabel"
      case 46   : sTab = "Tabell"
      case 48   : sTab = "Tabela"
      case 49   : sTab = "Tabelle"
      case else : if bAsianLan = False then sTab = "Tabelle"
   end select
   Sleep 1
   if sTab > "" then
    if TabellenName.GetText <> sTab & "2" then Warnlog "2. Tablenname is not '" + sTab + "2' but '" + TabellenName.GetText + "'"
   endif
   Spalten.SetText "5"
   Zeilen.SetText "30"
   UeberschriftWiederholen.Check
   TabelleNichtTrennen.Check
   Umrandung.Check
   TabelleEinfuegenWriter.OK

  printlog "     - check properties in Table Formats"
   FormatTable
   Sleep 1
   Kontext
   Active.SetPage TabTextflussTabelle
   Kontext "TabTextflussTabelle"
   if NOT UeberschriftWiederholen.IsChecked then Warnlog "'Repeat header' is not checked!"
   if NOT TabelleNichtTrennen.IsChecked then Warnlog "'Don't split table' is not checked!"
   TabTextflussTabelle.OK

  printlog "     - check if a 'not splitable' Table jumps to the next page"
   '/// check if a 'not splitable' Table jumps to the next page ///
   InsertFieldsPageNumbers
   Sleep 1
   Call wDokSchreiben "+1<Shift Home>"
   ToolsCalculate
   Sleep 1
   if GetClipboardText <> "3" then Warnlog "1. Column is not on the 2nd Page!"
   '/// close document ///
   Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertHorizontalLine
  Dim i
   PrintLog "- Insert / All horizontal Lines"

   '/// Insert all horizontal lines in a document ///
   Call hNewDocument
   InsertHorizontalLine
   Kontext "HorizontaleLinieEinfuegen"
   Auswahl.TypeKeys "<Down><Up>"
   HorizontaleLinieEinfuegen.OK
   wait 200
   for i = 1 to 26
      InsertHorizontalLine
      Kontext "HorizontaleLinieEinfuegen"
      Auswahl.TypeKeys "<Down>", i
      HorizontaleLinieEinfuegen.OK
      wait 200
    Sleep 1
   next i
   '/// Close document ///
   Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertGraphicsFromFile_1
 Dim Brei : Dim Hoeh, datIsser as string
  PrintLog "- Insert / Graphic / From file"
   '/// Insert a graphic with pre-selected properties ///
   '/// Does not work in the moment because of missing feature in file open dialog ///
   Warnlog "Does not work in the moment because of missing feature in file open dialog"
   goto endsub

   Call hNewDocument
  printlog "  - Insert a graphic with pre-selected properties"
   SetControlType CTBrowseBox

   InsertGraphicsFromFile
   Kontext "GrafikEinfuegenDlg"
   try
    Eigenschaften.Click
   catch
    Warnlog "Could not access 'Properties' in File-Dialog ! Cancel test !"
    GrafikEinfuegenDlg.Cancel
    Call hCloseDocument
    goto endsub
   endcatch

   Kontext
   Active.SetPage TabType
   Kontext "TabType"
   AnchorAsCharacter.Check
   if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
      Width.SetText "4.0"
      Height.SetText "5.0"
   else
      Width.SetText "4,0"
      Height.SetText "5,0"
   endif
   Brei = Width.GetText
   Hoeh = Height.GetText
   Kontext
   active.SetPage TabGrafik
   Kontext "TabGrafik"
   Vertikal.Check
   Horizontal.Check
   TabGrafik.OK
   Kontext "GrafikEinfuegenDlg"
   Dateiname.Settext ConvertPath(gTesttoolpath + "writer\input\grafik\jolink.jpg")
   Oeffnen.Click
   Sleep 4

  printlog "  - checking properties"
   InsertGraphicsFromFile
   wait 500
   Kontext
   Active.SetPage TabType
   Kontext "TabType"
   if Width.GetText <> Brei then Warnlog "Wrong Width : Shall " + Brei + "   Is " +Width.GetText
   if Height.GetText <> Hoeh then Warnlog "Wrong Height : Shall " + Hoeh + "   Is " +Height.GetText
   if NOT AnchorAsCharacter.IsChecked then Warnlog "As Character is not checked for anchor"
   wait 500
   Kontext
   active.SetPage TabGrafik
   Kontext "TabGrafik"
   if NOT Vertikal.IsChecked then Warnlog "Vertical is not checked"
   if NOT Horizontal.IsChecked then Warnlog "Horizontal ist nicht gecheckt"
   TabGrafik.Cancel

   Call hCloseDocument

endcase
