'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_005_.inc,v $
'*
'*  $Revision: 1.22 $
'*
'*  last change: $Author: hde $ $Date: 2006/08/16 11:25:50 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*                                                                **
'* owner : helge.delfs@sun.com                                    **
'*                                                                **
'* short description :                                            **
'*                                                                **
'\******************************************************************

sub w_005_
    printLog Chr(13) + "--------- Menu Format (w_005_.inc) ----------"

    Call tFormatDefault
    
    Call tFormatCharacter
    Call tFormatParagraph
    Call tFormatNumberingBullets
    Call tFormatPage    
    
    Call tFormatChangeCase
    Call tFormatRuby
    Call tFormatColumn
    Call tFormatSections    

    Call tFormatStylist
    Call tFormatAutoformatWhileTyping
    
    Call tFormatAnchor
    Call tFormatAnchorArea
    Call tFormatWrap
    Call tFormatWrapArea
    
end sub

'------------------------------------------------------

testcase tFormatDefault
    PrintLog "- Format / Default"

    Call hNewDocument
    '/// Open new document ///
    Call wBlindtextEinfuegen
    '/// Insert dummy text ///
    EditSelectAll
    '/// Edit / Select All ///
    FormatDefaultWriter
    '/// Format / Default ///
    Call hCloseDocument
    '/// Close active document ///

endcase

'------------------------------------------------------

testcase tFormatSections
    printlog "- Format / Sections"
    Call hNewDocument
    '/// Open new document ///
    InsertSection
    '/// Insert / Section ///
    Kontext
    Active.Setpage TabBereiche
    Kontext "TabBereiche"
    '/// Step through all tabpages ///
    Bereichsliste.SetText "Mein Bereich"
    TabBereiche.OK
    sleep(5)
    FormatSections
    Kontext "BereicheBearbeiten"
    Call Dialogtest(BereicheBearbeiten)
    Optionen.Click
    sleep(2)
    Kontext
    Active.SetPage TabSpalten
    Kontext "TabSpalten"
    Call Dialogtest(TabSpalten)
    Kontext
    Active.SetPage TabHintergrund
    Kontext "TabHintergrund"
    Call DialogTest2(TabHintergrund, 1)
    Als.Select(2)
    Call DialogTest2 (TabHintergrund,2)
    Durchsuchen.Click
    sleep(2)
    Kontext
    If Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.GetText
            Active.Ok
        endif
    end If
    Sleep 1
    Kontext "GrafikEinfuegenDlg"
    GrafikEinfuegenDlg.Cancel
    Sleep 1
    Kontext "TabHintergrund"
    TabHintergrund.Cancel
    sleep(1)
    Kontext "BereicheBearbeiten"
    BereicheBearbeiten.Cancel
    Call hCloseDocument
    '/// Close active document ///
endcase

'------------------------------------------------------

testcase tFormatCharacter
    PrintLog "- Format / Character"
    Dim j as integer

    Call hNewDocument
    '/// Open new document ///

    FormatCharacter
    '/// Format / Character ///

    Kontext
    active.SetPage TabFont
    kontext "TabFont"
    Call DialogTest ( TabFont )
    '/// Step through all tabpages ///

    Kontext
    active.SetPage TabFontEffects
    kontext "TabFontEffects"
    Call DialogTest ( TabFontEffects )

    Kontext
    Active.SetPage TabFontPosition
    Kontext "TabFontPosition"
    Call DialogTest ( TabFontPosition )

    if gAsianSup = True then
        try
            Kontext
            Active.SetPage TabAsianLayout
            Kontext "TabAsianLayout"
            Call DialogTest ( TabAsianLayout )
        catch
            Warnlog "Tabpage 'Asian Layout' is not visible! Activated in Options ?"
        endcatch
    endif

    Kontext
    active.SetPage TabHyperlinkZeichen
    Kontext "TabHyperlinkZeichen"
    Call DialogTest ( TabHyperlinkZeichen )

    if gUSeSysDlg = False then
        Durchsuchen.Click
        Kontext "OeffnenDlg"
        if OeffnenDlg.Exists then
            OeffnenDlg.Cancel
        else
            Warnlog "File-Open dialog is not up!"
        endif
    endif

    Kontext "TabHyperlinkZeichen"
    Ereignisse.Click
    ' if no JRE is installed a messagebox appears
    Do
        j = j + 1
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                if j = 1 then Warnlog Active.Gettext    
                Active.Ok
            else
                exit do
            endif                    
        else
            exit do
        endif
    Loop
    Kontext "MakroZuweisen"
    Call DialogTest ( MakroZuweisen )
    MakroZuweisen.Cancel        
    Kontext
    active.SetPage TabHintergrund
    kontext "TabHintergrund"
    Call DialogTest ( TabHintergrund )
    '/// Close dialog ///
    TabHintergrund.Close

    Call hCloseDocument
    '/// Close active document ///

endcase

'------------------------------------------------

testcase tFormatChangeCase
    printlog "- Format / Change Case"
    Call hNewDocument
    '/// Open new document ///
    Call wDokSchreiben ("Hello World!")
    Call wDokSchreiben ("<Shift Home>")
    '/// Insert some text in document and select text ///

    Wait 500
    FormatChangeCaseUpper
    '/// Format / Case Characters / Upper ///
    Wait 500
    FormatChangeCaseLower
    '/// Format / Case Characters / Lower ///
    Wait 500
    if gAsianSup = True then
        try
            FormatChangeCaseHalfWidth
            '/// Format / Case Characters / Half Width ///
        catch
            Warnlog "Format / Change Case / Half Width does not work. Maybe no Asian support!"
        endcatch
        Wait 500
        try
            FormatChangeCaseFullWidth
            '/// Format / Case Characters / Full Width ///
        catch
            Warnlog "Format / Change Case / Full Width does not work. Maybe no Asian support!"
        endcatch
        Wait 500
        try
            FormatChangeCaseHiragana
            '/// Format / Case Characters / Hiragana ///
        catch
            Warnlog "Format / Change Case / Hiragana does not work. Maybe no Asian support!"
        endcatch
        Wait 500
        try
            FormatChangeCaseKatagana
        catch
            Warnlog "Format / Change Case / Katagana does not work. Maybe no Asian support!"
            '/// Format / Case Characters / Katagana ///
        endcatch
    endif

    Call hCloseDocument
    '/// Close active document ///
endcase

'------------------------------------------------

testcase tFormatRuby
    printlog "- Format / Ruby"
    if gAsianSup = True then
        if gApplication = "HTMLDOKUMENT" then
            printlog "Not in WriterWeb!"
            goto endsub
        endif
        Call hNewDocument
        '/// Open new document ///
        Call wDokSchreiben ("Hello World!")
        Call wDokSchreiben ("<Shift Home>")
        '/// Insert some text in document ///

        try
            FormatRuby
            '/// Format / Ruby ///
        catch
            Warnlog "Format / Ruby does not work. Maybe No Asian support!"
            Call hCloseDocument
            goto endsub
        endcatch
        Kontext "RubyDialog"
        Call DialogTest ( RubyDialog )

        '/// Open Stylist ///
        CallStylist.Click
        wait 500
        Kontext "Stylist"
        if Stylist.Exists then
            Stylist.close
        else
            Warnlog "Stylist has not been opened!"
        endif

        '/// Close Stylist and Ruby dialog ///
        Kontext "RubyDialog"
        DialogClose.Click

        Call hCloseDocument
        '/// Close active document ///
    endif
endcase

'------------------------------------------------

testcase tFormatParagraph
    PrintLog "- Format / Paragraph"

    Call hNewDocument
    '/// Open new document ///
    FormatParagraph

    '/// Format / Paragraph ///
    Kontext
    active.SetPage TabEinzuegeUndAbstaende
    kontext "TabEinzuegeUndAbstaende"
    Call DialogTest ( TabEinzuegeUndAbstaende )
    '/// Step through all tabpages ///

    Kontext
    Active.SetPage TabAusrichtungAbsatz
    Kontext "TabAusrichtungAbsatz"
    Call DialogTest ( TabAusrichtungAbsatz )

    Kontext
    active.SetPage TabNumerierungAbsatz
    kontext "TabNumerierungAbsatz"
    Call DialogTest ( TabNumerierungAbsatz )

    Kontext
    active.SetPage TabUmrandung
    kontext "TabUmrandung"
    Call DialogTest ( TabUmrandung )

    if gApplication <> "HTMLDOKUMENT" then
        Kontext
        active.SetPage TabTextfluss
        kontext "TabTextfluss"
        Call DialogTest ( TabTextfluss )

        if gAsianSup = True then
            try
                Kontext
                Active.SetPage TabAsianTypography
                Kontext "TabAsianTypography"
                Call DialogTest ( TabAsianTypography )
            catch
                Warnlog "Tabpage 'Asian Typography' is not visible! Activated in Options ?"
            endcatch
        endif

        Kontext
        active.SetPage TabTabulator
        kontext "TabTabulator"
        Call DialogTest ( TabTabulator )

        Kontext
        active.SetPage TabInitialen
        kontext "TabInitialen"
        Anzeigen.Check
        Call DialogTest ( TabInitialen )

        Kontext
        active.SetPage TabHintergrund
        Kontext "TabHintergrund"
        Call DialogTest2 ( TabHintergrund, 1 )
        Als.Select 2
        Kontext "TabHintergrund"
        Call DialogTest2 ( TabHintergrund, 2 )
        Durchsuchen.Click
        Kontext "GrafikEinfuegenDlg"
        GrafikEinfuegenDlg.Cancel

        kontext "TabHintergrund"
        TabHintergrund.Close
    else
        TabUmrandung.Close
    endif
    '/// Close dialog ///
    Call hCloseDocument
    '/// Close active document ///

endcase

'------------------------------------------------

testcase tFormatPage
    PrintLog "- Format / Page"

    Call hNewDocument
    '/// Open new document ///

    FormatPageWriter
    '/// Format / Page ///

    Kontext
    '/// Step through all tabpages ///
    active.SetPage TabVerwalten
    kontext "TabVerwalten"
    Call DialogTest ( TabVerwalten )

    Kontext
    active.SetPage TabSeite
    kontext "TabSeite"
    Call DialogTest ( TabSeite )

    Kontext
    active.SetPage TabHintergrund
    Kontext "Active"
    If Active.GetRT = 304 then Active.Yes         ' Messagebox abfangen-> Seitenr�nder au�erhalb des Bereichs

    Kontext
    active.SetPage TabHintergrund
    kontext "TabHintergrund"
    Call DialogTest2 ( TabHintergrund, 1 )
    Als.Select 2
    Call DialogTest2 ( TabHintergrund, 2 )
    Durchsuchen.Click
    Sleep 2
    Kontext "GrafikEinfuegenDlg"
    GrafikEinfuegenDlg.Cancel

    Kontext
    active.SetPage TabKopfzeile
    kontext "TabKopfzeile"
    Call DialogTest ( TabKopfzeile )
    if gApplication <> "HTMLDOKUMENT" then
        KopfzeileMitAbstand.Check
        Zusaetze.Click

        Kontext
        active.SetPage TabUmrandung
        kontext "TabUmrandung"
        Call DialogTest ( TabUmrandung )
        Kontext
        active.SetPage TabHintergrund
        kontext "TabHintergrund"
        Call DialogTest ( TabHintergrund )
        Als.Select 2
        Call DialogTest ( TabHintergrund )
        TabHintergrund.Close
    endif
    Kontext
    active.SetPage TabFusszeile
    kontext "TabFusszeile"
    Call DialogTest ( TabFusszeile )
    if gApplication <> "HTMLDOKUMENT" then
        FusszeileMitAbstand.Check
        Zusaetze.Click

        Kontext
        active.SetPage TabUmrandung
        kontext "TabUmrandung"
        Call DialogTest ( TabUmrandung )
        Kontext
        active.SetPage TabHintergrund
        kontext "TabHintergrund"
        Call DialogTest2 ( TabHintergrund, 1 )
        Als.Select 2
        Call DialogTest2 ( TabHintergrund, 2 )
        TabHintergrund.Close

        Kontext
        active.SetPage TabUmrandung
        kontext "TabUmrandung"
        Call DialogTest ( TabUmrandung )

        Kontext
        active.SetPage TabSpalten
        kontext "TabSpalten"
        Call DialogTest ( TabSpalten )

        if gAsianSup = True then
            Kontext
            active.Setpage TabGrid
            Kontext "TabGrid"
            Call DialogTest ( TabGrid )
        endif

        Kontext
        active.SetPage TabFussnote
        kontext "TabFussnote"
        Call DialogTest ( TabFussnote )
        TabFussnote.Close
    else
        TabFussZeile.Close
    endif
    '/// Close dialog ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'--------------------------------------------------

testcase tFormatNumberingBullets
    PrintLog "- Format / Numbering / Bullets"

    Call hNewDocument
    '/// Open new document ///
    FormatNumberingBullets
    '/// Format / Numbering/Bullets ///

    Sleep 5
    '/// Step through all tabpages ///
    Kontext
    Active.SetPage TabBullet
    Kontext "TabBullet"
    Call DialogTest ( TabBullet )

    Kontext
    Active.SetPage TabNumerierungsart
    Kontext "TabNumerierungsart"
    Call DialogTest ( TabNumerierungsart )

    Kontext
    Active.SetPage TabNumerierung
    Kontext "TabNumerierung"
    Call DialogTest ( TabNumerierung )

    Kontext
    Active.SetPage TabGrafiken
    Kontext "TabGrafiken"
    Call DialogTest ( TabGrafiken )

    Kontext
    Active.SetPage TabPositionNumerierung
    Kontext "TabPositionNumerierung"
    Call DialogTest ( TabPositionNumerierung )

    Kontext
    Active.SetPage TabOptionenNumerierung
    Kontext "TabOptionenNumerierung"
    Call DialogTest ( TabOptionenNumerierung )
    Numerierung.Select 9
    if gUseSysDlg = False then
        try
            Auswahl.Click
        catch
            QAErrorlog "#i67185#Numbering option 'Linked graphics' is missing"
            TabOptionenNumerierung.Cancel
            Call hCloseDocument
            goto endsub
        endcatch
        Sleep 5
        Call hMenuSelectNr (1)
        Sleep 5
        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
    endif
    Kontext "TabOptionenNumerierung"

    Sleep 1
    '  MenuSelect(2)
    '  Call hMenuSelectNr (3)
    '  Sleep 10
    try
        Auswahl.Click
        Sleep 5
        Call hMenuSelectNr(2)
        Sleep 25
        Call hMenuClose
    catch
        Exceptlog
        Call hMenuClose
    endcatch

    TabOptionenNumerierung.Cancel
    '/// Close dialog ///

    Call hCloseDocument
    '/// Close active document ///
endcase

'------------------------------------------------------

testcase tFormatStylist
    PrintLog "- Format / Stylist"
	
	if gPlatgroup = "unx" then
		QAErrorlog "HDE: Doesn't run on unix"
		goto endsub
	endif
    Call hNewDocument
    '/// Open new document ///
    Kontext "Gestalter"
    If Not Gestalter.Exists then FormatStylist
    '/// Format / Stylist ///
    Kontext "Gestalter"
    Call DialogTest ( Gestalter )
    Zeichenvorlagen.Click
    '/// Click all Styles-buttons in Stylist ///
    if gApplication <> "HTMLDOKUMENT" then
        Sleep 1
        Rahmenvorlagen.Click
        Sleep 1
        Seitenvorlagen.Click
    endif
    Sleep 1
    Numerierungsvorlagen.Click
    Sleep 1
    Absatzvorlagen.Click
    Sleep 1

    TBGestalterRight.Click Giesskanne
    Sleep 1

    AusSelektion.OpenMenu
    Sleep 1
    hMenuSelectNr(1)
    Sleep 1
    Kontext "VorlageErzeugen"
    DialogTest ( VorlageErzeugen )
    VorlageErzeugen.Cancel
    Sleep 1
    
    Kontext "Gestalter"
    AusSelektion.OpenMenu
    Sleep 1
    hMenuSelectNr(2)
    
    AusSelektion.OpenMenu
    Sleep 1
    hMenuSelectNr(3)
    Sleep 10
    Kontext "Neu"
    DialogTest ( Neu )
    Neu.Cancel
	
    Kontext "Gestalter"
    Gestalter.Close
    '/// Close Stylist ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'------------------------------------------------------

testcase tFormatAutoformatWhileTyping
    PrintLog "- Format / Autoformat / "

    Call hNewDocument
    '/// Open new document ///
    FormatAutoformatWhileTyping
    '/// Uncheck 'Format / Autoformat / While typing' ///
    wait 2000
    FormatAutoformatWhileTyping
    '/// Check 'Format / Autoformat / While typing' ///
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFormatColumn
    PrintLog "- Format / Column"

    Call hNewDocument
    '/// Open new document ///
    Call hTabelleEinfuegen
    '/// Insert a table ///
    Wait 500
    FormatColumnWidthWriter
    '/// Format / column / Width ///
    Wait 500
    Kontext "SpaltenBreite"
    Breite.SetText "2,5"
    Call DialogTest ( SpaltenBreite )
    SpaltenBreite.OK
    '/// Close dialog ///
    Wait 500
    Call wDocSetContext
    Call wDokSchreiben ("Dies ist ein langer Text, HALLO HALLO")
    '/// Enter some text in document ///
    Wait 500
    FormatColumnOptimalWidthWriter
    '/// Format / Column / Optimal Width ///
    Wait 500
    FormatRowSelect
    '/// Format / Row / Select ///
    Wait 500
    FormatColumnSpaceEqually
    '/// Format / Column / Space equally ///
    Wait 500
    FormatColumnSelect
    '/// Format / Column / Select ///
    Wait 500
    FormatColumnDelete
    '/// Format / Cloumn / Delete ///
    Wait 500
    Call wDocSetContext
    Call wDokSchreiben ("<Up>",2)
    '/// Point cursor in table ///
    wait 500
    FormatColumnInsert
    '/// Format / Column / Insert  ///
    Wait 500
    Kontext "EinfuegenSpalten"
    Anzahl.SetText "3"
    Call DialogTest ( EinfuegenSpalten )
    EinfuegenSpalten.OK
    '/// Close dialog ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFormatAnchor
    PrintLog "- Format / Anchor"

    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert a graphic from file '..\writer\input\grafik\jolink.jpg' ///

    try
        FormatAnchorToPage
        '/// Format / Anchor / to page ///
    catch
        Warnlog "'Page' couldn't be executed!"
    endcatch

    Sleep 1
    try
        FormatAnchorToParagraph
    catch
        '///  Format / Anchor / to paragraph ///
        Warnlog "'to paragraph' couldn't be executed!"
    endcatch

    Sleep 1
    try
        FormatAnchorToCharacter
        '/// Format / Anchor / to character ///
    catch
      Warnlog "'To Character' couldn't be executed!"
    endcatch
    Sleep 1

    try
        FormatAnchorAsCharacter
        '/// Format / Anchor / As Character ///
    catch
        Warnlog "'as Character' couldn't be executed!"
    endcatch
    Sleep 1

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatWrap
    PrintLog "- Format / Wrap"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in Writer/Web!"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert a graphic from file '..\writer\input\grafik\jolink.jpg' ///

    try
        FormatWrapNoWrap
        '/// Format / Wrap / No wrap ///
    catch
        Warnlog "Error on 'No Wrap'"
    endcatch
    Sleep 1

    try
        FormatWrapPageWrap
        '/// Format / Wrap / Page Wrap ///
    catch
        Warnlog "Error on 'Page Wrap'"
    endcatch
    Sleep 1

    try
        FormatWrapOptimalPageWrap
        '/// Format / Wrap / optimal page wrap ///
    catch
        Warnlog "Error on 'Optimal Page Wrap'"
    endcatch
    Sleep 1

    try
        FormatWrapThrough
        '/// Format / Wrap / Through ///
    catch
        Warnlog "Error on 'Wrap Through'"
    endcatch
    Sleep 1

    try
        FormatWrapInBackground
        '/// Format / Wrap / In Background  ///
    catch
        Warnlog "Error on 'In Background'"
    endcatch
    Sleep 1

    try
        FormatWrapFirstParagraph
        '/// Format / Wrap / First paragraph ///
    catch
        Warnlog "Error on 'First Paragraph'"
    endcatch
    Sleep 1

    try
        FormatWrapContour
        '/// Format / Wrap / Contour ///
        Warnlog "Error on 'Contour'"
    catch
        printlog "Contour Wrap disabled->OK"
    endcatch
    Sleep 1

    try
        FormatWrapEditContour
        '/// Format / Wrap / Edit Contour ///
        Sleep 5
        Kontext "KonturEditor"
        Dialogtest ( KonturEditor )
        Sleep 5
        KonturEditor.Close
        '/// Close contour editor ///
        Kontext
        if Active.Exists (2) then Active.Yes
    catch
        Warnlog "#85505#Error on 'Edit Contur'"
    endcatch

    Call hCloseDocument
    '/// Close active document ///

endcase


'-----------------------------------------------------------

testcase tFormatAnchorArea
    PrintLog "- Format / Anchor drawing objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    printlog "crashed because of i32539 (fixed in m54)"

    Call hNewDocument
    '/// Open new document ///
    Call wRectangleToClipboard
    '/// Paste a rectangle from draw via clipboard ///
    Sleep 2
    EditPaste
    Sleep 2

    try
        '/// Format / Anchor / To page ///
        FormatAnchorToPage
    catch
        Warnlog "Clipboard problem between applications!"
        Call wZeichenobjektEinfuegen ( "Rechteck", 40, 40, 50, 50 )
        Call gMouseClick ( 45, 45 )
        FormatAnchorToPage
    endcatch

    Sleep 1
    '/// Format / Anchor / to paragraph ///
    FormatAnchorToParagraph
    Sleep 1
    '/// Format / Anchor / As character ///
    FormatAnchorAsCharacter
    Sleep 1

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatWrapArea
    PrintLog "- Format / Wrap drawing objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    printlog "crashed because of i32539 (fixed in m54)"

    Call hNewDocument
    '/// Open new document ///
    Call wRectangleToClipboard
    '/// Paste a rectangle from draw via clipboard ///
    EditPaste
    Sleep 2

    try
        FormatWrapNoWrap
        '/// Format / Wrap / No wrap ///
    catch
        Warnlog "Clipboard problem between applications!"
        Call wZeichenobjektEinfuegen ( "Rechteck", 40, 40, 50, 50 )
        Call gMouseClick ( 45, 45 )
        FormatWrapNoWrap
    endcatch

    Sleep 1
    '/// Format / Wrap / Contour ///
    try
        FormatWrapContour  ' should be disabled with 'No wrap'
        Warnlog "Format / Wrap / Contour is disabled!"
    catch
    endcatch
    Sleep 1
    '/// Format / Wrap / Page wrap ///
    try
        FormatWrapPageWrap
    catch
        Warnlog "Format / Wrap / Page Wrap is disabled!"
    endcatch
    Sleep 1
    '/// Format / Wrap / Contour ///
    try
        FormatWrapContour
    catch
        Warnlog "Format / Wrap / Contour is disabled!"
    endcatch
    Sleep 1
    '/// Format / Wrap / optimal page wrap ///
    try
        FormatWrapOptimalPageWrap
    catch
        Warnlog "Format / Wrap / Optimal page wrap is disabled!"
    endcatch
    Sleep 1
    '/// Format / Wrap / Through ///
    try
        FormatWrapThrough
    catch
        Warnlog "Format / Wrap /Through is disabled!"
    endcatch
    Sleep 1
    '/// Format / Wrap / In Background ///
    try
        FormatWrapInBackground
    catch
        Warnlog "Format / Wrap / In Background is disabled!"
    endcatch
    Sleep 1
    '/// Format / Wrap / First paragraph ///
    try
        FormatWrapFirstParagraph
    catch
        Warnlog "Format / Wrap / First paragraph is disabled!"
    endcatch
    Sleep 1
    try
        '/// Format / Wrap / Edit ///
        FormatWrapEdit
    catch
        Warnlog "Drawing object in wrong format from the clipboard!"
    endcatch
    Kontext "TabUmlauf"
    Call DialogTest ( TabUmlauf )
    '/// Close upcoming dialog ///
    TabUmlauf.Cancel

    Call hCloseDocument
    '/// Close active document ///
endcase


