'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_005b_.inc,v $
'*
'*  $Revision: 1.22 $
'*
'*  last change: $Author: hde $ $Date: 2006/02/16 08:43:37 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Put description here
'*
'\***********************************************************************


sub w_005b_
    printLog Chr(13) + "--------- Menu Format / 2 (w_005b_.inc) ----------"


    Call tFormatAlignment
    Call tFormatAlignmentArea
    Call tFormatAlignmentEdit
    Call tFormatArrange    
    Call tFormatArrangeArea
    Call tFormatFlip
    Call tFormatGroup    


    '    Object submenu
    Call tFormatPositionAndSize
    Call tFormatPositionAndSizeLegend
    Call tFormatLine
    Call tFormatArea
    Call tFormatText
    Call tFormatFontwork

    '    Frame
    Call hExportUmstellung ( TRUE )
    Call tFormatObject
    Call tFormatArrangeObject
    Call tFormatAlignmentObject
    Call tFormatAnchorObject
    Call tFormatWrapObject
    Call hExportUmstellung ( FALSE )    
    
    '    Picture ( jolink.jpg )
    Call tFormatGraphics

    '    Editmode with Draw objects
    Call tFormatStyleEdit
    Call tFormatLineSpacing    
    Call tFormatParagraphEdit

end sub


'-----------------------------------------------------------

testcase tFormatGraphics
    PrintLog "- Format / Graphics"
    Dim j as integer
    
    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert a graphic (..\writer\input\grafik\jolink.jpg) ///

    try
        '/// Format / Graphic ///
        FormatGraphics
    catch
        Warnlog "- Format / Graphics disabled or hidden!"
        goto endsub
    endcatch

    '/// Step through all tabpages ///
    Kontext
    active.SetPage TabType
    Kontext "TabType"
    Call DialogTest ( TabType )

    Kontext
    active.SetPage TabZusaetze
    Kontext "TabZusaetze"
    Call DialogTest ( TabZusaetze )

    Kontext
    active.SetPage TabUmlauf
    Kontext "TabUmlauf"
    Call DialogTest ( TabUmlauf )

    Kontext
    active.SetPage TabHyperlinkRahmen
    Kontext "TabHyperlinkRahmen"
    Call DialogTest ( TabHyperlinkRahmen )

    Kontext
    active.SetPage TabGrafik
    Kontext "TabGrafik"
    Call DialogTest ( TabGrafik )

    if gApplication <> "HTMLDOKUMENT" then
        Kontext
        active.SetPage TabZuschneiden
        Kontext "TabZuschneiden"
        Call DialogTest ( TabZuschneiden )

        Kontext
        active.SetPage TabHintergrund
        Kontext "TabHintergrund"
        Call DialogTest ( TabHintergrund )
    endif

    Kontext
    active.SetPage TabUmrandung
    Kontext "TabUmrandung"
    Call DialogTest ( TabUmrandung )

    Kontext
    active.SetPage TabMakro
    ' if no JRE is installed a messagebox appears
    Do
        j = j + 1
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                if j = 1 then Warnlog Active.Gettext    
                Active.Ok
            else
                exit do
            endif                    
        else
            exit do
        endif
    Loop
    Kontext "TabMakro"
    Call DialogTest ( TabMakro )

    TabMakro.Cancel
    '/// Close dialog ///

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFormatArrange
    PrintLog "- Format / Arrange"

    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert a graphic from file '..\writer\input\grafik\jolink.jpg' ///

    try
        FormatArrangeBringToFrontCalc
        '/// Format / Arrange / Bring to front ///
    catch
        Warnlog "'Bring to front' couldn't be executed!"
    endcatch
    Sleep 1
    try
        FormatArrangeBringForward
        '/// Format / Arrange / Bring forward ///
    catch
        Warnlog "'Bring forward' couldn't be executed!"
    endcatch
    Sleep 1
    try
        FormatArrangeSetBackward
        '/// Format / Arrange / Set backward ///
    catch
        Warnlog "'Send backward' couldn't be executed!"
    endcatch
    Sleep 1
    try
        FormatArrangeSendToBack
        '/// Format / Arrange / Send to back ///
    catch
        Warnlog "'Send to back' couldn't be executed!"
        Sleep 1
    endcatch
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFormatAlignment
    PrintLog "- Format / Alignment"

    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    '/// Insert a graphic from file '..\writer\input\grafik\jolink.jpg' ///
    if gApplication = "HTMLDOKUMENT" then
        wait 500
        '/// Format / Anchor / to Page ///
        FormatAnchorToPage
    endif

    try
        FormatAlignmentLeft
        '/// Format / Alignment / Left ///
    catch
        Warnlog "'Alignment left' couldn't be executed!"
    endcatch

    Sleep 1
    try
        FormatAlignmentRight
        '/// Format / Alignment / Right ///
    catch
        Warnlog "'Alignment right' couldn't be executed!"
    endcatch

    Sleep 1
    try
        FormatAlignmentTop
        '/// Format / Alignment / Top ///
    catch
        Warnlog "'Alignment top' couldn't be executed!"
    endcatch

    Sleep 1
    try
        FormatAlignmentCenter
        '/// Format / Alignment / Center ///
    catch
        Warnlog "'Alignment center' couldn't be executed!"
    endcatch

    Sleep 1
    try
        FormatAlignmentBottom
        '/// Format / Alignment / Bottom ///
    catch
        Warnlog "'Alignment bottom' couldn't be executed!"
    endcatch

    Sleep 1
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatObject
    PrintLog "- Format / Object"
    Dim j as integer
    
    Call hNewDocument
    '/// Open new document ///
    Call wInsertFrame
    '/// Insert a frame ///

    FormatFrame
    '/// Format / Frame ///

    Kontext
    active.SetPage TabType
    Kontext "TabType"
    Call DialogTest ( TabType )
    '/// Step through all tabpages ///

    Kontext
    active.SetPage TabZusaetze
    Kontext "TabZusaetze"
    Call DialogTest ( TabZusaetze )

    Kontext
    active.SetPage TabUmlauf
    Kontext "TabUmlauf"
    Call DialogTest ( TabUmlauf )

    Kontext
    active.SetPage TabUmrandung
    Kontext "TabUmrandung"
    Call DialogTest ( TabUmrandung )

    Kontext
    active.SetPage TabHintergrund
    Kontext "TabHintergrund"
    Call DialogTest ( TabHintergrund )

    if gApplication <> "HTMLDOKUMENT" then
        Kontext
        active.SetPage TabHyperlinkRahmen
        Kontext "TabHyperlinkRahmen"
        Call DialogTest ( TabHyperlinkRahmen )

        Kontext
        active.SetPage TabMakro
        ' if no JRE is installed a messagebox appears
        Do
            j = j + 1
            Kontext "Active"
            if Active.Exists then
                if Active.GetRT = 304 then
                    if j = 1 then Warnlog Active.Gettext    
                    Active.Ok
                else
                    exit do
                endif                    
            else
                exit do
            endif
        Loop
        Kontext "TabMakro"
        Call DialogTest ( TabMakro )
        TabMakro.Cancel
    else
        TabHintergrund.Cancel
    endif
    '/// Close dialog ///
    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFormatArrangeObject
    PrintLog "- Format / Arrange Frame"

    Call hNewDocument
    '/// Open new document ///
    Call wInsertFrame
    '/// Insert a frame ///

    FormatArrangeBringToFrontCalc
    '/// Format / Arrange / Bring to front ///
    Sleep 1
    FormatArrangeBringForward
    '/// Format / Arrange / Bring forward ///
    Sleep 1
    FormatArrangeSetBackward
    '/// Format / Arrange / Set backward ///
    Sleep 1
    FormatArrangeSendToBack
    '/// Format / Arrange / Send to back  ///
    Sleep 1

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFormatAlignmentObject
    PrintLog "- Format / Alignment Frame"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///
    Call wInsertFrame
    '/// Insert a frame ///

    FormatAlignmentLeft
    '/// Format / Alignment / Left ///
    Sleep 1
    FormatAlignmentCentered
    '/// Format / Alignment / Centered ///
    Sleep 1
    FormatAlignmentRight
    '/// Format / Alignment / Right ///
    Sleep 1
    FormatAlignmentTop
    '/// Format / Alignment / Top ///
    Sleep 1
    FormatAlignmentCenter
    '/// Format / Alignment / Center ///
    Sleep 1
    FormatAlignmentBottom
    '/// Format / Alignment / Bottom ///
    Sleep 1

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFormatAnchorObject
    PrintLog "- Format / Anchor Frame"

    Call hNewDocument
    '/// Open new document ///
    Call wInsertFrame
    '/// Insert a frame ///

    FormatAnchorToPage
    '/// Format / Anchor / to page ///
    Sleep 1
    FormatAnchorToParagraph
    '/// Format / Anchor / to paragraph ///
    Sleep 1
    FormatAnchorToCharacter
    '/// Format / Anchor / to character ///
    Sleep 1
    FormatAnchorAsCharacter
    '/// Format / Anchor / as character ///
    Sleep 1

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase tFormatWrapObject
    PrintLog "- Format / Wrap (Frame)"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif

    Call hNewDocument
    '/// Open new document ///
    Call wInsertFrame
    '/// Insert a frame ///

    FormatWrapNoWrap
    '/// Format / Wrap / no wrap ///
    Sleep 1
    FormatWrapPageWrap
    '/// Format / Wrap / page wrap ///
    Sleep 1
    FormatWrapOptimalPageWrap
    '/// Format / Wrap / optimal page wrap ///
    Sleep 1
    FormatWrapThrough
    '/// Format / Wrap / through ///
    Sleep 1
    FormatWrapInBackground
    '/// Format / Wrap / in background ///
    Sleep 1
    FormatWrapFirstParagraph
    '/// Format / Wrap / first paragraph ///
    Sleep 1
    try
        '/// Format / Wrap / Contour ///
        FormatWrapContour
        Wait 500
        Warnlog "Wrap / Contour should not be enabled for frames ! (Bug#90964)"
    catch
    endcatch
    Sleep 1
    try
        '/// Format / Wrap / Edit Contour ///
        FormatWrapEditContour
        Kontext "KonturEditor"
        Sleep 2
        KonturEditor.Close
        '/// Close 'Contour Editor' ///
        Warnlog "Wrap / Edit Contour should not be enabled for frames ! (Bug#90964)"
    catch
    endcatch
    Kontext
    if Active.Exists (2) then Active.Yes

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatLine
    PrintLog "- Format / Line in drawing object"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    printlog "crashed because of i32539 (fixed in m54)"

    Call hNewDocument
    '/// Open new document ///
	Call wRectangleToClipboard
    '/// Insert a rectangle ///
    EditPaste
    '/// Edit / Paste ///

    Sleep 2
    try
        '/// Format / Line ///
        FormatLine
    catch
        Warnlog "Clipboard problem between applications!"
        Call wZeichenobjektEinfuegen ( "Rechteck", 40, 40, 50, 50 )
        Call gMouseClick ( 45, 45 )
        FormatLine
    endcatch

    Kontext
    '/// Step through all tabpages ///
    wait 500
    active.SetPage TabLinie
    kontext "TabLinie"
    Call DialogTest ( TabLinie )

    Kontext
    active.SetPage TabLinienstile
    kontext "TabLinienstile"
    Call DialogTest ( TabLinienstile )
    try
        Aendern.Click
        Kontext "NameDlg"
        Call DialogTest ( NameDlg )
        NameDlg.Cancel
    catch
        Warnlog "Modify is disabled!"
        if Linienstil.GetItemCount = 0 then
            Warnlog "List of 'Line styles is empty! (Bug#99882)"
        endif
    endcatch

    Kontext
    active.SetPage TabLinienenden
    Kontext "Linienstil"
    if Linienstil.Exists then
        Warnlog "Messagebox appears changing to Tabpage 'Arrow Styles!"
        Linienstil.Cancel
    else
        kontext "TabLinienenden"

        Call DialogTest ( TabLinienenden )
        Aendern.Click
        Kontext
        Active.OK
        kontext "NameDlg"
        Call DialogTest ( NameDlg )
        NameDlg.Cancel
    endif

    kontext "TabLinienenden"
    TabLinienenden.cancel
    '/// Close dialog ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatArea
    Dim i as integer    
    PrintLog "- Format / Area in drawing object"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif

    Call hNewDocument
    '/// Open new document ///
    Call wRectangleToClipboard
    '/// Insert a rectangle ///
    EditPaste
    Sleep 2
    try
        '/// Format / Area ///
        FormatArea
    catch
        Warnlog "Clipboard problem between applications!"
        Call wZeichenobjektEinfuegen ( "Rechteck", 40, 40, 50, 50 )
        Call gMouseClick ( 45, 45 )
        FormatArea
    endcatch

    Kontext
    wait 500
    '/// Step through all tabpages ///
    active.SetPage TabArea
    Kontext "TabArea"
    For i = 1 to 5
        FillOptions.Select i
        Call DialogTest2 ( TabArea, i )
    next i
    Kontext
    active.SetPage TabSchatten
    kontext "TabSchatten"
    Anzeigen.Check
    Call DialogTest ( TabSchatten )

    Kontext
    active.SetPage TabTransparenz
    kontext "TabTransparenz"
    Call DialogTest ( TabTransparenz )

    Kontext
    active.SetPage TabFarben
    kontext "TabFarben"
    Sleep 1
    Farbmodell.Select 2
    Call DialogTest ( TabFarben )

    Bearbeiten.Click
    Sleep 3
    Kontext "FarbeDlg"
    Call DialogTest ( FarbeDlg )
    FarbeDlg.cancel
    Sleep 3

    Kontext
    active.SetPage TabFarbverlaeufe
    kontext "TabFarbverlaeufe"
    Call DialogTest ( TabFarbverlaeufe )
    Aendern.Click
    Kontext "NameDlg"
    Call DialogTest ( NameDlg )
    NameDlg.Cancel

    Kontext
    active.SetPage TabSchraffuren
    kontext "TabSchraffuren"
    Call DialogTest ( TabSchraffuren)
    try
        Aendern.Click
        Kontext "NameDlg"
        Call DialogTest ( NameDlg )
        NameDlg.Cancel
    catch
        Warnlog "Button 'Modify' does not work!"
        if Tabelle.GetItemcount = 0 then
            Warnlog "Table of Hatching's is empty! (Bug#99882)"
        endif
    endcatch

    Kontext
    active.SetPage TabBitmap
    kontext "TabBitmap"
    Call DialogTest ( TabBitmap )

    try
        Aendern.Click
        Kontext "NameDlg"
        Call DialogTest ( NameDlg )
        NameDlg.cancel
    catch
        WarnLog "#36902#Modify is disabled. Wrong default-list loaded"
    endcatch

    kontext "TabBitmap"
    Import.Click
    Kontext "GrafikEinfuegenDlg"
    Call DialogTest ( GrafikEinfuegenDlg )
    GrafikEinfuegenDlg.Cancel

    '/// Close Tabdialog ///
    kontext "TabBitmap"
    TabBitmap.Cancel
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatText
    PrintLog "- Format / Text in drawing object"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    printlog "crashed because of i32539 (fixed in m54)"

    Call hNewDocument
    '/// Open new document ///
    Call wRectangleToClipboard
    '/// Paste a rectangle from draw via clipboard ///
    EditPaste
    Sleep 2

    try
        FormatTextWriter
    '/// Format / Text ///
    catch
        Warnlog "Clipboard problem between applications!"
        Call wZeichenobjektEinfuegen ( "Rechteck", 40, 40, 50, 50 )
        Call gMouseClick ( 45, 45 )
        FormatTextWriter
    endcatch

    Kontext
    '/// Step through all tabpages ///
    wait 500
    Active.SetPage TabText
    Kontext "TabText"
    DialogTest ( TabText )

    Kontext
    Active.SetPage TabLauftext
    Kontext "TabLauftext"
    DialogTest ( TabLauftext )

    TabLauftext.Cancel
    '/// Close dialog ///
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatPositionAndSize
    PrintLog "- Format / Position and Size in drawing object"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    printlog "crashed because of i32539 (fixed in m54)"

    Call hNewDocument
    '/// Open new document ///
    Call wRectangleToClipboard
    '/// Paste a rectangle from draw via clipboard ///
    EditPaste
    Sleep 2

    try
        '/// Format Position and Size ///
        ContextPositionAndSize
    catch
        Warnlog "Clipboard problem between applications!"
        Call wZeichenobjektEinfuegen ( "Rechteck", 40, 40, 50, 50 )
        Call gMouseClick ( 45, 45 )
        ContextPositionAndSize
    endcatch

    '/// Step through all tabpages ///
    Kontext
    active.setpage TabPositionAndSizeWriter
    Kontext "TabPositionAndSizeWriter"
    call Dialogtest ( TabPositionAndSizeWriter )

    Kontext
    active.setPage TabDrehung
    Kontext "TabDrehung"
    call Dialogtest ( TabDrehung )

    Kontext
    active.setpage TabSchraegstellen
    Kontext "TabSchraegstellen"
    call Dialogtest ( TabSchraegstellen )
    '/// Close dialog ///
    TabSchraegstellen.cancel

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatFlip
    PrintLog "- Format / Flip drawing objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    printlog "crashed because of i32539 (fixed in m54)"

    Call hNewDocument
    '/// Open new document ///
    Call wRectangleToClipboard
    '/// Paste a rectangle from draw via clipboard ///
    EditPaste
    Sleep 2

    try
        '/// Format / Flip vertically ///
        FormatFlipVertically
    catch
        Warnlog "Clipboard problem between applications!"
        Call wZeichenobjektEinfuegen ( "Rechteck", 40, 40, 50, 50 )
        Call gMouseClick ( 45, 45 )
        FormatFlipVertically
    endcatch

    Sleep 3
    '/// Format / Flip horizontally ///
    FormatFlipHorizontally
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatArrangeArea
    PrintLog "- Format / Arrange drawing objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    printlog "crashed because of i32539 (fixed in m54)"

    Call hNewDocument
    '/// Open new document ///
    Call wRectangleToClipboard
    '/// Paste a rectangle from draw via clipboard ///
    EditPaste
    Sleep 2

    try
        '/// Format / Arrange / Bring to front ///
        FormatArrangeBringToFrontCalc
    catch
        Warnlog "Clipboard problem between applications!"
        Call wZeichenobjektEinfuegen ( "Rechteck", 40, 40, 50, 50 )
        Call gMouseClick ( 45, 45 )
        FormatArrangeBringToFrontCalc
    endcatch

    Sleep 1
    '/// Format / Arrange / Bring Forward ///
    FormatArrangeBringForward
    Sleep 1
    '/// Format / Arrange / Set backward ///
    FormatArrangeSetBackward
    Sleep 1
    '/// Format / Arrange / Send to beack ///
    FormatArrangeSendToBack
    Sleep 1

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatAlignmentArea
    PrintLog "- Format / Alignment drawing objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///
    Call wZeichenobjektEinfuegen ( "Rechteck", 20, 30, 45, 45 )
    '/// Paste a rectangle from draw via clipboard ///
    Call wObjektSelektieren ( 15, 25, 50, 50 )

    Sleep 1
    try
        '/// Format / Anchor / As Character ///
        FormatAnchorAsCharacter
    catch
        Warnlog "Anchor could not be set to character! No test!"
        Call hCloseDocument
        '/// Close active document ///
        goto endsub
    endcatch

    Sleep 1
    try
        '/// Format / Object / Alignment left ///
        FormatObjectAlignmentLeft
    catch
        Warnlog "Format / Object / Alignment / Left could not be executed!"
    endcatch
    Sleep 1
    try
        FormatObjectAlignmentCentered
        '/// Format / Object / Alignment centered ///
    catch
        Warnlog "Format / Object / Alignment / Centered could not be executed!"
    endcatch

    Sleep 1
    try
        FormatObjectAlignmentRight
        '/// Format / Object / Alignment right ///
    catch
        Warnlog "Format / Object / Alignment / Right could not be executed!"
    endcatch

    Sleep 1
    try
        '/// Format / Object / Alignment Top ///
        FormatObjectAlignmentTop
    catch
        Warnlog "Format / Object / Alignment / Top could not be executed!"
    endcatch

    Sleep 1
    try
        '/// Format / Object / Alignment Center ///
        FormatObjectAlignmentCenter
    catch
        Warnlog "Format / Object / Alignment / Center could not be executed!"
    endcatch

    Sleep 1
    try
        '/// Format / Object / Alignment bottom ///
        FormatObjectAlignmentBottom
    catch
        Warnlog "Format / Object / Alignment / Bottom could not be executed!"
    endcatch

    Sleep 1

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatGroup
    Dim x%, y%, x1%, y1%
    PrintLog "- Format / Group drawing objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///
    '/// Insert 2 rectangles and select both ///
    if gPlatGroup <> "unx" then
        Call wZeichenobjektEinfuegen ( "Rechteck", 20, 20, 30, 30 )
        Call wDokSchreiben ( "<Escape>" )
        Call wZeichenobjektEinfuegen ( "Rechteck", 35, 35, 45, 45 )
        Call wDokSchreiben ( "<Escape>" )
        Call wObjektSelektieren ( 15, 15, 50, 50 )
        x% = 25
        y% = 25
        x1% = 35
        y1% = 45
    else
        Call wZeichenobjektEinfuegen ( "Rechteck", 50, 60, 30, 30 )
        Call wDokSchreiben ( "<Escape>" )
        Call wZeichenobjektEinfuegen ( "Rechteck", 65, 80, 45, 45 )
        Call wDokSchreiben ( "<Escape>" )
        Call wObjektSelektieren ( 10, 10, 70, 90 )
        x% = 55
        y% = 55
        x1% = 55
        y1% = 65
    endif

    Sleep 1
    try
        '/// Format / Group / Group ///
        FormatGroupGroup
    catch
        QAErrorlog "Unable to execute Format / Group / Group. Maybe objects not selected!"
        Call hCloseDocument
        '/// Close active document ///
        goto endsub
    endcatch
    Sleep 2
    try
        '/// Format / Group / Edit Group ///
        FormatGroupEditGroupCalc
    catch
        Warnlog "Unable to execute Format / Group / Group. Maybe objects not selected!"
        Call hCloseDocument
        '/// Close active document ///
        goto endsub
    endcatch

    Sleep 2
    Call wDokSchreiben ( "<Shift F4>" )
    Sleep 2
    try
        '/// Format / Exit Group ///
        FormatExitGroupDraw
    catch
        Warnlog "Unable to execute Format / Group / Exit Group. Maybe objects not selected!"
        Call hCloseDocument
        '/// Close active document ///
        goto endsub
    endcatch

    Call wDokSchreiben ( "<Shift F4>" )
    Sleep 2
    try
        '/// Format / Ungroup ///
        FormatUngroupDraw
    catch
        Warnlog "Unable to execute Format / Group / Ungroup. Maybe objects not selected!"
        Call hCloseDocument
        '/// Close active document ///
         goto endsub
    endcatch
    Sleep 2
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatFontwork
    PrintLog "- Format / Fontwork drawing objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    printlog "crashed because of i32539 (fixed in m54)"

    Call hNewDocument
    '/// Open new document ///
    Call wRectangleToClipboard
    '/// Paste a rectangle from draw via clipboard ///
    EditPaste
    Sleep 2

    try
        '/// Format / Font Work ///
        FormatFontwork
    catch
        Warnlog "Clipboard problem between applications!"
        Call wZeichenobjektEinfuegen ( "Rechteck", 40, 40, 50, 50 )
        Call gMouseClick ( 45, 45 )
        FormatFontwork
    endcatch

    Kontext "Fontwork"
    if Fontwork.Exists then
        call Dialogtest ( Fontwork )
        '/// Close Fontwork dialog ///
        FormatFontwork
    else
        Warnlog "Dialog 'Fontwork' does not exist!"
    endif
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatPositionAndSizeLegend
    PrintLog "- Format / Position and Size in Legend"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///
    Call wZeichenobjektEinfuegen ( "Legende", 20, 20, 40, 50 )
    '/// Insert a legend ///
    Call wObjektSelektieren(15, 15, 45, 55)

    Sleep 1
    try
        '/// Format / Position and size ///
        FormatPositionAndSize
    catch
        Warnlog "Format / Position and Size does not work! Maybe object not selected!"
        Call hCloseDocument
        '/// Close active document ///
        goto endsub
    endcatch

    '/// In upcoming dialog step through all tabpages ///
    Kontext
    active.setpage TabPositionAndSizeWriter
    Kontext "TabPositionAndSizeWriter"
    call Dialogtest ( TabPositionAndSizeWriter )

    Kontext
    active.setpage TabLegende
    Kontext "TabLegende"
    call Dialogtest ( TabLegende )
    TabLegende.Cancel
    '/// Close dialog ///

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatStyleEdit
    PrintLog "- Format / Style Text objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb !"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///
    Kontext "DrawBar"
    if Not DrawBar.Exists then Call hToolbarSelect("Drawing", true)
    
    if Drawbar.Exists then
        Textobjekt.Click
        '/// Insert a textobject from toolbar ///
        Sleep 5
    
        Call gMouseMove(50, 20, 70, 40)
        Sleep 2
    
        FormatStyleBold
        '/// Format / Style / Bold ///
        Sleep 1
        Call wDokSchreiben ("a")
        Sleep 1
        FormatStyleItalic
        '/// Format / Style / Italic ///
        Sleep 1
        '/// Insert a letter in text object ///
        Call wDokSchreiben ("a")
        Sleep 1
        FormatStyleUnderline
        '/// Format / Style / Underline ///
        Sleep 1
        '/// Insert a letter in text object ///
        Call wDokSchreiben ("a")
        Sleep 1
        UseBindings
        FormatStyleStrikeThrough
        '/// Format /Style / Strike through ///
        Sleep 1
        '/// Insert a letter in text object ///
        Call wDokSchreiben ("b")
        Sleep 1
        UseBindings
        FormatStyleShadow
        '/// Format / Style / Shadow ///
        Sleep 1
        '/// Insert a letter in text object ///
        Call wDokSchreiben ("b")
        Sleep 1
        UseBindings
        '/// Format / Style / Outline ///
        FormatStyleOutline
        Sleep 1
        '/// Insert a letter in text object ///
        Call wDokSchreiben ("b")
        Sleep 1
        '/// Format / Style / Superscript ///
        FormatStyleSuperscript
        Sleep 1
        '/// Insert a letter in text object ///
        Call wDokSchreiben ("a")
        Sleep 1
        '/// Format / Style / Subscript  ///
        FormatStyleSubscript
        Sleep 1
        '/// Insert a letter in text object ///
        Call wDokSchreiben ("a")
    
        Kontext "Drawbar"
        Drawbar.Close
    else
        Warnlog "#i33132#Toolbar 'Drawbar' is not opened!"
    endif
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatAlignmentEdit
    PrintLog "- Format / Alignment text objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///
    Kontext "DrawBar"
    if Not DrawBar.Exists then Call hToolbarSelect("Drawing", true)

    Textobjekt.Click
    '/// Insert a textbox via 'Draw functions' toolbar ///

    Call gMouseMove(50, 20, 70, 40)
    Sleep 2
    '/// Insert some text in document ///

    Call wDokSchreiben ("Ein Wort")
    '/// Format / Alignment / Left ///
    FormatAlignmentLeftText
    Sleep 1
    '/// Format / Alignment / Right ///
    FormatAlignmentRightText
    Sleep 1
    '/// Format / Alignment / Centered ///
    FormatAlignmentCenteredText
    Sleep 1
    '/// Format  Alignment / Justify ///
    FormatAlignmentJustifiedText
    Sleep 1

    Kontext "Drawbar"
    Drawbar.Close
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatLineSpacing
    PrintLog "- Format / Line Spacing text objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///
    Kontext "DrawBar"
    if Not DrawBar.Exists then Call hToolbarSelect("Drawing", true)

    Textobjekt.Click
    '/// In a textbox via 'Draw Functions' toolbox ///

    Call gMouseMove(50, 20, 70, 40)
    Sleep 2

    Call wDokSchreiben ("Hallo<Return>Andere Zeile")
    '/// Format / Spacing / Single line ///
    FormatLineSpacingSingleLine
    Sleep 1
    '/// Format / Line Spacing / Single line ///
    FormatLineSpacing15Lines
    '/// Format / Line Spacing  / 1.5 line ///
    Sleep 1
    FormatLineSpacingDouble
    '/// Format / Line spacing / Double ///
    Sleep 1

    Kontext "Drawbar"
    Drawbar.Close
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tFormatParagraphEdit
    PrintLog "- Format / Paragraph text objects"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///
    Kontext "DrawBar"
    if Not DrawBar.Exists then Call hToolbarSelect("Drawing", true)

    Textobjekt.Click
    '/// In a textbox via 'Draw Functions' toolbox ///

    Call gMouseMove(50, 20, 70, 40)
    Sleep 2

    '/// Format / Paragraph  ///
    FormatParagraph
    '/// Step through all tabpages ///
    Kontext
    Active.SetPage TabEinzuegeUndAbstaende
    Kontext "TabEinzuegeUndAbstaende"
    Call DialogTest ( TabEinzuegeUndAbstaende )

    Kontext
    Active.SetPage TabAusrichtungAbsatz
    Kontext "TabAusrichtungAbsatz"
    Call DialogTest ( TabAusrichtungAbsatz )

    Kontext
    Active.SetPage TabTabulator
    Kontext "TabTabulator"
    Call DialogTest ( TabTabulator )

    TabTabulator.Cancel
    Sleep 1
    Kontext "Drawbar"
    Drawbar.Close
    '/// Close dialog ///

    Call hCloseDocument
    '/// Close active document ///
endcase
