'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_007_.inc,v $
'*
'*  $Revision: 1.42 $
'*
'*  last change: $Author: hde $ $Date: 2006/07/14 05:20:30 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Put description here
'*
'\***********************************************************************


sub w_007_
    printLog Chr(13) + "--------- Tools Menu (w_007_.inc) ----------"

    Call tToolsSpellcheck
    Call tToolsThesaurus
    Call tToolsHyphenation
    Call tToolsWordCount
    Call tToolsAutocorrectAutoformat
    Call tToolsOutlineNumbering
    Call tToolsLineNumbering
    Call tToolsFootnotes
    Call tToolsGallery
'   Call tToolsBibliographyDatabase
    Call tToolsMailMergeWizard
    Call tToolsTextInTables
    Call tToolsSort
    Call tToolsCalculate
    Call tToolsUpdate
'   Call tToolsMacro
    Call tToolsCustomize						'global\update\inc
    Call tToolsOptionsTest
    Call tToolsHangulHanjaConversion
    Call tToolsChineseTranslation

end sub

' -------------------------------------------

testcase tToolsSpellcheck
    PrintLog "- Tools / Spellcheck"
    Dim i as integer, DieDatei as string, IsWriteable as boolean
	' As long as OOo has no modules for that, disabled
	if gOOO = True then
		printlog "No spellchecking in OOo"
		goto endsub
	endif

    Call hNewDocument
    '/// Open new document ///
    Call wDokSchreiben ("Dies ist ein Rechtschreibtexxxxt<Home>")
    '/// Insert some faulty text ///
    ToolsSpellcheck
    '/// Tools / Spellcheck / Check ///
    wait 500
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            try
                Active.Yes  ' Start from beginning ?
                if Active.exists then
                    if Active.GetRT = 304 then Active.Ok
                    Warnlog "Dialog 'Spellcheck' not up!"
                    Call hCloseDocument
                    goto endsub
                endif
            catch
                Active.Ok
                Warnlog "Dialog 'Spellcheck' not up!"
                Call hCloseDocument
                goto endsub
            endcatch
        endif
    endif
    '/// Spellcheck dialog has to come up ///
    Kontext "Spellcheck"
    DialogTest ( Spellcheck )
    '/// Click 'Options' ///
    SpellcheckOptions.Click
    Wait 500
    kontext "TabLinguistik"
    DialogTest ( TabLinguistik )
    '/// Step through all options in list and if 'Edit' is enabled click 'Edit' ///
    for i = 1 to 12
        kontext "TabLinguistik"    
        Optionen.TypeKeys "<Down>"
        if OptionenBearbeiten.IsEnabled then
            OptionenBearbeiten.Click
            wait 500
            Kontext "SilbentrennungOptionen"
            DialogTest ( SilbentrennungOptionen )
            SilbentrennungOptionen.Cancel
        endif
    next i
    '/// Click 'New' in Options dialog
    Neu.Click
    wait 500
    Kontext "BenutzerwoerterbuchAnlegen"
    Call DialogTest ( BenutzerwoerterbuchAnlegen )
    BenutzerwoerterbuchAnlegen.Close
    
    '/// Check if there s a writeable dictionary and select it
    Kontext "TabLinguistik"
    for i = 1 to Benutzerwoerterbuch.GetItemCount
        Benutzerwoerterbuch.Select i 
        try
            Bearbeiten.Click
            IsWriteable = true
            i = Benutzerwoerterbuch.GetItemCount + 1
        catch
            IsWriteable = False
        endcatch    
    next i
    
    if IsWriteable = true then
        '/// Click 'Edit' in 'Options dialog'
        Sleep 1
        Kontext "BenutzerwoerterbuchBearbeiten"
        if BenutzerwoerterbuchBearbeiten.Exists then
            Call DialogTest ( BenutzerwoerterbuchBearbeiten )
            BenutzerwoerterbuchBearbeiten.Close
        else
            Warnlog "Dialog 'Edit Dictionary' is not up!"
        endif
    else
        Warnlog "All dictionarys are write protected!"        
    endif
    '/// Close 'Options' dialog ///
    Kontext "TabLinguistik"
    TabLinguistik.Close
    wait 500
    Kontext "Spellcheck"
    Spellcheck.Close
    '/// Close 'Spellcheck' dialog ///
    wait 500
    Call hCloseDocument
    '/// Close active document ///

endcase

' -------------------------------------------

testcase tToolsThesaurus
    PrintLog "- Tools / Thesaurus"
    Dim DieDatei as string

	' As long as OOo has no modules for that, disabled
	if gOOO = True then
		printlog "No spellchecking in OOo"
		goto endsub
	endif

    select case iSprache
        case 07 : Printlog "- No Thesaurus in Russian!"
                     goto endsub
        case 48 : Printlog "- No Thesaurus in Polish!"
                     goto endsub
        case 55 : Printlog "- No Thesaurus in Brazilian!"
                     goto endsub                     
        case 81 : Printlog "- No Thesaurus in Japanese!"
                     goto endsub
        case 82 : Printlog "- No Thesaurus in Korean!"
                     goto endsub
        case 86 : Printlog "- No Thesaurus in Chinese (simplified)!"
                     goto endsub
        case 88 : Printlog "- No Thesaurus in Chinese (traditional)!"
                     goto endsub
        case 30, 35, 36, 37, 42, 47, 48, 51, 90
                  Printlog "- No Thesaurus available !"
                  goto endsub                  
    end select

    Call hNewDocument
    '/// Open new document ///
    Call wDokSchreiben ("Dies ist ein Rechtschreibtexxt<Home>")
    '/// Insert a faulty text ///
    ToolsLanguageThesaurus
    Kontext "Active"
    if Active.Exists then
        Active.Ok
        Warnlog "Dialog 'Thesaurus' not up!"
        Call hCloseDocument
        goto endsub
    endif

    Kontext "Thesaurus"
    DialogTest ( Thesaurus )
    '/// In 'Thesaurus' dialog click 'Language' ///
    Sprache.Click
    Kontext "SpracheAuswaehlen"
    DialogTest ( SpracheAuswaehlen )
    '/// Close 'Language' dialog ///
    SpracheAuswaehlen.Cancel
    Kontext "Thesaurus"
    Thesaurus.Cancel
    '/// Close 'Thesaurus' dialog ///
    Call hCloseDocument
    '/// Close active document ///

endcase

' -------------------------------------------

testcase tToolsHyphenation
    Dim DieDatei as string,LingFile as string
    PrintLog "- Tools / Hyphenation"
	' As long as OOo has no modules for that, disabled
	if gOOO = True then
		printlog "No hyphenation in OOo"
		goto endsub
	endif

    select case iSprache
        case 1,01 : LingFile = "01-44-hyph.dat"
                     DieDatei = ConvertPath( gTesttoolpath + "writer\input\linguistik\001.odt" )
        case 81 : Printlog "- No Hyphenation in Japanese!"
                     goto endsub
        case 82 : Printlog "- No Hyphenation in Korean!"
                     goto endsub
        case 86 : Printlog "- No Hyphenation in Chinese (simplified)!"
                     goto endsub
        case 88 : Printlog "- No Hyphenation in Chinese (traditional)!"
                     goto endsub
        case else : DieDatei = ConvertPath( gTesttoolpath + "writer\input\linguistik\0" + trim$(str$(iSprache)) + ".odt" )
                        LingFile = str$(iSprache) + "-hyph.dat"
    end select

    if hFileExists(DieDatei) = False then
        Warnlog "No defined Errortext for language: " + isprache + "! Exit!"
        goto endsub
    endif

    Select Case gApplication
        Case "WRITER"
            Call hDateiOeffnen ( DieDatei )

        Case "MASTERDOC"
            if wInsertDocumentinMasterDoc(DieDatei) = False then
                Warnlog "Loading document did not work!"
                goto endsub
            else
                Call hNewDocument
                '/// Open new document ///
                EditPaste
            endif

        Case "HTMLDOKUMENT"
            printlog "- No Hyphenation in WriterWeb!"
            goto endsub
    end select

    '/// "Insert file 'writer\input\linguistik\0" + [OfficeLanguage] + ".sxw" ///
    Sleep 5
    Call wDokSchreiben ("<Mod1 Home>")

    ToolsLanguageHyphenate
    '/// Tools / Hyphenate ///
    Kontext "Active"
    try
        Active.Yes
    catch
    endcatch
    if Active.Exists then
        if Active.GetRT = 304 then
            Active.Ok
            ' Force pagesize change to bringup Hyphenation-dialog
            FormatPageWriter
            Kontext
            active.SetPage TabSeite
            Kontext "TabSeite"
            Breite.Settext "15"
            TabSeite.Ok
            Sleep 1
            ToolsLanguageHyphenate
        endif
    endif

    Kontext "Silbentrennung"
    '/// Close upcoming 'Hyphenation' dialog ///
    if Silbentrennung.Exists then
        Call DialogTest ( Silbentrennung )
        Silbentrennung.Cancel
    else
        Warnlog "Dialog 'Hyphenation' not up!"
        Kontext "Active"
        if Active.Exists then
            try
                Active.Ok
            catch
            endcatch
        endif
    endif

    Call hCloseDocument
    '/// Close active document ///
    if gApplication = "MASTERDOC" then Call hCloseDocument
endcase

' -------------------------------------------

testcase tToolsWordCount
	Printlog "- Tools / Word Count"
	'/// New Text document
	Call hNewDocument
	'///  Tools / Word Count
	ToolsWordCount
	'/// If if dialog has been opened
	Kontext "WordCount"
	if WordCount.Exists then
		Call DialogTest ( WordCount )
		'/// Close dialog 'WordCount' 	
		WordCount.Close
	else
		Warnlog "Dialog 'WordCount' has not been opened!"
	endif
	'/// Close Text document
	Call hCloseDocument
endcase

' -------------------------------------------

testcase tToolsAutocorrectAutoformat
    PrintLog "- Tools / Autocorrect / Autoformat"
    Dim i as integer
   
    Call hNewDocument
    '/// Open new document ///
    ToolsAutoCorrect
    '/// Tools / Autocorrect/Autoformat ///

    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.Gettext
            Active.Ok
        endif
    endif

    '/// Step through all tabpages ///
    Kontext
    active.SetPage TabErsetzung
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.Gettext
            Active.Ok
        endif
    endif
    Kontext "TabErsetzung"
    Call DialogTest ( TabErsetzung )

    Kontext
    active.SetPage TabAusnahmen
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.Gettext
            Active.Ok
        endif
    endif
    Kontext "TabAusnahmen"
    Call DialogTest ( TabAusnahmen )

    Kontext
    active.SetPage TabOptionenAutokorrektur
    Kontext "TabOptionenAutokorrektur"
    Call DialogTest ( TabOptionenAutokorrektur )
    '/// Step through all options in list ///
    '/// Tabpage Options: With entry 11 button 'Edit' should be enabled ///
    Einstellungen.TypeKeys "<Down>",11
    Wait 500
    if Bearbeiten.IsEnabled then
        Bearbeiten.Click
        Kontext "Sonderzeichen"
        DialogTest (Sonderzeichen)
        Sonderzeichen.Cancel
    else
        Warnlog "- Button 'Edit' on Entry 11 disabled!"
    endif

    Kontext "TabOptionenAutokorrektur"
    '/// Tabpage Options: With entry 17 button 'Edit' should be enabled ///
    Einstellungen.TypeKeys "<Down>",6
    Wait 500
    if Bearbeiten.IsEnabled then
        Bearbeiten.Click
        Kontext "Sonderzeichen"
        DialogTest (Sonderzeichen)
        Sonderzeichen.Cancel
    else
        Warnlog "- Button 'Edit' on Entry 16 disabled!"
    endif

    Kontext "TabOptionenAutokorrektur"
    '/// Tabpage Options: With entry 19 button 'Edit' should be enabled ///
    Einstellungen.TypeKeys "<Down>",2
    Wait 500
    if Bearbeiten.IsEnabled then
        Bearbeiten.Click
        Kontext "Zusammenfassen"
        DialogTest (Zusammenfassen)
        Zusammenfassen.Cancel
        Kontext "TabOptionenAutokorrektur"
    else
        Warnlog "- Button 'Edit' on Entry 18 disabled!"
    endif

    Kontext
    active.SetPage TabTypografisch
    Kontext "TabTypografisch"
    EinfachWortAnfang.Click
    Kontext "Sonderzeichen"
    Call Dialogtest2 ( Sonderzeichen, 1 )
    Sonderzeichen.Cancel

    Kontext "TabTypografisch"
    EinfachWortEnde.Click
    Kontext "Sonderzeichen"
    Call Dialogtest2 ( Sonderzeichen, 2 )
    Sonderzeichen.Cancel

    Kontext "TabTypografisch"
    EinfachStandard.Click

    Kontext "TabTypografisch"
    DoppeltWortAnfang.Click
    Kontext "Sonderzeichen"
    Call Dialogtest2 ( Sonderzeichen, 3 )
    Sonderzeichen.Cancel

    Kontext "TabTypografisch"
    DoppeltWortEnde.Click
    Kontext "Sonderzeichen"
    Call Dialogtest2 ( Sonderzeichen, 4 )
    Sonderzeichen.Cancel

    Kontext "TabTypografisch"
    DoppeltStandard.Click

    Kontext
    Active.Setpage TabWortergaenzung
    Kontext "TabWortergaenzung"
    Call DialogTest ( TabWortergaenzung )
    '/// Close Autocorrect dialg ///

    TabWortergaenzung.Cancel

    Call hCloseDocument
    '/// Close active document ///
endcase

' -------------------------------------------

testcase tToolsOutlineNumbering
    PrintLog "- Tools / Outline Numbering"

    Call hNewDocument
    '/// Open new document ///
    ToolsOutlineNumbering
    '/// Tools / Outline Numbering ///
    Kontext
    Active.SetPage TabKapitelnumerierung
    Kontext "TabKapitelnumerierung"
    Call DialogTest ( TabKapitelnumerierung )

    Kontext
    Active.SetPage TabPositionKapitelnumerierung
    Call DialogTest ( TabPositionKapitelnumerierung )
    '/// Step through tabpages and close dialog ///

    TabPositionKapitelnumerierung.Cancel
    Call hCloseDocument
    '/// Close active document ///

endcase

' -------------------------------------------

testcase tToolsLineNumbering
    PrintLog "- Tools / Line Numbering"

    Call hNewDocument
    '/// Open new document ///
    ToolsLineNumbering
    '/// Tools / Line Numbering ///
    Kontext "TabZeilennumerierung"
    '/// Check checkbox 'Show numbering' ///
    Einschalten.Check
    Call DialogTest ( TabZeilennumerierung )
    '/// Close dialog ///
    TabZeilennumerierung.Cancel
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase tToolsFootnotes
    PrintLog "- Tools / Footnotes"

    Call hNewDocument
    '/// Open new document ///
    ToolsFootnote
    '/// Tools / Footnotes ///
    Kontext
    Active.Setpage TabFussnoten
    Kontext "TabFussnoten"
    DialogTest ( TabFussnoten )
    '/// Step through all tabpages ///

    Kontext
    Active.SetPage TabEndnoten
    Kontext "TabEndnoten"
    DialogTest ( TabEndnoten )
    '/// Close dialog ///
    TabEndnoten.Cancel
    Call hCloseDocument
    '/// Close active document ///
endcase

' -------------------------------------------

testcase tToolsGallery
    Dim i as integer
    printlog "- Tools / Gallery"
    Call hNewDocument
    '/// Open new document ///    
	Kontext "Gallery"
	if Not Gallery.Exists then ToolsGallery
    '/// Tools / Gallery ///
    Sleep 3
    Kontext "Gallery"
    '/// Gallery has to be opened ///
    if Not Gallery.Exists then
        Warnlog "Gallery has not been opened! No test"
        goto endsub
    else
        '/// Step through all themes ///
        printlog "- Step through all Themes"
        For i = 1 to Gallerys.GetItemCount
            Gallerys.Select i
            Wait 500
        next i
        printlog "- New theme"
    endif

    Kontext
    ToolsGallery
    '/// Close gallery with Tools / Gallery ///
    Kontext "Gallery"
    if Gallery.Exists then Warnlog "Gallery has not been closed!"

    Call hCloseDocument
    '/// Close active document ///

endcase

' -------------------------------------------

testcase tToolsBibliographyDatabase
    Dim DlgTestDone as boolean
	printlog "- Tools / Bibliography Database "
    '/// Tools / Bibliography Database ///
    ToolsBibliographyDatabase
    Sleep 2
    Kontext "DatenquelleLiteraturdatenbank"
	if DatenquelleLiteraturdatenbank.Exists then
		Call DialogTest ( DatenquelleLiteraturdatenbank )
		DatenquelleLiteraturdatenbank.Close
		DlgTestDone = True
	endif
	wait 500
	Kontext "TB_Bibliography"
    try
        '/// Click 'Column Arrangement' ///
        ColumnArrangement.Click
        Sleep 1
    catch
        Warnlog "Unable to click 'Column Arangement'!"
    endcatch
    Kontext "Spaltenzuordnung"
    if Spaltenzuordnung.Exists then
        Call DialogTest ( Spaltenzuordnung )
        Spaltenzuordnung.Cancel
    else
        Warnlog "Dialog 'Column Layout' has not been opened!"
    endif
   
    Kontext "TB_Bibliography"
    try
        DataSource.Click
        '/// Click 'Data Source' ///
        Sleep 1
    catch
        Warnlog "Unable to click 'Data Source'!"
    endcatch
    Kontext "DatenquelleLiteraturdatenbank"
    if DatenquelleLiteraturdatenbank.Exists then
        if DlgTestDone = False then Call DialogTest ( DatenquelleLiteraturdatenbank )							
        DatenquelleLiteraturdatenbank.Cancel
    else
        Warnlog "Dialog 'Data Source' has not been opened!"
    endif
    
    Kontext "Bibliography"
    try
        '/// Close 'Bibliography Database' ///
        DatabaseClose
    catch
        Warnlog "Unable to close Bibliography dialog!"
    endcatch
endcase

' -------------------------------------------

testcase tToolsMailMergeWizard
    Dim i as integer

    PrintLog "- Tools / Mail Merge"
    if gApplication = "HTMLDOKUMENT" then goto endsub

    Call hNewDocument
    '/// Open new document ///
    ToolsMailMergeWizard
    Sleep 5
    '/// Tools / Mail Merge Wizard ///
    Kontext "MailMergeWizard"
    if Not MailMergeWizard.Exists then
        Warnlog "MailMerge Wizard is not up! Test ends here!"
        Call hCloseDocument
        goto endsub
    endif
    
    Call DialogTest ( MailMergeWizard )
    Kontext "TabMailMergeSourceDocument"
    Call DialogTest ( TabMailMergeSourceDocument )
    Wait 500
    '/// Click document 'Browse' button
    BrowseDocument.Click
    wait 500
    Kontext "OeffnenDlg"
    if Not OeffnenDlg.Exists then
        Warnlog "Filedialog not up on document 'Browse' button"
    else
        OeffnenDlg.Cancel
    endif
    
    Kontext "TabMailMergeSourceDocument"
    '/// Click template 'Browse' button
    BrowseTemplate.Click
    wait 500
    Kontext "Neu"
    Call DialogTest ( Neu )
    Neu.Cancel
    
    Kontext "TabMailMergeSourceDocument"
    '/// Check 'Use the current document' radio button
    UseTheCurrentDocument.Check
    
    '/// Click 'Next' button
    Kontext "MailMergeWizard"
    NextButton.Click
    Sleep 1    
    Kontext "TabMailMergeDocumentType"
    Call DialogTest ( TabMailMergeDocumentType )
    wait 500
    '/// Click 'Next' button
    Kontext "MailMergeWizard"
    NextButton.Click
    Sleep 1    
    Kontext "TabMailMergeAddressBlock"
    Call DialogTest ( TabMailMergeAddressBlock )
    wait 500
    '/// Click 'Select Address List'
    SelectAddressListButton.Click
    Wait 500
    Kontext "Active"
    if Active.Exists then
        if Active.GetRT = 304 then
            Warnlog Active.Gettext    
            Active.Ok
        endif
    endif
    Sleep 1
    Kontext "SelectAddressList"    
    Call DialogTest ( SelectAddressList ) 
    if Not SelectAddressList.Exists then
        Warnlog "Problems selecting addresses"
        Kontext "MailMergeWizard"
        MailMergeWizard.Cancel
        Call hCloseDocument
        goto endsub
    endif
    
    '/// In 'Select address list' dialog click 'Add'
    Add.Click
    wait 500
    Kontext "OeffnenDlg"
    if Not OeffnenDlg.Exists then
        Warnlog "Filedialog not up on template 'Browse' button"
    else
        OeffnenDlg.Cancel
    endif

    Kontext "SelectAddressList"
    '/// In 'Select address list' dialog click 'Create'
    Create.Click
    wait 500
    
    Kontext "NewAddressList"
    Call DialogTest ( NewAddressList )    
    '/// In 'New address' dialog click 'Find' button
    Find.Click
    wait 500
    
    Kontext "FindEntry"
    if FindEntry.Exists then
        Call DialogTest ( FindEntry )
        FindEntry.Cancel
    else
        Warnlog "Dialog 'Find entry' not up"
    endif
        
    '/// In 'New address' dialog click 'Customize' button
    Kontext "NewAddressList"
    Customize.Click
    wait 500
    
    Kontext "CustomizeAddressList"
    if CustomizeAddressList.Exists then
        Call DialogTest ( CustomizeAddressList )
        '/// In 'Customize Addresss List' dialog select first entry in list
        AddressListElements.Select 1
        '/// Click 'add' button
        Add.Click
        Kontext "RenameElement"
        Call DialogTest ( RenameElement )
        '/// Close 'Add Element' dialog
        RenameElement.Cancel        
        Kontext "CustomizeAddressList"
        '/// Click 'Rename' button
        Rename.Click
        Kontext "RenameElement"
        Call DialogTest ( RenameElement )
        RenameElement.Cancel
        wait 500
        Kontext "CustomizeAddressList"
        CustomizeAddressList.Cancel         
    else
        Warnlog "Dialog 'Customize Address List' is not up"
    endif
    '/// Close all open dialogs
    wait 500
    Kontext "NewAddressList"   
    NewAddressList.Cancel
    wait 500
    Kontext "SelectAddressList"
    SelectAddressList.Cancel
    
    Kontext "MailMergeWizard"
    MailMergeWizard.Cancel
        
    
    '/// Close active document ///
    Call hCloseDocument

endcase

' -------------------------------------------

testcase tToolsTextInTables
    PrintLog "- Tools / Text <-> Tables"

    Call hNewDocument
    '/// Open new document ///
    Call wDokSchreiben ("Hallo dieser Text soll in eine Tabelle")
    '/// Insert some text and select it ///
    Call wDokSchreiben ("<Shift Home>")
    ToolsTextInTable
    '/// Tools / Text<->Table ///
    Kontext "TextInTabelleUmwandeln"
    DialogTest ( TextInTabelleUmwandeln )
    TextInTabelleUmwandeln.Cancel
    '/// Close upcoming dialog ///
    Call hCloseDocument
    '/// Close active document ///

endcase

' -------------------------------------------

testcase tToolsSort
    Dim i as integer
    PrintLog "- Tools / Sort"

    Call hNewDocument
    '/// Open new document ///
    For i = 1 to 5
        Call wDokSchreiben (i)
        Call wDokSchreiben ("<Return>")
    next i
    Call wDokSchreiben ("<Mod1 A>")
    ToolsSort
    Kontext "Sortieren"
    Call DialogTest ( Sortieren )
    Sortieren.Cancel
    Call hCloseDocument
    '/// Close active document ///

endcase

' -------------------------------------------

testcase tToolsCalculate
    PrintLog "- Tools / Calculate"

    Call hNewDocument
    '/// Open new document ///
    Call wDokSchreiben( "2+4" )
    '/// Insert text: 2+4 ///
    EditSelectAll
    '/// Edit / Select All ///
    ToolsCalculate
    '/// Tools / Calculate ///
    Call wDokSchreiben ("<End>  Das Ergebnis ist = ")
    '/// Paste result of calculation with Edit / Paste ///
    EditPaste
    Call hCloseDocument
    '/// Close active document ///

endcase

' -------------------------------------------

testcase tToolsUpdate
    PrintLog "- Tools / Update"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb !"
        goto endsub
    endif
    Call hNewDocument
    '/// Open new document ///

    printlog "  - Update Indexes ( all, current )"
    '/// Add a text to document ///
    Call wDokSchreiben ("Dieser Text ist zur Aktualisierung")
    InsertIndexes
    '/// Insert / Indexes ///
    Sleep 2
    Kontext "Active"
    if Active.Exists then
        if active.GetRT = 304 then
            Warnlog Active.Gettext
            Active.Ok
        endif
    endif
    Sleep 2
    Kontext
    Active.Setpage TabVerzeichnisseVerzeichnis
    Kontext "TabVerzeichnisseVerzeichnis"
    TabVerzeichnisseVerzeichnis.OK
    '/// Close upcoming Index dialog ///
    Sleep 1
    '/// Tools / Update / All Indexes ///
    ToolsUpdateAllIndexes
    Sleep 1
    '/// Tools / Update / Current Index ///
    ToolsUpdateCurrentIndex

    printlog "  - Update Fields"
    Call wDokSchreiben ("<Up><Home><Tab>")
    '/// Insert / Fields / Author ///

    InsertFieldsAuthor
    '/// Insert / Fields / Time ///
    InsertFieldsTime
    Sleep 1
    ToolsUpdateFields
    '/// Tools / Update / Fields ///

    printlog "  - Update links"
    '/// Insert a graphic from file ///
    Call hGrafikVerknuepftEinfuegen ( gTesttoolPath + "writer\input\grafik\jolink.jpg" )
    try
        '/// Tools / Update / Links ///
        ToolsUpdateLinks
    catch
        Warnlog "Links can't be updated!"
    endcatch

    printlog "  - Update / Reformat Pages"
    '/// Tools / Page formatting ///
    ToolsPageFormatting

    printlog "  - update all"
    '/// Tools / Update / Update All ///
    ToolsUpdateUpdateAll

    Call hCloseDocument
    '/// Close active document ///
endcase

' -------------------------------------------

testcase tToolsMacro
    PrintLog "- Tools / Macro"
    Dim j as integer
    
    Call hNewDocument
    '/// Open new document ///
    ToolsMacro
    '/// Tools / Macro ///
    ' if no JRE is installed a messagebox appears
    Do
        j = j + 1
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                if j = 1 then Warnlog Active.Gettext    
                Active.Ok
            else
                exit do
            endif                    
        else
            exit do
        endif
    Loop                              
    Kontext "Makro"
    '/// On upcoming dialog step through all tabpages ///
    Call DialogTest ( Makro )
    Verwalten.Click

    Kontext
    active.SetPage TabModule
    Kontext "TabModule"
    Call DialogTest ( TabModule )

    Kontext
    active.SetPage TabBibliotheken
    Kontext "TabBibliotheken"
    Call DialogTest ( TabBibliotheken )
    if gUseSysDlg = False then
        Hinzufuegen.Click

        Kontext "Active"
        if Active.Exists then
            Warnlog Active.Gettext
            Active.Ok
        endif

        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
    endif

    Kontext "TabBibliotheken"
    TabBibliotheken.Close
    '/// Close 'Macro' dialog ///

    Kontext "Makro"
    Makro.Cancel
    Call hCloseDocument
    '/// Close active document ///

endcase

' -------------------------------------------

testcase tToolsHangulHanjaConversion

    Dim bAsianLanguage   as Boolean
    Dim sTestFile        as String

    
    if gApplication = "HTMLDOKUMENT" then
        sTestFile = Convertpath (gTesttoolpath + "writer\input\hangul.html")
    else 
        if Ucase(gApplication) = "MASTERDOC" then
            goto endsub
        else
            sTestFile = Convertpath (gTesttoolpath + "writer\input\hangul.sxw")
        endif
    end if    

    PrintLog "- Tools / HangulHanjaConversion"

    '/// Enable 'Asian Language support' ON
    bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)

    '/// Open the test file
    Call hDateiOeffnen(sTestFile)
    Call wDokSchreiben("<MOD1 Home>")

    '/// Tools / HangulHanjaConversion
    try
        ToolsLanguageHangulHanjaConversion
    catch
        Warnlog "- Format / HangulHanjaConversion is disabled or hidden!"
        bAsianLanguage = ActiveDeactivateAsianSupport(False)
        Call hCloseDocument
        goto endsub
    endcatch
    
    Kontext "HangulHanjaConversion"
    if HangulHanjaConversion.Exists then
        Call DialogTest ( HangulHanjaConversion )
    else
        Warnlog "- Format / HangulHanjaConversion doesn't work. Dialog is not up"
        bAsianLanguage = ActiveDeactivateAsianSupport(False)
        Call hCloseDocument
        goto endsub
    endif

    '/// Click button 'Options'
    try
        Options.Click
        Kontext "HangulHanjaOptions"
        Call DialogTest ( HangulHanjaOptions )
    catch
        Warnlog "- Something is wrong in the button 'Options' !"
        Call hCloseDocument
        goto endsub        
    endcatch
    
    NewDictionary.Click
    Kontext "HangulHanjaNewDictionary"
    Call DialogTest ( HangulHanjaNewDictionary )
    HangulHanjaNewDictionary.Close

    Kontext "HangulHanjaOptions"
    HangulHanjaOptions.Cancel
    
    Kontext "HangulHanjaConversion"
    '/// Close HangulHanja dialog
    HangulHanjaConversion.Close

    '/// Set the 'Asian Language support' to default
    if bAsianLanguage = FALSE then
       Call ActiveDeactivateAsianSupport(FALSE)
    end if

    '/// Close active document
    Call hCloseDocument

endcase

' -------------------------------------------

testcase tToolsChineseTranslation

    Dim bAsianLanguage   as Boolean

    PrintLog "- Tools / Language / Chinese Translation"

    '/// Open a new document
    Call hNewDocument

    '/// Enable 'Asian Language support' ON
    bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)

    '/// Tools / Language / Chinese Translation
    try
        ToolsLanguageChineseTranslation
    catch
        Warnlog "- Tools/language / Chinese Translation is disabled or hidden!"
        Call hCloseDocument
        goto endsub
    endcatch

    Kontext "ChineseTranslation"
    if ChineseTranslation.Exists then    
        Call DialogTest ( ChineseTranslation )
    else
        Warnlog "#i41364#Tools-> Language -> Chinese Translation does not work!"
        Call hCloseDocument
        goto endsub        
    endif  

    '/// Press 'Edit Terms' button , a new dialog should appear
    try
        EditTerms.Click
    catch
        Warnlog "- Something is wrong in the button 'Edit Terms' !"
        Kontext "ChineseTranslation"
        ChineseTranslation.Cancel
        Call hCloseDocument
        goto endsub
    endcatch

    Kontext "ChineseDictionary"
    if ChineseDictionary.Exists then    
        Call DialogTest ( ChineseDictionary )
    else
        Warnlog "Button 'Edit Terms' does not bring up the dialog!"
        Kontext "ChineseTranslation"
        ChineseTranslation.Cancel
        Call hCloseDocument
        goto endsub
    endif 
    ChineseDictionary.Cancel

   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

   '/// Set the 'Asian Language support' to default
   if bAsianLanguage = FALSE then
       Call ActiveDeactivateAsianSupport(FALSE)
   end if

   '/// Close active document
   Call hCloseDocument

endcase
