/* imageLoader.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * Creates a separate, image loading thread.
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/
import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.net.*;

import Scroller;

public class imageLoader extends Thread
{

    static final String BAD_URL       =  "\r\nError: Malformed Image URL.";
    static final String IMAGE_ERROR   =  "\r\nError: Image(s) not loaded.";   
    static final String IMAGE_LOADED  =  "Done.";
    static final String IMAGE_LOADING =  "\r\nLoading images...";
    
	Image image[];
	String szImage[];
	int nImages;
	boolean loaded;
	Applet app;
	Scroller s;
	
	imageLoader(Applet a, String szName[],int numImages, Scroller scroller)
	{
		image=new Image[numImages];
		szImage=new String[numImages];
		
		for(int i=0;i<numImages;i++){
			szImage[i]=szName[i];
			image[i]=null;
		}
		nImages=numImages;
		app=a;
		s=scroller;
	}

	public void run()
	{
		URL imageURL;
		
		
		if(null != s)s.appendText(IMAGE_LOADING);
		loaded=false;
	    MediaTracker  tracker = new MediaTracker(app);
	    for(int i=0; i<nImages; i++){
			if(null != szImage[i]){
		        try{
			         imageURL=new URL(app.getCodeBase(),szImage[i]);
    	    	} catch (MalformedURLException e)
	    	       {
    	    	   		imageURL=null;
    	    	   		s.appendText(BAD_URL);
    	    	   		continue;
		           }
			}
			else imageURL=null;
	    	    	
			if(null != imageURL){
       			image[i]=app.getImage(imageURL);
	           	if(null != image[i])
 		           tracker.addImage(image[i],i);
	    	}
	    	else image[i]=null;

			if(null != image[i])
				try{
					tracker.waitForID(i);
	        	   }catch (InterruptedException e)
	        	   	{
	        	   		image[i]=null;
	        	   		s.appendText(IMAGE_ERROR);
	        	   		return;
	        	   	}	   			
			
		}
		loaded=true;
		if(null != s)s.appendText(IMAGE_LOADED);
	}

	Image[] retrieveImages()
	{
		if(loaded)
			return image;
		else
			return null;
	}
}

