'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_101_.inc,v $
'*
'*  $Revision: 1.20 $
'*
'*  last change: $Author: jsi $ $Date: 2007/11/06 18:26:28 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description  :  Checks the File-menu more detailed
'*
'************************************************************************
'*
' #1 C_101_ ' Initial routine
' #1 tFileTextImport
' #1 tFileVersions
' #1 tFileProperties
' #1 tExportAsPDF
' #1 tFileSaveAs
'*
'\***********************************************************************

sub C_101_

Printlog "--------- C_101_ ---------"

   Call tFileTextImport
   call tFileVersions
   Call tFileProperties
   Call tExportAsPDF
   Call tFileSaveAs

End sub
'
'-------------------------------------------------------------------------
'
testcase tFileTextImport
'/// This testcase imports a file with the method TEXTIMPORT, changes the column spread and format ///
'/// of number and checks if these properties will be taken over.///

    dim filename$, filename_new$
    dim form as String
    dim column_current As Single
    dim column_spread As Single
    dim i as integer, k as integer
    dim lng as String
        lng = iSprache
    dim lang as integer
    
    if iSystemsprache <> 01 then
       QAErrorLog "Sorry, this Testcase only runs on locale en_US"
       goto endsub
    end if

    printlog "iSprache: " & lng

'/// Open the file "calc\level1\input\c_101\filetextimport_<languageID>.tst" with filetype CSV
   filename$ = convertpath(gTesttoolPath & "calc\level1\input\c_101\filetextimport_" & lng & ".tst")
   filename_new$ = convertpath(gOfficePath & "user/work/filetextimport_" & lng & ".tst")

    FileOpen
    Kontext "OeffnenDlg"
    UebergeordneterOrdner.Click
    Standard.Click
    sleep 3
      k = 1
      Dateityp.select k
       while instr ( Dateityp.getSelText , "CSV" ) = 0
         k = k + 1
         Dateityp.select k
       wend
    Dateiname.settext filename$
    Sleep 2
    Oeffnen.Click
    sleep 2
'/// Now the dialog "TextImport" should be appear
    Kontext "TextImport"
    if TextImport.exists then
      dim cnt as integer
      cnt = Zeichensatz.getItemCount
      Zeichensatz.select cnt
'/// Select the suggested characterset and check semicolon
      Kontext "TextImport"
      Sleep 3
      Semikolon.check
      call Dialogtest (TextImport)
      TextImport.Ok
    else
      warnlog "Text Import Dialog doesn't exists -> BUG!"
      goto Ende
    end if
'/// Select the cellrange 'C2:C5' and set as FormatCode "DD.MM.YYYY"(english OS)
'/// or "TT.MM.JJJJ"(german OS) and confirm the dialog
    try
        Kontext
        call cBereichmarkieren("C2:C5")
        FormatCells
        Kontext
        active.setpage TabZahlen
        Kontext "TabZahlen"
        if iSystemsprache = 01 then
         FormatCode.settext "DD.MM.YYYY"
       else
            FormatCode.settext "TT.MM.JJJJ"
       end if
        form = FormatCode.GetText
        TabZahlen.Ok
'/// Call the menuitem 'FormatColumnOptimalWidthCalc' and confirm it.
        FormatColumnOptimalWidthCalc
        Kontext "SpalteOptimaleBreite"
        SpalteOptimaleBreite.OK
        FormatColumnWidthCalc
           Kontext "SpaltenbreiteCalc"
        column_current = val(Breite.gettext)
        printlog "column_current = " & column_current
        SpaltenbreiteCalc.OK
        Sleep 1
        Kontext
'/// Check, if the Cellcontent of 'C2' is "13.04.1999"
        if cZellwert("C2") = "13.04.1999" then
        Printlog "  Import Ok"
        else
        Warnlog "Imported value isn't '13.04.1999' in cell C2 " & cZellwert("C2")
        end if
    catch
      Warnlog "Textimport doesn't work"
    endcatch
'/// Save the file in any local directory
   call hSpeichernUnterMitFilterKill filename_new$, gCalcFilter
   printlog "save file"
   FileClose
   printlog "close file"
   Kontext
   if Active.Exists then
      Active.yes
   end if
   printlog "open file"
'/// Open the file and check all made settings
   hDateiOeffnen filename_new$
   printlog "*** check, if the made adjustments exists after close and open the file! ***"
    if cgotocell("C1") <> 0 then
        warnlog "Traveling to C1 failed! Exiting test!"
        goto endsub
    end if

   FormatColumnWidthCalc
   Kontext "SpaltenbreiteCalc"
    column_spread = val(Breite.gettext)
    printlog "column_spread = " & column_spread
    SpaltenbreiteCalc.OK
   if column_spread = column_current then
      printlog "OK! The column spread was taken over!"
   else
      warnlog "Failure! The column spread wasn't taken over!"
   end if
   For i = 1 to 4
      Kontext "DocumentCalc"
      DocumentCalc.typekeys "<down>"
      FormatCells
       Kontext
       active.setpage TabZahlen
       Kontext "TabZahlen"
       if FormatCode.GetText = form then
         printlog "OK! Format of numbers is correct after closing and calling the file in cell 'C" & i &"'"
       else
         warnlog "Failure! Format of numbers wasn't taken over in Cell 'C" & i & "'"
       end if
       TabZahlen.OK
       sleep 10
    next i
      Kontext "DocumentCalc"
Ende:
      call hCloseDocument

      Sleep 5

endcase
'
'-----------------------------------------------------------
'
testcase tFileVersions
    Dim SFile as String
    SFile = convertpath (gOfficePath & "user/work/version1.ods")
    call hNewDocument
    '/// Create new spreadsheet document    
    if cgotocell("B1") <> 0 then
        warnlog "Traveling to B1 failed! Exiting test!"
        goto endsub
    end if
    '/// Go to cell B1
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "1111<RETURN>2222<RETURN>3333<RETURN>4444<RETURN>"
    '/// Type 1111 and then ENTER
    '/// Type 2222 and then ENTER
    '/// Type 3333 and then ENTER
    '/// Type 4444 and then ENTER
    if cgotocell("D1") <> 0 then
        warnlog "Traveling to D1 failed! Exiting test!"
        goto endsub
    end if
    '/// Go to cell D1
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "before<RETURN>"
    '/// type before and ENTER
    Printlog "Before save in ..."
    '/// Save the document as <i>officepath</i>/user/work/version1.ods
    Call hSpeichernUnterKill(SFile)
    Printlog "After saving ..."
    '/// File>Versions
    FileVersions
    Kontext "Versionen"
    if Versionen.Exists(1) then
    '/// In the dialog 'versions' click 'Save'
        Speichern.Click
        Kontext "Versionskommentareingeben"
        if Versionskommentareingeben.Exists(1) then
            '/// Enter the comment 'First version' 
            Kommentar.SetText "First version"
            printlog "Entering 'First version' as version comment."
            '/// Leave dialog with OK
            Versionskommentareingeben.OK
        else
            warnlog "Was not possible to enter comment to version!"
        end if
        Kontext "Versionen"
        '/// Close the 'version'dialog with the closer
        Versionen.Close        
        printlog "Modify the document"
        Kontext "DocumentCalc"        
        '/// Go to cell D1
        if cgotocell("D1") <> 0 then
            warnlog "Traveling to D1 failed! Exiting test!"
            goto endsub
        end if
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "AAAA<RETURN>BBBB<RETURN>CCCC<RETURN>DDDD<RETURN>"
        '/// Write AAAA and ENTER
        '/// Write BBBB and ENTER
        '/// Write CCCC and ENTER
        '/// Write DDDD and ENTER
        FileSave
        '/// File>Save
        sleep(2)
        '/// File>Versions
        FileVersions
        Kontext "Versionen"
        if Versionen.Exists(8) then
            '/// Click on Save-button
            Speichern.Click
            sleep(8)
            Kontext "Versionskommentareingeben"
            if Versionskommentareingeben.Exists(1) then
                '/// Add as comment 'second version'
                Kommentar.SetText "second version"
                printlog "Entering 'second version' as version comment."
                '/// Leave dialog with OK
                Versionskommentareingeben.OK
            else
                warnlog "Was not possible to enter comment to version!"
            end if            
            Kontext "Versionen"
            '/// Close the version-dialog wih closer
            Versionen.Close
        else
            warnlog "Version-dialog was not visible."
        end if
        '/// Close document
        call hCloseDocument
        '/// Load the saved document again         
        call hDateiOeffnen SFile
        '/// File>Versions
        FileVersions
        Kontext "Versionen"
        '/// Click on Open-button
        Oeffnen.Click
        sleep(5)
        '/// A new, write-protected spreadsheet-window with the first version should be opened.
        Kontext "DocumentCalc"
        '/// Check the value of cell D1 wich should be 'before'
        if cgotocell("D1") <> 0 then
            warnlog "Traveling to D1 failed! Exiting test!"
            goto endsub
        end if        
        Kontext "DocumentCalc"
        if cZellwert("D1") <> "before" then
            warnlog "FAILED. Cell D1 does not contain the string 'before'. It contains '" & cZellwert("D1")
        else
            printlog "OK. Cell D1 contains the string 'before'."
        end if
        '/// Close the document         
        call hCloseDocument      
    else
        warnlog "Version-dialog was not visible."
    end if
    '/// Close the opened, actual document 
    call hCloseDocument    
endcase

'
'-----------------------------------------------------------
'
testcase tFileProperties
'/// This testcase checks the file properties. 
    Dim SFile as String
    Dim bInternetUpdateChecked as boolean
    
    SFile = convertpath(gOfficePath & "user/work/tfileproperties.ods")
    bInternetUpdateChecked = FALSE

    '/// Create a new spreadsheet document
    Call hNewDocument    
        '/// File / Properties 
        FileProperties
        Kontext
        Active.SetPage TabBeschreibung
        Kontext "TabBeschreibung"
        Titel.settext "content1"
        sleep(2)
        Kontext
        Active.SetPage TabBenutzer
        Kontext "TabBenutzer"
        Info0.settext "info"
        Infofelder.Click
        Kontext "InfonamenBearbeiten"
        Namen1.settext "Kirk"
        InfonamenBearbeiten.Ok
        Kontext
        Active.SetPage TabInternet
        Kontext "TabInternet"
        if DoNotRefreshAutomatically.IsChecked then
            printlog "Internet tab page automatically refresh is off."
            '/// Enabling the 'Refresh this document' radio button.
            printlog "Enabling refreshing this document"
            RefreshThisDocument.check                  
        end if
        TabInternet.Ok
        call hSpeichernUnterMitFilterKill SFile, gCalcFilter
        call hCloseDocument
        sleep(1)
        call hDateioeffnen SFile
        FileProperties
        Kontext
        Active.SetPage TabBeschreibung
        Kontext "TabBeschreibung"
        if Titel.gettext = "content1" then
            printlog "PASSED. Ex-/Importing value of 'title' on tab page 'Description'."
        else
            warnlog "Value of title on tab page 'Description' not imported!"
        end if
        Kontext
        Active.SetPage TabBenutzer
        Kontext "TabBenutzer"
        if Info0.gettext = "info" then
            printlog "PASSED. Ex-/Importing value of Tab UserDefined field 'Info 1'."
        else
            warnlog "Value of 'Info 1' on tab page 'User Defined' not imported!"
        end if
        Infofelder.Click
        Kontext "InfonamenBearbeiten"
        if Namen1.gettext = "Kirk" then
            printlog "PASSED. Ex-/Importing value of first 'Names' field on 'Info Fileds'-dialog."
        else
            warnlog "Value of first 'Names'-field on 'Info Fileds'-dialog not imported!"
        end if
        InfonamenBearbeiten.Ok
        Kontext
        Active.SetPage TabInternet
        Kontext "TabInternet"        
        If RefreshThisDocument.IsChecked then
            printlog "PASSED. 'Refresh this document' setting on tab page 'Internet'."
            DoNotRefreshAutomatically.check
        else
            warnlog "'Refresh this document' setting on tab page 'Internet' not imported."
        end if
        TabInternet.ok
    call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAs

   dim i as integer, k as integer
   dim sFile as String
       sFile = convertpath(gOfficepath & "user/work/format")
   dim sCurrentFileType, sFileTypeSuffix as STRING
   dim bCommitAlienDialog, bCommitExportDialog , bCommitActiveSheet as BOOLEAN
   
   call hNewDocument
   sleep 2
   FileSaveAs
   sleep(1)
   Kontext "SpeichernDLG"
    if AutomatischeDateinamenserweiterung.Exists then        
        AutomatischeDateinamensErweiterung.check
    endif
   i =  Dateityp.getItemCount
   printlog "There are " & i & " filters in the listbox"
   SpeichernDLG.cancel
   for k = 1 to  i
      FileSaveAs
      sleep(2)
      Kontext "SpeichernDLG"
      Dateiname.setText sFile
      Dateityp.select k
      sCurrentFileType = Dateityp.getselText
      sFileTypeSuffix = right(sCurrentFileType, 6)
      printlog "Save empty document with filter: " & sCurrentFileType
      Speichern.click
      sleep(1)
      Kontext
      if Active.exists(2) then
          Active.YES
      endif
      sleep(1)
      '///<li>Check alien file format warning</li>///
      select case sFileTypeSuffix
             case "(.ods)" : bCommitAlienDialog = FALSE
             case "(.ots)" : bCommitAlienDialog = FALSE
             case else : bCommitAlienDialog = TRUE
      end select
      if bCommitAlienDialog = TRUE then
          '///<li>-> Commit if exists</li>///
          Kontext "AlienWarning"
          AlienWarning.OK
          printlog "+ OK, alien warning dialog was found"
      endif
      sleep(1)

      select case sFileTypeSuffix
             case "(.dif)" : bCommitExportDialog = TRUE : bCommitActiveSheet = TRUE
             case "(.dbf)" : bCommitExportDialog = TRUE : bCommitActiveSheet = FALSE
             case "(.csv)" : bCommitExportDialog = TRUE : bCommitActiveSheet = TRUE
             case else : bCommitExportDialog = FALSE
      end select
      if bCommitExportDialog = TRUE then
          Kontext "ExportCalc"
          ExportCalc.OK
          printlog "+ OK, export dialog was found"
          Kontext "Active"
          if bCommitActiveSheet = TRUE then
              Active.OK
          end if
      endif
      sleep(5)
      Kontext
      if Active.exists(2) then      	
          Active.OK
          qaErrorLog Active.GetText & " - Unexpected MsgBox."
      endif
   next k
   
   call hCloseDocument

endcase

testcase tExportAsPDF
    dim sPath as string
    dim bTemp as boolean
    dim sTemp as string
    dim sApp as string
    dim sFilter as string
    dim sExtension as string
    dim sTextFiltername as string

    sPath = ConvertPath ( gOfficePath + "user/work/calc_pdf.pdf"   
    '/// open application    
    Call hNewDocument
    hTypeKeys ("a<return>")
    '/// File->Export as PDF document
    hFileExport (sPath, "PDF")
    '/// close application
    Call hCloseDocument
    if (dir(sPath) <> "") then
        sleep(5)
        '/// the first line has to be '%PDF'
         sTemp = fGetFileText(sPath, 8)
         if (InStr(sTemp, "%PDF") <> 1) then
            warnlog "File doesn't start with '%PDF' it is: '" + sTemp + "'"
         end if
     else
        warnlog "file was not exported to PDF :-( '" + sPAth + "'"
    end if
endcase

