'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: addin.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: jsi $ $Date: 2008/01/23 13:23:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Detailed test part for new AddInn functions
'*
'************************************************************************
'*
' #0 checkvalues    ' routine to check correct cell content
' #1 tAddin_new     ' check correct results in AddInn functions
' #1 tConvert       ' check results that the convert_add function delivers
'*
'\***********************************************************************

testcase tAddin_new
'/// This testcase load a document with all new calc addins and check if the results of the functions
'/// are correct. First the document is loaded, than a hard recalc is executed. Then the document is
'/// saved as excel '97/2000 document and reloaded. Then the result are checked again.

    dim sAddin_New as String
    dim sAddin_Excel as String
    dim sAddin_ODS as String

    sAddin_New = convertpath(gTesttoolpath & "calc\special\input\addin_new.sxc")
    sAddin_ODS =  convertpath(gOfficePath & "user\work\addin_sxc.ods")
    sAddin_Excel =  convertpath(gOfficePath & "user\work\addin_excel.xls")
    
    Call hDateioeffnen(sAddin_New)
    call checkvalues("E3", 1, 3, 92)
    printlog "Save Document as excel file, close it, reload it and check results again"
    call hSpeichernUnterMitFilterKill (sAddin_Excel, "Microsoft Excel 97/2000/XP (.xls)")
    call hCloseDocument
    
    call hDateioeffnen(sAddin_Excel)
    call checkvalues("E3", 1, 3, 92)
    printlog "Save Document again as sxc file, close it, reload it and check results again"
    if NOT hSpeichernUnterMitFilterKill(sAddin_ODS , gCalcFilter) then
        warnlog "Saving test document localy failed -> Aborting"
        call hCloseDocument
        exit sub
   endif
   call hCloseDocument    
   call hDateioeffnen(sAddin_ODS)
   call checkvalues("E3", 1, 3, 92)
   call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tConvert
'/// This test load the a document with all of the measurementunits which could be converted
'/// into other units of the same category. The convertation is circular executed which means
'/// that at least the last convert unit convert it's value to the first unit which with the
'/// value line is started. Therefore this value must be the same as the first value.

     dim sConvertfile as String

     sConvertfile = convertpath(gTesttoolPath & "calc\special\input\convert.sxc")

     Call hDateiOeffnen(sConvertfile)
        call checkvalues("Y2", 2, 2, 24)
     Call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
sub checkvalues (caddress as String, stepwidth as integer, begin as integer, finish as integer )
    dim i as integer
    dim sCell as String
    Kontext
    Printlog "Execute hard Recalc..."
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 SHIFT F9>"
    printlog "... and look, if all values are zero"
    Kontext "DocumentCalc"
    if cgotocell(caddress) <> 0 then
        warnlog "Traveling to " & caddress & " failed! Exiting sub routine!"
        exit sub
    end if                    
    for i = begin to finish step stepwidth
        sCell = left(caddress, 1)  & i
        call checkcellwert(sCell, 0)
    next i
end sub
