'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: calculat.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: jsi $ $Date: 2007/10/10 09:11:38 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : Detailed test for functions 
'*
'************************************************************************
'*
' #1 tDatenB   ' Database functions      
' #1 tMinimal  ' Functions that are used in calc short test
' #1 tDezimal  ' Functions for converting decimal, binary etc.
' #1 tDatum    ' Date and Time functoins
' #1 tFinanz   ' Financial functions
' #1 tInformat ' Information functions
' #1 tLogic    ' Logic functions
'*
'\***********************************************************************

testcase tDatenB
'/// This testcase checks the results from the file "gtesttoolpath & "calc\special\input\datenb.xls" ///
     Dim sFileToLoad as string
     Dim i as integer 
     Dim r As integer
     Dim sCell as string
     
     sFileToLoad = convertpath (gtesttoolpath & "calc\special\input\datenb.xls")

     call hDateiOeffnen (sFileToLoad)
     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"
       For i = 4 to 8
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i

       For i = 10 to 14
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i

       For i = 16 to 20
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i

       For i = 22 to 25
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i

     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"

       For i = 28 to 32
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i

       For i = 34 to 38
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i

       For i = 40 to 44
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i

     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"

       For i = 46 to 50
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i

       call checkcellwert("A52", 0)

     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"

       call checkcellwert("A56", 0)

       For i = 58 to 62
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i

       For i = 64 to 68
           sCell = "A" & i
           call checkcellwert(sCell, 0)
       Next i
       call checkcellwert("A70", 0)
       call checkcellwert("A74", 0)
     call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tMinimal
     Dim sFileToLoad as string     
     Dim sDelimiter as string
     
     sFileToLoad = convertpath(gtesttoolpath & "calc\special\input\minimal.sdc")
     sDelimiter = getDecimalSeperator()
          
     call hDateiOeffnen (sFileToLoad)
     '/// Open <i>gTestToolPath</i>/calc/special/input/minimal.sdc 
     Kontext "DocumentCalc"
     '/// Type CTRL+SHIFT+F9 
     DocumentCalc.TypeKeys "<Mod1 Shift F9>"
     '/// Validate that the value in cell A1 is 1,2 (or 1.2 - depending on the delimitter)
     call checkcellwert("A1", "1" & sDelimiter & "2")
     '/// Validate that the value in cell A2 is #DIV/0! (devision with zero)  
     call checkcellwert("A2",  "#DIV/0!")
     '/// Validate that the value in cell A3 is 3,14 (or 3.14 - depending on the delimitter)
     call checkcellwert("A3", "3" & sDelimiter & "14")
     '/// Close the document 
     call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tDezimal
'/// This testcase check the function "Dezimal" in file gtesttoolpath & "calc\special\input\dezimal.sdc"
'/// Reference Values for D7=65535; D8=65535; D9=32767. ///
    Dim sFileToLoad as string
     
    sFileToLoad =  convertpath(gtesttoolpath & "calc\special\input\dezimal.sdc")

    call hDateiOeffnen(sFileToLoad)
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Shift F9>"
        call checkcellwert("D7", 65535)
        call checkcellwert("D8", 65535)
        call checkcellwert("D9", 32767)
    call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tDatum
'/// Open a Excel Document with several date/time functions
'/// Check if results are correct 
    Dim sFileToLoad as string
    Dim sCell as string
    Dim i as integer
    sFileToLoad = convertpath(gtesttoolpath & "calc\special\input\datum.xls")
     
    if iSystemsprache <> 01 then
       QAErrorLog "Sorry, this Testcase only runs on locale en_US"
       goto endsub
    end if

    call hDateiOeffnen (sFileToLoad)
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Shift F9>"
    
        For i = 3 to 7
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        For i = 9 to 13
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        call checkcellwert("A15", 0)
        
        For i = 17 to 19
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        next i
        
        For i = 21 to 25
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        For i = 27 to 31
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        For i = 33 to 37
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        call checkcellwert("A39", 0)
        
        For i = 41 to 43
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        For i = 47 to 51
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        For i = 53 to 56
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        For i = 59 to 63
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        For i = 67 to 71
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
        
        For i = 73 to 77
           sCell = "A" & i
           call checkcellwert(sCell, 0)
        Next i
    call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tFinanz
'/// Open Excel file with financial functions
'/// Check for correct results
    Dim sFileToLoad as string
    Dim sCell as string
    Dim i as integer

    sFileToLoad = convertpath(gtesttoolpath & "calc\special\input\finanz.xls")
    
    call hDateiOeffnen (sFileToLoad)
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Shift F9>"
        For i = 4 to 8
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 10 to 14
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 16 to 20
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 22 to 26
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 28 to 32
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 34 to 38
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 40 to 44
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 46 to 50
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 53 to 57
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 59 to 63
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 65 to 69
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 72 to 76
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 78 to 82
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i
    call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tInformat
'/// Open Excel file with information functions
'/// Check for correct results
    Dim sFileToLoad as string
    Dim sCell as string
    Dim i as integer    
    
    sFileToLoad = convertpath(gtesttoolpath & "calc\special\input\informat.xls")
   
    call hDateiOeffnen (sFileToLoad)
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Shift F9>"
        For i = 7 to 11
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 13 to 14
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 16 to 18
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 20 to 24
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 26 to 27
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 29 to 31
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 33 to 35
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 37 to 40
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i


        For i = 42 to 46
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i

        For i = 48 to 52
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i
        
        select case iSprache
            case 01:    call checkcellwert("A54", "#N/A")
            case 07:    call checkcellwert("A54", "#Н/Д")
            case 31:    call checkcellwert("A54", "#NB")
            case 33:    call checkcellwert("A54", "#NA")
            case 34:    call checkcellwert("A54", "#N/A")
            case 39:    call checkcellwert("A54", "#N/D")
            case 46:    call checkcellwert("A54", "#Saknas")
            case 49:    call checkcellwert("A54", "#NV")
            case 55:    call checkcellwert("A54", "#N/D")
            case 81:    call checkcellwert("A54", "#N/A")
            case 82:    call checkcellwert("A54", "#N/A")
            case 86:    call checkcellwert("A54", "#N/V")
            case 88:    call checkcellwert("A54", "#N/V")
            case else : QAErrorLog "No adjustment for current language. Skipping this check."                        
        end select        
        For i = 56 to 58
                sCell = "A" & i
                call checkcellwert(sCell, 0)
        Next i
        call checkcellwert("A59", -1)
        call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
testcase tLogic
'/// Open Excel file with logic functions
'/// Check for correct results
    Dim sFileToLoad as string
    
    sFileToLoad = convertpath(gtesttoolpath & "calc\special\input\logisch.xls")
    
    call hDateiOeffnen (sFileToLoad)
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Shift F9>"
        call checkcellwert("A3", 0)
        call checkcellwert("A4", 0)
        call checkcellwert("A6", 0)
        call checkcellwert("A7", 0)
        call checkcellwert("A9", "Zuviel")
        call checkcellwert("A10", "Gehälter OK")
        call checkcellwert("A11", "Mindestgehalt zu niedrig")
    call hCloseDocument
endcase


