'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: clipboardtest_tools.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsi $ $Date: 2006/08/19 12:09:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description : 
'*
'************************************************************************
'*
' #0 checkFormatsAndAttributes
' #0 checkInsertedObject
' #0 checkCellValue
'*
'\***********************************************************************

sub checkFormatsAndAttributes(protect as boolean)

   FormatCells
   Kontext
   Active.setPage TabZahlen
   Kontext "TabZahlen"
   if FormatCode.getText = "0,00" or FormatCode.getText = "0.00" then
      printlog "OK, the formatcode has been copied correct"
   else
      warnlog "The formatcode is " & FormatCode.getText & " instead of '0,00'/'0.00'"
   end if
   Kontext
   Active.setPage TabFont
   Kontext "TabFont"
   printlog "Asian support: " & gAsianSup
   if gAsianSup = FALSE then
      if Style.getSelIndex = 4 then
         printlog "OK, the style has ben copied correct"
      else
         warnlog "The style is " & Style.getSelText & " instead of bold and italic"
      end if
   else
      if StyleWest.getSelIndex = 4 then
         printlog "OK, the style has ben copied correct"
      else
         warnlog "The style is " & StyleWest.getSelText & " instead of bold and italic"
      end if
   end if
   Kontext
   Active.setPage TabFontEffects
   Kontext "TabFontEffects"
   if FontColor.getSelIndex = 11 then
      printlog "OK, the fontcolor has been copied correct"
   else
      warnlog "The fontcolor is " & FontColor.getSelIndex & " instead of '11' (blue)"
   end if
   Kontext
   Active.setPage TabAusrichtung
   Kontext "TabAusrichtung"
   if ListeHAusrichtung.getSelIndex = 3 then
      printlog "OK, the horizontal alignment has benn copied correct"
   else
      warnlog "The horizontal alignment is " &  ListeHAusrichtung.getSelIndex & " instead of '3'(center)"
   end if
   Kontext
   Active.setPage TabUmrandung
   Kontext "TabUmrandung"
   if Stil.getSelIndex = 5 then
      printlog "OK, the linestyle from the border has been copied correct"
   else
      warnlog "The linestyle from the border is " &  Stil.getSelIndex & " insetad of '5'(2.50 pt)"
   end if
   if Stilfarbe.getSelIndex = 2 then
      printlog "OK, the bordercolor has been copied correct"
   else
      warnlog "The bordercolor is " &  Stilfarbe.getSelIndex & " instead of '2'(dark blue)"
   end if

   Kontext
   Active.setPage TabZellschutz
   Kontext "TabZellschutz"
   if protect then
      if Gesperrt.isChecked then
         printlog "OK, the cellprotection is active"
      else
         warnlog "The cellprotection isn't active"
      end if
   else
      if NOT Gesperrt.isChecked then
         printlog "OK, the cellprotection is not active"
      else
         warnlog "The cellprotection is active"
      end if
   end if

   TabZellschutz.close

end sub

sub checkInsertedObject(InsObject as String)
   try
      FormatArea
      Kontext
      Active.setPage TabArea
      Kontext "TabArea"
      TabArea.cancel
      printlog "OK, the " &  InsObject & " has been copied"
   catch
      warnlog "It seems that no " & InsObject & " has been copied"
   endcatch

end sub

sub checkCellValue(CellAdress as String, RefValue as String)

   call cGotoCell(CellAdress)
   if cZellWert(CellAdress) = RefValue then
      printlog "OK, the value from cell " & CellAdress & " is correct"
   else
      warnlog "The value from cell " & CellAdress & " is " & cZellWert(CellAdress) & " instead of " & RefValue
   end if

end sub
