'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: keyboardaccessibility.bas,v $
'*
'*  $Revision: 1.17 $
'*
'*  last change: $Author: jsi $ $Date: 2007/12/05 13:47:00 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner :joerg.sievers@sun.com
'*
'* short description : Complete test for Keyboard Accessibility
'*
'\***********************************************************************

global gSeperator , gMeasurementUnit as String
global gMeasurementunitindex as Integer
global gMeasurementConfiguration as Boolean

sub main
    PrintLog "---------------------------------------------------------------------"
    Printlog "-----                    Keyboard Accessibility                 -----"
    PrintLog "---------------------------------------------------------------------"

    use "calc\special\inc\keyboardaccessibility\keyboardaccessibility1.inc"
    use "calc\special\inc\keyboardaccessibility\keyboardaccessibility2.inc"
    use "calc\special\inc\keyboardaccessibility\keyboardaccessibility3.inc"
    use "calc\special\inc\keyboardaccessibility\keyboardaccessibility4.inc"
    use "calc\special\inc\keyboardaccessibility\keyboardaccessibility5.inc"
    use "calc\tools\c_tool.inc"
    use "calc\tools\c_tool_1.inc"
    use "calc\tools\c_select_tools.inc"
    use "calc\special\inc\keyboardaccessibility\tools.inc"    

    'Software Configuration:
    Call MeasurementConfiguration
    
    Call hStatusIn("Calc", "keyboardaccessibility.bas", "Keyboard Accessibility test for Calc")
    
    if iSprache = 01 then
        Call C_Keyboard_Accessibility_1
    endif

    printlog Chr(13) + "=== Keyboard_Accessibility 4 ==="

    printlog Chr(13) + "-- Test moving draw objects"
    Call tMoveDrawObject1 

    printlog Chr(13) + "-- Test entering control"
    Call tEnteringControl1    
    Call tEnteringControl2    

    printlog Chr(13) + "-- Select first draw object and travel through severeal ojbects"
    Call tTravelObject1        
    Call tTravelObject2        
    Call tTravelObject3        

    printlog Chr(13) + "-- Select first draw object and travel through severeal ojbects"
    Call tInsertSpecialCharacter1     
    Call tInsertSpecialCharacter2
    Call tInsertSpecialCharacter3
    
    printLog Chr(13) & "=== Keyboard_Accessibility 2 ==="

    printLog Chr(13) & "-- Resize Objects , including graphic,  chart and draw objects"
    Call tResizeObject1      
    Call tResizeObject2      
    Call tResizeObject3      
    Call tResizeObject4      
    Call tResizeObject5      
    Call tResizeObject6      
    Call tResizeObject7      
    
    printLog Chr(13) & "-- Check Multi selection of Cells using Keyboard"
    Call tMultiSelection1      
    Call tMultiSelection2      
    Call tMultiSelection3      
    Call tMultiSelection4      
    
    printLog Chr(13) & "-- Check Keyboard shortcut to select array formula"
    Call tSelectArrayFormula1  
    Call tSelectArrayFormula2  
    
    printLog Chr(13) & "-- Check Select tables with keyboard"
    Call tSelectTables1       
    Call tSelectTables2       
    Call tSelectTables3       
    Call tSelectTables4       
     
    Call C_Keyboard_Accessibility_3    
    if iSprache = 01 then
        Call C_Keyboard_Accessibility_5
    endif
     
     'Setting measurement back to starting value
     Call RestoreSettings
     
     Call hStatusOut
end sub

'-------------------------------------------------------------------------

sub LoadIncludeFiles   
    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    use "global\tools\inc\t_toolbar_tools1.inc"
    use "global\tools\inc\t_toolbar_calc.inc"
    gApplication   = "Calc"
    Call GetUseFiles
end sub
'
'-------------------------------------------------------------------------
'
sub RestoreSettings
    'Setting measurement back to starting value
    Call hNewDocument
    ToolsOptions
    Call hToolsOptions("SPREADSHEET","GENERAL")
    Masseinheit.Select(gMeasurementunitindex)
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    gMeasurementConfiguration = False    'Configuration has not been run
    Call hCloseDocument
    Printlog "MeasurementUnit has been set back to starting value"
end sub
