'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_001_.inc,v $
'*
'*  $Revision: 1.71 $
'*
'*  last change: $Author: jsi $ $Date: 2008/01/25 12:52:36 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description  :  Resource test section file
'*
'**************************************************************************
'** 
' #1 tFileNewSpreadsheet
' #1 tFileNewTemplatesAndDocuments
' #1 tFileOpen
' #1 tFileRecentDocuments
' #1 tFileOpenCSV
' #1 tFileWizardsDocumentConverter
' #1 tFileWizardsEuroConverter
' #1 tToolbarEuroConverter
' #1 tFileClose
' #1 tFileSave
' #1 tFileSaveWithPassword
' #1 tFileSaveAs
' #1 tFileSaveAsExcel
' #1 tFileSaveAsCSV
' #1 tFileSaveAsDIF
' #1 tFileSaveAsDBF
' #1 tFileSaveAll
' #1 tFileReload
' #1 tFileVersions
' #1 tFileExport
' #1 tFileProperties
' #1 tFileTemplatesOrganize
' #1 tFilePagepreview
' #1 tFilePrint
' #1 tFilePrinterSettings
'**
'\************************************************************************


sub C_001_

Printlog Chr(13) + "--------- C_001_ ---------"

    call tFileNewSpreadsheet
    Call tFileNewTemplatesAndDocuments
    Call tFileOpen
    call tFileRecentDocuments
    call tFileOpenCSV
    call tFileWizardsDocumentConverter
    call tFileWizardsEuroConverter
    call tToolbarEuroConverter
    Call tFileClose
    Call tFileSave
    Call tFileSaveWithPassword
    Call tFileSaveAs
    Call tFileSaveAsExcel
    call tFileSaveAsCSV
    call tFileSaveAsDIF
    call tFileSaveAsDBF
    Call tFileSaveAll
    call tFileReload
    call tFileVersions
    call tFileExport
    'external testcase from ...\global\update\inc\g_001.inc
        Call tFileExportAsPDF
        Call tExportAsPDFButton    
    Call tFileProperties
    Call tFileTemplatesOrganize
    Call tFilePagepreview
    Call tFilePrint
    Call tFilePrinterSettings

end sub

'
'-----------------------------------------------------------
'
testcase tFileNewSpreadsheet
   '/// open new document
  call hNewDocument
  Kontext "DocumentCalc"
  '/// open new document with menu
  DocumentCalc.UseMenu
  sleep(2)
  hMenuSelectNr(1)
  sleep(2)
  hMenuSelectNr(1)
  sleep(2)
  hMenuSelectNr(2)
  sleep(2)
  Kontext "DocumentCalc"
  '/// check for Calc Document
  Call DialogTest (DocumentCalc)
  '/// close two documents
  call hCloseDocument
  call hCloseDocument  
endcase
'
'-----------------------------------------------------------
'
testcase tFileNewTemplatesAndDocuments
  '/// open new document
  call hNewDocument
    '/// invoke template dialog {File::New::From Template}
    FileNewFromTemplate
    Kontext "TemplateAndDocuments"
      '/// check for Template dialog
      Call DialogTest (TemplateAndDocuments)
      TemplateAndDocuments.Cancel
  '/// close document
  call hCloseDocument  
endcase
'
'-----------------------------------------------------------
'
testcase tFileOpen
  '/// open new document
  call hNewDocument
  '/// invoke file open dialog
    FileOpen
    Kontext "OeffnenDlg"
      '/// click "Up one level"
      UebergeordneterOrdner.Click
      '/// Click "Default directory"
      Standard.Click
      '/// Check "Read only"
      NurLesen.check
      '/// Check if dialog exists
      Call DialogTest ( OeffnenDlg )
      '/// Cancel dialog
      OeffnenDlg.Cancel      
  '/// close document
  call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileRecentDocuments
  dim sTestFile as string
  dim iEntries as integer
  dim sContentB3 as string
  dim sContentA1 as string
  
    sTestFile = convertpath(gTesttoolPath & "calc/update/input/c_001/fileRecentDocuments.ods")
    '/// Open Test File <i>calc/update/input/c_001/fileRecentDocuments.ods</i>
    call hDateiOeffnen(sTestFile)
    sleep(3)
    '/// Close the document again    
    call hCloseDocument
    '/// File / New / Spreadsheet
    call hNewDocument
    '/// Now a item in <i>Recent Documents</i> should exist
    sleep(2)
    '/// Reopen Document using the menu <i>File / Recent Documents</i>
    Kontext "DocumentCalc"
    DocumentCalc.UseMenu
    sleep(2)
    iEntries = hMenuItemGetCount
    if iEntries <> 0 then 
        hMenuSelectNr(1)
        sleep(2)
        hMenuSelectNr(3)
        sleep(2)
        hMenuSelectNr(1)
        '/// Goto Cell B3
        Kontext "DocumentCalc"
        call cGotoCell("B3")
        Kontext "DocumentCalc"
        '///Read cell content B3
        sContentB3 = cZellinhalt("B3")
        sleep(2)        
        if sContentB3 = "Check this out" then
            printlog "Loading most recent Document seems to work"
        else
            'Sometimes the recent doc is loaded in background
            Kontext "DocumentCalc"
            call cGotoCell("A1")
            Kontext "DocumentCalc"
            sContentA1 = cZellinhalt("A1")
            sleep(2)
            if sContentA1 = "The first doc!" then
                QAErrorLog "Recent document is loaded in background (#i76541#)"
                Kontext "DocumentCalc"
                DocumentCalc.UseMenu 
                sleep(2)
                hMenuSelectNr(8) 'Open Window menu
                sleep(2)
                hMenuSelectNr(hMenuItemGetCount) 'Select last loaded document
                sleep(2)
                'Goto Cell B3
                Kontext "DocumentCalc"
                call cGotoCell("B3")
                Kontext "DocumentCalc"
                'Read cell content B3
                sContentB3 = cZellinhalt("B3")
                sleep(2)        
                if sContentB3 = "Check this out" then
                    printlog "Loading most recent Document seems to work"
                else
                    warnlog "Loading most recent Document seems to fail -> CHECK IT OUT!"
                endif
            else
                warnlog "Loading most recent Document seems to fail -> CHECK IT OUT!"
            endif
        endif
    else
        warnlog "The main menu wasn't opened!"
    endif
    '/// Close document
    call hCloseDocument           
endcase
'
'-----------------------------------------------------------
'
testcase tFileOpenCSV  
    Dim vFilter as string
    Dim vExtension(10) as string 
    Dim yFilter as string
    Dim yExtension(10) as string
    Dim xTextFiltername as string
    
    '/// Invoke file open dialog
    printlog "Test the import dialog for CSV files"
    FileOpen
    Kontext "OeffnenDlg"
    vFilter = hGetUIFiltername("Text - txt - csv (StarCalc)")         
    vExtension() = hGetFilternameExtension("calc_Text_txt_csv_StarCalc")    
    xTextFiltername = vFilter & " (*." & vExtension(0) & ";*." & vExtension(1) & ";*." & vExtension(2) & ")"
    printlog "TEXT CSV filter name in UI (in configuration files): " & xTextFiltername
    try
        Dateityp.Select(xTextFiltername)
        '/// Select the 'Text CSV (*.csv;*.txt)' filter directly
        '/// Open file "calc\update\input\c_001\import.tst"     
        Dateiname.settext convertpath(gtesttoolpath & "calc\update\input\c_001\import.tst")
        Oeffnen.Click                  
        Kontext "DocumentWriter"
        if DocumentWriter.exists(2) then
            warnlog "Filter detection is broken. Text file opened in writer although CSV filter was selected."
            call hCloseDocument
            goto endsub
        endif
        '/// Check existence of CSV import dialog
        Kontext "TextImport"
        call Dialogtest (TextImport)
          if TextImport.exists(2) then
             TextImport.ok
             Kontext "DocumentCalc"
             call hCloseDocument
          else
             warnlog "CSV Import failed"
          endif
    catch
        Kontext "OeffnenDlg"
        OeffnenDlg.Cancel
        if iSprache = 81 then
            QAErrorLog "#i66011# - Text CSV filter name is wrong in japanese language"
            goto endsub
        else
            warnlog "Filter detection is broken."
        endif
    endcatch
endcase
'
'-----------------------------------------------------------
'
testcase tFileWizardsDocumentConverter 
   '/// Open new document
   call hNewDocument
   '/// Invoke document converter
   if ActivateAutoPilot ( "DocumentConverter" ) = TRUE then
      Kontext "DocumentConverter"
      '/// Check existence of document converter dialog
      Call DialogTest ( DocumentConverter )
      '/// Choose spreadsheet as application in dialog
      spreadsheet.check
      '/// Click continue button
      continueButton.Click
      '/// Check if proceeding works
      if template.isVisible then
         printlog " + Proceeding (Step 1) in 'Document Converter' seems to work"
      else
         warnlog " + Proceeding (Step 1) in 'Document Converter' doesn't seem to work"
      endif

      '/// <b>Check four times for file open dialog</b>
      '///+ for "Import from Template"
      '///+<li><ol>
      ImportFormTemplatesSearch.Click
      Kontext "OeffnenDLG"
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "DocumentConverter"
      '///+<li>for "Save to Template"</li>
      SaveToTemplatesSearch.Click
      Kontext "OeffnenDLG"
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "DocumentConverter"
      '///+<li>for "Import from Document"</li>
      ImportFormDocumentSearch.Click
      Kontext "OeffnenDLG"
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "DocumentConverter"
      '///+<li>for "Save to document"</li>
      '///+</ol></li>
      SaveToDocumentSearch.Click
      Kontext "OeffnenDLG"
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "DocumentConverter"
      
      '/// Click continue button
      continueButton.Click
      '/// Check if proceeding works
      if template.isVisible then
         warnlog " + Proceeding (Step 2) in 'Document Converter' doesn't seem to work"
      else         
         printlog " + Proceeding (Step 2) in 'Document Converter' seems to work"
      endif
      '/// Cancel dialog
      CancelButton.Click
   else
      warnlog "Starting the 'Document Converter' seems to have failed"
   endif
   '/// Close document
   call hCloseDocument   
endcase
'
'-----------------------------------------------------------
'
testcase tFileWizardsEuroConverter
   Dim sDirectory$
   sDirectory$ = convertpath(gOfficePath & "user" )
   '/// Open new document
   call hNewDocument
   '/// Invoke euro converter
   if ActivateAutoPilot ( "EuroConverter" ) = TRUE then
      Kontext "AutoPilotEuroKonverter"
      '/// Check existence of euro converter dialog
      Call DialogTest ( AutoPilotEuroKonverter )
      '/// Invoke source directory dialog
      QuelleSuchen.Click
      Kontext "OeffnenDLG"
      '/// Check if file open dialog does exist
      Call Dialogtest (OeffnenDlg)
      '/// Cancel file open dialog
      OeffnenDLG.Cancel
      Kontext "AutoPilotEuroKonverter"
      '/// Invoke target directory
      ZielSuchen.Click
      Kontext "OeffnenDLG"
      '/// Check if file open dialog does exist
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "AutoPilotEuroKonverter"      
      '/// Set source directory
      Quelle.setText (sDirectory$)
      '/// Select random item if there isn't a preselection e.g. CJK
      if Waehrungen.GetSelIndex = 0 then
          Waehrungen.select 1
      endif
      '/// Click "Convert"
      konvertieren.Click
      '/// Check if proceeding did work
      if quelle.isVisible then
         warnlog " + Proceeding in 'Euro Converter' doesn't seem to work"
      else
         printlog " + Proceeding in 'Euro Converter' seems to work"
      endif
      '/// Cancel dialog
      abbrechen.Click
   else
      warnlog "Starting the 'Euro Converter' seems to have failed"
   endif
   '/// Close document
   call hCloseDocument   
endcase
'
'-----------------------------------------------------------
'
testcase tToolbarEuroConverter
   '/// Open new document
   Call  hNewDocument
   '/// Inovke 'recent document' euro converter
   SpreadsheetEuroConverter
   Kontext "AutoPilotEuroKonverter"
   '/// check existence of euro converter
   Call DialogTest (AutoPilotEuroKonverter)
   '/// Cancel euro converter
   abbrechen.Click
   '/// Close document
   call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileClose
     '/// Open new document
     Call  hNewDocument
     '/// Edit random stuff to obtain a 'dirty' document
     EditCopy
     EditPaste
     '/// Invoke file::close
     '/// (Save|Discard|Cancel MsgBox should come up)
     FileClose
     Kontext
     '/// MsgBox: Cancel
     Active.Cancel
     '/// Invoke file::close
     FileClose
     '/// MsgBox: Save
     Kontext
     Active.Yes
     '/// Check for file open dialog
     Kontext "SpeichernDlg"
     '/// Cancel file open dialog
     SpeichernDlg.Cancel
     '/// Invoke file::close
     FileClose
     Kontext
     '/// MsgBox: Discard
     Active.No
endcase
'
'-----------------------------------------------------------
'
testcase tFileSave
    '/// Open new document
    Call  hNewDocument
    '/// Edit random stuff to obtain a 'dirty' document
    EditCopy
    EditPaste
    '/// File::Save
    FileSave
    '/// Save dialog should be visible now
    Kontext "SpeichernDlg"
    '/// Click 'folder up'
    UebergeordneterOrdner.click
    '/// Click 'default folder'
    Standard.Click
    '/// Select default file format
    try
        Dateityp.Select gCalcFilter
    catch
        warnlog "Wrong filternames"
    endcatch
    '/// Check if save dialog exists
    Call DialogTest (SpeichernDlg)
    '/// Cancel save dialog
    SpeichernDlg.Cancel   
    '/// Close document
    call hCloseDocument    
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveWithPassword
    Dim sDatei as string
    Dim sDatei1 as string

    sDatei = convertpath(gOfficePath & "user/work/password.ods")
    sDatei1 = convertpath(gOfficePath & "user/work/test.ods")
    
    if Dir(sDatei) <> "" then 
        kill sDatei
    end if        
    if Dir(sDatei1) <> "" then 
        kill sDatei1
    end if
    '/// File / New / Spreadsheet
    Call hNewDocument
    sleep(2)
    '/// Type in the first cell <i>Random stupid content</i> and [Return]
    DocumentCalc.TypeKeys "Random stupid content<Return>"
    '/// File / Save
    FileSave
    Kontext "SpeichernDlg"
    '/// Check the password check-box
    Passwort.Check
    printlog "Password checked"    
    '/// Check if passwordbox is still checked
    if Passwort.IsChecked = FALSE then        
        warnlog "Checked state of password check-box lost by changing the directory"
        Passwort.check        
    end if
    '/// Set file name <i>gOfficePath</i>/user/work/password.ods
    Dateiname.settext sDatei
    '/// Deselect 'automatic file name extension'
    if AutomatischeDateinamenserweiterung.Exists then
        if AutomatischeDateinamenserweiterung.IsChecked then
            QAErrorLog "OBSOLETE: Check-box Automatic file extension in file dialog will be removed soon!"
            AutomatischeDateinamenserweiterung.Uncheck
        end if
    endif
    '/// Click save button
    Speichern.Click
    'Check for overwrite warning
    Kontext "Active"
    if Active.Exists(2) then        
        Active.Yes
    end if
    '/// (Password dialog should be visible now)
    Kontext "Passwort"    
    Call DialogTest (Passwort)
    printlog "1st test case: Wrong confirmation"
    '/// Set password 'Tiberius'
    PasswortName.SetText "Tiberius"
    '/// Set wrong conformation of password '12345678'
    PasswortBestaetigen.SetText "12345678"
    '/// Try to leave dialog with OK
    Passwort.Ok    
    '/// MsgBox warning for wrong password confirmation should be visible
    Kontext
    if Active.exists(4) then
        if Active.GetRT = 304 then
            '/// Confirm warning
            printlog "Comparison of two different passwords detected successfully."
            Active.OK
        end if
    else
        warnlog "Comparison with two different passwords has not been detected. Aborting!"
        call hCloseDocument
        goto endsub        
    end if
    Kontext "Passwort"
    if Passwort.Exists(2) then
        printlog "2nd test case; Correct confirmation"
        '/// Set password correctly
        PasswortName.SetText "Tiberius"
        '/// Now enter right confirmation
        PasswortBestaetigen.SetText "Tiberius"
        '/// OK
        Passwort.Ok        
    else
        warnlog "Password dialog has been gone. Aborting!"
        Call hCloseDocument
        goto endsub
    end if        
    '/// Close file
    call hCloseDocument
    sleep(5)      
    '/// Try to reopen file
    FileOpen
    sleep(2)
    Kontext "OeffnenDlg"
    Dateiname.Settext sDatei
    Oeffnen.Click
    '/// (Password input dialog should be visible now)
    Kontext "PasswordFileOpen"
    if PasswordFileOpen.Exists(3) then
        printlog "file re-opened"
        '/// Enter wrong password
        PasswortName.SetText "Suirebit"
        '/// OK
        PasswordFileOpen.Ok
    else
        warnlog "Password dialog was not visible. Aborting!"
        Call hCloseDocument
        goto endsub
    end if          	
    Kontext    
    if Active.exists(3) then
        if Active.GetRT = 304 then
            '/// A warning should occour and click on OK
          	Active.OK
        end if
    else
        warnlog "Warning message box that a wrong password has been entered is missing!"        
        goto endsub
    end if  
    Kontext "PasswordFileOpen"
    if PasswordFileOpen.Exists(3) then
        printlog "PasswordDlg reopened"
    else
        '/// Reopen file
        FileOpen
        Kontext "OeffnenDlg"
        Dateiname.SetText sDatei
        Oeffnen.Click
    end if
    Kontext "PasswordFileOpen"
    '/// Enter right password and press OK
    if PasswordFileOpen.Exists(3) then
        PasswortName.settext "Tiberius"            
        PasswordFileOpen.Ok
    else
        warnlog "Correct password wasn't noticed by loading the document"
        goto endsub
    end if 
    '/// File / Save as <i>gOfficePath</i>/user/work/test.ods without password
    sleep(2)
    FileSaveAs
    Kontext "SpeichernDlg"
    Dateiname.Settext sDatei1
    if AutomatischeDateinamenserweiterung.Exists then    
        if AutomatischeDateinamenserweiterung.IsChecked then 
            AutomatischeDateinamenserweiterung.uncheck
        end if
    endif
    '/// Uncheck password option
    if Passwort.IsChecked then 
        Passwort.UnCheck
    end if
    '/// Save
    Speichern.Click
    '/// Close the document     
    call hCloseDocument    
    '/// Reopen file (NO password dialog should appear now!)
    call hDateiOeffnen(sDatei1)
    '/// Close the document
    call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAs
     '/// Open new document
     Call  hNewDocument
     '/// File::Save As... 
     FileSaveAs
      Kontext "SpeichernDlg"
        '/// Check for existence of file open dialog
        Call DialogTest ( SpeichernDlg )
        '/// Cancel dilaog
        SpeichernDlg.Cancel
    '/// Close document
    call hCloseDocument    
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAsExcel  
   '/// Open test document "calc/update/input/c_001/all_features.sxc"
   call hDateiOeffnen convertpath(gTesttoolPath & "calc/update/input/c_001/all_features.sxc")
   sleep(60)
   '/// File::Save as...
   FileSaveAs
   '/// (File open dialog should be visible now)
   Kontext "SpeichernDlg"
   '/// Enter target file name
     Dateiname.setText convertpath(gOfficePath & "user/work/all_features")
     '/// Select filter #7 (should be Excel97/2000/XP)
     Dateityp.select 7
     '/// Check if assumption was right
     if instr(Dateityp.getSelText,"xls") AND instr(Dateityp.getSelText,"XP") then
        printlog "Excel97/2000/XP filter was selected"
     else
        '/// + Throw warning and exit if selecting Excel97/2000/XP filter failed
        warnlog "Excel97/2000/XP filter not available or moved in filter list!"
        SpeichernDlg.Cancel
        Call hCloseDocument
        goto endsub
     end if
     '/// Select 'automatic file name extention
     if AutomatischeDateinamenserweiterung.Exists then
        QAErrorLog "OBSOLETE: Automatic file extension check-box in file dialog will be removed soon!"
        AutomatischeDateinamenserweiterung.check
     endif
     printlog "Filetype: " & Dateityp.getSelText
     '/// Click save button
     Speichern.click
     '/// Check for overwrite warning
     sleep(1)
     Kontext "Active"
       if Active.exists(2) then
          '/// -> Commit if exists
             Active.YES
       endif
     '/// Check for alien file format warning
     Kontext "AlienWarning"
       if AlienWarning.exists(2) then
          '/// -> Commit if exists
          AlienWarning.OK
       else 
          warnlog "Alien file format warning is missing -> Check this out!"
       endif
     sleep 60 ' necessary because it takes some time to save! (especially on a nonpro)
       '/// Check for unexpected MsgBox
     Kontext "Active"
       if Active.exists(2) then
          warnlog "An unexpected MsgBox seems to be in the way"
          goto endsub
       endif
       '/// Close file
     FileClose
       '/// Check for unexpected MsgBox
     Kontext "Active"
       if Active.exists(2) then
          warnlog "Saving to MS office formats seems to enable the change flag"
          active.yes
       endif
     sleep(2)
   '/// Reopen Excel file
    call hDateiOeffnen convertpath(gOfficePath & "user/work/all_features.xls")
   sleep (2)
   FileClose
   sleep(2)
   '/// Check for unexpected MsgBox
     Kontext "Active"
       if Active.exists(2) then
          QAErrorLog "#i46837# Save button enabled immediately after loading excel document"
          active.no
       endif
     sleep(2)     
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAsCSV
   '/// Open new document
   call hNewDocument
   sleep(2)
   Kontext "DocumentCalc"
   '/// Edit some random stuff
   DocumentCalc.typeKeys ("1<return>")
   '/// File::Save As... (CSV)
   FileSaveAs
   Kontext "SpeichernDlg"
   '/// Set target file name "user/work/saveCSV"
     Dateiname.setText convertpath(gOfficePath & "user/work/saveCSV")
     '/// Select filter #20 (should be the CSV filter)
     Dateityp.select 20 
     '/// Check if assumption was right
     if instr(Dateityp.getSelText,"csv") then
        printlog "CSV filter was selected"
     else
        '/// + Throw warning and exit if selecting CSV filter failed
        warnlog "CSV filter not available or moved in filter list!"
        SpeichernDlg.Cancel
        Call hCloseDocument
        goto endsub
     end if
     '/// Select 'automatic file extention'
     if AutomatischeDateinamenserweiterung.Exists then
        QAErrorLog "OBSOLETE: Automatic file extension check-box in file dialog will be removed soon!"
        AutomatischeDateinamenserweiterung.check
     endif
     printlog "Filetype: " & Dateityp.getSelText
     '/// Click Save
     Speichern.click
     '/// Check for overwrite warning
     sleep(1)
     Kontext "Active"
       if Active.exists(2) then
          '/// -> Commit if exists
             Active.YES
       endif
     sleep(2)
     '/// Check alien file format warning
     Kontext "AlienWarning"
     if AlienWarning.exists(2) then
        '/// -> Commit if exists
        AlienWarning.OK
     else 
        warnlog "Alien file format warning is missing -> Check this out!"
     endif
     '/// Check existence of export encoding dialog
     Kontext "ExportCalc"
     Call DialogTest (ExportCalc)
     '/// Cancel dialog
     ExportCalc.Cancel
   '/// Close document
   Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAsDIF
   '/// Open new document
   call hNewDocument
   sleep(2)
   Kontext "DocumentCalc"
   '/// Edit some random stuff (e.g. 1|Return)
   DocumentCalc.typeKeys ("1<return>")
   '/// File::Save as...
   FileSaveAs
   Kontext "SpeichernDlg"
     '/// Enter file name "user/work/saveDIF"
     Dateiname.setText convertpath(gOfficePath & "user/work/saveDIF")
     '/// Select filter #5 (should be DIF)
     Dateityp.select 5
     '/// Check if above assumption is right
     if instr(Dateityp.getSelText,"dif") then
        printlog "DIF filter was selected"
     else
        '/// + Throw warning and exit if selecting DIF filter failed
        warnlog "DIF filter not available or moved in filter list!"
        SpeichernDlg.Cancel
        Call hCloseDocument
        goto endsub
     end if
     '/// Check 'automatic file name extention'
     if AutomatischeDateinamenserweiterung.Exists then
        QAErrorLog "OBSOLETE: Automatic file extension check-box in file dialog will be removed soon!"
        AutomatischeDateinamenserweiterung.check
     endif
     printlog "Filetype: " & Dateityp.getSelText
     '/// Click Save
     Speichern.click
     sleep(2)
     '/// Commit overwrite warning if file already exists
     Kontext
     if Active.exists(2) then
        Active.Yes
     endif
     '/// Check alien file format warning
     Kontext "AlienWarning"
     if AlienWarning.exists(2) then
        '/// -> Commit if exists
        AlienWarning.OK
     else 
        warnlog "Alien file format warning is missing -> Check this out!"
     endif
     '/// Check existence of export encoding dialog
     Kontext "ExportCalc"
     Call DialogTest (ExportCalc)
     '/// Cancel dialog
     ExportCalc.Cancel
   '/// Close document
   Call hCloseDocument  
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAsDBF
   '/// Open new document
   call hNewDocument
   sleep(2)
   Kontext "DocumentCalc"
   '/// Edit random stuff to obtain 'dirty' document
   DocumentCalc.typeKeys ("1<return>")
   '/// File::Save as ...
   FileSaveAs
   Kontext "SpeichernDlg"
   '/// Enter target file name "user/work/saveDBF"
     Dateiname.setText convertpath(gOfficePath & "user/work/saveDBF")
     '/// Select filter #6 (should be DBF)
     Dateityp.select 6
     '/// + Check if assumption was correct
     if instr(Dateityp.getSelText,"dbf") then
        printlog "DBF filter was selected"
     else
       '/// Throw warning and exit is selecting DBF filter failed 
       warnlog "DBF filter not available or moved in filter list!"
        SpeichernDlg.Cancel
        Call hCloseDocument
        goto endsub
     end if
     '/// Check 'automatic file name extention'
     if AutomatischeDateinamenserweiterung.Exists then
        QAErrorLog "OBSOLETE: Automatic file extension check-box in file dialog will be removed soon!"
        AutomatischeDateinamenserweiterung.check
     endif
     printlog "Filetype: " & Dateityp.getSelText
     '/// Click 'save'
     Speichern.click
     sleep(2)
     '/// Commit overwrite warning if file already exists
     Kontext
     if Active.exists(2) then
        Active.Yes
     endif
     '/// Check alien file format warning
     Kontext "AlienWarning"
     if AlienWarning.exists(2) then
        '/// -> Commit if exists
        AlienWarning.OK
     else 
        warnlog "Alien file format warning is missing -> Check this out!"
     endif
     '/// Check existence of export encoding dialog
     Kontext "ExportCalc"
     Call DialogTest (ExportCalc)
     '/// Cancel dialog
     ExportCalc.Cancel
     '/// Close document
   call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAll
    '/// Open new document
    Call  hNewDocument
    '/// Edit random stuff to enable Save Button
    EditCopy
    EditPaste     
    '/// Open another new document
    Call  hNewDocument
    '/// Edit random stuff to enable Save Button
    EditCopy
    EditPaste
    '/// File::Save all...
    FileSaveAll
    '/// Cancel 'Save' for the first document
    Kontext "SpeichernDlg"
    SpeichernDlg.Cancel
    '/// Cancel 'Save' for the second document
    Kontext "SpeichernDlg"
    SpeichernDlg.Cancel
    try
        '/// Try to cancel 'Save' for the third document (This is expected)
        Kontext "SpeichernDlg"
        SpeichernDlg.Cancel
    catch
        '/// + (After a earlier crash only two save dialogs may appeared)
        QAErrorLog "Alternative result: Only two Save dialogs closed."
        QAErrorLog "This happens sometime if a earlier testcase crashed OOo."
        goto skipNextTry
    endcatch
    try
        '/// Try to cancel 'Save' a fourth (Unexpected)
        Kontext "SpeichernDlg"
        SpeichernDlg.Cancel
        '/// + Throw warning if four save dialogs appeared
        warnlog "Unexpected result: Four Save dialogs closed"
    catch
        printlog "Expected result: Three Save dialogs closed"
    endcatch
skipNextTry:
      '/// Close two documents
      Call hCloseDocument
      Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileReload
  Dim sTestFile$   
  sTestFile$ = convertpath(gTesttoolPath & "calc/update/input/c_001/fileReload.ods")  
  '/// open Test File "calc/update/input/c_001/fileReload.oos"</li>
  call hDateiOeffnen(sTestFile$)
  sleep(3)
  Kontext "DocumentCalc"
  '/// Goto cell A1</li>
  call cGotoCell("A1")
  Kontext "DocumentCalc"
  '/// Edit random stuff
  DocumentCalc.typekeys "3<RETURN>"
  '/// File;;reload
  FileReload
  '/// Look for reload warning
  Kontext "Active"
  if Active.Exists(2) then
     call Dialogtest(Active)
     printlog "MsgBox appeared: " & Active.GetText
     '/// + Commit if warning exists (desired behaviour)
     Active.Yes
     sleep(5)
  else
     '/// + Throw warning if MsgBox doesn't exist
     warnlog "OOPS, a warning should appear here -> CHECK IT OUT!"
  endif
  Kontext "DocumentCalc"
  '/// Goto cell A1</li>
  call cGotoCell("A1")
  '/// Check if reload restored original content of cell A1
  Kontext "DocumentCalc"
  DocumentCalc.typekeys "<F2><MOD1 A><MOD1 C><ESCAPE>"
  sleep(2)
  '/// Verify string in clipboard</li>
  if getClipboard() = "1" then
     printlog "Reload seems to work as expected"
  else
     warnlog "Reload doesn't seem to work as expected -> CHECK IT OUT!"
  endif
  '/// close document</li>
  call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileVersions
    '/// Open new document
    call hNewDocument
    '/// Save document as "user/work/version.{ext}"
    call hSpeichernUnterKill convertpath(gOfficePath & "user/work/version.ods")
    '/// File::Version...
    FileVersions
    Kontext "Versionen"
      '/// Check existence of versions dialog
      call Dialogtest (Versionen)
      '/// Click 'save' button
      Speichern.click
        Kontext "VersionskommentarEingeben"
          '/// Check existence of comments dialog
          call DialogTest(VersionskommentarEingeben)
          '/// Cancel comments dialog
          VersionskommentarEingeben.Cancel
    Kontext "Versionen"
       '/// Close versions dialog
       Versionen.close
    '/// Close document    
    Call hCloseDocument  
endcase
'
'-----------------------------------------------------------
'
testcase tFileExport
    dim sOutputFile as string
    dim iItemsInTypeList as integer   
        
    sOutputFile = convertpath(gOfficePath & "user/work/tFileExport")
    
    '/// Delete older version of <i>user/work/tFileExport</i> if exists.
    if Dir(sOutputFile) <> "" then 
        kill sOutputFile
    endif
    '/// File / New / Spreadsheet
    call hNewDocument
    sleep(2)
    Kontext "DocumentCalc"
    '/// Type 1 in the cell A1 and press RETURN
    DocumentCalc.typeKeys ("1<RETURN>")
    '/// File / Export...
    FileExport
    Kontext "ExportierenDLG"    
    call Dialogtest (ExportierenDLG)
    '/// Click 'one level up' button
    UebergeordneterOrdner.Click
    '/// Click 'default folder' button
    Standard.Click
    '/// Click 'new folder' button
    NeuerOrdner.Click
    Kontext "NeuerOrdner"
    '/// Cancel 'name new folder' dialog -> back to export dialog
    NeuerOrdner.cancel
    Kontext "ExportierenDLG"
    '/// Enter output file name -> <i>user/work/tFileExport</i>
    Dateiname.SetText(sOutputFile)
    '/// Select filter #3 (should be XHTML)
    iItemsInTypeList = Dateityp.GetItemCount
    if iItemsInTypeList > 2 then 
        Dateityp.select(3)
    else
        QAErrorLog "XHTML filter has not been installed. Exiting test case."
        ExportierenDLG.Cancel
        call hCloseDocument
        goto endsub
    endif
    if AutomatischeDateinamenserweiterung.Exists then
        AutomatischeDateinamenserweiterung.UnCheck
    endif
    Speichern.Click
    '/// Check format warning
    Kontext "AlienWarning"
    if AlienWarning.exists(2) then
        '/// -> Commit if exists
        AlienWarning.OK
        warnlog "File format warning shouldn't pop up for export!"
    endif    
    Kontext
    if Active.exists(2) then
        try 
            Active.OK
            if Active.exists(2) then
                Active.OK
                '/// If Java isn't installed two MsgBoxes should appear
                QAErrorLog "Probably XHTML export failed due to lack of a JRE -> Please check it!"
            else
                warnlog "At this point a second MsgBox is expected to follow the first one -> Check it out!"
            endif
        catch
            Active.YES            
            warnlog "Unexpected kind of MsgBox found -> Please check!"
        endcatch
    endif
    sleep(2)
    '/// Close document
    Call hCloseDocument   
endcase
'
'-----------------------------------------------------------
'
testcase tFileProperties
    '/// Open new document
    Call hNewDocument
    '/// File::Properties
    FileProperties
    Kontext
      '/// Goto tabpage 'decription'
      active.SetPage TabDokumentinfo
      Kontext "TabDokumentinfo"
      '/// Check existence of tabpage 'decription'
        Call DialogTest ( TabDokumentinfo )
    Kontext
      '/// Goto tabpage 'General'
      active.SetPage TabDokument
      '/// Check existence of tabpage 'general'
      Kontext "TabDokument"
        Call DialogTest ( TabDokument )
    Kontext
      '/// Goto tabpage 'User defined'
      active.SetPage TabBenutzer
      Kontext "TabBenutzer"
      '/// Check existence of tabpage 'User defined'
        Call DialogTest ( TabBenutzer )
        '/// Click 'Info fields' button
        Infofelder.Click
        Kontext "InfonamenBearbeiten"
          '/// Check existence of dialog 'Edit field names'
          Call DialogTest ( InfonamenBearbeiten )
          InfonamenBearbeiten.Close
    Kontext
      '/// Goto tabpage 'Statistics'
      active.SetPage TabStatistikCalc
      Kontext "TabStatistikCalc"
        '/// Check existence of tabpage 'Statistics'
        Call DialogTest ( TabStatistikCalc )
    Kontext
      '/// Goto tabpage 'Internet'
      active.SetPage TabInternet
      Kontext "TabInternet"
        '/// Check existence of tabpage 'Internet'
        Call DialogTest ( TabInternet )
        '/// Check 'redirect from this document'
        RedirectFromThisDocument.check
        '/// Try to change to tab 'statistics'
        try
        Kontext
          active.SetPage TabStatistikCalc
          '/// -> A warning regarding the unspecified 'redirect URL' should hinder this
          Kontext "Active"
          '/// Check if the MsgBox is the one we expect
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog "MsgBox has expected Resource type."
                printlog "OK. Probably a warning to enter a redirect URL poped up:"
                printlog Active.GetText
             else
                warnlog "MsgBox has unexpected Resource type! -> Check this out"
             endif
             '/// Commit MsgBox
             '/// (The testttol triggers the MsgBox three times, this doesn't happen in reality)
             while Active.Exists(1) 
               Active.OK
             wend
          else
          '/// + Throw a warning if there wasn't a MsgBox
             warnlog "A warning to enter a URL for redirection was expected -> Check it out!"
          endif
          catch
          endcatch
        '/// Check if we are still on tab 'Internet' (expected)
        Kontext "TabInternet"
        if TabInternet.exists(2) then
           printlog "Staying on tab 'internet' as expected"
        else
           warnlog "Changing the tabpage shouldn't happen here!"
           Kontext  
           active.SetPage TabInternet
        endif
        '/// Continue test of tab Internet
        Kontext "TabInternet"
        '/// Click browse button
        BrowseURL.Click
        '/// (File open dialog should be visible now)
        Kontext "OeffnenDlg"
          '/// Check if dialog exists
          Call DialogTest ( OeffnenDlg )
          '/// Cancel dialog
          OeffnenDlg.Cancel
          '/// Select bottom entry (should be #5) of 'Frame' listbox
        Kontext "TabInternet"
        frame.select(5)
        '/// Cancel dialog
        TabInternet.Cancel        
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileTemplatesOrganize 
    '/// Open new document
    Call  hNewDocument
    '/// File::Templates::Organize...
    FileTemplatesOrganize
    Kontext "DVVerwalten"
    '/// Check existence of template dialog
      Call DialogTest (DVVerwalten)
      '/// Move one up in right list
      ListeRechts.Typekeys("<UP>")
      '/// Click 'File...' button
      WelcheDatei.Click
      '/// Check existence of file open dialog
      Kontext "OeffnenDLG"
        Call Dialogtest (OeffnenDlg)
        '/// Cancel File open dialog
        OeffnenDLG.Cancel
        '/// Close template dialog
      Kontext "DVVerwalten"
        DVVerwalten.Close
    '/// Close document
    Call hCloseDocument    
endcase
'
'-----------------------------------------------------------
'
testcase tFilePagepreview
    '/// Open new document
    Call hNewDocument
    sleep(2)
    '/// Add random content to obtain at least one page of output
    Call hTypeKeys ( "13<Return>" )
    '/// File::Page preview...
    try 
        FilePageView
    catch
        warnlog "#i44073# - Page preview crashes under certain circumstances"
        goto endsub
    endcatch
    Kontext "Previewbar"
    '/// Close page previes with button in toolbar
      Seitenansicht.Click
    '/// Close document
    Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFilePrint 
    '/// Open new document
    Call  hNewDocument
    '/// File::Print...
    FilePrint
    '/// Look for warning regarding missing printer configured first
    '/// -> If configuration is missing only this MsgBox is tested
    Kontext
      if Active.Exists(2) then
         if Active.GetRT = 304 then
            printlog Active.GetText
            QAErrorLog "No printer is configured for this system"
            Active.OK
            Kontext "DruckenDLG"
            DruckenDLG.Cancel            
         end if
      else
         Kontext "DruckenDLG"
         '/// Check existence of print dilaog
           call DialogTest ( DruckenDLG )
         '/// Invoke the print options dialog
         Kontext "DruckenDLG"
           Zusaetze.Click
           Kontext "TabPrintCalcOptions"
           '/// Check existence of print options dilaog
             call DialogTest ( TabPrintCalcOptions )
             '/// Cancel print options dialog
             TabPrintCalcOptions.Cancel
         '/// Check option 'Print to file'         
         Kontext "DruckenDLG"
           AusdruckInDatei.check
           '/// Commit print dilaog
           DruckenDLG.OK
           '/// (Save file dialog should be visible now)
           Kontext "SpeichernDLG"
           '/// Check existence of save dilaog
             call DialogTest ( SpeichernDLG )
             '/// Cancel save dialog
             SpeichernDLG.Cancel
      end if      
    '/// Close document
    Call hCloseDocument    
endcase
'
'-----------------------------------------------------------
'
testcase tFilePrinterSettings
    '/// Open new document
    Call  hNewDocument
    '/// File::Printer Settings...
    FilePrintersettings
    '/// Catch MsgBox in case no printer is configured on system (test exits)
    Kontext
      if Active.Exists(2) then
         if Active.GetRT = 304 then
            printlog Active.GetText
            QAErrorLog "No printer is configured for this system"
            Active.OK
            Kontext "DruckerEinrichten"
            DruckerEinrichten.Cancel
         end if
      else
      '/// Else Check existence of printer settings dilaog (default behaviour)
         Kontext "DruckerEinrichten"
         Call DialogTest ( DruckerEinrichten )
         '/// Cancel printer settings
         DruckerEinrichten.Cancel
      end if
      '/// Close document
    Call hCloseDocument    
endcase
'
'-----------------------------------------------------------
'
testcase tFileExit
    '/// Open new document
    call hNewDocument
    sleep(2)
    Kontext "DocumentCalc"
    '/// Add random content
      DocumentCalc.typekeys ("Bye<RETURN>")
      '/// File::Exit
      FileExit
      '/// Close to files (discard MsgBoxes) on the way
      try
         Kontext "Active"
           if active.exists then
              printlog active.GetText
              active.no
              Kontext "Active"
                if active.exists then
                   printlog active.GetText
                   active.no
                end if
           else
              Warnlog "The modified document was closed without warning"
              FileClose
              Kontext "Active"
              if active.exists then active.no
           end if
      catch
      endcatch
      sleep(3)      
    '/// Restart OOo
    call hStartTheOffice
endcase

