'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_tools_statistics.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsi $ $Date: 2008/02/18 14:01:46 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Tool library for Statistics dialog
'*
'**************************************************************************************************
'*
' #1 fInvokeStatisticsDialog
' #1 fCloseStatisticsDialogOK
' #1 fSetMeanValue
' #1 fSetErrorCategory
' #1 fSetErrorValue
' #1 fSetErrorIndicatorItem
' #1 fSetRegressionCurvesItem
'*
'\************************************************************************************************

' ch_tools_statistics.inc - Library for automation of the 'Insert::Statistics...' dialog
' This Include contains a set of functions to modify the controls of the Statistics dialog.
' All functions are designed to return error-codes depending on the behaviour of the action applied.
' Return codes:
' Error 0: Success.
' Error 1: The basic action beeing applied caused a serious problem, e.g. a crash.
' Error 2 TO 9: A functional problem occured.
' Error 11 TO 19: Wrong marginal conditions end up in failture, e.g. control not visible.
' NOTE: This errors can also be used for 'negative' testing.
' Error 42: Wrong input. Probably only of interest during test development.
' Error 99: Unexpected behaviour - Shouldn't normally occur.
' ATTENTION:
' Only Errors 42 and 99 throw 'warnlogs'.
' All other errors are silent.
' They only throw QAErrorlogs the give a hint what probably went wrong.
' Expected Errors MUST exclusivly be handled by the calling routine.
'
'--------------------------------------------------------------------
'
function fInvokeStatisticsDialog() as INTEGER
         fInvokeStatisticsDialog = 99
' Function to invoke the 'Insert::Statistics...' dialog
' No Input
' Returns error-code:
' 0 := Sucess
' 1 := Serious problem trying to invoke the dialog
' 2 := Failure (Dialog not present after invocation)
'99 := Unexpected error
    
    printlog "** Invoking 'Insert::Statistics...' in menu"
    '/// Execute menu item 'Insert::Statistics...'
    try 
        InsertStatistics
    catch
        qaErrorLog "Error 1: Invoking menu item 'Insert::Statistics...' failed"
        fInvokeStatisticsDialog = 1
        exit function
    endcatch
    
    '/// Lookup if call was successful
    Kontext "InsertStatisticsDialog"
    if InsertStatisticsDialog.exists(2) then
        printlog ">> Statistics dialog is visible now."
        fInvokeStatisticsDialog = 0
    else
        qaErrorLog "Error 2: OOPS, calling the slot 'InsertStatistics' didn't cause any problem ..."
        qaErrorLog "..., BUT the dialog doesn't seem to be visible"
        fInvokeStatisticsDialog = 2
    endif

    if fInvokeStatisticsDialog = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif    
end function
'
'--------------------------------------------------------------------
'
function fCloseStatisticsDialogOK() as INTEGER
         fCloseStatisticsDialogOK = 99
' Function to close the Statistics dialog using OK button
' No Input
' Returns error-code:
' 0 := Sucess
' 1 := Serious problem trying to Close the dialog
' 2 := Failure (Dialog present after applying OK button)
'15 := Dialog not present before closing
'99 := Unexpected error   
    printlog "** Closing Statistics dialog"
    Kontext "InsertStatisticsDialog"
    '/// Check existence of Statistics dialog
    if InsertStatisticsDialog.exists(2) then
        printlog ">> Statistics dialog is visible as expected."
    else
        ' Return Error 15 and quit if dialog not found
        qaErrorLog "Error 15: OOPS, Statistics dialog should be visible ..."
        qaErrorLog "... this is a BUG or a scripting error -> Check this out!"
        fCloseStatisticsDialogOK = 15
        exit function
    endif
    '/// Click OK button in Statistics dialog
    try 
        InsertStatisticsDialog.OK
    catch
        qaErrorLog "Error 1: Closing the Statistics dialog seems to have a serious problem -> Check this out!"
        fCloseStatisticsDialogOK = 1
        exit function
    endcatch
    '/// Check existence of Statistics dialog
    Kontext "InsertStatisticsDialog"
    if InsertStatisticsDialog.exists(2) then
        ' Return Error 2 if still present
        qaErrorLog "Error 2: Statistics dialog should be invisible now ..."
        qaErrorLog "... closing the dialog doesn't seem to work -> Check this out!"
        fCloseStatisticsDialogOK = 2
    else
        printlog ">> Closing the Statistics dialog seems to work as expected"
        fCloseStatisticsDialogOK = 0
    endif
    
    if fCloseStatisticsDialogOK = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif
end function
'
'--------------------------------------------------------------------
'
function fSetMeanValue ( bSetMeanValue as BOOLEAN ) as INTEGER
         fSetMeanValue = 99
' Function to [en|dis]able 'Mean Value' option chart Statistics
' Input:
' BOOLEAN bSetMeanValue
' TRUE := Check 'Mean Value' 
' FALSE := Uncheck 'Mean Value'
' Returns error-code:
' 0 := Sucess
' 1 := Serious problem trying to check grid
' 2 := 'Mean Value' was not set
'11 := 'Mean Value' Check-box is not visible
'99 := Unexpected error
    printlog "** Setting Mean Value"
    '/// Check if 'Mean Value' check-box is visible
    Kontext "InsertStatisticsDialog"
    if NOT MeanValue.IsVisible then
        qaErrorLog "Error 11: Check-box for 'Mean Value' is not visible"
        qaErrorLog "... BUG or Script problem -> Check this out!"
        fSetMeanValue = 11
        exit function
    endif
    '/// Try to (Un)Check 'Mean Value'
    Kontext "InsertStatisticsDialog"
    try 
        if bSetMeanValue then
            MeanValue.Check
        else
            MeanValue.UnCheck
        endif
    catch
        ' Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Check 'Mean Value' seems to cause a serious problem -> Check this out!"
        fSetMeanValue = 1
        exit function
    endcatch
    '/// Verify (against input) if check-box was checked
    if MeanValue.IsChecked = bSetMeanValue then
        fSetMeanValue = 0
        printlog ">> Setting 'Mean Value' seems to work"
    else
        qaErrorLog "Error 2: 'Mean Value' was not checked -> Check this out!"
        fSetMeanValue = 2
    endif

    if fSetMeanValue = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif   
end function
'
'--------------------------------------------------------------------
'
function fSetErrorCategory ( oErrorCategory as OBJECT ) as INTEGER
         fSetErrorCategory = 99
' Function to select 'Error Category'
' Input:
' OBJECT oErrorCategory
' Declaration name of Radio-Button (valid values):
' - NoFunction
' - Variance<
' - StandardDeviation
' - Percentage 
' - ErrorMargin
' - ConstantValue
' Returns error-code:
' 0 := Sucess
' 1 := Serious problem trying to check 'Error Category' radio-button
' 2 := 'Error Category' radio-button was not set
'12 := Radio-Button for desired 'Error Category' is not enabled
'42 := User error, input doesn't match.
'99 := Unexpected error
    printlog "** Setting 'Error Category'"
    '/// Check if desired 'Error Category' radio-button is enabled
    Kontext "InsertStatisticsDialog"
    if NOT oErrorCategory.IsEnabled then
        qaErrorLog "Error 12: Radio-Button for desired 'Error Category' is not enabled"
        qaErrorLog "... BUG or Script problem -> Check this out!"
        fSetErrorCategory = 12
        exit function
    endif
    '/// Try to check desired 'Error Category'
    Kontext "InsertStatisticsDialog"
    try 
        oErrorCategory.Check
    catch
        ' Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Check 'Error Category' radio-button seems to cause a serious problem -> Check this out!"
        fSetErrorCategory = 1
        exit function
    endcatch
    '/// Verify (against input) if 'Error Category' radio-button was checked
    if oErrorCategory.IsChecked then
        fSetErrorCategory = 0
        printlog ">> Setting 'Error Category' radio-button seems to work"
    else
        qaErrorLog "Error 2: Desires 'Error Category' radio-button was not checked -> Check this out!"
        fSetErrorCategory = 2
    endif

    if fSetErrorCategory = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif  
end function
'
'--------------------------------------------------------------------
'
function fSetErrorValue ( oErrorValue as OBJECT , _
                          sErrorValue as STRING , _
                          OPTIONAL bCheckResult as BOOLEAN , _
                          OPTIONAL sExpectedValue as STRING ) as INTEGER
         fSetErrorValue = 99
' Function to set 'Error Value'
' Input:
' OBJECT oErrorValue
' Declaration name of Spin-Field (valid values):
' - PercentageValue
' - ErrorMarginValue
' - ConstantValuePlus
' - ConstantValueMinus
' - STRING (numeric) sErrorValue
' - Value to assign to Spin-Field
' Returns error-code:
' 0 := Sucess
' 1 := Serious problem trying to check 'Error Value' Spin-Field
' 2 := 'Error Value' Spin-Field was not set
'12 := Spin-Field for desired 'Error Value' is not enabled
'42 := User error, input doesn't match.
'99 := Unexpected error
    if isMissing ( bCheckResult ) then
        bCheckResult = FALSE
    endif
    if isMissing ( sExpectedValue ) then
        sExpectedValue = sErrorValue
    endif
    printlog ""
    printlog "** Setting 'Error Value'"
    '/// Check if desired 'Error Value' Spin-Field is enabled
    Kontext "InsertStatisticsDialog"
    if NOT oErrorValue.IsEnabled then
        qaErrorLog "Error 12: Spin-Field for desired 'Error Value' is not enabled"
        qaErrorLog "... BUG or Script problem -> Check this out!"
        fSetErrorValue = 12
        exit function
    endif
    '/// Try to set desired 'Error Value'
    Kontext "InsertStatisticsDialog"
    try 
        oErrorValue.setText ( sErrorValue )
    catch
        ' Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Setting 'Error Value' Spin-Field seems to cause a serious problem -> Check this out!"
        fSetErrorValue = 1
        exit function
    endcatch
    '/// Verify (against input) if 'Error Value' Spin-Field was set correctly
    if bCheckResult then
        if oErrorValue.getText = sExpectedValue then
            fSetErrorValue = 0
            printlog ">> Setting 'Error Value' Spin-Field seems to work"
        else
            qaErrorLog "Error 2: Desires 'Error Value' Spin-Field was not set correctly (value out of range?) -> Check this out!"
            qaErrorLog "Expected result: " & sExpectedValue
            qaErrorLog "Obtained result: " & oErrorValue.getText
            fSetErrorValue = 2
        endif
    else
        fSetErrorValue = 0
        qaErrorLog "!! Skipped verification of result"
    endif

    if fSetErrorValue = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif   
end function
'
'--------------------------------------------------------------------
'
function fSetErrorIndicatorItem ( iErrorIndicatorNumber as INTEGER ) as INTEGER
         fSetErrorIndicatorItem = 99
' Function to select the 'Error Indicator' item
' Input:
' INTEGER iErrorIndicatorNumber:
' Position in 'Error Indicator' control.
' Posible Values are 1 to 4
' NOTE: Currently the 'Error Indicator' control can only be addressed using 'typekeys'.
' -> No 100% proof verification of success possible!
' Returns error-code:
' 0 := Sucess.
' 1 := Serious problem while selecting the variant control.
'11 := 'Error Indicator' is not visible
'42 := User error, input out of range.
'99 := Unexpected error. 
    '/// Check if 'Error Indicator' is visible
    Kontext "InsertStatisticsDialog"
    if NOT ErrorIndicator.IsVisible then
        qaErrorLog "Error 11: 'Error Indicator' is not visible"
        qaErrorLog "... BUG or Script problem -> Check this out!"
        fSetErrorIndicatorItem = 11
        exit function
    endif
    '/// Lookup valid input value for 'Error Indicator Item'
    if ( iErrorIndicatorNumber < 1 ) OR ( iErrorIndicatorNumber > 4 ) then
         fSetErrorIndicatorItem = 42
         warnlog "USER ERROR: Input doesn't match!"
         exit function
    endif   
    printlog "** Selecting the 'Error Indicator'"
    '/// Select the desired entry number
    Kontext "InsertStatisticsDialog"
    try 
        ErrorIndicator.typeKeys "<HOME>"
        ErrorIndicator.typeKeys "<RIGHT>", ( iErrorIndicatorNumber - 1 )
        fSetErrorIndicatorItem = 0
        printlog ">> Selecting the 'Error Indicator' probably worked"
    catch
        ' Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Selecting 'Error Indicator' seems to cause a serious problem -> Check this out!"
        fSetErrorIndicatorItem = 1
        exit function
    endcatch
    
    if fSetErrorIndicatorItem = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif   
end function
'
'--------------------------------------------------------------------
'
function fSetRegressionCurvesItem ( iRegressionCurveNumber as INTEGER ) as INTEGER
         fSetRegressionCurvesItem = 99
' Function to select the 'Regression Curves' item
' Input:
' INTEGER iRegressionCurveNumber:
' Position in 'Regression Curves' control.
' Posible Values are 1 to 5
' NOTE: Currently the 'Regression Curves' control can only be addressed using 'typekeys'.
' -> No 100% proof verification of success possible!
' Returns error-code:
' 0 := Sucess.
' 1 := Serious problem while selecting the variant control.
'11 := 'Regression Curves' is not visible
'42 := User error, input out of range.
'99 := Unexpected error.
    ' Check if 'Regression Curves' is visible
    Kontext "InsertStatisticsDialog"
    if NOT RegressionCurves.IsVisible then
        qaErrorLog "Error 11: 'Regression Curves' is not visible"
        qaErrorLog "... BUG or Script problem -> Check this out!"
        fSetRegressionCurvesItem = 11
        exit function
    endif
    '/// Lookup valid input value for 'Regression Curves Item'
    if ( iRegressionCurveNumber < 1 ) OR ( iRegressionCurveNumber > 5 ) then
         fSetRegressionCurvesItem = 42
         warnlog "USER ERROR: Input doesn't match!"
         exit function
    endif        
    printlog "** Selecting the 'Regression Curves'"
    '/// Select the desired entry number
    Kontext "InsertStatisticsDialog"
    try 
        RegressionCurves.typeKeys "<HOME>"
        RegressionCurves.typeKeys "<RIGHT>", ( iRegressionCurveNumber - 1 )
        fSetRegressionCurvesItem = 0
        printlog ">> Selecting the 'Regression Curves' probably worked"
    catch
        ' Throw error 1 and quit on serious problem
        qaErrorLog "Error 1: Selecting 'Regression Curves' seems to cause a serious problem -> Check this out!"
        fSetRegressionCurvesItem = 1
        exit function
    endcatch
    
    if fSetRegressionCurvesItem = 99 then
        warnlog "Error 99: Something unexpected happened!!"
    endif   
end function

