'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch2_flexible_source_range_selection.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsi $ $Date: 2007/06/28 10:55:44 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/***********************************************************************
'*
'* owner : oliver.craemer@sun.com
'*
'* short description : Updatetest for Flexible Source Range Selection in Calc
'*
'************************************************************************
'*
' #1 tDataRangeWizardCalc     ' Updatetest for tabpage DataRange via chart wizard in Calc
' #1 tDataSeriesWizardCalc    ' Updatetest for tabpage DataSeries via chart wizard in Calc
' #1 tDataRangeDialogCalc     ' Updatetest for tabpage DataRange via data ranges dialog in Calc
' #1 tDataSeriesDialogCalc    ' Updatetest for tabpage DataSeries via data ranges dialog in Calc
'*
'\***********************************************************************

testcase tDataRangeWizardCalc

    dim sDataRange as string
    dim sInputFile as string
    sInputFile = convertpath ( gtesttoolpath & "chart2/update/input/ch_flexrange01.ods" )

    '///Open test document ch_flexrange01.ods
    printlog "Open test document ch_flexrange01.ods"
    call hDateiOeffnen sInputFile
    sleep(2)
        
    '///Move cursor to datarange
    printlog "Move cursor to datarange"
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 HOME><RIGHT><RIGHT><DOWN><DOWN><DOWN>"
    
    '///Menu Insert chart to open chart wizard
    printlog "Menu Insert chart to open chart wizard"
    InsertChart
    sleep(5)
    Kontext "ChartType"
    
    '///Choose the Chart type <i>bar</i> (should be the second in the top-down list)
    printlog "Choose the Chart type <i>bar</i> (should be the second in the top-down list)"
    if fSetChartType( "bar" ) > 0 then
        warnlog "Something went wrong setting chart type to BAR."
        warnlog "Testcase aborted"
        Kontext "ChartWizard"
        ChartWizard.Cancel
        call hCloseDocument
        goto endsub
    endif
    
    '///Switch to tabpage Data Range
    printlog "Switch to tabpage Data Range"
    Kontext "ChartWizard"
    GoNext.Click
        
    printlog "Dialogtest"
    Kontext "TabChartTypeDataRange"
    call DialogTest ( TabChartTypeDataRange )
    
    '///Check data range in edit field
    printlog "Check data range in edit field"
    Kontext "TabChartTypeDataRange"
    sDataRange = DataRange.GetText
    if sDataRange <> "$ChartFlexRange.$B$3:$E$6" then
        warnlog "This is not the expected datarange, it is " & sDataRange & " but should be $ChartFlexRange.$B$3:$E$6" 
    else
        printlog "    Datarange is correct"
    endif
    
    '///Check if -Data series in rows- is enabled
    printlog "Check if -Data series in rows- is enabled"
    if Rows.IsEnabled then
        printlog "    Data series in rows is enabled" 
    else
        warnlog "Data series in rows is disabled"
    endif
            
    '///Check if -Data series in columns- is enabled and chosen
    printlog "Check if -Data series in columns- is enabled and chosen"
    if Columns.IsEnabled then
        printlog "    Data series in columns is enabled"
        if Columns.IsChecked then
            printlog "        and checked"
        else
            warnlog "Data series in columns is not checked"
        endif
    else
        warnlog "Data series in columns is disabled"
    endif
    
    '///Check if -First row as label- is enabled and checked
    printlog "Check if -First row as label- is enabled and checked"
    if FirstRowAsLabel.IsEnabled then
        printlog "    First row as label is enabled"
        if FirstRowAsLabel.IsChecked then
            printlog "        and checked"        
        else
            warnlog "First row as label is not checked"
        endif
    else
        warnlog "First row as label is disabled"
    endif
    
    '///Check if -First column as label- is enabled and not checked
    printlog "Check if -First column as label- is enabled and not checked"
    if FirstColumnAsLabel.IsEnabled then
        printlog "    First column as label is enabled"
        if FirstColumnAsLabel.IsChecked then
            warnlog "First column as label is checked"
        else
            printlog "        and not checked"
        endif
    else
        warnlog "First column as label is disabled"
    endif
    
    '///Press button Range Chooser
    printlog "Press button Range Chooser"
    SelectDataRange.Click
    
    '///Enter an invalid range and close Range Chooser
    printlog "Enter an invalid range and close Range Chooser"    
    Kontext "AcceptOrRejectChangesArea"
    AreaEditField.SetText "$ChartFlexRange.$B$3:$E$0"
    ShrinkButton.Click    

    '///Check if -Data series in rows- is disabled
    printlog "Check if -Data series in rows- is disabled"
    Kontext "TabChartTypeDataRange"
    if NOT Rows.IsEnabled then
        printlog "    Data series in rows is disabled" 
    else
        warnlog "Data series in rows is enabled, but should be disabled"
    endif
    
    '///Check if -Data series in columns- is disabled
    printlog "Check if -Data series in columns- is disabled"
    if NOT Columns.IsEnabled then
        printlog "    Data series in columns is disabled" 
    else
        warnlog "Data series in columns is enabled, but should be disabled"
    endif
    
    '///Check if -First row as label- is disabled
    printlog "Check if -First row as label- is disabled"
    if NOT FirstRowAsLabel.IsEnabled then
        printlog "    First row as label is disabled" 
    else
        warnlog "First row as label is enabled, but should be disabled"
    endif
    
    '///Check if -First column as label- is disabled
    printlog "Check if -First column as label- is disabled"
    if NOT FirstColumnAsLabel.IsEnabled then
        printlog "    First Column as label is disabled" 
    else
        warnlog "First Column as label is enabled, but should be disabled"
    endif
    
    '///Check if Back, Next and Finish does not work
    printlog "Check if Back, Next and Finish does not work"
    Kontext "ChartWizard"
    GoBack.Click
    Kontext "TabChartTypeDataRange"
    if FirstColumnAsLabel.IsVisible then
        printlog "    Success: Back button does not work"
    else
        warnlog "Back button is not functionless"
        Kontext "ChartWizard"
        GoNext.Click
    endif
        
    '///Enter a valid range
    printlog "Enter a valid range"
    Kontext "TabChartTypeDataRange"
    DataRange.SetText sDataRange
    
    '///Check if -Data series in rows- is enabled
    printlog "Check if -Data series in rows- is enabled"
    if Rows.IsEnabled then
        printlog "    Data series in rows is enabled" 
    else
        warnlog "Data series in rows is disabled"
    endif
            
    '///Check if -Data series in columns- is enabled and chosen
    printlog "Check if -Data series in columns- is enabled and chosen"
    if Columns.IsEnabled then
        printlog "    Data series in columns is enabled"
        if Columns.IsChecked then
            printlog "        and checked"
        else
            warnlog "Data series in columns is not checked"
        endif
    else
        warnlog "Data series in rows is disabled"
    endif
    
    '///Check if -First row as label- is enabled and checked
    printlog "Check if -First row as label- is enabled and checked"
    if FirstRowAsLabel.IsEnabled then
        printlog "    First row as label is enabled"
        if FirstRowAsLabel.IsChecked then
            printlog "        and checked"        
        else
            warnlog "First row as label is not checked"
        endif
    else
        warnlog "First row as label is disabled"
    endif
    
    '///Check if -First column as label- is enabled and not checked
    printlog "Check if -First column as label- is enabled and not checked"
    if FirstColumnAsLabel.IsEnabled then
        printlog "    First column as label is enabled"
        if FirstColumnAsLabel.IsChecked then
            warnlog "First column as label is checked"
        else
            printlog "        and not checked"
        endif
    else
        warnlog "First column as label is disabled"
    endif
    
    '///Press Cancel button
    printlog "Press Cancel button"
    Kontext "ChartWizard"
    ChartWizard.Cancel
    
    '///Close document
    printlog "Close document"
    Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataSeriesWizardCalc

    dim sInputFile as string
    dim iDataSeries as integer
    dim sDataRanges as string
    dim sRangeFor as string
    dim sCategories as string
    sInputFile = convertpath ( gtesttoolpath & "chart2/update/input/ch_flexrange02.ods" )

    '///Open test document ch_flexrange02.ods
    printlog "Open test document ch_flexrange02.ods"
    call hDateiOeffnen sInputFile
    sleep(2)
        
    '///Move cursor to datarange
    printlog "Move cursor to datarange"
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 HOME><RIGHT><RIGHT><DOWN><DOWN><DOWN>"
    
    '///Menu Insert chart to open chart wizard
    printlog "Menu Insert chart to open chart wizard"
    InsertChart
    sleep(5)
    
    '///Choose the Chart type <i>XY (SCATTER)</i>
    Kontext "ChartType"
    printlog "Choose the Chart type <i>XY (SCATTER)</i> (should be the second in the top-down list)"
    if fSetChartType( "xy" ) > 0 then
        warnlog "Something went wrong setting chart type to XY (SCATTER)."
        warnlog "Testcase aborted"
        Kontext "ChartWizard"
        ChartWizard.Cancel
        call hCloseDocument
        goto endsub
    endif
    
    '///Switch to tabpage Data Series
    printlog "Switch to tabpage Data Range"
    Kontext "ChartWizard"
    GoNext.Click
    GoNext.Click
    Kontext "TabChartTypeDataSeries"
    if RangeFor.IsVisible then
        printlog "    Switching to tabpage was successfull"
    else
        warnlog "Switching to tabpage Data Series was not successfull"
        goto endsub
    endif
    
    printlog "Dialogtest"
    call DialogTest ( TabChartTypeDataSeries )    
    
    '///Check if the data series listbox is enabled and contains 3 entries
    printlog "Check if the data series listbox is enabled and contains 3 entries"
    iDataSeries = DataSeries.GetItemCount
    if iDataSeries = 3 then
        printlog "    All 3 data series are available"
    else
        warnlog "There are " & iDataSeries & " data series instead of 3"
    endif
    
    '///Check if the ADD button is enabled and click the button
    printlog "Check if the ADD button is enabled and click the button"
    if AddButton.IsEnabled then
        printlog "    ADD button is enabled"
        AddButton.Click
    else
        warnlog "ADD button is not enabled"
    endif
        
    '///Check if there are now 4 entries in the data series listbox
    printlog "Check if there are now 4 entries in the data series listbox"
    iDataSeries = DataSeries.GetItemCount
    if iDataSeries = 4 then
        printlog "    Adding a data series was successfull"
    else
        warnlog "There are " & iDataSeries & " data series instead of 4"
    endif
    
    '///Check if the new data series was added below the highlighted one
    printlog "Check if the new data series was added below the highlighted one"
    if DataSeries.GetSelIndex = 2 then
        printlog "    The new data series was inserted below the highlighted (first) one"
    else
        warnlog "The new dataseries was not inserted below the highlighted one"
    endif
    
    '///Check if the REMOVE button is enabled and click the button
    printlog "Check if the REMOVE button is enabled and click the button"
    if RemoveButton.IsEnabled then
        printlog "    REMOVE button is enabled"
        RemoveButton.Click
    else
        warnlog "REMOVE button is not enabled"
    endif
    
    '///Check if there are now 3 entries in the data series listbox
    printlog "Check if there are now 3 entries in the data series listbox"
    iDataSeries = DataSeries.GetItemCount
    if iDataSeries = 3 then
        printlog "    Removing a data series was successfull"
    else
        warnlog "There are " & iDataSeries & " data series instead of 3"
    endif
    
    '///Use UP button and verify that it it disabled on first entry
    printlog "Use UP button on last data series and verify that it it disabled on first entry"
    DataSeries.Select 3
    if MoveUp.IsEnabled then
        printlog "    The MoveUp button is enabled"
        MoveUp.Click
        MoveUp.Click
    else
        warnlog "The MoveUp button is disabled"
    endif
    if DataSeries.GetSelIndex = 1 then
        printlog "    Moving data series was successfull"
        if MoveUp.IsEnabled then
            warnlog "MoveUp button is not disabled on first entry"
        else
            printlog "        and MoveUp button is disabled on first enty"
        endif
    else
        warnlog "Moving data series was not successfull"
    endif
    
    '///Use DOWN button and verify that it is disabled on last entry
    printlog "Use DOWN button and verify that it is disabled on last entry"
    DataSeries.Select 1
    if MoveDown.IsEnabled then
        printlog "    The MoveDown button is enabled"
        MoveDown.Click
        MoveDown.Click
    else
        warnlog "The MoveDown button is disabled"
    endif
    if DataSeries.GetSelIndex = 3 then
        printlog "    Moving data series was successfull"
        if MoveDown.IsEnabled then
            warnlog "MoveDown button is not disabled on first entry"
        else
            printlog "        and MoveDown button is disabled on first enty"
        endif
    else
        warnlog "Moving data series was not successfull"
    endif
    
    '///Select first entry in Data Ranges
    printlog "Select first entry in Data Ranges"
    DataRanges.Select 1

'works only with testtool >= gh13
    '///Verify that the range matches the one in edit field
'    printlog "Verify that the range matches the one in edit field"
'    sDataRanges = DataRanges.GetSelText (1,3)
'    sRangeFor = RangeFor.GetText
'    if sDataRanges = sRangeFor then
'        printlog "    Both ranges are matching"
'    else
'        warnlog "The ranges does not match: " & sDataRanges & sRangeFor
'    endif
    
    '///Select second entry in Data Ranges
    printlog "Select second entry in Data Ranges"
    DataRanges.Select 2
    
    '///Check that the range in the edit field has changed too
    printlog "Check that the range in the edit field has changed too"
'works only with testtool >= gh13
'    sDataRanges = DataRanges.GetSelText (1,3)
'    sRangeFor = RangeFor.GetText
'    if sDataRanges = sRangeFor then
'        printlog "    Both ranges are matching"
'    else
'        warnlog "The ranges does not match" & sDataRanges & sRangeFor
'    endif
    
    '///Change the range in edit field
    printlog "Change the range in edit field"
    RangeFor.SetText "$ChartFlexRange.$D$5:$D$6;$ChartFlexRange.$D$8"
    
'works only with testtool >= gh13
    '///Check that the range in Data Ranges has changed too
    printlog "Check that the range in Data Ranges has changed too"
'    sDataRanges = DataRanges.GetSelText (1,3)
'    if sDataRanges = "$ChartFlexRange.$D$5:$D$6;$ChartFlexRange.$D$8" then
'       printlog "    The data range has also changed"
'    else
'        warnlog "The data range has not changed"
'    endif
    
    '///Click on Range Chooser and change the range
    printlog "Click on Range Chooser and change the range"
    SelectRange.Click
    Kontext "AcceptOrRejectChangesArea"
    AreaEditField.SetText "$ChartFlexRange.$D$5:$D$6"
    ShrinkButton.Click
    
'works only with testtool >= gh13
    '///Check if the range in the Data ranges has changed
    printlog "Check if the range in Data ranges has changed"
    Kontext "TabChartTypeDataSeries"
'    sDataRanges = DataRanges.GetSelText (1,3)
'    if sDataRanges = "$ChartFlexRange.$D$5:$D$6" then
'       printlog "    The data range has also changed"
'    else
'        warnlog "The data range has not changed"
'    endif
    
    '///Edit range for Data Labels
    printlog "Edit range for Data Labels"
    Categories.SetText "$ChartFlexRange.$C$15:$C$16"
    sCategories = Categories.GetText
    if sCategories = "$ChartFlexRange.$C$15:$C$16" then
        printlog "    The range has been modified"
    else
        warnlog "Modifiing the range was not successfull"
    endif
    
    '///Click on Range Chooser and change the range
    printlog "Click on Range Chooser and change the range"
    SelectCategories.Click
    Kontext "AcceptOrRejectChangesArea"
    AreaEditField.SetText "$ChartFlexRange.$C$5:$C$6"
    ShrinkButton.Click
    
    '///Verify that the range is taken
    printlog "Verify that the range is taken"
    Kontext "TabChartTypeDataSeries"
    sCategories = Categories.GetText
    if sCategories = "$ChartFlexRange.$C$5:$C$6" then
        printlog "    The range has been modified"
    else
        warnlog "Modifiing the range was not successfull"
    endif
    
    '///Enter an invalid range
    printlog "Enter an invalid range"
    Categories.SetText "$ChartFlexRange.$C$5:$C$"
    
    '///Check that the BACK button does not work
    printlog "Check that the BACK button does not work"
    Kontext "ChartWizard"
    GoBack.Click
    Kontext "TabChartTypeDataSeries"
    if Categories.IsVisible then
        printlog "    Success: Back button does not work"
    else
        warnlog "Back button is not functionless"
        Kontext "ChartWizard"
        GoNext.Click
    endif
    
    '///Enter a valid range
    printlog "Enter a valid range"
    Categories.SetText "$ChartFlexRange.$C$5:$C$6"
    
    '///Press Range Chooser for Data Lables
    printlog "Press Range Chooser"
    SelectCategories.Click
    
    '///Move cursor to the end
    printlog "Move cursor to the end"
    Kontext "AcceptOrRejectChangesArea"
    AreaEditField.TypeKeys "<END>"
    
    '///Enter a semicolon and a second range
    printlog "Enter a semicolon and a second range"
    AreaEditField.TypeKeys ";$ChartFlexRange.$C$8"
    
    '///Close Range Chooser
    printlog "Close Range Chooser"
    ShrinkButton.Click
    
    '///Verify that there is a multiple range
    printlog "Verify that there is a multiple range"
    Kontext "TabChartTypeDataSeries"
    sCategories = Categories.GetText
    if sCategories = "$ChartFlexRange.$C$5:$C$6;$ChartFlexRange.$C$8" then
        printlog "    The range has been modified to a multiple range"
    else
        warnlog "Modifiing the range was not successfull"
    endif
    
    '///Press Cancel button
    printlog "Press Cancel button"
    Kontext "ChartWizard"
    ChartWizard.Cancel
    
    '///Close document
    printlog "Close document"
    Call hCloseDocument


endcase

'-------------------------------------------------------------------------

testcase tDataRangeDialogCalc

    dim sDataRange as string
    dim sInputFile as string
    sInputFile = convertpath ( gtesttoolpath & "chart2/update/input/ch_flexrange03.ods" )

    '///Open test document ch_flexrange03.ods
    printlog "Open test document ch_flexrange03.ods"
    call hDateiOeffnen sInputFile
    sleep(2)
    
    '/// Select chart using navigator
    printlog "Select chart using navigator"

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<UP><DOWN>"
    call fSelectFirstOLE
    
    '/// Edit / Object / Edit
    printlog "Edit / Object / Edit"
    EditObjectEdit
    
    '///Open FORMAT / DATA RANGES
    printlog "Open FORMAT / DATA RANGES"
    FormatDataRanges
    
    '///Switch to tabpage Data Range
    printlog "Switch to tabpage Data Range"
    Kontext
    active.SetPage TabChartTypeDataSeries   'Switching tabpages as workaround for #i77237#
    active.SetPage TabChartTypeDataRange
    
    '///Dialogtest
    printlog "Dialogtest"
    Kontext "TabChartTypeDataRange"
    call DialogTest ( TabChartTypeDataRange )
    
    '///Check data range in edit field
    printlog "Check data range in edit field"
    Kontext "TabChartTypeDataRange"
    sDataRange = DataRange.GetText
    if sDataRange <> "$ChartFlexRange.$D$4:$G$6;$ChartFlexRange.$C$5:$G$6;$ChartFlexRange.$C$4" then
        warnlog "This is not the expected datarange, it is " & sDataRange & " but should be $ChartFlexRange.$D$4:$G$6;$ChartFlexRange.$C$5:$G$6;$ChartFlexRange.$C$4" 
    else
        printlog "    Datarange is correct"
    endif
    
    '///Check if -Data series in columns- is enabled
    printlog "Check if -Data series in columns- is enabled"
    if Columns.IsEnabled then
        printlog "    Data series in columns is enabled" 
    else
        warnlog "Data series in columns is disabled"
    endif
            
    '///Check if -Data series in rows- is enabled and chosen
    printlog "Check if -Data series in columns- is enabled and chosen"
    if Rows.IsEnabled then
        printlog "    Data series in rows is enabled"
        if rows.IsChecked then
            printlog "        and checked"
        else
            warnlog "Data series in rows is not checked"
        endif
    else
        warnlog "Data series in rows is disabled"
    endif
    
    '///Check if -First row as label- is enabled and checked
    printlog "Check if -First row as label- is enabled and checked"
    if FirstRowAsLabel.IsEnabled then
        printlog "    First row as label is enabled"
        if FirstRowAsLabel.IsChecked then
            printlog "        and checked"        
        else
            warnlog "First row as label is not checked"
        endif
    else
        warnlog "First row as label is disabled"
    endif
    
    '///Check if -First column as label- is enabled and checked
    printlog "Check if -First column as label- is enabled and checked"
    if FirstColumnAsLabel.IsEnabled then
        printlog "    First column as label is enabled"
        if FirstColumnAsLabel.IsChecked then
            printlog "        and checked"
        else
            warnlog "First column as label is not checked"
        endif
    else
        warnlog "First column as label is disabled"
    endif
    
    '///Press button Range Chooser
    printlog "Press button Range Chooser"
    SelectDataRange.Click
    
    '///Enter an invalid range in Range Chooser and close Range Chooser
    printlog "Enter blank in Range Chooser and close Range Chooser"    
    Kontext "AcceptOrRejectChangesArea"
    AreaEditField.SetText "$ChartFlexRange.$B$3:$E$0"
    ShrinkButton.Click    

    '///Check if -Data series in rows- is disabled
    printlog "Check if -Data series in rows- is disabled"
    Kontext "TabChartTypeDataRange"
    if NOT Rows.IsEnabled then
        printlog "    Data series in rows is disabled" 
    else
        warnlog "Data series in rows is enabled, but should be disabled"
    endif
    
    '///Check if -Data series in columns- is disabled
    printlog "Check if -Data series in columns- is disabled"
    if NOT Columns.IsEnabled then
        printlog "    Data series in columns is disabled" 
    else
        warnlog "Data series in columns is enabled, but should be disabled"
    endif
    
    '///Check if -First row as label- is disabled
    printlog "Check if -First row as label- is disabled"
    if NOT FirstRowAsLabel.IsEnabled then
        printlog "    First row as label is disabled" 
    else
        warnlog "First row as label is enabled, but should be disabled"
    endif
    
    '///Check if -First column as label- is disabled
    printlog "Check if -First column as label- is disabled"
    if NOT FirstColumnAsLabel.IsEnabled then
        printlog "    First Column as label is disabled" 
    else
        warnlog "First Column as label is enabled, but should be disabled"
    endif
    
    '///Check if OK button is disabled
    printlog "Check if OK button is disabled"
    try
        Kontext "TabChartTypeDataRange"
    	TabChartTypeDataRange.OK
    	warnlog "The OK button is not disabled"
        goto endsub
    catch
        printlog "    The OK button is disabled"
    endcatch
    
    '///Enter a valid multiple range
    printlog "Enter a valid range"
    Kontext "TabChartTypeDataRange"
    DataRange.SetText "$ChartFlexRange.$C$4:$G$6;$ChartFlexRange.$C$8:$G$8"
    
    '///Check if -Data series in columns- is enabled
    printlog "Check if -Data series in columns- is enabled"
    if Columns.IsEnabled then
        printlog "    Data series in columns is enabled" 
    else
        warnlog "Data series in columns is disabled"
    endif
            
    '///Check if -Data series in rows- is enabled and chosen
    printlog "Check if -Data series in columns- is enabled and chosen"
    if Rows.IsEnabled then
        printlog "    Data series in rows is enabled"
        if rows.IsChecked then
            printlog "        and checked"
        else
            warnlog "Data series in rows is not checked"
        endif
    else
        warnlog "Data series in rows is disabled"
    endif
    
    '///Check if -First row as label- is enabled and checked
    printlog "Check if -First row as label- is enabled and checked"
    if FirstRowAsLabel.IsEnabled then
        printlog "    First row as label is enabled"
        if FirstRowAsLabel.IsChecked then
            printlog "        and checked"        
        else
            warnlog "First row as label is not checked"
        endif
    else
        warnlog "First row as label is disabled"
    endif
    
    '///Check if -First column as label- is enabled and checked
    printlog "Check if -First column as label- is enabled and checked"
    if FirstColumnAsLabel.IsEnabled then
        printlog "    First column as label is enabled"
        if FirstColumnAsLabel.IsChecked then
            printlog "        and checked"
        else
            warnlog "First column as label is not checked"
        endif
    else
        warnlog "First column as label is disabled"
    endif
    
    '///Press Cancel button
    printlog "Press Cancel button"
    Kontext "TabChartTypeDataRange"
    TabChartTypeDataRange.Cancel
    
    '///Close document
    printlog "Close document"
    Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tDataSeriesDialogCalc

    dim sInputFile as string
    dim iDataSeries as integer
    dim sDataRanges as string
    dim sRangeFor as string
    dim sCategories as string
    sInputFile = convertpath ( gtesttoolpath & "chart2/update/input/ch_flexrange04.ods" )

    '///Open test document ch_flexrange04.ods
    printlog "Open test document ch_flexrange04.ods"
    call hDateiOeffnen sInputFile
    sleep(2)
    
    '/// Select chart using navigator
    printlog "Select chart using navigator"
    call fSelectFirstOLE
    
    '/// Edit / Object / Edit
    printlog "Edit / Object / Edit"
    EditObjectEdit
    
    '///Open FORMAT / DATA RANGES
    printlog "Open FORMAT / DATA RANGES"
    FormatDataRanges
    
    '///Switch to tabpage Data Series
    printlog "Switch to tabpage Data Series"
    Kontext
    active.SetPage TabChartTypeDataRange    'Switching tabpages as workaround for #i77237#
    active.SetPage TabChartTypeDataSeries
    
    '///Dialogtest
    printlog "Dialogtest"
    Kontext "TabChartTypeDataSeries"
    call DialogTest ( TabChartTypeDataSeries )

    '///Check if the data series listbox is enabled and contains 1 entrie
    printlog "Check if the data series listbox is enabled and contains 1 entries"
    iDataSeries = DataSeries.GetItemCount
    if iDataSeries = 1 then
        printlog "    One data serie is available"
    else
        warnlog "There are " & iDataSeries & " data series instead of 1"
    endif
    
    '///Check if the ADD button is enabled and click the button
    printlog "Check if the ADD button is enabled and click the button"
    if AddButton.IsEnabled then
        printlog "    ADD button is enabled"
        AddButton.Click
    else
        warnlog "ADD button is not enabled"
    endif
    
    '///Check if there are now 2 entries in the data series listbox
    printlog "Check if there are now 2 entries in the data series listbox"
    iDataSeries = DataSeries.GetItemCount
    if iDataSeries = 2 then
        printlog "    Adding a data series was successfull"
    else
        warnlog "There are " & iDataSeries & " data series instead of 2"
    endif
    
    '///Check if the new data series was added below the highlighted one
    printlog "Check if the new data series was added below the highlighted one"
    if DataSeries.GetSelIndex = 2 then
        printlog "    The new data series was inserted below the highlighted (first) one"
    else
        warnlog "The new dataseries was not inserted below the highlighted one"
    endif
    
    '///Use UP button and verify that it it disabled on first entry
    printlog "Use UP button on last data series and verify that it it disabled on first entry"
    DataSeries.Select 2
    if MoveUp.IsEnabled then
        printlog "    The MoveUp button is enabled"
        MoveUp.Click
    else
        warnlog "The MoveUp button is disabled"
    endif
    if DataSeries.GetSelIndex = 1 then
        printlog "    Moving data series was successfull"
        if MoveUp.IsEnabled then
            warnlog "MoveUp button is not disabled on first entry"
        else
            printlog "        and MoveUp button is disabled on first enty"
        endif
    else
        warnlog "Moving data series was not successfull"
    endif
    
    '///Use DOWN button and verify that it is disabled on last entry
    printlog "Use DOWN button and verify that it is disabled on last entry"
    DataSeries.Select 1
    if MoveDown.IsEnabled then
        printlog "    The MoveDown button is enabled"
        MoveDown.Click        
    else
        warnlog "The MoveDown button is disabled"
    endif
    if DataSeries.GetSelIndex = 2 then
        printlog "    Moving data series was successfull"
        if MoveDown.IsEnabled then
            warnlog "MoveDown button is not disabled on first entry"
        else
            printlog "        and MoveDown button is disabled on first enty"
        endif
    else
        warnlog "Moving data series was not successfull"
    endif
    
    '///Check if the REMOVE button is enabled and click the button
    printlog "Check if the REMOVE button is enabled and click the button"
    if RemoveButton.IsEnabled then
        printlog "    REMOVE button is enabled"
        RemoveButton.Click
    else
        warnlog "REMOVE button is not enabled"
    endif
    
    '///Check if there are now 1 entrie in the data series listbox
    printlog "Check if there are now 1 entry in the data series listbox"
    iDataSeries = DataSeries.GetItemCount
    if iDataSeries = 1 then
        printlog "    Removing a data series was successfull"
    else
        warnlog "There are " & iDataSeries & " data series instead of 1"
    endif
    
    '///Select first entry in Data Ranges
    printlog "Select first entry in Data Ranges"
    DataRanges.Select 1
    
'works only with testtool >= gh13
    '///Verify that the range for NAME matches the one in edit field
'    printlog "Verify that the range for NAME matches the one in edit field"
'    sDataRanges = DataRanges.GetSelText (1,3)
'    sRangeFor = RangeFor.GetText
'    if sDataRanges = sRangeFor then
'        printlog "    Both ranges are matching"
'    else
'        warnlog "The ranges does not match: " & sDataRanges & sRangeFor
'    endif
    
    '///Select second entry in Data Ranges
    printlog "Select second entry in Data Ranges"
    DataRanges.Select 2
    
    '///Check that the range in the edit field has changed too
    printlog "Check that the range in the edit field has changed too"
'works only with testtool >= gh13
'    sDataRanges = DataRanges.GetSelText (1,3)
'    sRangeFor = RangeFor.GetText
'    if sDataRanges = sRangeFor then
'        printlog "    Both ranges are matching"
'    else
'        warnlog "The ranges does not match" & sDataRanges & sRangeFor
'    endif
    
    '///Change the range in edit field
    printlog "Change the range in edit field"
	RangeFor.SetText "$ChartFlexRange.$D$5:$D$10"
	
'works only with testtool >= gh13
    '///Check that the range in Data Ranges has changed too
    printlog "Check that the range in Data Ranges has changed too"
'    sDataRanges = DataRanges.GetSelText (1,3)
'    if sDataRanges = "$ChartFlexRange.$D$5:$D$10" then
'       printlog "    The data range has also changed"
'    else
'        warnlog "The data range has not changed"
'    endif

    '///Click on Range Chooser and change the range
    printlog "Click on Range Chooser and change the range"
    SelectRange.Click
    Kontext "AcceptOrRejectChangesArea"
    AreaEditField.SetText "$ChartFlexRange.$D$5:$D$12"
    ShrinkButton.Click
    
'works only with testtool >= gh13
    '///Check if the range in the Data ranges has changed
    printlog "Check if the range in Data ranges has changed"
    Kontext "TabChartTypeDataSeries"
'    sDataRanges = DataRanges.GetSelText (1,3)
'    if sDataRanges = "$ChartFlexRange.$D$5:$D$12" then
'       printlog "    The data range has also changed"
'    else
'        warnlog "The data range has not changed"
'    endif

    '///Edit range for Categories
    printlog "Edit range for Categories"
    Categories.SetText "$ChartFlexRange.$B$5:$B$10"
    sCategories = Categories.GetText
    if sCategories = "$ChartFlexRange.$B$5:$B$10" then
        printlog "    The range has been modified"
    else
        warnlog "Modifiing the range was not successfull"
    endif
    
    '///Click on Range Chooser and change the range
    printlog "Click on Range Chooser and change the range"
    SelectCategories.Click
    Kontext "AcceptOrRejectChangesArea"
    AreaEditField.SetText "$ChartFlexRange.$B$5:$B$12"
    ShrinkButton.Click
    
    '///Verify that the range is taken
    printlog "Verify that the range is taken"
    Kontext "TabChartTypeDataSeries"
    sCategories = Categories.GetText
    if sCategories = "$ChartFlexRange.$B$5:$B$12" then
        printlog "    The range has been modified"
    else
        warnlog "Modifiing the range was not successfull"
    endif
    
    '///Enter an invalid range
    printlog "Enter an invalid range"
    Categories.SetText "$ChartFlexRange.$B$5:$B$"
    
    '///Check that the OK button does not work
    printlog "Check that the OK button does not work"
    try
        Kontext "TabChartTypeDataSeries"
    	TabChartTypeDataSeries.OK
    	warnlog "The OK button is not disabled"
        goto endsub
    catch
        printlog "    The OK button is disabled"
    endcatch
    
    '///Enter a valid range
    printlog "Enter a valid range"
    Kontext "TabChartTypeDataSeries"
    Categories.SetText "$ChartFlexRange.$B$5:$B$12"
    
    '///Press Range Chooser
    printlog "Press Range Chooser"
    SelectCategories.Click
    
    '///Move cursor to the end
    printlog "Move cursor to the end"
    Kontext "AcceptOrRejectChangesArea"
    AreaEditField.TypeKeys "<END>"
    
    '///Enter a semicolon and a second range
    printlog "Enter a semicolon and a second range"
    AreaEditField.TypeKeys ";$ChartFlexRange.$B$14"
    
    '///Close Range Chooser
     printlog "Close Range Chooser"
    ShrinkButton.Click
    
    '///Verify that there is a multiple range 
    printlog "Verify that there is a multiple range"
    Kontext "TabChartTypeDataSeries"
    sCategories = Categories.GetText
    if sCategories = "$ChartFlexRange.$B$5:$B$12;$ChartFlexRange.$B$14" then
        printlog "    The range has been modified to a multiple range"
    else
        warnlog "Modifiing the range was not successfull"
    endif
    
    '///Press Cancel button
    printlog "Press Cancel button"
    Kontext "TabChartTypeDataSeries"
    TabChartTypeDataSeries.Cancel
    
    '///Close document
    printlog "Close document"
    Call hCloseDocument

endcase


