'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_extension_errors.inc,v $
'*
'*  $Revision: 1.7.2.2 $
'*
'*  last change: $Author: jsk $ $Date: 2008/03/17 09:43:53 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Reproduction of misc errors when working with extensions
'*
'*******************************************************************************
'**
' #1 tExtensionError77436 ' Registration error when installing extension
'**
'\******************************************************************************

testcase tExtensionError77436

    '///<h3>Registration error when installing extension, Linux/UNIX only</h3>
    '///<ul>
    
    if ( lcase( gtSysName ) <> "linux" ) then 
        printlog( "Sample extension is not suitable for Windows or Solaris" )
        goto endsub
    endif
    
    dim irc as integer
    dim brc as boolean
    dim cMsg as string
    
    dim cWorkPath as string
        cWorkPath = gTesttoolPath & "framework\basic\input\extensions\errors\"
        cWorkPath = convertpath( cWorkPath )
        
    const EXTENSION_NAME = "i77436-extension.oxt"
    const MACRO_NAME = "i77436"
    
    '///+<li>Create an initial document, change it so it cannot be replaced</li>
    hInitSingleDoc()
    hChangeDoc()
    
    '///+<li>Add the extension (see code for details)</li>
    irc = hExtensionAddGUI( cWorkPath & EXTENSION_NAME , false )
    select case irc
    case 0    : printlog( "Extension was added, ok" )
    case 4    : warnlog( "#i77436# Registration error/extension already installed" )
    case else : warnlog( "Adding extension failed with rc = " & irc )
    end select
    
    '///+<li>Go to the BASIC IDE, create a new module</li>
    brc = hInitBasicIde( MACRO_NAME )
    if ( not brc ) then
        warnlog( "Failed to init BASIC IDE, fatal" )
        call ExitRestartTheOffice()
        goto endsub
    endif
    
    '///+<li>Insert the macro (that comes with the extension</li>
    irc = hInsertMacroFromFile( MACRO_NAME )
    if ( irc <> 9 ) then
        warnlog( "Retrieved/inserted wrong macro, please check" )
    endif
    
    '///+<li>Close the BASIC IDE</li>
    irc = hCloseBasicIDE()
    
    '///+<li>Run the macro from the Run Macro dialog</li>
    irc = hMacroOrganizerRunMacro( MACRO_NAME )
    
    '///+<li>Verify that the macro was indeed executed - messagebox 1</li>
    kontext "Active"
    if ( Active.exists( 2 ) ) then
        cMsg = Active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        printlog( "Message 1: " & cMsg )
        active.ok()
    endif
    
    '///+<li>Verify that the macro was indeed executed - messagebox 2</li>
    kontext "Active"
    if ( Active.exists( 2 ) ) then
        cMsg = Active.getText()
        cMsg = hRemoveLineBreaks( cMsg )
        printlog( "Message 2: " & cMsg )
        active.ok()
    endif
    
    '///+<li>Remove the extension again</li>
    irc = hExtensionRemoveGUI( EXTENSION_NAME )
    select case irc
    case 0    : printlog( "Extension was removed, ok" )
    case else : warnlog( "Removing extension failed with rc = " & irc )
    end select
    
    '///+<li>Verify that the number of documents is still correct (should be two)</li>
    if ( getDocumentCount() = 2 ) then  
        warnlog( "Document left over by some error. Closing" )
        hDestroyDocument()
    endif
    
    '///+<li>Close all documents until we are on backing window</li>
    do while ( getDocumentCount > 0 ) 
        hDestroyDocument()
    loop
    '///</ul>

endcase

