'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_shared_modules.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsk $ $Date: 2007/10/16 13:16:24 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2006 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Access modules below OpenOffice.org macros
'*
'*******************************************************************************
'**
' #1 tBasicSharedModules ' Access modules below OpenOffice.org macros
'**
'\******************************************************************************

testcase tBasicSharedModules

    '///<h3>Access modules below OpenOffice.org macros</h3>
    '///Covers issues #i74058, #i74120 and  #i74372
    
    dim iObjectPosition as integer
    dim iLibraryCount as integer
    
    '///<ul>
    '///+<li>Open a document to work on</li>
    hInitSingleDoc()
    
    '///+<li>Open the basic organizer</li>
    ToolsMacro_uno
    
    '///+<li>Select one of the internal macros</li>
    Kontext "Makro"
    iObjectPosition = hSelectNodeByName( MakroAus , "Depot" )
    if ( iObjectPosition = 0 ) then
        warnlog( "Could not find the specified node" )
        goto endsub
    endif
    
    '///+<li>Jump to the last node</li>
    hSelectTheLastNode( MakroAus )
    printlog( "Current node (Last node): " & MakroAus.getSelText() )
    
    '///+<li>Select the next node (should be one of the modules below Depot)</li>
    hSelectNode( MakroAus, iObjectPosition+1 )
    printlog( "Current node (Depot/..): " & MakroAus.getSelText() 
    
    '///+<li>Click &quot;Edit...&quot;</li>
    Kontext "Makro"
    Bearbeiten.click()
    
    '///+<li>Check that we are on the BASIC-IDE</li>
    Kontext "MacroBar"
    if ( MacroBar.exists( 2 ) ) then
        printlog( "Macro Bar is open." )
    else
        warnlog( "MacroBar is not open but we should be on the Basic IDE" )
    endif
    
    '///+<li>Use the Library listbox (Jump to top)</li>
    Kontext "MacroBar"
    Library.typeKeys( "<HOME>" )
    printlog( "Top entry = " & Library.getSelText() )
    
    '///+<li>Get the number of items from the Library control</li>
    iLibraryCount = Library.getItemCount()
    printlog( "There are " & iLibraryCount & " items in the list" )
    
    if ( iLibraryCount <> 13 ) then
        warnlog( "The number of items in the library-list is incorrect: " & iLibraryCount )
    endif
    
    '///+<li>Use the Library listbox (Jump to bottom)</li>
    Kontext "MacroBar"
    Library.select( iLibraryCount )
    printlog( "Last entry = " & Library.getSelText() )   
    
    '///+<li>Close the Basic-IDE</li>
    hCloseBasicIDE()
    
    '///+<li>Close the document</li>
    hDestroyDocument()
    '///</ul>
    
    
endcase

