'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_scripting_addpkg.inc,v $
'*
'*  $Revision: 1.17.2.1 $
'*
'*  last change: $Author: jsk $ $Date: 2008/02/26 10:22:45 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Deploy, execute and delete uno-package
'*
'*******************************************************************************
'**
' #1 tDeployScript ' Deploy, execute and delete uno-package
'**
'\******************************************************************************

testcase tDeployScript

    '///<h1>Import a UNO package containing a script via Package-Manager UI</h1>
    
    ' Text to identify the document we work with. 
    ' NOTE: Capitalise.bsh changes the case of a string rather than capitalising 
    ' it.
    dim cText as string
        cText = "Testdoc for Capitalise.bsh"
        
    ' The path to the package that will be installed 
    dim cPackagePath as string
        cPackagePath = "framework\basic\input\pkgmgr\capitalise.uno.pkg"
        cPackagePath = convertpath( gTesttoolpath & cPackagePath )
        
    dim cScriptName as string
    dim cMessage as string
        
    dim cPackageName as string
    dim bStatus as boolean
    
    dim brc as boolean
    dim irc as integer
        
    '///<ul>
    
    gApplication = "WRITER"
    
    '///+<li>Open a new document</li>
    printlog( "Open an new document" )
    hCreateDocument()
    
    '///+<li>Write some text to the document</li>
    printlog( "Write a string to the document (mixed- or lowercase)" ) 
    kontext "DocumentWriter"
    DocumentWriter.TypeKeys( cText )    
    
    '///+<li>Add the package, close Extension Manager</li>
    cPackageName = hExtensionAddGUI( cPackagePath , false )

    '///+<li>Reopen Extension Manager</li>
    ToolsPackageManager

    '///+<li>Find the second package in the list</li>
    kontext "PackageManager"
    BrowsePackages.TypeKeys( "<RIGHT>" )
    BrowsePackages.TypeKeys( "<DOWN>" )
    
    cPackageName = BrowsePackages.getText() 
    
    '///+<li>Verify that the package at the first node is the correct one</li>
    printlog( "Verify that the package is the correct one" )
    if ( cPackageName <> "capitalise.uno.pkg" ) then
        warnlog( "Since the package is not in place, the test ends here." )
        call hCloseDocument()
        goto endsub
    endif

    '///+<li>Close the Extension manager</li>
    PackageManager.close()
    
    '///+<li>Verify that we still have the focus on the correct document</li>
    ' NOTE: Autocorrection uppercases the first letter, so capitalise.bsh will
    '       actually LOWERCASE the string!!!!
    bStatus = hIdentifyWriterDoc( cText , true )
    kontext "DocumentWriter"
    
    '///+<li>Open the 'Run Macro' dialog</li>
    printlog( "Open the 'Run Macro' dialog" )
    ToolsMacrosRunMacro
    if ( WaitSlot() <> WSFinished ) then
        qaerrorlog( "Slot did not finish within 1 second - might be a problem" )
    endif
    
    '///+<li>Browse through 'My Macros' and find the Capitalise Macro</li> 
    kontext "ScriptSelector"
    irc = hSelectNodeByName( LibraryTreeList , "Capitalise" )
    
    ' Perform full recovery in case of error
    ' Reason: in the past there was a problem getting the script to the script-
    ' selector. In that case the test aborted (hard) and left the UNO-package
    ' installed which intereferes some other tests.
    if ( irc = 0 ) then
        warnlog( "Requested Node could not be found: Capitalise" )
        ScriptSelector.cancel()
        hOpenPackageManager() 
        hRemovePackage( "capitalise.uno.pkg" )
        hClosePackageManager()        
        hDestroyDocument()
        goto endsub
    endif
    
    cScriptName = hGetNodeName( ScriptList , 1 )
    printlog( "Currently selected script: " & cScriptName )
    if ( cScriptName <> "capitalise.bsh" ) then
        warnlog( "Incorrect script selected: Teststate is undefined" )
    endif
    
    '///+<li>execute the macro</li>
    printlog( "Execute macro" )
    ScriptSelector.ok()
    
    '///+<li>handle unexpected errormessage</li>
    kontext "active"
    if ( active.exists( 1 ) ) then
        cMessage = active.gettext()
        cMessage = hRemoveLineBreaks( cMessage )
        
        ' we expect an exception here but it might as well be an unexpected
        ' macro that is being executed (see prior warning about cScriptName)
        ' We check for the substring "Exception"
        if ( instr( cMessage , "Exception" ) <> 0 ) then
            warnlog( "#i41066# An exception occured: " & cMessage )
        else
            warnlog( "Unexpected/unknown active: " & cMessage )
        endif
        
        active.ok()
    endif
    
    '///+<li>Verify that the text has indeed been changed (lowercased)</li>
    bStatus = hIdentifyWriterDoc( lcase( cText ) , false )
    
    ' errormessage in case the macro did not give the expected result 
    if ( not bStatus ) then
        warnlog( "The macro was not executed" )
    endif
    
    '///+<li>remove the package</li>
    ' this is the generic (preferred) function. Does not work for PkgMgr,
    ' the pkgmgr uses multiselection by default.
    ' bStatus = hRemovePackageGeneric( "capitalise.uno.pkg" , true  )
    ' alternative method using arrowkeys to navigate
    hExtensionRemoveGUI( "capitalise.uno.pkg" )
    
    '///+<li>Close the current document</li>
    printlog( "Close the document" )
    brc = hDestroyDocument()

    '///</ul>
    
endcase
