'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_drawing_objects.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2007/12/10 13:52:43 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.co
'*
'*  short description : Check the drawing objects files
'*
'*******************************************************************************
'**
' #1 tCheck_AllFormatForDrawingObjectFiles ' Check the drawing objects files
'**
'\******************************************************************************

testcase tCheck_AllFormatForDrawingObjectFiles
    Dim j as Integer, i as Integer
    Dim sDatei as String, Farbe5 as String, Farbe16 as String
    Dim lsListe(1000) as String
    Dim Fehler as Boolean
    dim brc as boolean
    
    
    '///<h1>This test checks all files: They are important to format drawing objects</h1>
    '///<ul>
    '///<li>line styles</li>
    '///<li>arrow styles</li>
    '///<li>area colors</li>
    '///<li>area gradients</li>
    '///<li>area hatchings</li>
    '///<li>area bitmaps</li>
    '///</ul>
    Fehler = FALSE
    printlog "The tested language is :" + gLanguage
    printlog "- Line styles"
    gApplication = "DRAW"
    '///<h3>line styles</h3>
    '///<ul>
    '///<li>open a draw document</li>
    '///<li>format / line</li>
    '///<li>open tabpage 'Line Styles'</li>
    '///</ul>
    brc = hCreateDocument()
    FormatLine

    kontext
    Active.SetPage TabLinienStile
    '///<h3>Test procedure: </h3>
    '///<ul>
    '///<li>click on open and insert the styles files 'standard.sod' and check all entries</li>
    '///<li>click on open and insert the styles files 'styles.sod' and check all entries ( in other languages the filename is translated )</li>

    kontext "tablinienstile"

    for j=1 to 2
        Oeffnen.Click
        select case j
        case 1 : sDatei = hGetDrawObjectSpecialFileName( "LineStyles" , "Default" )
        case 2 : sDatei = hGetDrawObjectStyleFileName( "LineStyles" )
        end select

        brc = hTestFile( sDatei )

        if ( brc ) then

            kontext "oeffnendlg"
            if ( OeffnenDlg.exists( 2 ) ) then

                Dateiname.SetText sDatei
                Oeffnen.Click
                
            else
                warnlog( "FileOPen dialog did not open" )
            endif

            kontext "Active"
            if ( Active.exists( 2 ) and active.getRT = 304 ) then
                Warnlog Active.GetText()
                Active.OK()
                Fehler =  TRUE
            endif

            

            kontext "tablinienstile"
            if Fehler = FALSE then
                ListAllDelete ( lsListe() )

                for i=1 to LinienStil.GetItemCount
                    ListAppend ( lsListe(), LinienStil.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 1, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
        endif

    next j

    '///<li>load standard.sod for default settings</li>
    printlog "   - load standard.sod for default settings"
    Oeffnen.Click()

    kontext "oeffnendlg"
    if ( OeffnenDlg.exists( 2 ) ) then
        sDatei = hGetDrawObjectSpecialFileName( "LineStyles" , "Default" )
        Dateiname.SetText( sDatei )
        Oeffnen.Click
    else
        warnlog( "File Open dialog did not open" )
    endif
    '///</ul>
    
    '///<h3>Arrow styles</h3>
    '///<ul>
    '///<li>open tabpage 'Arrow Styles'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Arrow styles"

    kontext
    Active.SetPage TabLinienenden

    kontext "tablinienenden"
    '///<li>click on open and insert the styles files 'standard.soe' and check all entries</li>
    '///<li>click on open and insert the styles files 'arrowhd.soe' and check all entries ( in other languages the filename is translated )</li>

    for j=1 to 2
    
        Oeffnen.Click
        
        select case j
        case 1 : sDatei = hGetDrawObjectSpecialFileName( "ArrowHead" , "Default" )
        case 2 : sDatei = hGetDrawObjectStyleFileName( "ArrowHead" )
        end select

        brc = hTestFile( sDatei )

        if ( brc ) then

            kontext "oeffnendlg"
            if ( OeffnenDlg.exists( 2 ) ) then
                Dateiname.SetText sDatei
                Oeffnen.Click
            else
                warnlog( "File Open dialog did not open" )
            endif

            kontext "Active"
            if ( Active.exists( 2 ) and active.getRT = 304 ) then
                Warnlog Active.GetText()
                Active.OK()
                Fehler =  TRUE
            endif


            kontext "tablinienenden"
            if Fehler = FALSE then
                ListAllDelete ( lsListe() )

                for i=1 to Liste.GetItemCount
                    ListAppend ( lsListe(), Liste.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 2, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
        endif

    next j

    '///<li>load standard.soe for default settings</li>
    '///<li>close the 'Arrow styles'-tabpage with 'cancel'</li>
    printlog "   - load standard.soe for default settings"
    Oeffnen.Click()

    kontext "oeffnendlg"
    if ( OeffnenDlg.exists( 2 ) ) then
        sDatei = hGetDrawObjectSpecialFileName( "Arrowhead", "Default" )
        Dateiname.SetText( sDatei )
        Oeffnen.Click
    else
        warnlog( "File Open dialog did not open" )
    endif

    kontext "tablinienenden"
    TabLinienenden.Cancel
    
    '///</ul>
    '///<h3>Colors</h3>
    '///<ul>
    '///<li>Format / Area</li>
    '///<li>activate tabpage 'Colors'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Colors"
    FormatArea

    kontext
    Active.SetPage TabFarben

    kontext "tabfarben"
    '///<li>click on open and insert the styles files 'standard.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'palette.soc' and check all entries ( in other languages the filename is translated )</li>
    '///<li>click on open and insert the styles files 'cmyk.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'web.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'html.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'gallery.soc' and check all entries</li>
    '///<li>click on open and insert the styles files 'sun-color.soc' and check all entries</li>

    for j=1 to 7
    
        select case j
        case 1 : sDatei = hGetDrawObjectSpecialFileName( "Colors" , "Default" )
        case 2 : sDatei = hGetDrawObjectStyleFileName( "Colors" )
        case 3 : sDatei = hGetDrawObjectSpecialFileName( "Colors" , "1" )
        case 4 : sDatei = hGetDrawObjectSpecialFileName( "Colors" , "2" )
        case 5 : sDatei = hGetDrawObjectSpecialFileName( "Colors" , "3" )
        case 6 : sDatei = hGetDrawObjectSpecialFileName( "Colors" , "4" )
        case 7 : sDatei = hGetDrawObjectSpecialFileName( "Colors" , "5" )
        end select

        brc = hTestFile( sDatei )

        if ( brc ) then

            ' This is the open-button on the color tab-page of the object 
            ' properties dialogue. The File-Open dialog is only called if we
            ' are certain that the file exists. 
            kontext "tabfarben"
            Oeffnen.Click

            kontext "oeffnendlg"
            if ( OeffnenDlg.exists( 2 ) ) then
                Dateiname.SetText sDatei
                Oeffnen.Click
            else
                warnlog( "File Open dialog did not open" )
            endif
            
            kontext "Active"

            if ( Active.exists( 2 ) and active.getRT = 304 ) then
                Warnlog Active.GetText()
                Active.OK()
                Fehler =  TRUE
            endif

            if Fehler <> TRUE then
                ListAllDelete ( lsListe() )

                kontext "tabfarben"

                for i=1 to Farbe.GetItemCount
                    ListAppend ( lsListe(), Farbe.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 3, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
            
            ' Need to close the dialog again
            kontext "OeffnenDlg"
            
        endif

    next j
    '///</ul>

    '///<i>load standard.soc for default settings</i>
    printlog "   - load standard.soc for default settings"
    Oeffnen.Click

    kontext "oeffnendlg"
    if ( OeffnenDlg.exists( 2 ) ) then
        sDatei = hGetDrawObjectSpecialFileName( "Colors" , "Default" )
        Dateiname.SetText( sDatei )
        Oeffnen.Click
    else
        warnlog( "File Open dialog did not open" )
    endif
    '///<h3>Gradients</h3>
    '///<ul>
    '///<li>activate tabpage 'Gradients'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Gradients"

    kontext
    Active.SetPage TabFarbverlaeufe

    kontext "tabfarbverlaeufe"
    '///<li>click on open and insert the styles files 'standard.sog' and check all entries</li>
    '///<li>click on open and insert the styles files 'classic.sog' and check all entries ( in other languages the filename is translated )</li>
    '///<li>click on open and insert the styles files 'modern.sog' and check all entries ( in other languages the filename is translated )</li>

    for j=1 to 3

        select case j
        case 1 : sDatei = hGetDrawObjectSpecialFileName( "ClassicGradients", "Default" )
        case 2 : sDatei = hGetDrawObjectStyleFileName( "ClassicGradients" )
        case 3 : sDatei = hGetDrawObjectStyleFileName( "ModernGradients" )
        end select
        
        brc = hTestFile( sDatei )
        if ( brc ) then
        
            kontext "TabFarbverlaeufe"
            Oeffnen.Click

            kontext "oeffnendlg"
            if ( OeffnenDlg.exists( 2 ) ) then
                Dateiname.SetText sDatei
                Oeffnen.Click
            else
                warnlog( "File Open dialog did not open" )
            endif
            
            kontext "Active"

            if ( Active.exists( 2 ) and active.getRT = 304 ) then
                Warnlog Active.GetText()
                Active.OK()
                Fehler =  TRUE
            endif

            kontext "tabfarbverlaeufe"
            if Fehler = FALSE then
                ListAllDelete ( lsListe() )

                for i=1 to Tabelle.GetItemCount
                    ListAppend ( lsListe(), Tabelle.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 4, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
        endif

    next j
    '///</ul>

    '///<i>load standard.sog for default settings</i>
    printlog "   - load standard.sog for default settings"
    Oeffnen.Click
    sleep( 1 )

    kontext "oeffnendlg"
    sDatei = hGetDrawObjectSpecialFileName( "ClassicGradients" , "Default" )
    Dateiname.SetText( sDatei )
    Oeffnen.Click
    '///<h3>Hatchings</h3>
    '///<ul>
    '///<li>activate tabpage 'Gradients'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Hatchings"

    kontext
    Active.SetPage TabSchraffuren

    kontext "tabschraffuren"
    '///<li>click on open and insert the styles files 'standard.soh' and check all entries</li>
    '///<li>click on open and insert the styles files 'hatching.soh' and check all entries ( in other languages the filename is translated )</li>

    for j=1 to 2

        select case j
        case 1 : sDatei = hGetDrawObjectSpecialFileName( "Hatchings" , "Default" )
        case 2 : sDatei = hGetDrawObjectStyleFileName( "Hatchings" )
        end select
        
        brc = hTestFile( sDatei )

        if ( brc ) then
        
            kontext "TabSchraffuren"
            Oeffnen.Click

            kontext "oeffnendlg"
            if ( OeffnenDlg.exists( 2 ) ) then
                Dateiname.SetText sDatei
                Oeffnen.Click
            else
                warnlog( "File Open dialog did not open" )
            endif
            
            kontext "Active"

            if ( Active.exists( 2 ) and active.getRT = 304 ) then
                Warnlog Active.GetText()
                Active.OK()
                Fehler =  TRUE
            endif


            kontext "tabschraffuren"

            if Fehler = FALSE then
                ListAllDelete ( lsListe() )

                for i=1 to Tabelle.GetItemCount
                    ListAppend ( lsListe(), Tabelle.GetItemText (i) )
                next i

                hCompareStylesAndFormats ( lsListe(), 5, j )
            endif

        else
            Warnlog sDatei + " does not exists!"
        endif

    next j
    '///</ul>

    '///<i>load standard.soh for default settings</i>
    printlog "   - load standard.soh for default settings"
    kontext "TabSchraffuren"
    Oeffnen.Click

    kontext "oeffnendlg"
    sleep( 1 )
    sDatei = hGetDrawObjectSpecialFileName( "Hatchings" , "Default" )
    Dateiname.SetText( sDatei )
    Oeffnen.Click
    '///<h3>Bitmaps</h3>
    '///<ul>
    '///<li>activate tabpage 'Bitmaps'</li>
    Fehler = FALSE
    printlog Chr(13) + "- Bitmaps"

    kontext
    Active.SetPage TabBitmap

    kontext "tabbitmap"
    '///<li>click on open and insert the styles files 'standard.sob' and check all entries</li>

    Oeffnen.Click
    sDatei = hGetDrawObjectSpecialFileName( "Bitmaps" , "Default" )
    brc = hTestFile( sDatei )

    kontext "oeffnendlg"
    if ( OeffnenDlg.exists( 2 ) ) then
        Dateiname.SetText sDatei
        Oeffnen.Click
    else
        warnlog( "File Open dialog did not open" )
    endif
    
    kontext "Active"

    if ( Active.exists( 2 ) and active.getRT = 304 ) then
        Warnlog Active.GetText()
        Active.OK()
        Fehler =  TRUE
    endif


    kontext "tabbitmap"

    if Fehler = FALSE then
        ListAllDelete ( lsListe() )

        for i=1 to Tabelle.GetItemCount
            ListAppend ( lsListe(), Tabelle.GetItemText (i) )
        next i

        hCompareStylesAndFormats ( lsListe(), 6, 1 )
    endif

    '///</ul>

    '///<i>load standard.sob for default settings</i>
    printlog "   - load standard.sob for default settings"
    kontext "tabbitmap"
    Oeffnen.Click

    kontext "oeffnendlg"
    if ( OeffnenDlg.exists( 2 ) ) then
        sDatei = hGetDrawObjectSpecialFileName( "Bitmaps" , "Default" )
        Dateiname.SetText( sDatei )
        Oeffnen.Click
    else
        warnlog( "File Open dialog did not open" )
    endif
    '///<ul>
    '///<li>close the 'bitmap'-tabpage with 'cancel'</li>

    kontext "tabbitmap"
    TabBitmap.Cancel
    '///<li>close the draw-document</li>
    '///</ul>
    brc = hDestroyDocument()
    
    skip_test:
    
endcase
