'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_filternames.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2008/01/07 12:20:55 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Verify that all filters are listed in the filter listbox
'*
'*******************************************************************************
'**
' #1 tVerifyFilterNames ' Verify that all filters are listed in the filter listbox
'**
'\******************************************************************************

testcase tVerifyFilterNames

    '///<h3>Verify that all filters are listed in the filter listbox</h3>
    
    const MAX_FILTERCOUNT = 300
    dim asFilterNames( MAX_FILTERCOUNT ) as string
    dim iFilterCount as integer
    dim iCurrentItem as integer
    
    dim cFile as string


    ' For Windows and Solaris Sparc there exists additional commercial filters
    ' that are available for StarOffice only.
    if ( not gOOo ) then
        select case gtSysName
            case "Windows"       : cFile = "filtername_add" & iSprache & ".txt"
            case "WinXP"         : cFile = "filtername_add" & iSprache & ".txt"
            case "Linux"         : cFile = "filtername" & iSprache & ".txt"
            case "Solaris SPARC" : cFile = "filtername_add" & iSprache & ".txt"
            case "Solaris x86"   : cFile = "filtername" & iSprache & ".txt"
        end select
    else
        cFile = "filtername" & iSprache & ".txt"
    endif
    
    dim cFileIn as string
        cFileIn  = gTesttoolPath & "framework\filedlg\input\filternames"
        cFileIn  = hGetInputPath( cFileIn , cFile ) 
        
    dim cFileOut as string
        cFileOut = hGetWorkPath() & cFile
    
    
    '///<ul>
    '///+<li>New document</li>
    hCreateDocument()
    
    '///+<li>Open FileOpen</li>
    FileOpen
    Kontext "OeffnenDlg"

    if ( OeffnenDlg.exists( 1 ) ) then    
    
        '///+<li>Get the number of items from the filterlist</li>    
        iFilterCount = DateiTyp.getItemCount()
        if ( iFilterCount > MAX_FILTERCOUNT ) then
            warnlog( "Too many filters in filterlist for this test to handle" )
            goto endsub
        endif
        
        printlog( "Reading in " & iFilterCount & " filternames" )

        '///+<li>Make the list compatible to listfunctions</li>    
        asFilterNames( 0 ) = iFilterCount
        
        '///+<li>Collect the list of filternames (including all separators etc.</li>
        for iCurrentItem = 1 to iFilterCount         
        
            kontext "OeffnenDlg"
            try
                asFilterNames( iCurrentItem ) = DateiTyp.getItemText( iCurrentItem )
            catch
                printlog( "Test broke at pos: " & iCurrentItem )
            endcatch
            
        next iCurrentItem
        
        '///+<li>Close FileOpen dialog</li>
        OeffnenDlg.cancel()
        
        '///+<li>Compare the current list against a reference</li>
        hManageComparisionList( cFileIn, cFileOut, asFilterNames() )    

    else
        warnlog( "File Open dialog not present." )
    endif
    
    '///+<li>Cleanup: Close document</li>
    hDestroyDocument()
    
    '///</ul>
     
endcase

