'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_special_load_save.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsk $ $Date: 2007/12/11 12:46:16 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'************************************************************************
'**
' #1  tFileSpecialLoad             ' load non existed files, load file from readonly directory and file out of no entry directory
' #1  tFileSpecialSave   'wrn:1    ' save a file in a non-existed dir, save a file in a dir without any rights for the user
'**
'\***************************************************************************

testcase tFileSpecialLoad
    
    '///<h1>Try to load files with special attributes to the directories or the files themselves</h1>
    '///<ol>
    '///+<li>Load a file that does not exist</li>
    '///+<li>Load a file from an unaccessible directory</li>
    '///+<li>Load a file from a read-only directory (not the files!)</li>
    '///</ol>
    
    dim NONEXISTINGFILE as String
    NONEXISTINGFILE = gTesttoolPath + "framework\filedlg\input\nonexist.sxw"
    
    dim UNACCESSIBLEFILE as String
    UNACCESSIBLEFILE = gTesttoolPath + "framework\filedlg\input\noentry\dead.sxw"
    
    dim READONLYFILE as String
    READONLYFILE = gTesttoolPath + "framework\filedlg\input\readentry\fdlg.sxw"
    
    printlog( "Test: Try to load a file that does not exist" )
    
    '///<i>Description</i>
    '///<ul>
    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    hCreateDocument()
    
    '///+<li>Try to load a non-existing file</li>
    FileOpen

    '///+<li>Handle possible messagebox (not expected)</li>    
    Kontext "Active"
    if Active.Exists( 1 ) then
        warnlog( "An unexpected messagebox came up and will be closed" )
        printlog( "Text: " + Active.getText() )
        Active.OK()
    endif
    
    '///+<li>Open [TesttoolPath]\input\desktop\filedlg\nonexist.sxw</li>
    printlog( "Try to open a non-existing file" )
    Kontext "OeffnenDlg"
    if ( OeffnenDlg.exists( 1 ) ) then
        Dateiname.SetText ( convertpath( NONEXISTINGFILE ))
        Oeffnen.Click()
    else
        warnlog( "File Open dialog is not open" )
    endif
    
    '///+<li>Handle (expected) messagebox</li>
    printlog( "Handle the (expected) errormessage" )
    Kontext "Active"
    if Active.Exists( 1 ) then
        Active.OK
    else
        Warnlog "No warning for non existing file! Bugid #104869#"
    end if
    
    '///+<li>Check for second (unexpected) messagebox</li>
    printlog( "check for second errormessage" )
    Kontext "Active"
    if Active.Exists( 1 ) then
        Warnlog "A second messagebox is active"
        printlog( "This might be a testtool issue, please check manually" )
        Active.OK
    end if
    
    '///+<li>Check for filter selection dialog (unexpected)</li>
    printlog( "ckeck for (unexpected) filter-dialog" )
    Kontext "Filterauswahl"
    If FilterAuswahl.Exists then
        Warnlog "Filterbox is also active!"
        FilterAuswahl.Cancel
    end if
    
    '///+<li>Close the File Open dialog (we end there when a file cannot be found)</li>
    Kontext "OeffnenDlg"
    if ( OeffnenDlg.exists( 1 ) ) then
        OeffnenDlg.cancel()
    else
        warnlog( "We should be on the file open dialog" )
    endif
    
    '///+<li>Close the document</li>
    printlog( "Close the document" )
    hDestroyDocument()
    
    printlog( "Test: Load a file file that is not accessible by permissions" )
    
    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    hCreateDocument()

    '///+<li>Open the FileOpen dialog</li>
    FileOpen
    
    '///+<li>Try to load file out of directory, with no right to enter ( 700for root )</li>
    printlog "- load a file out of directory, with no right to enter ( 700 for root )"
    Kontext "OeffnenDlg"
    
    '///+<li>Open [TesttoolPath]\input\desktop\filedlg\noentry\fdlg.sxw</li>
    if ( OeffnenDlg.exists( 1 ) ) then
        Dateiname.SetText ( convertpath( UNACCESSIBLEFILE ))
        Oeffnen.Click
    else
        warnlog( "File open dialog is not open" )
    endif
    
    '///+<li>Close the "unable to open ..." dialog</li>
    printlog( "handle the (expected) 'unable to open...' dialog" )
    Kontext "Active"
    if Active.Exists( 1 ) then
        Active.OK()
    else
        Warnlog "No warning for non existing file! Bugid #104869#"
        ' hDestroyDocument()() crash if filedialog is open !!!!
    end if
    
    '///+<li>Check for a second (unexpected) messagebox</li>
    printlog( "check for a second errormessage" )
    Kontext "Active"
    if Active.Exists(2) then
        Warnlog ( "A second messagebox is active" )
        printlog( "This might be a testtool issue, please check manually" )
        Active.OK()
    end if
    
    '///+<li>Check for (unexpected) filter selection dialog</li>
    printlog( "check for (unexpected) filter-dialog" )
    Kontext "Filterauswahl"
    If FilterAuswahl.Exists( 1 ) then
        Warnlog "Filterbox is also active!"
        FilterAuswahl.Cancel()
    end if
    
    '///+<li>Verify that we are back on the fileopen dialog</li>
    Kontext "OeffnenDlg"
    if OeffnenDlg.Exists( 1 ) then
        printlog( "closing File-Open dialog" )
        OeffnenDlg.cancel()
    else
        warnlog( "File Open dialog is not open" )
    endif
    
    '///+<li>Close the document</li>
    printlog( "Close the document" )
    hDestroyDocument()
    
    printlog( "Test: Load a file from a read-only directory" )
    
    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    hCreateDocument()
    
    printlog( "Open the file-open dialog" )
    FileOpen
    
    Kontext "OeffnenDlg"
    if ( OeffnenDlg.exists( 1 ) ) then
        '///+<li>Open [TesttoolPath]\filedlg\input\readentry\fdlg.sxw</li>
        Dateiname.SetText ( ConvertPath ( READONLYFILE ) )
        Oeffnen.Click()
    else
        warnlog( "File Open dialog is not open" )
    endif
    
    '///+<li>Check for (unexpected) errormessages/messageboxes, we should be back on FileOpen</li>
    printlog( "check for (unexpected) file-open error" )
    
    Kontext "Active"
    if Active.Exists( 1 ) then
        
        Warnlog "File can't be opened! The error was :"
        printlog Active.GetText()
        Active.OK()
        
        if Active.Exists( 1 ) then
            Warnlog "A second messagebox is active"
            printlog( "This might be a testtool issue, please check manually" )
            Active.OK()
        end if
        
        printlog( "check for (unexpected) filter-dialog" )
        Kontext "Filterauswahl"
        
        If FilterAuswahl.Exists( 1 ) then
            Warnlog( "Filterbox is active, this is not expected" )
            FilterAuswahl.Cancel()
        else
            printlog( "Filter selection not active. Good" )
        end if
        
    else
        
        Kontext "OeffnenDlg"
        
        if OeffnenDlg.Exists( 1 ) then
            printlog( "close the file-open dialog" )
            OeffnenDlg.cancel()
        endif
        
    end if
    
    '///+<li>Close the documents</li>
    printlog( "Close the documents" )
    hDestroyDocument()
    hDestroyDocument()
    
    '///</ul>
    
endcase

'*******************************************************************************

testcase tFileSpecialSave
    
    '///<h1>Try to save files with special attributes to the directories or the files themselves</h1>
    '///<ol>
    '///+<li>Save a file to a directory that does not exist</li>
    '///+<li>Save a file to an unaccessible directory</li>
    '///+<li>Load a file from a read-only directory (not the file!)</li>
    '///</ol>
    
    const TGT_NOEXIST as String = "framework\filedlg\output\noexists\fdlg.sxw"
    const TGT_NORIGHT as String = "framework\filedlg\input\noentry\fdlg.sxw"
    const TGT_WORKDIR as String = "framework\filedlg\input\readentry\fdlg.sxw"

    '///<i>Description:</i>    
    '///<ul>
    '///+<li>Try to save a file in a non-existed directory</li>
    printlog "Test: Save a file in a non-existing directory (writer only)"
    
    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    hCreateDocument()
    
    '///+<li>File/save as</li>
    printlog( "Open the file-save dialog" )
    FileSaveAs
    
    '///+<li>Save it as [TesttoolPath]\output\desktop\filedlg\noexists\fdlg.sxw</li>
    printlog( "name the file and try to save it" )
    Kontext "SpeichernDlg"
    Dateiname.SetText ( ConvertPath ( gTesttoolPath + TGT_NOEXIST ) )
    Speichern.Click()
    
    '///+<li>Handle the errormessage</li>
    printlog( "handle the (expected) errormessage" )
    Kontext "Active"
    If Active.Exists( 1 ) then
        Active.OK()
    else
        Warnlog "No error-message at saving"
    end if
    
    '///+<li>Cancel the FileSave dialog</li>
    Kontext "SpeichernDlg"
    SpeichernDlg.Cancel()
    
    '///+<li>Close the document</li>
    printlog( "Close the document" )
    hDestroyDocument()
    
    printlog "Test: save a file in a directory with no rights ( 700 for root ) "
    
    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    hCreateDocument()
    
    '///+<li>Try to save a file in a directory with no rights ( 700 for root )</li>
    '///+<li>Open FileSaveAs</li>
    printlog( "open the file-save dialog" )
    FileSaveAs
    
    '///+<li>Handle possible (unexpected) errormessages</li>
    Kontext "Active"
    if Active.Exists() then
        warnlog( "There is an unexpected 'Active' dialog" )
        printlog( "Text: " + Active.getText())
        Active.OK()
    endif
    
    '///+<li>Save it as [TesttoolPath]\input\desktop\filedlg\noentry\fdlg.sxw</li>
    printlog( "name the file and try to save it" )
    Kontext "SpeichernDlg"
    If SpeichernDlg.Exists(2) = FALSE then
        FileSaveAs
    endif
    Dateiname.SetText( ConvertPath ( gTesttoolPath + TGT_NORIGHT ) )
    Speichern.Click()
    
    '///+<li>Handle the expedcted &quot;Unable to save...&quot; warning</li>
    ' A warning is expected, that the file cannot be saved. If an overwrite-
    ' warning is shown, this usually means you are running on a local work-
    ' space
    Kontext "Active"
    if Active.Exists() then
        printlog( "Text: " + Active.getText())
        try
            Active.Ok()
        catch
            warnlog( "Probably this is an overwrite warning." )
            printlog( "Are you testing in a local environment?" )
            Active.Yes()
        endcatch
    endif
    
    '///+<li>Cancel the FileSave dialog</li>
    Kontext "SpeichernDlg"
    If SpeichernDlg.Exists() then
        SpeichernDlg.Cancel()
    endif
    
    '///+<li>Close the document</li>
    printlog( "Close the document" )
    hDestroyDocument()
    
    printlog( "Test: Check for changed default-directory" )
    
    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    hCreateDocument()
    
    '///+<li>Check if File/open has changed the default-directory</li>
    ' although the saving-process is broken ( an old bug )
    printlog( "Check if File/open has changed the default-directory," )
    printlog( "   although the saving-process is broken" )
    FileOpen
    
    '///+<li>Handle the possible errormessage (unexpected)</li>
    Kontext "Active"
    If Active.Exists(2) then
        Warnlog( "   The default-dir was changed #93187#" )
        Active.OK()
    end if
    
    '///+<li>Change the default directory to some other working directory via FileOpen</li>
    printlog( "Change the default-dir to a normal working-dir " )
    printlog( "   without warning at file/open" )
    printlog( "Continue working with the file-open dialog" )
    
    Kontext "OeffnenDlg"
    Dateiname.SetText( ConvertPath ( gTesttoolPath + TGT_WORKDIR ) )
    Oeffnen.Click()

    
    '///+<li>Handle possible (unexpected) errormessage</li>
    Kontext "Active"
    if Active.Exists( 2 ) then
        warnlog( "Unexpected errormessage before closing document" )
        printlog( "Text: " + Active.getText() )
        Active.OK()
    endif
    
    '///+<li>Close the document</li>
    printlog( "Close the document" )
    hDestroyDocument()
    
    '///</ul>
    
endcase


