'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: help_search.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2007/05/29 12:10:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Search for a string, apply restrictions, verify
'*
'*******************************************************************************
'**
' #1 tHelpSearch ' Search for a string, apply restrictions, verify
'**
'\******************************************************************************

testcase tHelpSearch

    '///<H1>Search for a string, apply restrictions, verify</H1>
    '///<h2>help_search.bas::tHelpSearch</h2>
    '///<ul>
    dim brc as boolean
    dim irc as integer
    
    dim sFileIn as string
    dim sFileOut as string
    dim aUIList( 100 ) as string
    
    dim cBasePath as string 
        cBasePath = gTesttoolPath & "framework\help\input\search"
    dim cDataFile as string
    
    '///+<li>Open the help browser</li>
    brc = hOpenHelp()
    if ( not brc ) then
        warnlog( "Help not open, aborting test" )
        goto endsub
    endif

    
    '///+<li>Switch to the Search-tab (find)</li>
    brc = hSelectHelpTab( "find" )
    if ( not brc ) then
        warnlog( "Could not access requested TabPage, aborting test" )
        call hClosehelp()
        goto endsub
    endif
    
    '----------- Search without filter -----------------------------------------
    printlog( "" )
    printlog( "Search for <java> without any filter" )
    
    '///+<li>Enter &quot;Java&quot; into the search entryfield</li>
    '///+<li>Uncheck Whole words only and headings only</li>
    SearchFind.setText( "java" )
    FindFullWords.unCheck()
    FindInHeadingsOnly.unCheck()
    
    '///+<li>Click &quot;Search&quot;</li>
    FindButton.click()

    '///+<li>Retrieve all entries from the list</li>
    ListAllDelete( aUIList() )
    hGetListItems( Result, aUIList() )
    
    '///+<li>Compare content to a reference or create a new ref-file</li>
    cDataFile = hGetLocalizedFileName( "search_without_filter.txt" )
    sFileOut  = hGetWorkFile( cDataFile )
    sFileIn   = hGetInputPath( cBasePath, cDataFile )
    irc       = hManageComparisionList( sFileIn, sFileOut, aUIList() )
    if ( irc <> 0 ) then
        warnlog( "Lists are not identical, please review the log" )
    endif
    
    ' ------------ Search whole words only -------------------------------------
    printlog( "" )
    printlog( "Search for <java>, whole words only" )
    
    '///+<li>Apply filter: Whole words only</li>
    SearchFind.setText( "java" )
    FindFullWords.Check()
    FindInHeadingsOnly.unCheck()   
    
    '///+<li>Click &quot;Search&quot;</li>
    FindButton.click()     
  
    '///+<li>Retrieve all entries from the list</li>
    ListAllDelete( aUIList() )
    hGetListItems( Result, aUIList() )
    
    '///+<li>Compare content to a reference or create a new ref-file</li>
    cDataFile = hGetLocalizedFileName( "search_whole_words_only.txt" )
    sFileOut  = hGetWorkFile( cDataFile )
    sFileIn   = hGetInputPath( cBasePath, cDataFile )
    irc       = hManageComparisionList( sFileIn, sFileOut, aUIList() )
    if ( irc <> 0 ) then
        warnlog( "Lists are not identical, please review the log" )
    endif

    ' ------------ Search headings only ----------------------------------------
    printlog( "" )
    printlog( "Search for <java>, headings only" )    
        
    '///+<li>Apply filter: Whole words only</li>
    SearchFind.setText( "java" )
    FindFullWords.unCheck()
    FindInHeadingsOnly.Check()   
    
    '///+<li>Click &quot;Search&quot;</li>
    FindButton.click()     
  
    '///+<li>Retrieve all entries from the list</li>
    ListAllDelete( aUIList() )
    hGetListItems( Result, aUIList() )
    
    '///+<li>Compare content to a reference or create a new ref-file</li>
    cDataFile = hGetLocalizedFileName( "search_headings_only.txt" )
    sFileOut  = hGetWorkFile( cDataFile )
    sFileIn   = hGetInputPath( cBasePath, cDataFile )
    irc       = hManageComparisionList( sFileIn, sFileOut, aUIList() )
    if ( irc <> 0 ) then
        warnlog( "Lists are not identical, please review the log" )
    endif

    ' ------------ Search headings and whole words -----------------------------
    printlog( "" )
    printlog( "Search for <java>, limit results to whole words and headings" )    
        
    '///+<li>Apply filter: Headings and whole words</li>
    SearchFind.setText( "java" )
    FindFullWords.Check()
    FindInHeadingsOnly.Check()  
    
    '///+<li>Click &quot;Search&quot;</li>
    FindButton.click()      
  
    '///+<li>Retrieve all entries from the list</li>
    ListAllDelete( aUIList() )
    hGetListItems( Result, aUIList() )
    
    '///+<li>Compare content to a reference or create a new ref-file</li>
    cDataFile = hGetLocalizedFileName( "search_headings_and_whole_words.txt" )
    sFileOut  = hGetWorkFile( cDataFile )
    sFileIn   = hGetInputPath( cBasePath, cDataFile )
    irc       = hManageComparisionList( sFileIn, sFileOut, aUIList() )
    if ( irc <> 0 ) then
        warnlog( "Lists are not identical, please review the log" )
    endif    
    
    
    hCloseHelp()

endcase

