'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_lvl1_ole.bas,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: jsk $ $Date: 2007/08/14 19:10:59 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : OLE
'*
'\******************************************************************************

sub main

    use "framework\level1\inc\l1_ole_tools.inc"
    use "framework\level1\inc\l1_ole.inc"
    use "framework\level1\inc\l1_ole2.inc"
    use "framework\level1\inc\l1_ole3.inc"
    
    use "framework\tools\inc\filetools.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\stringtools.inc"
    
    dim iCurrentApp as integer
    
    call hStatusIn ( "framework", "f_lvl1_ole.bas" )
    
    printlog( "" )
    printlog( "Quick tests of the OLE object dialog" )
    call tOLEWriter
    call tOLECalc
    call tOLEDraw
    call tOLEImpress   
    
    printlog( "" )
    printlog( "A more exhaustive test of the OLE dialog" )
    qaerrorlog( "#i80670# The OLE retrieval routine is broken beyond repair, redesign required" )
    'call tCheckTheOLEObjectDialog
    
    printlog( "" )
    printlog( "Do some presets required to make the following tests run smoothly" )
    call hSetToStandardView ( "WRITER" )
    call hSetToStandardView ( "GLOBALDOC" )    
     
    printlog( "" )
    printlog( "All useful combinations of applications / OLE objects" )
    
    ' Run this one in advance. Note that this function changes gApplication
    call GetOLEDefaultNames()
    
    for iCurrentApp = 1 to 6
    
        printlog( "" )
        printlog( hNumericDoctype( iCurrentApp ) )
        printlog( "" )
        
        if ( iCurrentApp = 5 ) then
            printlog( "Skipping Math" )
        else ' Testcase names as before to keep comparability to earlier testruns
            call tWriter_as_OLE_object()
            call tCalc_as_OLE_Object()
            call tDRAW_as_OLE_Object()
            call tImpress_as_OLE_Object()
            call tMath_as_OLE_Object ()
            call tChart_as_OLE_Object ()
        endif
        
    next iCurrentApp
    
    call hStatusOut()
    
end sub

'*******************************************************************************

sub LoadIncludeFiles
   use "global\system\inc\master.inc"
   use "global\system\inc\gvariabl.inc"
   Call GetUseFiles
   gApplication   = "DESKTOP"
End Sub

