'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_lvl1_customized_icons.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: jsk $ $Date: 2007/05/30 06:23:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Customized icons in toolbar Test
'*
'*******************************************************************************
'**
' #1 tCustomized_icons01 ' Add customized icons and scripts to the standardbar
'**
'\******************************************************************************

testcase tCustomized_icons01
    
    const MACRO_COUNT = 6
    const TOOLBAR_ICONS_BEFORE = 38
    const TOOLBAR_ICONS_AFTER  = 44
    const DOCUMENT_COUNT = 2

    dim brc as boolean
    
    dim iCurrentPos as integer
    dim iTabLimit as integer
    
    dim iCurrentMacro as integer
    dim cCurrentMacro as string
    
    dim iCurrentIcon as integer
    dim iToolbarItemCount as integer
    
    dim cWorkFile as string
        cWorkFile = convertpath( gOfficePath + "user\work\cust_icons.odt" )
        
    dim cMacroNames( MACRO_COUNT ) as string
    dim iName as integer
    for iName = 1 to MACRO_COUNT
        cMacroNames( iName ) = "icon" & iName
    next iName 
        
    '///<h1>Add custom icons to the standardbar and execute the associated macros</h1>
    
    '///<ul>
    
    '///+<li>Open new writerdocument</li>
    hCreateDocument()
    
    ' without the new macros there should be 38 icons on the toolbar
    kontext "StandardBar"
    iToolbarItemCount = standardbar.getItemCount()
    if ( iToolbarItemCount <> TOOLBAR_ICONS_BEFORE ) then
    	warnlog( "The toolbar has a non-default itemcount. Please reset!" )
    endif
    
    '///+<li>Create new basic module with six subs, attached to the new document</li>
    brc = hInitBasicIde( "AppMakro" )
    if ( not brc ) then
        warnlog( "Could not open the BASIC Macro Organizer, aborting" )
        hDestroyDocument()
        goto endsub
    endif
    EditWindow.TypeKeys( "<mod1 a><DELETE>" )
    For iCurrentMacro = 1 to MACRO_COUNT
        EditWindow.TypeKeys( "sub " & cMacroNames( iCurrentMacro ) & "<return>" )
        EditWindow.TypeKeys( "    msgbox( """ & cMacroNames( iCurrentMacro ) & """ ) <return>" )
        EditWindow.TypeKeys( "<left><left><left><left>end sub <return><return>" )
    next iCurrentMacro
    
    '///+<li>Close the BASIC-IDE</li>
    brc = hCloseBasicIde()
    
    '///+<li>Open ToolsCustomizeToolbars and configure the new macros to the standardbar</li>
    brc = hToolsCustomizeOpen()
    brc = hToolsCustomizeSelectTab( "toolbars" )
    
    kontext "TabCustomizeToolbars"
    SaveIn.select(2)
    AddCommands.click()
    
    printlog( "Add Macros to the toolbar..." )
    kontext "ScriptSelector"
    LibraryTreeList.typeKeys( "<END><RIGHT><END><RIGHT><END><RIGHT><END>" )
    For iCurrentMacro = 1 to MACRO_COUNT
    
        cCurrentMacro = ScriptList.getSelText()
        
        if ( cCurrentMacro <> cMacroNames( iCurrentMacro ) ) then
        	warnlog( "Incorrect macro selected in ScriptSelector" )
        	printlog( "Expected: " & cMacroNames( iCurrentMacro ) )
        else
            ScriptSelector.ok
            printlog( "Added icon (scriptselector): " & cCurrentMacro )
        endif
          
    next iCurrentMacro
    ScriptSelector.cancel
    
    kontext "TabCustomizeToolbars"
    printlog( "Verify that the icons are added to the list of available items" )
    for iCurrentIcon = 1 to MACRO_COUNT
    
    	ToolbarContents.select( iCurrentIcon + 1 )
    	cCurrentMacro = ToolbarContents.getSelText()
    	
        if ( cCurrentMacro <> cMacroNames( iCurrentIcon ) ) then
        	warnlog( "Incorrect macro selected in ScriptSelector" )
        	printlog( "Expected: " & cMacroNames( iCurrentIcon ) )
        else
            printlog( "Added icon (Tools/Customize/Toolbars): " & cCurrentMacro
        endif
        
    next iCurrentIcon
    	
    brc = hToolsCustomizeClose( 1 )
    
    ' there should be 44 items on the toolbar
    kontext "StandardBar"
    iToolbarItemCount = standardbar.getItemCount()
    if ( iToolbarItemCount <> TOOLBAR_ICONS_AFTER ) then
    	warnlog( "The toolbar has a non-default itemcount. Please reset!" )
    endif
    
   
    '///+<li>Click on new icons on Standardbar</li>
    For iCurrentIcon = 1 to MACRO_COUNT
        
        kontext "standardbar"
        Standardbar.TypeKeys("<Home>")
        if ( iCurrentIcon > 1 ) then

            ' Unfortunately we have a platform dependency for the toolbar behavior when
            ' navigating around using the TAB key.
            select case gtSYSName
            case "Linux"         : iTabLimit = iCurrentIcon 
            case "Solaris x86"   : iTabLimit = iCurrentIcon - 1
            case "Solaris SPARC" : iTabLimit = iCurrentIcon
            case else            : iTabLimit = iCurrentIcon - 1
            end select
        
	        For iCurrentPos = 1 to iTabLimit
	            'printlog( "iCurrentIcon = " & iCurrentIcon )
	            'printlog( "iTabLimit    = " & iTabLimit    )
	            'printlog( "iCurrentPos  = " & iCurrentPos  )
    	        sleep( 1 )
        	    Standardbar.TypeKeys("<TAB>")
	        Next iCurrentPos
	    endif
        Standardbar.TypeKeys("<Return>")
        
        kontext "Active"
        if ( not Active.exists ) then
            warnlog "Wrong Icon pressed or Msgbox missing"
            hDestroyDocument()
            goto endsub
        else
        
	        if ( Active.GetText <> ( cMacroNames( iCurrentIcon ) ) ) then
    	        warnlog "Wrong MsgBox, should be " & cMacroNames( iCurrentIcon ) & " but is " & Active.GetText
        	else 
            	printlog( cMacroNames( iCurrentIcon ) & " ok" )
	        endif
    	    Active.OK
    	endif
    Next iCurrentIcon
    
    '///+<li>Save, close and reload the document allowing to execute macros</li>
    hDeleteFile( cWorkFile )
    hSaveFile( cWorkFile, "current" , false , true )
    hDestroyDocument()
    hLoadFile( cWorkFile )
    hAllowMacroExecution()
    
    ' We should have 44 icons on the toolbar
    kontext "StandardBar"
    iToolbarItemCount = standardbar.getItemCount()
    if ( iToolbarItemCount <> TOOLBAR_ICONS_AFTER ) then
    	warnlog( "The toolbar has an icorrect itemcout. Please check!" )
    endif
    
    
    '///+<li>Verifying that the macro is still working</li>
    printlog "Make sure that the macro is still working"
    For iCurrentIcon = 1 to MACRO_COUNT
        
        ' Selecting item using keyboard navigation. The icons are supposed to 
        ' be at position 1 to 6 on the standardbar - if the "Load URL" item
        ' is not visible (which is the default )
        kontext "standardbar"
        Standardbar.TypeKeys("<Home>")

        if ( iCurrentIcon > 1 ) then

            ' Unfortunately we have a platform dependency for the toolbar behavior when
            ' navigating around using the TAB key.
            select case gtSYSName
            case "Linux"         : iTabLimit = iCurrentIcon 
            case "Solaris x86"   : iTabLimit = iCurrentIcon - 1
            case "Solaris SPARC" : iTabLimit = iCurrentIcon
            case else            : iTabLimit = iCurrentIcon - 1
            end select
        
	        For iCurrentPos = 1 to iTabLimit
                sleep( 1 )
        	    Standardbar.TypeKeys("<TAB>")
	        Next iCurrentPos
	    endif
        Standardbar.TypeKeys("<Return>")
        
        kontext "Active"
        if ( not Active.exists() ) then
            warnlog "Wrong Icon pressed or Msgbox missing"
            hDestroyDocument()
            goto endsub
        else
        	if ( Active.GetText <> cMacroNames( iCurrentIcon ) ) then
            	warnlog "Wrong MsgBox, should be " & cMacroNames( iCurrentIcon ) & " but is " & Active.GetText
        	else 
            	printlog( cMacroNames( iCurrentIcon ) & " was saved and reloaded" )
        	endif
        	Active.OK()
        endif
        
        ' This happens if we run beyond the expected number of icons - we
        ' open a new document. Close all open docs and exit the test.
        if ( getDocumentCount <> DOCUMENT_COUNT ) then
        	warnlog( "Incorrect icon selected - a new document is open. Aborting" )
        	hDestroyDocument()
        	hDestroyDocument()
        	goto endsub
        endif
        
    Next iCurrentIcon
    
    '///+<li>Closing document</li>
    hDestroyDocument()
    
    '///</ul>
    
endcase



