'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: opt_ooo_security.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: jsk $ $Date: 2007/12/19 11:07:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Tools->Options: OpenOffice.org Security
'*
'*******************************************************************************
'**
' #1 tOOoSecurity
'**
'\******************************************************************************

testcase tOOoSecurity
    '///Test the OpenOffice.org/Security-Tabpage in Tools/Options
    '///<ul>    
    dim _file as string
    
    hNewDocument()
    '///<li>check defaults</li>
    _file = gTesttoolPath & "framework\options\input\ooo_security_defaults.ref"
    checkSecurityPage( _file )

    '///<li>change the settings</li>    
    _file = gTesttoolPath & "framework\options\input\ooo_security_changed.ref"
    changeSecurityPage( _file )
    
    '///<li>check the changes</li>
    checkSecurityPage( _file )
    
    '///<li>revert to default settings</li>
    _file = gTesttoolPath & "framework\options\input\ooo_security_defaults.ref"
    changeSecurityPage( _file )
    
    '///<li>check the changes</li>
    checkSecurityPage( _file )
    
    '///</ul>
    kontext "ExtrasOptionenDlg"
    if ( ExtrasOptionenDlg.exists() ) then
        ExtrasOptionenDlg.ok()
    else
        warnlog( "options dialog not available" 
    endif
endcase

'*******************************************************************************

sub checkSecurityPage( _file as string )
    _file = convertpath( _file )

    printlog( " * Testing current settings against a reference list." )
    printlog( " * Using settings from file: " & _file )

    ToolsOptions
    call hToolsOptions("StarOffice", "Security")
    
    kontext "TabSecurity"
    if ( TabSecurity.exists() ) then
       
        Options.click
        
        Kontext "TabSecurityOptionsAndWarnings"
        if ( TabSecurityOptionsAndWarnings.exists( 2 ) ) then
            checkCheckBox( _file , "*" , SavingOrSendingDocuments )
            checkCheckBox( _file , "*" , SigningDocuments )
            checkCheckBox( _file , "*" , PrintingDocuments )
            checkCheckBox( _file , "*" , CreatingPDFfiles )
            checkCheckBox( _file , "*" , RemovePersonalInformationOnSaving )
            checkCheckBox( _file , "*" , RecommendPasswordProtectionOnSaving )
            TabSecurityOptionsAndWarnings.cancel
        else
            warnlog( "Failed to open Security options" )
        endif
        
        Kontext "TabSecurity"
        if ( TabSecurity.exists() ) then
            checkCheckBox( _file , "*" , RecommendToOpenDocumentReadOnly )
            checkCheckBox( _file , "*" , RecordChanges )   
        else
            warnlog( "Could not return to Security Tabpage" )
        endif
    else
        warnlog( "Security Tabpage not available" )
    endif
end sub

'*******************************************************************************

sub changeSecurityPage( _file as string )
    _file = convertpath( _file )
    
    printlog( " * Changing current settings according to the reference list." )
    printlog( " * Using settings from file: " & _file )
    
    Options.click
    Kontext "TabSecurityOptionsAndWarnings"
    setCheckBox( _file , "*" , SavingOrSendingDocuments )
    setCheckBox( _file , "*" , SigningDocuments )
    setCheckBox( _file , "*" , PrintingDocuments )
    setCheckBox( _file , "*" , CreatingPDFfiles )
    setCheckBox( _file , "*" , RemovePersonalInformationOnSaving )
    setCheckBox( _file , "*" , RecommendPasswordProtectionOnSaving )
    TabSecurityOptionsAndWarnings.cancel
    Kontext "TabSecurity"
    setCheckBox( _file , "*" , RecommendToOpenDocumentReadOnly )
    setCheckBox( _file , "*" , RecordChanges )
    
    Kontext "OptionenDLG"
    OptionenDLG.OK
   
    sleep(2)
    call exitRestartTheOffice()
end sub


