'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_trusted_path.bas,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2007/10/17 08:41:10 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Execute macros from trusted path
'*
'\******************************************************************************

sub main

    use "framework\security\inc\f_sec_trusted_path.inc"

    use "framework\tools\inc\filetools.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\security_tools.inc"

    ' this is the trusted path we want to add to the list
    dim cWorkPath as string
        cWorkPath = gTesttoolPath & "framework\basic\input\BasicDocs\"
        cWorkPath = convertpath( cWorkPath )

    ' this is the file to be loaded, located directly below trusted path
    dim cWorkFile as string

    dim iApplication as integer ' Index of the application WRITER, CALC ...
    dim cApplication as string  ' Name of the current application
    
    dim iSecurityLevel as integer ' Security from loweset to highest (0...4)

    call hStatusIn( "framework" , "f_sec_trusted_path.bas" )

    ' Add a trusted path which contains a number of files with macros
    hAddTrustedPath( cWorkPath )

    ' For each security level we verify that macros are executed
    for iSecurityLevel = 0 to 3
    
        hSetMacroSecurityAPI( iSecurityLevel )
    
        ' Cycle through the six main applications for the most recent documenttype
        for iApplication = 1 to 6 step 2 ' Do not test all, does not seem to be required.

            cWorkFile = cWorkPath & "basic" & hGetSuffix( "current" )
            cApplication = hNumericDoctype( iApplication )

            printlog( "" )
            printlog( cApplication )
            call tSecTrustedPath( cWorkFile, iSecurityLevel )

        next iApplication
        
    next iSecurityLevel

    ' Reset the trusted path, reset macro security level.
    hRemoveTrustedPath( cWorkPath )
    hSetMacrosecurityAPI( GC_MACRO_SECURITY_LEVEL_DEFAULT )

    call hStatusOut()

end sub

'-------------------------------------------------------------------------

sub LoadIncludeFiles

    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    gApplication = "WRITER"
    call GetUseFiles()

end sub

