'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_evilmacro3.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsk $ $Date: 2007/12/13 09:38:12 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Load documents containing hidden BASIC scripts
'*
'*******************************************************************************
'**
' #1 tSecurityEvilMacro3 ' Macros not executed/Security level set to High or Very High
'**
'\******************************************************************************

testcase tSecurityEvilMacro3()

    '///<h1>Level 1 test: Macros not executed/Security level set to High or Very High</h1>
    '///<ul>
    
    use "framework\tools\inc\stringtools.inc"

    dim acFile( 2 ) as string

        acFile( 1 ) = gTesttoolPath & "framework\security\input\test_macro.html"
        acFile( 1 ) = convertpath( acFile( 1 ) )

        acFile( 2 ) = gTesttoolPath & "framework\security\input\test_macro.odt"
        acFile( 2 ) = convertpath( acFile( 2 ) )

    dim iCurrentFile as integer ' increment variable
    dim cMsg as string          ' string from messagebox
    dim brc as boolean          ' some returnvalue
    

    '///+<li>Do following for each document to be tested:</li>
    '///<ul>

    for iCurrentFile = 1 to ubound( acFile() )

        printlog( "" )
        printlog( "File: " & acFile( iCurrentFile ) )

        '///+<li>Click FileOpen or go to the dialog via menu</li>
	FileOpen

        '///+<li>Enter the name of the file</li>
	kontext "OeffnenDlg"
	Dateiname.setText( acFile( iCurrentFile ) )

        '///+<li>Click &quot;Open&quot;</li>
        Oeffnen.click()

      
        '///+<li>We expect a message that macros exist but that they will not be executed</li>
        kontext "Active"
        if ( active.exists() ) then
            cMsg = active.getText()
            cMsg = hRemoveLineBreaks( cMsg )
            printlog( "Messagebox: " & cMsg )
            active.ok()
        else
            warnlog( "Missing messagebox: Document contains macros ..." )
        endif

        '///+<li>Wait a moment for the document to get loaded</li>
        '///+<li>Check for a messagebox to come up on load. This might only<br>
        '///+ after a security warning has been displayed!</li>
        kontext "Active"
        if ( active.exists( 5 ) ) then

            ' warn if macro runs without security warning
            warnlog( "A macro was executed without permission" )

            ' get the string on the messagebox
            cMsg = active.getText()
            cMsg = hRemoveLineBreaks( cMsg )
            warnlog( "Macro was executed: " & cMsg )
            active.ok()
        else
            printlog( "Macro was not executed" )
        endif

        '///+<li>Close the document</li>
        call ExitRestartTheOffice()

    next iCurrentFile

    '///</ul>
    '///</ul>

endcase

