'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_filters.bas,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2007/01/25 11:19:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : get filternames for a specific version
'*
'\******************************************************************************

sub main

    use "framework\tools\inc\filetools.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\stringtools.inc"

    f_filters( "569" )
    f_filters( "641" )
    f_filters( "645" )
    f_filters( "680" )

end sub

'-------------------------------------------------------------------------

sub LoadIncludeFiles

    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    gApplication = "WRITER"
    call GetUseFiles()

end sub

'*******************************************************************************

function f_filters( cBuildId as string ) as boolean

    '///<h1>Function to retrieve filternames from the UI</h1>
    '///+This function extends the functionality provided by CreateFilterNamesList
    '///+by creating the lists for older office versions as well
    '///You will have to edit and copy the files before checking them in!
    
    ' Internal stuff:
    ' - The function uses global/input/filters/native_suffixes.dat to preselect
    '   the filters by their extension. This works 100% for the current filters
    '   but only partly for older ones as we have the same suffixes for different
    '   file formats. This means the list created by this function have to be
    '   reviewed and the incorrect lines have to be removed. If we have <> than 
    '   7 filters in the list, the function warns and returns false.
    ' - The function will create its files below the user directory using the 
    '   same directory structure as it can be found below global/.../filters/...
    ' - This is not a testcase
   

    const CFN = "f_filters::"
    const IMAX_FILTERS = 30  ' max number of filters in filterlist per application

    dim sFileOut as string
    
    dim aFilterNames( IMAX_FILTERS ) as string ' filters per application
    dim aFilterList( IMAX_FILTERS ) as string  ' filterlist for output
    dim cSuffix as string                      ' suffix for Build-ID
    
    dim iApplication as integer ' numeric expression for gApplication
    dim cApplication as string  ' same as gApplication
    
    dim iFilterCount as integer   ' number of filters in list per application
    dim iCurrentFilter as integer ' the current filter-index in loops
    dim cCurrentFilter as string  ' the current filter-name in loops
    
    dim bOK as boolean ' boolean errorvalue, we assume all is well
        bOK = true
    
    ' General settings: We need a place to put the file. We create the same 
    ' directory structure than the one used below global/input/filters/...
    sFileOut = hGetWorkPath() 
    sFileOut = convertpath( sFileOut & cBuildId )
    hCreateDirectory( sFileOut ) ' (.../user/work/BuildID)
    
    sFileOut = convertpath( sFileOut & "/" & gProductName )
    hCreateDirectory( sFileOut ) ' (.../user/work/BuildId/Branding)
    
    sFileOut = convertpath( sFileOut & "/" & "filter" & iSprache & ".txt" )
    hDeleteFile( sFileOut )      ' (.../user/BuildId/Branding/filterX.txt)
    
    ' Now retrieve the list of filternames and try to isolate those matching
    ' cBuildID
    for iApplication = 1 to 7
    
        ' Whatever version of the filter-names we are looking for, we have
        ' to cycle through all 7 applications
        cApplication = hNumericDocType( iApplication )
        printlog( "" )
        printlog( cApplication )
        
        ' create a new document and open the save-as dialog, we get the filters 
        ' from there
        hCreateDocument()
        FileSaveAs
        
        ' find out how many filters we have, if the list is too long, we cancel
        ' the list-creation for the application but do the others. In this case
        ' the function is to return 'false'
        Kontext "SpeichernDlg"
        iFilterCount = DateiTyp.getItemCount()
        if ( iFilterCount > IMAX_FILTERS ) then
            warnlog( CFN & "There are more filters listed than the array can hold" )
            printlog( CFN & "Skipping this application, please increase IMAX_FILTERS" )
            bOK = false
            exit for
        endif
        
        ' copy all filternames for the current application into an array
        ' for some reason DateiTyp.select() does not work so we use keyboard
        ' navigation instead
        printlog( CFN & "Retrieving filternames for " & cBuildId )
        for iCurrentFilter = 1 to iFilterCount
            cCurrentFilter = DateiTyp.getSelText()
            listappend( aFilterNames() , cCurrentFilter )
            DateiTyp.TypeKeys( "<DOWN>" )
        next iCurrentFilter
        
        ' close the save-as dialog and the document
        Kontext "SpeichernDlg"
        SpeichernDlg.cancel()
        hDestroyDocument()
        
        ' retrieve the suffix from native_suffixes.dat, we use it to remove
        ' as many invalid filternames as possible (The filternames always are
        ' appended by (.xxx), we try to match these suffixes.
        cSuffix = hGetSuffix( cBuildId )
        
        ' copy all matching filternames (by suffix) to a second array
        for iCurrentFilter = 1 to listCount( aFilterNames() )
            if ( instr( aFilterNames( iCurrentFilter ) , cSuffix ) <> 0 ) then
                cCurrentFilter = gApplication & "=" & aFilterNames( iCurrentFilter )
                listAppend( aFilterList() , cCurrentFilter )
            endif
        next iCurrentFilter
        
        ListAllDelete( aFilterNames() )
        
    next iApplication
    
   
    ListWrite( aFilterList() , sFileOut , "UTF8" )
    hListPrint( aFilterList() , "Filternames" )
    
    printlog( "" )
    printlog( "How to proceed:" )
    printlog( "   The file is located at: " & sFileOut
    printlog( "1. Review the filecontent, delete incorrect entries (if any)" )
    printlog( "   There should be 7 entries (one for each gApplication)" )
    printlog( "   Check the spelling, verify translations" )
    printlog( "2. Copy the file to the directory below global/input/filters" )
    printlog( "3. Check the file into CVS" )
    printlog( "" )
    printlog( "" )
    
    if ( bOK ) then
        if ( listcount( aFilterList() ) <> 7 ) then
            warnlog( CFN & "Incorrect number of filters found, check outputfile" ) 
            bOK = false
        endif
    endif
    
    f_filters() = bOK
    
end function

'*******************************************************************************


