'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: docfuncs.inc,v $
'*
'*  $Revision: 1.47 $
'*
'*  last change: $Author: jsk $ $Date: 2007/12/19 09:42:39 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : misc functions to handle documents
'*
'*******************************************************************************
' **
' #1 hUseImpressAutopilot ' enables/disables the autopilot in tools/options
' #1 hCloseNavigator ' closes the navigator in writer
' #1 hNumericDocType ' translates a given number to a gApplication
' #1 hChangeDoc ' changes any documenttype (to trigger document-is-changed-flag)
' #1 hIdentifyWriterDoc ' verify that the correct document has the focus
' #1 hCreateDocument ' open new document, return true on success
' #1 hDocumentTypeKeys ' type some chars/sequences to any document
' #1 hDestroyDocument ' close a document, return true on success
' **
'\******************************************************************************

function hUseImpressAutopilot( bEnable as boolean ) as boolean

    '///<h3>Enable/disable the Impress Autopilot in Tools/Options</h3>
    '///<i>Starting point: Any plain document</i>
    '///<ul>
    const CFN = "hUseImpressAutopilot::"
    
    printlog( CFN & "Enter" )

    '///+<li>Create a new IMPRESS document</li>
    gApplication = "IMPRESS"
    hCreateDocument()

    '///+<li>Open Tools/Options, go to Presentataion/General page</li>
    ToolsOptions
    hToolsOptions( "Presentation" , "General" )

    '///+<li>Check or uncheck to start with autopilot</li>
    Kontext "TabSonstigesDraw"
    if ( mitAutopilotStarten.exists() ) then

        if ( bEnable ) then
            mitAutopilotStarten.check()
            printlog( CFN & "Enable Impress Autopilot" )
        else
            mitAutopilotStarten.uncheck()
            printlog( CFN & "Disable Impress Autopilot" )
        endif

    else

        warnlog( CFN & "Cannot find Autopilot Checkbox" )

    endif
   
    '///+<li>Return Status of Checkbox (checked=TRUE)</li>
    hUseImpressAutopilot() = mitAutopilotStarten.isChecked()

    '///+<li>Close Tools/Options</li>
    Kontext "OptionenDlg"
    OptionenDlg.OK()

    '///+<li>Close IMPRESS document</li>
    hDestroyDocument()

    '///+<li>Returncode is undefined</li>
    printlog( CFN & "Exit" )
    '///</ul>
    
end function

'*******************************************************************************

function hCloseNavigator() as boolean

    '///<h3>Function to close the navigator</h3>
    '///<i>Starting point: Any document</i>
    '///<ul>
    const CFN = "hCloseNavigator::"
    
    printlog( CFN & "Enter" )
    
    '///+<li>close the navigator if found</li>
    Kontext "Navigator"
    if ( Navigator.Exists() ) then
        Navigator.Close()
        printlog( CFN & "Closed Navigator" )
    else
        printlog( CFN & "Navigator not present" )
    endif
    
    '///+<li>verify that the navigator is indeed closed, return true on success</li>
    Kontext "Navigator"
    if ( Navigator.exists() ) then
        hCloseNavigator() = false
        warnlog( CFN & "Failed to close Navigator, it is still open." )
    else
        hCloseNavigator() = true
    endif
    
    printlog( CFN & "Exit" )
    '///</ul>

end function

'*******************************************************************************

function hNumericDocType( doctype as integer ) as string

    '///<h3>Convert a numeric expression to a gApplication</h3>
    '///<i>BEWARE: This is a core function used by many testcases!</i><br>
    '///<u>Using file: framework/tools/input/applications.txt as reference</u>
    '///<ul>
    
    const CFN = "hNumericDocType::"
    
    dim sFile as string
        sFile = gTesttoolPath & "framework\tools\input\applications.txt"
        sFile = convertpath( sFile )
       
    dim sList( 100 ) as string
    dim iDocTypes as integer
    
    'printlog( CFN & "Enter" )
    
    '///+<li>Retrieve matching list from file</li>
    hGetDataFileSection( sFile , sList() , "application" , "" , "" )
    iDocTypes = val( sList( 0 ) )
    
    '///+<li>Verify that the functionparameter (documenttype) is valid</li>
    if ( ( doctype < 0 ) or ( doctype > iDocTypes ) ) then
        warnlog( CFN & "Undefined numeric doctype: " & doctype )
        hNumericDocType() = ""
        exit function
    endif
       
    '///+<li>Set gApplication to the requested document type</li>
    gApplication = hGetValueForKeyAsString( sList() , doctype )
    
    '///+<li>Set a plain text name as returnvalue for the function</li>
    hGetDataFileSection( sFile , sList() , "application_names" , "" , "" )
    hNumericDocType() = hGetValueForKeyAsString( sList() , gApplication )
    'printlog( CFN & "Exit" )
    '///</ul>

end function

'*******************************************************************************

function hChangeDoc() as string

    '///<h3>Function to modify all documenttypes to set  the "changed" flag</h3>
    '///<i>Starting point: Any plain document</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>String, ready to use in printlog</li>
    '///<ul>
    '///+<li>&quot;Changed &lt;Documenttype&gt;&quot;</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    select case gApplication
   
      '///+<li>WRITER: Type some text</li>
      case "WRITER", "HTML", "MASTERDOC"
                      Kontext "DocumentWriter"
                      DocumentWriter.TypeKeys "<Return>This doc is changed!"
                      hChangeDoc() = "Changed WRITER/HTML/MASTERDOC" 

      '///+<li>CALC: Write some text into the current location (usually A1)</li>
      case "CALC"   : Kontext "DocumentCalc"
                      DocumentCalc.TypeKeys "<Down>This doc is changed!<Return>"
                      hChangeDoc() = "Changed CALC" 

      '///+<li>DRAW: Draw a rectangle</li>
      case "DRAW"   : Kontext "DocumentDraw"
                      hRechteckErstellen ( 20, 20, 25, 25 )
                      gMouseClick ( 1, 1 )
                      hChangeDoc() = "Changed DRAW" 

      '///+<li>IMPRESS: Draw a rectangle</li>
      case "IMPRESS": Kontext "DocumentImpress"
                      hRechteckErstellen ( 20, 20, 25, 25 )
                      gMouseClick ( 1, 1 )
                      hChangeDoc() = "Changed IMPRESS" 

      '///+<li>MATH: Create a simple formaula</li>
      case "MATH"   : SchreibenInMathdok( "b over c" )
                      hChangeDoc() = "Changed MATH" 

   end select
   '///</ul>
   
end function

'*******************************************************************************

function hIdentifyWriterDoc( cString as string, bWarn as boolean ) as boolean

    '///<h3>Function to validate that the expected WRITER doc has the focus</h3>
    '///<i>Starting point: Any WRITER document containing some text</i>
    '///<ul>
    
    use "framework\tools\inc\stringtools.inc"

    const CFN = "hIdentifyWriterDoc::"
    dim cIdentifier as string
    dim irc as integer ' some temporary returnvalue
    
    printlog( CFN & "Enter" )

    '///+<li>Test the function parameter</li>
    if ( cString = "" ) then
        qaerrorlog( CFN & "Function parameter is empty string. Aborting" )
        hIdentifyWriterDoc() = false
        exit function
    endif

    '///+<li>Verify function prerequisites</li>
    kontext "DocumentWriter"
    if ( not DocumentWriter.exists() ) then
        printlog( CFN & "There is no Writer document. Aborting" )
        hIdentifyWriterDoc() = false
        exit function
    endif
    
    hIdentifyWriterDoc() = true

    '///+<li>Go to the very beginning of the current writer document</li>
    kontext "DocumentWriter"
    DocumentWriter.typeKeys( "<MOD1 HOME>" )
    
    '///+<li>Select the entire line</li>
    DocumentWriter.typeKeys( "<SHIFT END>" )
   
    '///+<li>copy the string to the clipboard and store it into a variable</li>
    try
	    editcopy
	    cIdentifier = getClipboardText()
	catch
	    warnlog( "EditCopy failed. Probably the document is empty" )
	    cIdentifier = "**** invalid ****"
	endcatch
    
   
    '///+<li>compare the string to the reference (given as parameter)</li>
    irc = hCompareSubstrings( cIdentifier, cString )

    '///+<li>Write the result to the printlog if desired</li>
    if ( irc = 0 ) then
   
        if ( bWarn ) then
            warnlog ( CFN & "The focus is not on the expected document" )
        else
            printlog( CFN & "The focus is not on the expected document" )
        endif
        
        printlog( CFN & "Expected: " & cString )
        printlog( CFN & "Found...: " & cIdentifier )
        hIdentifyWriterDoc() = false
      
    else
        printlog( CFN & "OK: The document contains the requested string" )
    endif
    '///+<li>Return TRUE only if the current document is the expected one</li>
    
    printlog( CFN & "Exit" )
    '///</ul>

end function

'*******************************************************************************

function hCreateDocument() as boolean

    '///<h3>Create anew document, extends hNewDocument()</h3>
    '///<i>Starting point: Any document</i><br>
    '///<i>Note: When calling this function with gApplication "BACKGROUND" the
    '///+ function will actually close one document to get to the backing window</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing, valid gApplication must be set</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorstatus (boolean)</li>
    '///<ul>
    '///+<li>TRUE if a new document was created successfully</li>
    '///+<li>FALSE if anything went wrong</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    const CFN = "hCreateDocument::"

    dim iDocCountBefore as integer 
    dim iDocCountAfter as integer

    '///+<li>Retrieve the number of open documents</li>
    iDocCountBefore = getDocumentCount
    printlog( CFN & "Number of open documents before: " & iDocCountBefore )

    '///+<li>Special treatment if gApplication = BACKGROUND (virtual gApplication)</li>
    if ( ucase( gApplication ) = "BACKGROUND" ) then
    	do while( getDocumentCount > 0 )
    	    hCloseDocument()
        loop
        hCreateDocument() = true
    else
    
        '///+<li>Open a new document using hNewDocument()</li>
        call hNewDocument()

        '///+<li>Retrieve the number of open documents</li>
        iDocCountAfter = getDocumentCount()

        '///+<li>Verify that there is exactly one more document than before</li>
        if ( iDocCountAfter = ( iDocCountBefore + 1 ) ) then
            hCreateDocument() = true
        else
            hCreateDocument() = false
        endif
    endif
    printlog( CFN & "Number of open documents after.: " & iDocCountAfter )
    '///</ul>
    
end function

'*******************************************************************************

function hDocumentTypeKeys( cString as string ) as boolean

    '///<h3>Type a string to a document</h3>
    '///<i>The documenttype is determined by gApplication.<br>
    '///See hNumericDocType for details and number/gApplication matching</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Keystrokes to be sent to the document (string), e.g.</li>
    '///<ul>
    '///+<li>&quot;&lt;SHIFT HOME&gt;&quot;</li>
    '///+<li>&quot;&lt;MOD1 A&gt;&quot;</li>
    '///+<li>&quot;&lt;MOD2 Q&gt;&quot;</li>
    '///+<li>&quot;Hello&quot;</li>
    '///</ul>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorstatus (boolean)</li>
    '///<ul>
    '///+<li>TRUE if all went well</li>
    '///+<li>FALSE on any error</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hDocumentTypeKeys::"
    dim brc as boolean
        brc = true
        
    printlog( CFN & "Enter" )
    
    '///+<li>Set focus to the current documenttype determined by gApplication</li>
    '///+<li>Type the string passed as function parameter</li>
    select case gApplication
    case "WRITER"   :   kontext "DocumentWriter"
                        DocumentWriter.typeKeys( cString )
    case "CALC"     :   kontext "DocumentCalc"
                        DocumentCalc.typeKeys( cString )
    case "IMPRESS"  :   kontext "DocumentImpress"
                        DocumentImpress.typeKeys( cString )
    case "DRAW"     :   kontext "DocumentDraw"
                        DocumentDraw.typeKeys( cString )
    case "MATH"     :   kontext "DocumentMath"
                        DocumentMath.typeKeys( cString )
    case "MASTERDOC":   kontext "DocumentWriter"
                        DocumentWriter.typeKeys( cString )
    case "HTML"     :   kontext "DocumentWriter"
                        DocumentWriter.typeKeys( cString )
    case else
        warnlog( CFN & "Exit: Unknown gApplication: " & gApplication )
        brc = false
    end select
    
    '///+<li>Print some message to the log on success</li>
    if ( brc ) then
        printlog( CFN & "Exit: Sent keystroke to " & gApplication )
    endif
    
    hDocumentTypeKeys() = brc
    '///</ul>
    
end function


'*******************************************************************************

function hDestroyDocument() as boolean


    '///<h3>Enhanced version of hCloseDoc()</h3>
    '///<i>Close a document and print some additional information to the log to
    '///+ ease debugging tests which handle a lot of documents</i><br><br>

    '///<u>Parameter(s):</u><br>
    '///<ol>
    '///+<li>No input parameters</li>
    '///</ol>


    '///<u>Returns:</u><br>
    '///<ol>
    '///+<li>Return value description</li>
    '///<ul>
    '///+<li>TRUE: The document was closed successfully (-1 open document)</li>
    '///+<li>TRUE: We are on backing window, no document closed</li>
    '///+<li>FALSE: The number of documents is unchanged, closing failed</li>
    '///+<li>FALSE: If any error occurred during close (open dialogs etc.)</li>
    '///</ul>
    '///</ol>

    const CFN = "hDestroyDocument::"
    dim brc as boolean 'a multi purpose boolean returnvalue
    dim irc as integer
    
    dim iOpenDocsBefore as integer
    dim iOpenDocsAfter as integer
    dim iAttemptToClose as integer

    '///<u>Description:</u>
    '///<ul>
    '///+<li>Get the current number of documents</li>
    iOpenDocsBefore = getDocumentCount
    printlog( CFN & "Open documents before close: " & iOpenDocsBefore )
    
    '///+<li>Handle special case of 0 open documents</li>
    '///<ul>
    if ( iOpenDocsBefore = 0 ) then
    
        '///+<li>If gApplication has been set to BACKGROUND explicitly we do a restart</li>
        if ( ucase( gApplication ) = "BACKGROUND" ) then
        
            do while ( getDocumentCount > 0 ) 
                hCloseDocument()
            loop
 
            iOpenDocsAfter = getDocumentCount
            printlog( CFN & "Open documents after restart: " & iOpenDocsAfter )
            
            if ( iOpenDocsAfter = 0 ) then
                hDestroyDocument() = true
                exit function
            else
                warnlog( CFN & "There should be 0 open documents" )
                hDestroyDocument() = false
                exit function
            endif
            
        '///+<li>Otherwise just do not close the backing window - do nothing</li>
        else
            printlog( CFN & "On backing window, no action taken" )
            hDestroyDocument() = true
            exit function
        endif
        
    endif
    '///</ul>
                
    '///+<li>Handle more than one open document - handle FileOpen/FileSave dialogs</li>
    '///<ul>
    brc = true
    for iAttemptToClose = 1 to 3
    
        '///+<li>FileOpen</li>
        kontext "OeffnenDlg"
        if ( OeffnenDlg.exists( 1 ) ) then
            qaerrorlog( CFN & "Closed FileOpen dialog. This was not expected." )
            OeffnenDlg.cancel()
            brc = false
        endif
        
        '///+<li>FileSave</li>
        kontext "SpeichernDlg"
        if ( SpeichernDlg.exists( 1 ) ) then
            qaerrorlog( CFN & "Closed FileSave dialog. This was not expected." )
            brc = false
        endif
        
        '///+<li>Check for any messagebox (some might still be floating around)</li>
        '///<ul>
        kontext "active"
        if ( active.exists( 1 ) ) then
        
            qaerrorlog( CFN & "Closed unexpected messagebox: " & active.getText() )
            
            '///+<li>Try to close the dialog clicking on &quot;OK&quot;</li>
            try
                active.ok()
                printlog( CFN & "Clicked <OK> to close the dialog" )
            catch
                printlog( CFN & "Failed using OK" )
            endcatch
            
            '///+<li>Try to close the dialog clicking on &quot;YES&quot;</li>
            try
                active.yes()
                printlog( CFN & "Clicked <YES> to close the dialog" )
            catch
                printlog( CFN & "Failed using <YES>" )
            endcatch
            
            brc = false
            
        endif
        '///</ul>
        
        '///+<li>Close the current document using hCloseDocument()</li>
        call hCloseDocument()
        
        '///+<li>Verify that the document has indeed been closed, exit function if yes</li>
        iOpenDocsAfter = getDocumentCount
        if ( iOpenDocsAfter = ( iOpenDocsBefore - 1 ) ) then
            printlog( CFN & "Open documents after close.: " & iOpenDocsAfter )
            hDestroyDocument() = brc
            exit function
        else
            qaerrorlog( CFN & "Failed to close document, retrying" )
            brc = false
        endif
        
    next iAttemptToClose    
    '///</ul>
    '///</ul>

    printlog( CFN & "Exit with result: " & brc )

    hDestroyDocument() = brc

end function
