'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: export_graphic.inc,v $
'*
'*  $Revision: 1.45 $
'*
'*  last change: $Author: wg $ $Date: 2008/02/14 15:03:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'* Owner : wolfram.garten@sun.com
'*
'* short description : Graphics Export A-tests. (More durable ones)
'*
'*******************************************************************************
'*
' #1 tEPS
' #1 tGIF
' #1 tJPEG
' #1 tPBM
' #1 tPCT
' #1 tPGM
' #1 tPPM
' #1 tRAS
' #1 tTIFF
' #1 tXPM
'*
'\******************************************************************************
testcase tEPS

   dim x as integer
   dim i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "EPS - Encapsulated PostScript (.eps)"
   sExt = ".eps"

   '/// open the document
   hDateiOeffnen ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString)

   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "EPSOptionen"
      if EPSOptionen.Exists (2) then
      '/// check if all properties have the right count, and depend on each other ///'
      ' they do not affect annything, i can check (TBO)
      ' VorschauTIF.Check
      '  InterchangeEPSI.Check
         Level1.Check
            if Farbe.IsEnabled then warnlog " :-("
            if Graustufen.IsEnabled then warnlog " :-("
            if LZWKodierung.IsEnabled then warnlog " :-("
            if Keine.IsEnabled then warnlog " :-("
            ' if (TextEinstellungen.IsEnabled <> TRUE) then warnlog " :-("
         Level2.Check
            if (Farbe.IsEnabled <> TRUE) then warnlog " :-("
            if (Graustufen.IsEnabled <> TRUE) then warnlog " :-("
            if (LZWKodierung.IsEnabled <> TRUE) then warnlog " :-("
            if (Keine.IsEnabled <> TRUE) then warnlog " :-("
            ' if (TextEinstellungen.IsEnabled <> TRUE) then warnlog " :-("
         '/// 'Color Resolution' listbox contains eight items ///'
         ' x = TextEinstellungen.GetItemCount
         ' if x <> 2 then warnlog "'TextEinstellungen' Count is wrong; should:2, is:" + x
         ' for i = 1 to x
         ' TextEinstellungen.Select i
         ' sleep 1
         ' Printlog " - " + i + ": '" +TextEinstellungen.GetSelText + "'"
         ' next i
         '/// leave dialog with cancel -> there has to be no file created! ///'
         EPSOptionen.Cancel
         sleep 5
         if ( dir(OutputGrafikTBO+sExt) = "") then ' inspired by bug #99932 Graphic is exported though cancel is pressed
            Printlog "Ok :-)"
         else
            warnlog "Dialog was canceled, but file got saved, too :-(  - i35177"
         endif
      else
         Warnlog "No '" + sFilter + "'-Option-Dialog!"
         i=5
      end if
      sleep 2
      Kontext "Active"
      if Active.Exists(2) then
         Warnlog "'" + sFilter + "' has a problem"
         Active.OK
      end if
   end if
   Printlog "'/// now save it realy and load the file afterwards ///'"
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "EPSOptionen"
      if EPSOptionen.Exists (2) then
      '  TextEinstellungen.select 2
         EPSOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tPCT

   dim x as integer
   dim i as integer
   dim iWaitIndex as integer
   dim sFilter as string
   dim sExt as string
   dim bTemp as boolean
   dim sX as string
   dim sY as string
   dim sx1 as string
   dim sX2 as string
   dim sY2 as string
   dim sDocument as string

   sFilter = "PCT - Mac Pict (.pct)"
   sExt = ".pct"

   '/// open the document
   sDocument = ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString)
   hDateiOeffnen sDocument

   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
      '/// check if all properties have the right count, and depend on each other ///'
         Original.Check
            if Breite.IsEnabled then warnlog " :-("
            if Hoehe.IsEnabled then warnlog " :-("
         Groesse.Check
            Breite.More
            Hoehe.Less
         '/// leave dialog with cancel -> there has to be no file created! ///'
         PICTOptionen.Cancel
         sleep 5
         if ( dir(OutputGrafikTBO+sExt) = "") then ' inspired by bug #99932 Graphic is exported though cancel is pressed
            Printlog "Ok :-)"
         else
            warnlog "Dialog was canceled, but file got saved, too :-(  - i35177"
         endif
      else
         Warnlog "No  '" + sFilter + "' -Dialog!"
         i=5
      end if
      sleep 2
      Kontext "Active"
      if Active.Exists(2) then
         Warnlog " '" + sFilter + "'  has a problem"
         Active.OK
      end if
   end if
   Printlog "'/// now save it realy and load the file afterwards ///'"
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
         Groesse.Check
            Breite.Less
            Hoehe.More
         PICTOptionen.OK
         iWaitIndex = 0
         do while PICTOptionen.Exists AND iWaitIndex < 30
         sleep (1)
         iWaitIndex = iWaitIndex + 1
         loop
      endif
      i=0
      while ((NOT fileExists(OutputGrafikTBO+sExt)) AND (i<36))
         inc(i)
         sleep(5)
      wend
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif
   hCloseDocument ()
   Printlog "'/// now save a SELECTION in ORIGINAL SIZE and load the file afterwards ///'"
   hDateiOeffnen (sDocument)
   sleep (10)

    ' check if the document is writable
    if fIsDocumentWritable = false then
        ' make the document writable and check if it's succesfull
        if fMakeDocumentWritable = false then
            warnlog "The document can't be make writeable. Test stopped."
            goto endsub
        endif
    endif

   hTypeKeys ("<escape><tab>")
   fGetSizeXY sx1, sY, TRUE
   if hCallExport (OutputGrafikTBO + "1" , sFilter, TRUE ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
         Original.Check
         PICTOptionen.OK
         iWaitIndex = 0
         do while PICTOptionen.Exists AND iWaitIndex < 30
         sleep (1)
         iWaitIndex = iWaitIndex + 1
         loop
      endif
      i=0
      while ((NOT fileExists(OutputGrafikTBO+ "1"+sExt)) AND (i<36))
         inc(i)
         sleep(5)
      wend
      if ( dir(OutputGrafikTBO + "1"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "1"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO + "1"+sExt )
      bTemp = FALSE
      fGetSizeXY sx1, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   hCloseDocument ()
   Printlog "'/// now CREATE a rectangle, select it, save it in SIZE and load the file afterwards ///'"
   hNewDocument()
   hRechteckErstellen ( 10, 10, 30, 40 )
   if hCallExport (OutputGrafikTBO + "2" , sFilter, TRUE ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
         Groesse.Check
            Breite.SetText "9"
            Hoehe.SetText "9"
            Groesse.Check 'Check "Size" one more time to make the change go through"
            sx1 = Breite.GetText
            sY = Hoehe.GetText
         PICTOptionen.OK
         iWaitIndex = 0
         do while PICTOptionen.Exists AND iWaitIndex < 30
            sleep (1)
            iWaitIndex = iWaitIndex + 1
         loop
      endif
      i=0
      while ((NOT fileExists(OutputGrafikTBO+ "2"+sExt)) AND (i<36))
         inc(i)
         sleep(5)
      wend
      if ( dir(OutputGrafikTBO + "2"+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO + "2"+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hDateiOeffnen (OutputGrafikTBO + "2"+sExt)
      kontext "DocumentDraw"
      DocumentDraw.TypeKeys ("<escape><tab>")
      ContextOriginalSize
      bTemp = FALSE
      fGetSizeXY sx1, sY, bTemp
      if (bTemp = FALSE) then
         warnlog "Selected original size NOT OK :-("
      endif
   endif
   if hCallExport (OutputGrafikTBO + "3" , sFilter, TRUE ) = TRUE then
      Kontext "PICTOptionen"
      if PICTOptionen.Exists (2) then
         Groesse.Check
            sX2 = Breite.GetText
            if (LiberalMeasurement(sx1, sX2)) <> TRUE then
               if (val(str(StrToDouble(sx1)+5)) >= StrToDouble(sX2) ) AND (val(str(StrToDouble ( sx1 )-5)) <= StrToDouble ( sX2 )) then
                  Printlog "Width was ok. Expected: " + sx1 + "' was: '" + sX2 + "'"
               else
                  warnLog "Width is different expected: '" + sx1 + "' is: '" + sX2 + "'"
               endif
            endif
            sY2 = Hoehe.GetText
            if (LiberalMeasurement(sY, sY2)) <> TRUE then
               if ( val(str(StrToDouble(sY)+5)) >= StrToDouble(sY2) ) AND (val(str(StrToDouble ( sY )-5)) <= StrToDouble ( sY2 )) then
                  Printlog "Height was ok. Expected: " + sY + "' was: '" + sY2 + "'"
               else
                  warnLog "Height is different expected: '" + sY + "' is: '" + sY2 + "'"
               endif
            endif
         PICTOptionen.Cancel
         sleep 5
       endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------------
testcase tPBM

   dim x as integer
   dim i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "PBM - Portable Bitmap (.pbm)"
   sExt = ".pbm"

   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PBMOptionen"
      if PBMOptionen.Exists (2) then
            Ascii.Check
         PBMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------------
testcase tPGM

   dim x as integer
   dim i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "PGM - Portable Graymap (.pgm)"
   sExt = ".pgm"

   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString  ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PGMOptionen"
      if PGMOptionen.Exists (2) then
            Ascii.Check
         PGMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------------
testcase tPPM

   dim x as integer
   dim i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "PPM - Portable Pixelmap (.ppm)"
   sExt = ".ppm"

   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString  ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PPMOptionen"
      if PPMOptionen.Exists (2) then
            Ascii.Check
         PPMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'------------------------------------------------------------------------------
testcase tRAS

    dim x as integer
    dim i as integer
    dim sFilter as string
    dim sExt as string
    
    sFilter = "RAS - Sun Raster Image (.ras)"
    sExt = ".ras"
    
     '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
         hCloseDocument ()
         sleep 5
         hNewDocument()
         sleep 5
         Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
      else
         warnlog "File didn't get saved :-("
      endif
   endif

   call hCloseDocument

endcase
'------------------------------------------------------------------------------
testcase tTIFF

    dim x as integer
    dim i as integer
    dim sFilter as string
    dim sExt as string
    
    sFilter = "TIFF - Tagged Image File Format (.tif;.tiff)"
    sExt = ".tif"
    
     '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
         hCloseDocument ()
         sleep 5
         hNewDocument()
         sleep 5
         Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
      else
         warnlog "File didn't get saved :-("
      endif
   endif

   call hCloseDocument

endcase
'------------------------------------------------------------------------------
testcase tXPM

    dim x as integer
    dim i as integer
    dim sFilter as string
    dim sExt as string
    
    sFilter = "XPM - X PixMap (.xpm)"
    sExt = ".xpm"
    
     '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
         hCloseDocument ()
         sleep 5
         hNewDocument()
         sleep 5
         Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
      else
         warnlog "File didn't get saved :-("
      endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------------
testcase tGIF

   dim x as integer
   dim i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "GIF - Graphics Interchange Format (.gif)"
   sExt = ".gif"

   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString)

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "GIFOptionen"
      if GIFOptionen.Exists (2) then
            Interlace.Uncheck
            TransparentSpeichern.UnCheck
         GIFOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------------
testcase tJPEG

   dim x as integer
   dim i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "JPEG - Joint Photographic Experts Group (.jpg;.jpeg;.jfif;.jif;.jpe)"
   sExt = ".jpg"

   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport."+ExtensionString)

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "JpegOptionen"
      if JpegOptionen.Exists (2) then
             Echtfarben.Check
             Qualitaet.ToMin
         JpegOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
