'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_namedrange.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: oc $ $Date: 2007/07/09 07:49:59 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : oliver.craemer@sun.com
'*
'* short description : calc named range level 2 test
'*
'*************************************************************************
'*
' #1 c_namedrange ' Initial routine
' #1 tAssignRangeName
' #1 tCheckErrorInvalidRangeName
' #1 tCheckErrorInvalidRangeSelected
'*
'\************************************************************************
'TODO: add some old features

sub cNamedRange

Printlog Chr(13) + "--------- named range ---------"

   call tAssignRangeName
   call tCheckErrorInvalidRangeName
   call tCheckErrorInvalidRangeSelected
End sub
'
'---------------------------------------------------------------------------

testcase tAssignRangeName

     dim sFilterName
         sFilterName = hGetUIFiltername("StarOffice XML (Calc)")
     dim sExtNames(20)
         sExtNames() = hGetFilternameExtension("calc_StarOffice_XML_Calc")
     dim sFileFormat as string
         sFileFormat = sFilterName & " (." & sExtNames(0) & ")"
     dim sInputFile as String
         sInputFile = convertpath(gTesttoolPath & "spreadsheet/level2/input/namedrange.sxc")
     dim sOutputFile as String
         sOutputFile = convertpath(gOfficePath & "user/work/assignrangename." & sExtNames(0))

     '///<b>Assign range names in name box</b>

     '///+<ul><li>Load test document</li>
     call hDateiOeffnen (sInputFile)
     sleep(2)
     '///+<li>Save test document localy</li>
     if NOT hSpeichernUnterMitFilterKill (sOutputFile , sFileFormat) then
         warnlog "Saving test document localy failed -> Aborting"
         call hCloseDocument
         goto endsub
     endif
  
     '///+<li>Select range C2:F10</li>
     call fCalcSelectRange("C2:F10")
     '///+<li>Assign name 'FirstRange'</li>
     call fCalcNameRange("FirstRange")
     '///+<li>Select range X31996:AB32005</li>
     call fCalcSelectRange("X31996:AB32005")
     '///+<li>Assign name 'SecondRange'</li>
     call fCalcNameRange("SecondRange")
     '///+<li>Select range IT65533:IU65535</li>
     call fCalcSelectRange("IT65533:IU65535")
     '///+<li>Assign name 'ThördRänge' (Special Characters ;-)</li>
     call fCalcNameRange("ThördRänge")
     '///+<li>Select cell J333</li>
     call fCalcSelectRange("J333")
     '///+<li>Assign name 'OneCell'</li>
     call fCalcNameRange("OneCell")
     '///+<li>Save changes and reload</li>
     FileSave
     sleep(5)
     call hCloseDocument
     sleep(3)
     call hDateiOeffnen (sOutputFile)
     sleep(3)
     '///+<li>Select range C2:F10</li>
     call fCalcSelectRange("C2:F10")
     '///+<li>Check for formula bar visibility</li>
     Kontext "RechenleisteCalc"
     if not RechenleisteCalc.isvisible then
        warnlog "Formula bar was expected to be visible"
        ViewToolbarsFormulaBar
     end if
     sleep(2)
     '///+<li>Check name box for 'FirstRange'</li>
     printlog "Check name box for 'FirstRange'"
     Kontext "RechenleisteCalc"
     if Bereich.GetSelText = "FirstRange" then 
        printlog "Correct name assigned for 'C2:F10'"
     else
        warnlog "Name for 'C2:F10' is " & Bereich.GetSelText & " instead of 'FirstRange'"
     end if
     '///+<li>Select range X31996:AB32005</li>
     call fCalcSelectRange("X31996:AB32005")
     '///+<li>Check name box for 'SecondRange'</li>
     printlog "Check name box for 'SecondRange'"
     Kontext "RechenleisteCalc"
     if Bereich.GetSelText = "SecondRange" then 
        printlog "Correct name assigned for 'X31996:AB32005'"
     else
        warnlog "Name for 'X31996:AB32005' is " & Bereich.GetSelText & " instead of 'SecondRange'"
     end if
     '///+<li>Select range IT65533:IU65535</li>
     call fCalcSelectRange("IT65533:IU65535")
     '///+<li>Check name box for 'ThördRänge' (Special Characters ;-)</li>
     printlog "Check name box for 'ThördRänge'"
     Kontext "RechenleisteCalc"
     if Bereich.GetSelText = "ThördRänge" then 
        printlog "Correct name assigned for 'IT65533:IU65535'"
     else
        warnlog "Name for 'IT65533:IU65535' is " & Bereich.GetSelText & " instead of 'ThördRänge'"
     end if
     '///+<li>Select cell J333</li>
     call fCalcSelectRange("J333")
     '///+<li>Check name box for 'OneCell'</li>
     printlog "Check name box for 'OneCell'"
     Kontext "RechenleisteCalc"
     if Bereich.GetSelText = "OneCell" then 
        printlog "Correct name assigned for 'J333'"
     else
        warnlog "Name for 'J333' is " & Bereich.GetSelText & " instead of 'OneCell'"
     end if
  '///+<li>Close document and finish test</li></ul>
     sleep(2)
     call hCloseDocument

  endcase
'
'---------------------------------------------------------------------------
'
testcase tCheckErrorInvalidRangeName
'TODO: (Maybe) add check for correct localized (l10n) error strings 
  '///<b>Check for error messages when assigning invalid range name</b>
  '///+<ul><li>New calc document</li>
  call hNewDocument
  '///+<li>Select range C2:F10</li>
  call fCalcSelectRange("C2:F10")
  '///+<li>Try to assign name '%FirstRange'</li>
  '///+<li>and check for failture</li>
  if fCalcNameRange("%FirstRange") then
     warnlog "OOPS, assigning invalid range name '%FirstRange' should fail!"
  else
     printlog "Invalid name was not accepted"
  endif
  '///+<li>Close document and finish test</li></ul>
  call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tCheckErrorInvalidRangeSelected
'TODO: (Maybe) add check for correct localized (l10n) error strings 
  '///<b>Check for error messages when assigning invalid range name</b>
  '///+<ul><li>New calc document</li>
'  if gtPlatform = "lin" then
'      warnlog "#i38648# makes this testcase probably fail. Waiting for the fix to verify"
'      goto endsub
'  endif
  call hNewDocument
  '///+<li>Select range C2:F10</li>
  call fCalcSelectRange("C2:D3")
  '///+<li>Change calc selection mode</li>
  Kontext "DocumentCalc"
  DocumentCalc.TypeKeys ("<SHIFT F8>")
  '///+<li>Add random cell to selection</li>
  Kontext "DocumentCalc"
  call gMouseClick (90,90)
  '///+<li>Try to assign valid name 'FirstRange'</li>
  '///+<li>and check for failture</li>
  if fCalcNameRange("FirstRange") then
     warnlog "OOPS, assigning invalid range selected with 'FirstRange' should fail!"
  else
     printlog "Invalid selection was not accepted"
  endif
  Kontext "DocumentCalc"
  '///+<li>Reset calc selection mode</li>
  DocumentCalc.TypeKeys ("<SHIFT F8>")
  '///+<li>Close document and finish test</li></ul>
  call hCloseDocument
endcase

