'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_chinesetranslate1.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:21:35 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Chinese Translation test
'*
'************************************************************************
'*
' #1 tDefaultSetting_1           'Default settings for different Chinese language
' #1 tDefaultSetting_2           'Default settings
' #1 tDefaultSetting_3           'Cursor's position
' #1 tChineseTranslate_1         'Translation for selected text
' #1 tChineseTranslate_2         'Translation for NO-selected document
' #1 tChineseTranslate_3         'Translation direction : T Chinese to S Chinese
' #1 tChineseTranslate_4         'Translation direction : S Chinese to T Chinese
' #1 tChineseTranslate_5         ''Use Taiwan , Hongkong SAR...'s statue
' #0 fSetAsian
'*
'\***********************************************************************

testcase tDefaultSetting_1

  printlog "Default settings for different Chinese language"
 '/// <b> Default settings for different Chinese language</b>

  Call hNewDocument

  '/// Set default language(asian) for document is "Simplified Chinese"
   fSetAsian(fGetLanguageName(86))

  '/// Tools/language / Chinese translation
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"

    '/// "Traditional Chinese to Simplified Chinese" should be Checked by default
     if NOT TChineseToSChinese.IsChecked then
         Warnlog "'Traditional Chinese to Simplified Chinese' should be Checked by default !"
     end if
   ChineseTranslation.Cancel

  '/// Set default language(asian) for document is "Traditional Chinese"
   fSetAsian(fGetLanguageName(88))

  '/// Tools/language / Chinese translation
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"

    '/// "Simplified Chinese to Traditional Chinese" should be Checked by default
     if NOT SChineseToTChinese.IsChecked then
         Warnlog "'Simplified Chinese to Traditional Chinese' should be Checked by default !"
     end if
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tDefaultSetting_2

  printlog "Default settings "
 '/// <b> Default settings </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Tools/language / Chinese translation
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"

'    '/// "Use Taiwan,Hongkong SAR , and Macao SAR character variants"
'    '/// + should NOT be Checked by default
'     if UseSARCharacter.IsChecked then
'         Warnlog "'Use Taiwan,Hongkong SAR , and Macao SAR character variants' should NOT be Checked by default !"
'     end if

    '/// "Common Terms" should NOT be Checked by default
     if TranslateCommonTerms.IsChecked then
         Warnlog "'Common Terms' should NOT be Checked by default !"
     end if

    '/// Click 'Edit terms' button
     EditTerms.Click
     Kontext "ChineseDictionary"

      '/// "Traditional Chinese to Simplified Chinese" should be Checked by default
       if NOT TChineseToSChinese.IsChecked then
           Warnlog "'Traditional Chinese to Simplified Chinese' should be Checked by default !"
       end if

      '/// "Reverse mapping" should NOT be Checked by default
       if ReverseMapping.IsChecked then
           Warnlog "'Reverse mapping' should NOT be Checked by default !"
       end if

      '/// "Property" should be "other" by default
       if Property.GetSelIndex <> 1 then
           Warnlog "'Property' should be 'Other' by default !"
       end if
     ChineseDictionary.Cancel

   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tDefaultSetting_3

  Dim sChinese , sExpect  as  String

  sChinese = "红上蓝国"
  sExpect  = "紅"

  printlog "Cursor position"
 '/// <b> Cursor position </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input some chinese and set cursor in the beginning
   Call wDokSchreiben sChinese
   Call wDokSchreiben "<Home>"

  '/// Tools/language / Chinese translation , check
  '/// + "Simplified Chinese to Traditional Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check
   ChineseTranslation.OK

  '/// Check if the cursor's position is changed -- Should NOT
   Call wDokSchreiben "<Shift Right>"
   try
       EditCopy
       if GetClipboardText <> sExpect then
           Warnlog "Hope to get " & sExpect & " but get " & GetClipboardText
       end if
   catch
       Warnlog "Cursor's position is changed - 117787"
   endcatch

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_1

  Dim sChinese , sExpect  as  String

  sChinese = "红上蓝国"
  sExpect  = "紅上蓝国"

  printlog "Translation for selected text"
 '/// <b> Translation for selected text </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input some chinese and select part of input
   Call wDokSchreiben sChinese
   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Shift Right>" , 2

  '/// Tools/language / Chinese translation , check
  '/// + "Simplified Chinese to Traditional Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check
   ChineseTranslation.OK

  '/// Check if the only selected text is translated -- Should
   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Shift End>"
   EditCopy
   if GetClipboardText <> sExpect then
       Warnlog "Hope to get " & sExpect & " but get " & GetClipboardText
   end if

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_2

  Dim sChinese , sExpect  as  String

  sChinese = "红上蓝国"
  sExpect  = "紅上藍國"

  printlog "Translation for NO-selected document"
 '/// <b> Translation for NO-selected document </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input some chinese
   Call wDokSchreiben sChinese

  '/// Tools/language / Chinese translation , check
  '/// + "Simplified Chinese to Traditional Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check
   ChineseTranslation.OK

  '/// Check if all document is translated -- Should
   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Shift End>"
   EditCopy
   if GetClipboardText <> sExpect then
       Warnlog "Hope to get " & sExpect & " but get " & GetClipboardText
   end if

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_3

  Dim sChinese , sExpect  as  String

  sChinese = "红上藍國"
  sExpect  = "红上蓝国"

  printlog "Translation direction : T Chinese to S Chinese"
 '/// <b> Translation direction : T Chinese to S Chinese </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(88))

  '/// Input some chinese , include some
  '/// + tradition chinese and simplified chinese
   Call wDokSchreiben sChinese

  '/// Tools/language / Chinese translation , check
  '/// + "Traditional Chinese to Simplified Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     TChineseToSChinese.Check
   ChineseTranslation.OK

  '/// Check if only traditional chinese is translated -- Should
   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Shift End>"
   EditCopy
   if GetClipboardText <> sExpect then
       Warnlog "Hope to get " & sExpect & " but get " & GetClipboardText
   end if

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_4

  Dim sChinese , sExpect  as  String

  sChinese = "红上藍國"
  sExpect  = "紅上藍國"

  printlog "Translation direction : S Chinese to T Chinese"
 '/// <b> Translation direction : S Chinese to T Chinese </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(86))

  '/// Input some chinese , include some
  '/// + tradition chinese and simplified chinese
   Call wDokSchreiben sChinese

  '/// Tools/language / Chinese translation , check
  '/// + "Simplified Chinese to Traditional Chinese" , press OK
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     SChineseToTChinese.Check
   ChineseTranslation.OK

  '/// Check if only simplified chinese is translated -- Should
   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Shift End>"
   EditCopy
   if GetClipboardText <> sExpect then
       Warnlog "Hope to get " & sExpect & " but get " & GetClipboardText
   end if

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

testcase tChineseTranslate_5

  printlog "'Use Taiwan , Hongkong SAR...'s statue"
 '/// <b> 'Use Taiwan , Hongkong SAR...'s statue </b>

  Call hNewDocument

   fSetAsian(fGetLanguageName(88))

  '/// Tools/language / Chinese translation ,
  '/// Check "Traditional Chinese to Simplified Chinese"
  '/// + "Use Taiwan , Hongkong SAR..." should be disable
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     TChineseToSChinese.Check
     try
         UseSARCharacter.Check
         Warnlog "'Use Taiwan , Hongkong SAR and ...' should be disable !"
     catch
     endcatch

  '/// Check "Simplified Chinese to Traditional Chinese"
  '/// + "Use Taiwan , Hongkong SAR..." should be enabled
     SChineseToTChinese.Check
     try
         UseSARCharacter.Check
     catch
         Warnlog "'Use Taiwan , Hongkong SAR and ...' should be enabled !"
     endcatch

  '/// UnCheck "Use Taiwan , Hongkong SAR..."
     UseSARCharacter.UnCheck

  '/// Check "Translate Common Terms"
     TranslateCommonTerms.Check

  '/// "Use Taiwan , Hongkong SAR..." should be checked automatically
     if NOT UseSARCharacter.IsChecked then
         Warnlog "'Use Taiwan , Hongkong SAR and ...' should be checked !"
     end if
   ChineseTranslation.OK

  '/// Close the dialog and reopen it
  '/// "Use Taiwan , Hongkong SAR..." and "Translate Common Terms"
  '/// + should be checked
   ToolsLanguageChineseTranslation
   Kontext "ChineseTranslation"
     if NOT UseSARCharacter.IsChecked then
         Warnlog "'Use Taiwan , Hongkong SAR and ...' should be checked ! - 117802 "
     end if
     if NOT TranslateCommonTerms.IsChecked then
         Warnlog "'Translate common terms' should be checked ! - 117802 "
     end if
   ChineseTranslation.Cancel

  Call hCloseDocument

endcase

'-----------------------------------------------------------------

function fSetAsian(sAsian as String)  as String

    'This function is set CJK language in Tools/Options/Language Settings / Languages
    ToolsOptions
    Call hToolsOptions("LANGUAGESETTINGS","LANGUAGES")
    fSetAsian = Asiatisch.GetSelText
    if sAsian = "Null" then
        Asiatisch.Select  1
        goto GoON
    else
        Asiatisch.Select  sAsian
    end if
    
    GoON:
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

end function

