'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_221_.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: hde $ $Date: 2008/01/02 14:02:35 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_221_

    Call DrawToHTMLScrollingText
    Call DrawToHTMLGroupedObject
    Call DrawToHTML3D
    Call DrawToHTMLFontwork
    Call DrawToHTMLBullets
    Call DrawToHTMLDimensionLines
    Call DrawToHTMLConnectors

end sub


testcase DrawToHTMLScrollingText
  gApplication = "DRAW"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\draw.sxd' ///
  '///+ Jump to beginning of document ///
  '///+ Select Scrolling text ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\draw.sxd")
  Kontext "DocumentDraw"
  '/// Jump to beginning of document ///
  DocumentDraw.TypeKeys "<Tab>"
  EditCopy
  gApplication = "HTMLDOKUMENT"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
     Call hCloseDocument ' Close Source-File
     Call hCloseDocument ' Close Target-File
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Scrolling Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\draw_to_html_scrolling_text.html", gHTMLFilter)
    '///+ Save document as "..\user\work\draw_to_html_scrolling_text.html" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\draw_to_html_scrolling_text.html",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase DrawToHTMLGroupedObject
  gApplication = "DRAW"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\draw.sxd' ///
  '///+ Jump to beginning of document ///
  '///+ Select Grouped Object ///
  '///+ Copy selected Object ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\draw.sxd")
  Kontext "DocumentDraw"
  '/// Jump to beginning of document ///
  DocumentDraw.TypeKeys "<Tab>",2
  EditCopy
  gApplication = "HTMLDOKUMENT"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
     Call hCloseDocument ' Close Source-File
     Call hCloseDocument ' Close Target-File
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\draw_to_html_grouped_object.html", gHTMLFilter)
    '///+ Save document as "..\user\work\draw_to_html_grouped_object.html" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\draw_to_html_grouped_object.html",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase DrawToHTML3D
  gApplication = "DRAW"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\draw.sxd' ///
  '///+ Jump to beginning of document ///
  '///+ Select cell <A5:C5> ///
  '///+ Copy selected text ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\draw.sxd")
  Kontext "DocumentDraw"
  '/// Jump to beginning of document ///
  DocumentDraw.TypeKeys "<Tab>",3
  EditCopy
  gApplication = "HTMLDOKUMENT"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
     Call hCloseDocument ' Close Source-File
     Call hCloseDocument ' Close Target-File
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\draw_to_html_3d.html", gHTMLFilter)
    '///+ Save document as "..\user\work\draw_to_html_3d.html" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\draw_to_html_3d.html",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase DrawToHTMLFontwork
  gApplication = "DRAW"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\draw.sxd' ///
  '///+ Jump to beginning of document ///
  '///+ Select Fontwork ///
  '///+ Copy selected Fontwork ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\draw.sxd")
  Kontext "DocumentDraw"
  '/// Jump to beginning of document ///
  DocumentDraw.TypeKeys "<Tab>",4
  EditCopy
  gApplication = "HTMLDOKUMENT"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
     Call hCloseDocument ' Close Source-File
     Call hCloseDocument ' Close Target-File
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\draw_to_html_fontwork.html", gHTMLFilter)
    '///+ Save document as "..\user\work\draw_to_html_fontwork.html" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\draw_to_html_fontwork.html",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase DrawToHTMLBullets
  gApplication = "DRAW"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\draw.sxd' ///
  '///+ Jump to beginning of document ///
  '///+ Select Bullets ///
  '///+ Copy selected Bullets ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\draw.sxd")
  Kontext "DocumentDraw"
  '/// Jump to beginning of document ///
  DocumentDraw.TypeKeys "<Tab>",5
  EditCopy
  gApplication = "HTMLDOKUMENT"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
     Call hCloseDocument ' Close Source-File
     Call hCloseDocument ' Close Target-File
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Text' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\draw_to_html_bullets.html", gHTMLFilter)
    '///+ Save document as "..\user\work\draw_to_html_bullets.html" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\draw_to_html_bullets.html",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase DrawToHTMLDimensionLines
  gApplication = "DRAW"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\draw.sxd' ///
  '///+ Jump to beginning of document ///
  '///+ Select Dimension Lines ///
  '///+ Copy selected Dimension Lines ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\draw.sxd")
  Kontext "DocumentDraw"
  '/// Jump to beginning of document ///
  DocumentDraw.TypeKeys "<PageDown>"
  DocumentDraw.TypeKeys "<Tab>"
  EditCopy
  gApplication = "HTMLDOKUMENT"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
     Call hCloseDocument ' Close Source-File
     Call hCloseDocument ' Close Target-File
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Dimension Lines' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\draw_to_html_dim_lines.html", gHTMLFilter)
    '///+ Save document as "..\user\work\draw_to_html_dim_lines.html" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\draw_to_html_dim_lines.html",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

' ---------------------------------------------------------------------------------

testcase DrawToHTMLConnectors
  gApplication = "DRAW"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\draw.sxd' ///
  '///+ Jump to beginning of document ///
  '///+ Select Connectors ///
  '///+ Copy selected Connectors ///
  Call hDateiOeffnen (gtesttoolpath & "writer\level1\input\clipboard\draw.sxd")
  Kontext "DocumentDraw"
  '/// Jump to beginning of document ///
  DocumentDraw.TypeKeys "<PageDown>"
  DocumentDraw.TypeKeys "<Tab>"
  EditCopy
  gApplication = "HTMLDOKUMENT"
  '/// Open a new writerdocument ///
  Call hNewDocument
  Sleep 2
  try
     EditPasteSpecialWriter
  catch
     Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
     Call hCloseDocument ' Close Source-File
     Call hCloseDocument ' Close Target-File
     goto endsub
  endcatch
  Wait 500
  '/// Paste 'Connectors' in all available clipboard formats ///
  Kontext "InhaltEinfuegen"
  if InhaltEinfuegen.Exists then
    Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
    '///+ Write Clipboard format under pasted content ///
    Call hSpeichernUnterMitFilterKill (gOfficepath + "user\work\draw_to_html_connectors.html", gHTMLFilter)
    '///+ Save document as "..\user\work\draw_to_html_connectors.html" ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
    wait 500
    Call hDateiOeffnen (gOfficepath + "user\work\draw_to_html_connectors.html",true)
    '///+ Reopen saved document ///
    Wait 500
    Call hCloseDocument
    '///+ Close saved document ///
  else
    Warnlog "Dialog 'Paste Special' is not up!"
    Call hCloseDocument
    goto endsub
  endif
  Call hCloseDocument
  '/// Close active document ///
endcase

